/*
 * $Header:   J:/22vcs/srclib/socket/gettimeo.c_v   1.4.1.0   13 Apr 1993 18:38:02   rcq  $
 */

/*
 * GETTIMEO.C - Get time of day
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit history:
 * 25-May-90    vicka   created
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 27-Nov-91    rcq     added check for TZ env variable, call to tzset()
 *                        and use of IPCUST timezone setting.
 * 14-Aug-92    rcq     updated the copyright in comments
 * 18-Feb-93	rcq	changed get_ipconfig to getconf (we no longer have
 *			  support for daylight savings but not used by MSC
 *			  time functions anyway so moot point).
 */

#include <stdio.h>
#include <stdlib.h>

#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <time.h>
#include <debug.h>

#include <pctcp/types.h>
#include <pctcp/rwconf.h>
#include "4bsd.h"

int gettimeofday(struct timeval  *tp, struct timezone *tzp)
{
    struct timeb  foo;
    int tz_flag;
    char timebuf[10];

#ifdef	DEBUG
	printf("gettimeofday(tp = x%Np, tzp = x%Np)", tp, tzp);
#endif

    /* Check for MSC TimeZone environment variable */
    tz_flag = ((getenv("TZ") == 0) ? 0 : 1);

    if (tz_flag)
        tzset();  /* To setup internal global variables */

    ftime(&foo);  /* get time and tz settings (if any) */

    if(tp) {
	tp->tv_sec = foo.time;
	tp->tv_usec = (long) foo.millitm * 1000L;
    } else
	bomb(EFAULT);

    if(tzp) {
        if (tz_flag)  {                         /* If TZ env var set, */
                tzp->tz_minuteswest = foo.timezone; /*  use MSC TZ setting */
                tzp->tz_dsttime = foo.dstflag;
        } else {                              /* Else use IPCUST TZ offset */
		if ((getconf("general","time-zone-offset",
		   timebuf,sizeof(timebuf))) == 0) {
                     tzp->tz_minuteswest = 0;   /* Not set in Config so */
                     tzp->tz_dsttime = 0;       /*  just set BOGUS Values! */
                } else {
		     /* set to minutes west of Greenwich Mean time */
                     tzp->tz_minuteswest = atoi(timebuf);
                     tzp->tz_dsttime = 0;  /* no way to know */
	        }
        } 
   } /* end if (tzp) */
   
	dreturn(" = %d\n", 0);
	
} /* end gettimeofday() */


/*
 * $Log:   J:/22vcs/srclib/socket/gettimeo.c_v  $
 * 
 *    Rev 1.4.1.0   13 Apr 1993 18:38:02   rcq
 * changed get_ipconfig() to get_conf()
 * 
 *    Rev 1.4.1.0   09 Apr 1993 15:10:28   rcq
 * changed get_ipconfig() to get_conf()
 * 
 *    Rev 1.4   02 Oct 1992 18:54:40   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.3   27 Aug 1992 16:03:20   arnoff
 *  * 27-Nov-91    rcq      added check for TZ env variable, call to tzset()
 *  *                        and use of IPCUST timezone setting.
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.2   13 Apr 1992 16:04:06   arnoff
 * Added pctcp header files
 * 
 *    Rev 1.1   30 Jan 1992 00:51:22   arnoff
 *  
 */
