/*
 * $Header:   J:/22vcs/srclib/socket/gethostn.c_v   1.8   19 Oct 1992 14:43:24   rcq  $
 */

/*
 * GETHOSTN.C - Get host name
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * EDIT HISTORY:
 * 	9/2/87	romkey	changed gethostname() and sethostname() to use
 * 			strcpy() and not include domain name. added
 * 			declarations of integer arguments. 
 * 			Added getdomainname() and setdomainname() functions.
 * 	12/07/87 jbvb	Handle insufficient length case properly.
 * 	19OCT89	stev	added EFAULT, no use for EPERM (already documented)
 * 	09-Aug-91 Ben	replaced get/set_ipconfig with getconf/net_config.
 * 	21-Oct-91 Ben	Check for strlen after getconf
 * 	31-Oct-91 Ben	Use get_kernel_info instead of getconf (except for 
 * 			 username).
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 09-Nov-91 Ben	Cleaned up get[domain/host]name a little bit.
 * 25-Feb-92	paul	still include !@#$ ipconfig.h for benefit of config.h
 * 19-Mar-92 Ben	Get rid of get_kernel calls, use getconf instead.
 *			 Close INI file, iff it wasn't open before.
 * 21-Jul-92	rcq	changed rwconf.h, ipconfig.h, config.h to reference
 *			those in /include/pctcp rather than /include
 * 13-Oct-92	rcq	changed all to remove TAG_HOSTNAME use and error
 *			messages printed and add some error checking
 * 14-Oct-92	rcq	fix my bad ptr to sethostname config_write() and
 *			bad err check from get_kernel_info in getdomainname()
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <debug.h>

#include <netinet/in.h>
#include <pctcp/types.h>
#include <pctcp/error.h>
#include <pctcp/pctcp.h>
#include <pctcp/protocol.h>
#include <pctcp/rwconf.h>
#include <pctcp/ipconfig.h>		/* definitions for config.h */
#include <pctcp/config.h>
#include "4bsd.h"


/* These *used* to be defined in config.h, before respective TAGS removed */
#ifndef UNAME_STRLEN
#define	UNAME_STRLEN	64
#endif
#ifndef HNAME_STRLEN
#define	HNAME_STRLEN	64
#endif

int
gethostname(char *name, int namelen)
{
	int	copy_len;
	int	config_open;

#ifdef	DEBUG
	printf ("gethostname: name = %p namelen = %d, ",  name, namelen);
#endif

	/* set flag to indicate config file already open! */
	config_open = (int) _config_FILE;

	if (!getconf ("general", "host-name", name, namelen) ||
	    (strlen(name) == 0)) {
		*name = '\0';
		errno = EFAULT;
		copy_len = -1;   /* to indicate error */
	} else
	    copy_len = strlen (name);

    
	/* close file only if NOT open before us */
	if (!config_open)
	    config_close (0);

#ifdef	DEBUG
	printf("string len = %d\n", copy_len);
#endif

	return (copy_len);
}


int
sethostname(char *name, int namelen)
{
#ifdef	DEBUG
	printf("sethostname(name = x%Np, namelen = %d)", name, namelen);
#endif
	if (namelen > HNAME_STRLEN)   /* name length greater than allowed */
	    bomb (EFAULT);
	
	if (!config_write ("pctcp","general",CONF_NONE,"host-name",name,0)) {
	    namelen = 0;
	    bomb (EPERM);
	}
	
	if (_config_FILE)     /* Must close config file if open */
	    config_close (0); /*  before we call config_flush() */
	
	if (!config_flush((char*)0, (char*)0, CF_FLAG_NOBACKUP)) {
	    namelen = 0;
	    bomb (EPERM);
	}

	/* It would be nice to open config file if open before ...but */
	/*  since we don't know *what* file was open, we're out of luck! */

	return (namelen);
}

int
getdomainname(char *name, int namelen)
{
#ifdef	DEBUG
	printf("getdomainname(name = x%Np, namelen = %d)", name, namelen);
#endif

        if ((get_kernel_info(0, TAG_DOMAIN, (byte)0, (void far*)name,
	          (int far *)&namelen)) < 0) {
		if (neterrno == NET_ERR_NOMEM)  /* domainname longer than */
		    bomb (ENOBUFS);             /*  user buffer provided */
		bomb (EFAULT);			/* OR generic error */
	}

#ifdef	DEBUG
	printf("string len = %d\n", copy_len);
#endif

	return (namelen);
}

int
setdomainname (char *name, int	namelen)
{

#ifdef	DEBUG
	printf("setdomainname(name = x%Np, namelen = %d)", name, namelen);
#endif

	if (namelen > DOMAIN_STRLEN)
	        bomb (EFAULT);

	if (net_config(TAG_DOMAIN, 0, (void far *)name, namelen)) {
		bomb(EPERM);
	}

	return (namelen);
}

/* bad place to put it, but... */

char *
getlogin()
{
	char		*name_ptr;
	static char	name_buf[UNAME_STRLEN+1];
	int		config_open;

	/* set flag to indicate config file already open! */
	config_open = (int) _config_FILE;

	name_ptr = name_buf;   /* default (success) return value */
	
	if (!getconf ("general", "user", name_buf, UNAME_STRLEN) ||
	    (strlen(name_buf) == 0)) {
		*name_buf = '\0';
		name_ptr  = (char *)0;   /* Error returns null ptr */
		errno = EFAULT;
	}
    
	/* close file only if NOT open before us */
	if (!config_open)
	    config_close (0);

	return(name_ptr);
}

/*
 * $Log:   J:/22vcs/srclib/socket/gethostn.c_v  $
 * 
 *    Rev 1.8   19 Oct 1992 14:43:24   rcq
 *  * 14-Oct-92	rcq	fix my bad ptr to sethostname config_write() and
 *  *			bad err check from get_kernel_info in getdomainname()
 * 
 *    Rev 1.8   19 Oct 1992 14:00:12   rcq
 *  * 14-Oct-92	rcq	fix my bad ptr to sethostname config_write() and
 *  *			bad err check from get_kernel_info in getdomainname()
 * 
 *    Rev 1.8   16 Oct 1992 18:09:10   rcq
 *  * 14-Oct-92	rcq	fix my bad ptr to sethostname config_write() and
 *  *			bad err check from get_kernel_info in getdomainname()
 * 
 *    Rev 1.7   13 Oct 1992 19:15:40   rcq
 * deleted TAG_HOSTNAME reference, deleted "USER" env variable reference,
 * eliminated pneterror printing, used get_kernel_info for getdomainname
 * so symmetrical with net_config() call for setdomainname, added checks
 * for namelen in sethostname() and setdomainname()
 * 
 *    Rev 1.6   02 Oct 1992 18:36:32   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.5   27 Aug 1992 15:40:22   arnoff
 *  * 21-Jul-92	rcq	changed rwconf.h, ipconfig.h, config.h to reference
 *  *			those in /include/pctcp rather than /include
 * 
 *    Rev 1.4   13 Apr 1992 15:54:38   arnoff
 * Still include !@#$ ipconfig.h for benefit of config.h
 * 
 *    Rev 1.3   20 Mar 1992 00:35:54   arnoff
 * Close INI file, iff it wasn't open before.   ---Ben
 * 
 *    Rev 1.2   19 Mar 1992 18:05:04   arnoff
 * get rid of get_kernel calls, use getconf instead.   ---Ben
 * 
 *    Rev 1.1   30 Jan 1992 00:51:06   arnoff
 *  
 */
