/*
 * $Header:   J:/22vcs/srclib/socket/bughalt.c_v   1.3   02 Oct 1992 18:25:06   rcq  $
 */

/*
 * BUGHALT.C - print an error message and exit
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit history:
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 14-Aug-92    rcq     updated the copyright in comments
 * 09-Sep-92	rcq	ifdef'd out bughalt() used *nowhere* (I also
 *			eliminated calls to panic from other modules.
 */

#include <stdio.h>
#include <stdlib.h>		/* exit */


#ifdef DEBUG
void
bughalt(char *s)
{
	fputs(s, stderr);
	fputc('\n', stderr);
	exit(-1);
}
#endif

void
panic(char *s, int a)
{
	printf(s, a);
	exit(-1);
}

void
ipanic(char *s, int a, int b, int c, int d, int e, int f)
{
#ifdef	DEBUG
	dbg(s, a, b, c, d, e, f);
	for (;;)
		;
#endif
}

void
dbg(char *fmt, int a, int b, int c, int d, int e, int f, int g, int h)
{
#ifdef	DEBUG
	char	buf[80], *s = buf;
	int	ch;
	static int	i = 0;

	if(! i++)
		scr_init();

	sprintf(buf, fmt, a, b, c, d, e, f, g, h);

	while(*s) {
		if(*s == '\n')
			putcharh19('\r');
		putcharh19(*s++);
	}

	set_cursor();
#endif
}

/*
 * $Log:   J:/22vcs/srclib/socket/bughalt.c_v  $
 * 
 *    Rev 1.3   02 Oct 1992 18:25:06   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.2   27 Aug 1992 15:42:04   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.1   30 Jan 1992 00:50:50   arnoff
 *  
 */
