/*
 * $Header:   J:/22vcs/srclib/socket/bind.c_v   1.4.1.0   14 Apr 1993 11:15:54   rcq  $
 */

/*
 * BIND.C - Emulate 4BSD bind() (assign name to socket) call.
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * ??-Jul-87	philip	His version
 * 20-Sep-87	romkey	Did ?something?
 * 02-Oct-87	jbvb	Fix bug: bind() should return an error on duplicate
 *			 local port, or invalid IP addr (1st byte 255).
 * 17-Nov-87	jbvb	Change error return if namelen bad.
 * 07-Dec-87	jbvb	Allow use of same port for different types of socket
 *			 (e.g. DGRAM and STREAM).
 * 07-Jan-88	jbvb	Only check for duplicate local port when user hasn't
 *			 set SO_REUSEADDR (HP #752, 885).
 * 22-Jul-88	jbvb	Attempt to parse errors from net_connect() on DGRAMs.
 * 26-Aug-88	jbvb	Fix bugs in above, allow MSB of IP address to be all
 *			 ones (remove HP-induced change of 2/10/87).  This
 *			 isn't bsd-conforming, but it is *right*.
 * 23 AUG 89	stev	fixed compiler warning about types mismatch on 
 *			 routines using sockaddr_in here but sockaddr 
 *			 in the header file.
 * 29-AUG-89	stev	add EBADF check. we dont do EACCESS.
 * 28-DEC-89	stev	fixed newport to be the return of ntohs().
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 14-Aug-92    rcq     updated the copyright in comments
 * 12-Nov-92	rcq	put "#ifdef DEBUG" around pneterror()
 * 19-Feb-93	rcq	added fake dgram connect() to get/assign a free
 *			local port if bind() invoked for TCP with port==0.
 */

#include <stdio.h>
#include <stdlib.h>

#include <pctcp/error.h>
#include <pctcp/types.h>
#include <pctcp/pctcp.h>

#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <debug.h>

#include "4bsd.h"

int
bind(int s, struct sockaddr *name_passed, int namelen)
/* s		socket descriptor	*/
/* name_passed	ip address structure	*/
/* namelen	sizeof(struct sockaddr)	*/
{
	int	i;
	SOCKET	*t_sock;			/* Temporary for checks */
	SOCKET	*sp;				/* Caller's socket 	*/
	u_short	newport;			/* host order (swapped)	*/
	struct sockaddr_in	*name;		/* pointer to name_passed*/

	int nd;           /* temp network desriptor (used if port == 0)*/
	struct addr a;    /* temp address structure */
	a.lsocket = 0;    /* use random local port */
	a.fsocket = 0;    /* <irrelevant, not used here> */
	a.fhost = 0xFFFF; /* <irrelevant, not used here> */
	    

	name = (struct sockaddr_in *)name_passed;
	sp = NSOCK(s);
	newport = ntohs(name->sin_port);	/* do the swap once only */

#ifdef	DEBUG
	printf("bind(s = %d, name = x%Np, namelen = %d)",
		s, name, namelen);
#endif
#if	DEBUG > 5
	fputs("bind: ", stdout);
	dump_sockaddr(name);
#endif

	if (sp->nd == 0)			/* not a valid descriptor*/
		bomb(EBADF);
	    
	if(is_netnd(sp->nd))			/* not a valid socket	*/
		bomb(ENOTSOCK);

	if(name->sin_family != sp->af)		/* not AF_INET		*/
		bomb(EAFNOSUPPORT);

	if ((STATE(sp) & SI_BOUND) ||		/* already bound	*/
	    (namelen != sizeof(*name)))		/* size wrong		*/
		bomb(EINVAL);			/*HP, Digital says so.	*/

#if 0
	if (name->sin_addr.s_net == 255)	/* illegal, acc. to HP */
		bomb(EADDRNOTAVAIL);
#endif
	/* HP wants us to fail if the address is in use (unless SO_REUSEADDR
	 * is set).  We have to check this by scanning all the other sockets.
	 */
	if ((SFLAGS(sp) & SO_REUSEADDR) == 0) {	/* Check uniqueness? 	*/
	    for (i = 0; i < MAXSOCK; i++) {	/* Hasn't asked us not to.. */
		if ((t_sock = NSOCK(i)) &&		/* if a socket 	*/
		    (s != i) &&				/*  & not ours 	*/
		    (t_sock->lsocket == newport) &&	/*  & same lcl port */
		    (t_sock->type == sp->type)) {	/*  & same type	*/
#ifdef	DEBUG
			printf("bind(): port in use by socket %d", i);
#endif
			bomb(EADDRINUSE);
		}
	    }
	}

	sp->fhost = 0L;
	sp->fsocket = 0;
	sp->lsocket = newport;
	sp->lhost = name->sin_addr.s_addr;

	if(sp->type == DGRAM) {  /* If UDP, then just do a bind... */
	    nd = net_connect(sp->nd, sp->type, SADDR(sp));
	} 
	else if (!newport) {  /* Else if TCP and port is 0...   */
            /* Use dummy datagram "connection" to get a random, */
	    /*  unique local port from the kernel (so we return */
	    /*  valid sockaddr_in contents as BSD does          */
            nd = net_connect(-1, DGRAM, &a); /* tmp connect to get port */

	    if (nd != -1) {              /* If it succeeded... */
		sp->lsocket = a.lsocket; /*  use the new local port */
		net_release(nd);         /*  then give up tmp connection */
	    }
        }
	
	if (nd == -1)  {
                switch(neterrno) {
                case NET_ERR_INUSE:
                        bomb(EADDRINUSE);
                case NET_ERR_NOMEM:             /* too many connections */
                        bomb(ENOBUFS);
                case NET_ERR_NOTNETCONN:
                        bomb(ENOTCONN);
                case NET_ERR_UNBOUND:
                        bomb(EDESTADDRREQ);
                default:
#ifdef DEBUG		    
			pneterror("bsd_bind: net_connect");
#endif		    
                        bomb(-1);
                };
        };
	
	sp->state |= SI_BOUND|SI_CAN_SEND|SI_CAN_RECV;
	dreturn(" = %d\n", 0);
}

/*
 * $Log:   J:/22vcs/srclib/socket/bind.c_v  $
 * 
 *    Rev 1.4.1.0   14 Apr 1993 11:15:54   rcq
 * assign port number if port 0 passed in sockaddr_n structure
 * 
 *    Rev 1.4.1.0   09 Apr 1993 15:13:56   rcq
 * assign port number if port 0 passed in sockaddr structure
 * 
 *    Rev 1.4   11 Nov 1992 19:53:34   rcq
 * pneterror() only if DEBUG manifest defined
 * 
 *    Rev 1.3   02 Oct 1992 18:24:20   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.2   27 Aug 1992 15:41:30   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.1   30 Jan 1992 00:50:48   arnoff
 *  
 */

