/*
 * $Header:   J:/22vcs/srclib/rpcgen/rpc_svco.c_v   1.3   14 May 1992 14:21:40   paul  $
 */

/* @(#)rpc_svcout.c	1.2 87/11/24 3.9 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#ifndef lint
static char sccsid[] = "@(#)rpc_svcout.c 1.6 87/06/24 (C) 1987 SMI";
#endif

/*
 * rpc_svcout.c, Server-skeleton outputter for the RPC protocol compiler
 * Copyright (C) 1987, Sun Microsytsems, Inc. 
 */
/* Edit history
 *  2-Nov-90	paul	don't complain when svc_run returns
 *  2-Nov-90	paul	MSC < 6.0 doesn't switch on long expressions
 *  8-Nov-90	paul	prototyped, added return types to all functions
 * 14-Nov-91	paul	changed to new-style function declarators
 * 20-Mar-92	paul	changed MSC conditionals to MSDOS (any DOS compiler)
 *			 or _MSC_VER (automatically defined by MSC compiler)
 * 23-Mar-92	paul	generate full prototypes and new-style declarators
 *			changed f_print to fprintf
 */

#include <stdio.h>
#ifndef MSDOS
#include <strings.h>
#include "rpc_parse.h"
#else
#include <string.h>
#include "rpc_pars.h"
#endif
#include "rpc_scan.h"
#include "rpc_util.h"

/*
 * Prototypes
 */
static void write_program(definition *def, char *storage);
static void printerr(char *err, char *transp);
static void printif(char *proc, char *transp, char *prefix, char *arg);
static int nullproc(proc_list *proc);

static char RQSTP[] = "rqstp";
static char TRANSP[] = "transp";
static char ARG[] = "argument";
static char RESULT[] = "result";
static char ROUTINE[] = "local";


/*
 * write most of the service, that is, everything but the registrations. 
 */
void 
write_most(void)
{
	list *l;
	definition *def;
	version_list *vp;

	for (l = defined; l != NULL; l = l->next) {
		def = (definition *) l->val;
		if (def->def_kind == DEF_PROGRAM) {
			for (vp = def->def.pr.versions; vp != NULL; vp = vp->next) {
				fprintf(fout, "\nstatic void ");
				pvname(def->def_name, vp->vers_num);
#ifdef OLD_STYLE
				fprintf(fout, "();");
#else
				fprintf(fout, "(struct svc_req *%s, SVCXPRT *%s);\n",
					RQSTP, TRANSP);
#endif
			}
		}
	}
	fprintf(fout, "\n\n");
#ifdef OLD_STYLE
	fprintf(fout, "main()\n");
#else
	fprintf(fout, "void main(void)\n");
#endif
	fprintf(fout, "{\n");
	fprintf(fout, "\tSVCXPRT *%s;\n", TRANSP);
	fprintf(fout, "\n");
	for (l = defined; l != NULL; l = l->next) {
		def = (definition *) l->val;
		if (def->def_kind != DEF_PROGRAM) {
			continue;
		}
		for (vp = def->def.pr.versions; vp != NULL; vp = vp->next) {
			fprintf(fout, "\tpmap_unset(%s, %s);\n", def->def_name, vp->vers_name);
		}
	}
}


/*
 * write a registration for the given transport 
 */
void 
write_register(char *transp)
{
	list *l;
	definition *def;
	version_list *vp;

	fprintf(fout, "\n");
	fprintf(fout, "\t%s = svc%s_create(RPC_ANYSOCK", TRANSP, transp);
	if (streq(transp, "tcp")) {
		fprintf(fout, ", 0, 0");
	}
	fprintf(fout, ");\n");
	fprintf(fout, "\tif (%s == NULL) {\n", TRANSP);
	fprintf(fout, "\t\tfprintf(stderr, \"cannot create %s service.\\n\");\n", transp);
	fprintf(fout, "\t\texit(1);\n");
	fprintf(fout, "\t}\n");

	for (l = defined; l != NULL; l = l->next) {
		def = (definition *) l->val;
		if (def->def_kind != DEF_PROGRAM) {
			continue;
		}
		for (vp = def->def.pr.versions; vp != NULL; vp = vp->next) {
			fprintf(fout,
				"\tif (!svc_register(%s, %s, %s, ",
				TRANSP, def->def_name, vp->vers_name);
			pvname(def->def_name, vp->vers_num);
			fprintf(fout, ", IPPROTO_%s)) {\n",
				streq(transp, "udp") ? "UDP" : "TCP");
			fprintf(fout,
				"\t\tfprintf(stderr, \"unable to register (%s, %s, %s).\\n\");\n",
				def->def_name, vp->vers_name, transp);
			fprintf(fout, "\t\texit(1);\n");
			fprintf(fout, "\t}\n");
		}
	}
}


/*
 * write the rest of the service 
 */
void 
write_rest(void)
{
	fprintf(fout, "\tsvc_run();\n");
#ifndef MSDOS
	fprintf(fout, "\tfprintf(stderr, \"svc_run returned\\n\");\n");
	fprintf(fout, "\texit(1);\n");
#endif
	fprintf(fout, "}\n");
}

void 
write_programs(char *storage)
{
	list *l;
	definition *def;

	for (l = defined; l != NULL; l = l->next) {
		def = (definition *) l->val;
		if (def->def_kind == DEF_PROGRAM) {
			write_program(def, storage);
		}
	}
}


static void 
write_program(definition *def, char *storage)
{
	version_list *vp;
	proc_list *proc;
	int filled;
#ifdef _MSC_VER
	int gt_flag;
#endif

	for (vp = def->def.pr.versions; vp != NULL; vp = vp->next) {
		fprintf(fout, "\n");
		if (storage != NULL) {
			fprintf(fout, "%s ", storage);
		}
		fprintf(fout, "void\n");
		pvname(def->def_name, vp->vers_num);
#ifdef OLD_STYLE
		fprintf(fout, "(%s, %s)\n", RQSTP, TRANSP);
		fprintf(fout, "	struct svc_req *%s;\n", RQSTP);
		fprintf(fout, "	SVCXPRT *%s;\n", TRANSP);
#else
		fprintf(fout, "(struct svc_req *%s, SVCXPRT *%s)\n", 
			RQSTP, TRANSP);
#endif
		fprintf(fout, "{\n");

		filled = 0;
		fprintf(fout, "\tunion {\n");
		for (proc = vp->procs; proc != NULL; proc = proc->next) {
			if (streq(proc->arg_type, "void")) {
				continue;
			}
			filled = 1;
			fprintf(fout, "\t\t");
			ptype(proc->arg_prefix, proc->arg_type, 0);
			pvname(proc->proc_name, vp->vers_num);
			fprintf(fout, "_arg;\n");
		}
		if (!filled) {
			fprintf(fout, "\t\tint fill;\n");
		}
		fprintf(fout, "\t} %s;\n", ARG);
		fprintf(fout, "\tchar *%s;\n", RESULT);
		fprintf(fout, "\tbool_t (*xdr_%s)(), (*xdr_%s)();\n", ARG, RESULT);
		fprintf(fout, "\tchar *(*%s)();\n", ROUTINE);
		fprintf(fout, "\n");

#ifdef _MSC_VER
		fprintf(fout, "#if _MSC_VER < 600\n");
		fprintf(fout, "\tif (%s->rq_proc > %s) {\n", 
			RQSTP, "0xffff");

		for (proc = vp->procs; proc != NULL; proc = proc->next) {
			if (atol(proc->proc_num) > 0xffff) {
				fprintf(fout, "\t\tif (%s->rq_proc == %s) {\n",
					RQSTP, proc->proc_name);
				fprintf(fout, "\t\t\txdr_%s = xdr_%s;\n", 
					ARG, stringfix(proc->arg_type));
				fprintf(fout, "\t\t\txdr_%s = xdr_%s;\n", 
					RESULT, stringfix(proc->res_type));
				fprintf(fout, "\t\t\t%s = (char *(*)()) ", 
					ROUTINE);
				pvname(proc->proc_name, vp->vers_num);
				fprintf(fout, ";\n\t\t} else\n");
				}
			}
		printerr("noproc", TRANSP);
		fprintf(fout, "\t\treturn;\n");
		fprintf(fout, "\t} else\n");

		fprintf(fout, "\tswitch ((unsigned short)%s->rq_proc) {\n", 
			RQSTP);
		fprintf(fout, "#else\n");
#endif
		fprintf(fout, "\tswitch (%s->rq_proc) {\n", RQSTP);
#ifdef _MSC_VER
		fprintf(fout, "#endif\n");
#endif

		if (!nullproc(vp->procs)) {
			fprintf(fout, "\tcase NULLPROC:\n");
			fprintf(fout, "\t\tsvc_sendreply(%s, xdr_void, NULL);\n", TRANSP);
			fprintf(fout, "\t\treturn;\n\n");
		}
		for (proc = vp->procs; proc != NULL; proc = proc->next) {
#ifdef _MSC_VER
			gt_flag = 0;
			if (atol(proc->proc_num) > 0xffff) {
				gt_flag = 1;
				fprintf(fout, "#if !(_MSC_VER < 600)\n");
				}
#endif
			fprintf(fout, "\tcase %s:\n", proc->proc_name);
			fprintf(fout, "\t\txdr_%s = xdr_%s;\n", ARG, 
				stringfix(proc->arg_type));
			fprintf(fout, "\t\txdr_%s = xdr_%s;\n", 
				RESULT, stringfix(proc->res_type));
			fprintf(fout, "\t\t%s = (char *(*)()) ", 
					ROUTINE);
			pvname(proc->proc_name, vp->vers_num);
			fprintf(fout, ";\n");
			fprintf(fout, "\t\tbreak;\n\n");
#ifdef _MSC_VER
			if (gt_flag)
				fprintf(fout, "#endif\n");
#endif
		}
		fprintf(fout, "\tdefault:\n");
		printerr("noproc", TRANSP);
		fprintf(fout, "\t\treturn;\n");
		fprintf(fout, "\t}\n");

		fprintf(fout, "\tbzero(&%s, sizeof(%s));\n", ARG, ARG);
		printif("getargs", TRANSP, "&", ARG);
		printerr("decode", TRANSP);
		fprintf(fout, "\t\treturn;\n");
		fprintf(fout, "\t}\n");

		fprintf(fout, "\t%s = (*%s)(&%s, %s);\n", RESULT, ROUTINE, ARG,
			RQSTP);
		fprintf(fout, 
			"\tif (%s != NULL && !svc_sendreply(%s, xdr_%s, %s)) {\n",
			RESULT, TRANSP, RESULT, RESULT);
		printerr("systemerr", TRANSP);
		fprintf(fout, "\t}\n");

		printif("freeargs", TRANSP, "&", ARG);
		fprintf(fout, "\t\tfprintf(stderr, \"unable to free arguments\\n\");\n");
		fprintf(fout, "\t\texit(1);\n");
		fprintf(fout, "\t}\n");

		fprintf(fout, "}\n\n");
	}
}

static void 
printerr(char *err, char *transp)
{
	fprintf(fout, "\t\tsvcerr_%s(%s);\n", err, transp);
}

static void 
printif(char *proc, char *transp, char *prefix, char *arg)
{
	fprintf(fout, "\tif (!svc_%s(%s, xdr_%s, %s%s)) {\n",
		proc, transp, arg, prefix, arg);
}

static int 
nullproc(proc_list *proc)
{
	for (; proc != NULL; proc = proc->next) {
		if (streq(proc->proc_num, "0")) {
			return (1);
		}
	}
	return (0);
}

/*
 * $Log:   J:/22vcs/srclib/rpcgen/rpc_svco.c_v  $
 * 
 *    Rev 1.3   14 May 1992 14:21:40   paul
 *  
 * 
 *    Rev 1.2   13 May 1992 18:03:30   paul
 *  
 * 
 *    Rev 1.1   30 Jan 1992 00:38:34   arnoff
 *  
 */
