/*
 * $Header:   J:/22vcs/srclib/rpcgen/rpc_main.c_v   1.2   13 May 1992 18:03:08   paul  $
 */

/* @(#)rpc_main.c	1.4 87/11/30 3.9 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#ifndef lint
static char sccsid[] = "@(#)rpc_main.c 1.7 87/06/24 (C) 1987 SMI";
#endif

/*
 * rpc_main.c, Top level of the RPC protocol compiler. 
 * Copyright (C) 1987, Sun Microsystems, Inc. 
 */
/* Edit history
 *  8-Nov-90	paul	prototyped, added return types to all functions
 * 12-Nov-90	paul	#include <stdio.h> in xdr, server, client modules
 *			#include <rpc/pmap_cln.h> in client, server modules
 * 14-Nov-91	paul	changed to new-style function declarators
 * 20-Mar-92	paul	changed MSC conditionals to MSDOS
 * 20-Mar-92	paul	changed from mktemp to tmpnam (ANSI)
 * 13-May-92	paul	reworked open_input for Turbo C
 */

#include <stdio.h>
#ifndef MSDOS
#include <strings.h>
#include <sys/file.h>
#else
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include <io.h>
#endif /* MSDOS */

#ifndef MSDOS
#include "rpc_parse.h"
#else
#include "rpc_pars.h"
#endif
#include "rpc_scan.h"
#include "rpc_util.h"

#define EXTEND	1		/* alias for TRUE */

struct commandline {
	int cflag;
	int hflag;
	int lflag;
	int sflag;
	int mflag;
	char *infile;
	char *outfile;
};

/*
 * Prototypes
 */
void main(int argc, char *argv[]);
static char *extendfile(char *file, char *ext);
static void open_output(char *infile, char *outfile);
static void open_input(char *infile, char *define);
static void c_output(char *infile, char *define, int extend, char *outfile);
static void h_output(char *infile, char *define, int extend, char *outfile);
static void s_output(int argc, char *argv [], char *infile, char *define, int extend, char *outfile, int nomain);
static void l_output(char *infile, char *define, int extend, char *outfile);
static void do_registers(int argc, char *argv []);
static int parseargs(int argc, char *argv [], struct commandline *cmd);

#ifndef MSDOS
static char CPP[] = "/lib/cpp";
static char CPPFLAGS[] = "-C";
#else
static char tmprpcgen[L_tmpnam];
#if _MSC_VER			/* automatically defined by MSC compiler */
static char CPP[] = "cl";
#if 0
static char CPPFLAGS[] = "-E -C";
#else
static char CPPFLAGS[] = "-P -C";
#endif
#else /* __TURBOC__ */
static char CPP[] = "cpp";
static char CPPFLAGS[] = "-P-";
#endif /* _MSC_VER */
#endif /* MSDOS */

static char *cmdname;
static char *allv[] = {
	"rpcgen", "-s", "udp", "-s", "tcp",
};
static int allc = sizeof(allv)/sizeof(allv[0]);

void
main(int argc, char *argv[])
{
	struct commandline cmd;

	if (!parseargs(argc, argv, &cmd)) {
		fprintf(stderr,
			"usage: %s infile\n", cmdname);
		fprintf(stderr,
			"       %s [-c | -h | -l | -m] [-o outfile] [infile]\n",
			cmdname);
		fprintf(stderr,
			"       %s [-s udp|tcp]* [-o outfile] [infile]\n",
			cmdname);
		exit(1);
	}
	if (cmd.cflag) {
		c_output(cmd.infile, "-DRPC_XDR", !EXTEND, cmd.outfile);
	} else if (cmd.hflag) {
		h_output(cmd.infile, "-DRPC_HDR", !EXTEND, cmd.outfile);
	} else if (cmd.lflag) {
		l_output(cmd.infile, "-DRPC_CLNT", !EXTEND, cmd.outfile);
	} else if (cmd.sflag || cmd.mflag) {
		s_output(argc, argv, cmd.infile, "-DRPC_SVC", !EXTEND,
			 cmd.outfile, cmd.mflag);
	} else {
		/* do them all */
		
		c_output(cmd.infile, "-DRPC_XDR", EXTEND, "_xdr.c");
		reinitialize();
#ifdef MSDOS
		fclose(fout);
		unlink(tmprpcgen);
#endif
		h_output(cmd.infile, "-DRPC_HDR", EXTEND, ".h");
		reinitialize();
#ifdef MSDOS
		fclose(fout);
		unlink(tmprpcgen);
#endif
		l_output(cmd.infile, "-DRPC_CLNT", EXTEND, "_clnt.c");
		reinitialize();
#ifdef MSDOS
		fclose(fout);
		unlink(tmprpcgen);
#endif
		s_output(allc, allv, cmd.infile, "-DRPC_SVC", EXTEND,
			 "_svc.c", cmd.mflag);
	}
#ifdef MSDOS
	fclose(fout);
	unlink(tmprpcgen);
#endif
	exit(0);
}

/*
 * add extension to filename 
 */
static char *
extendfile(char *file, char *ext)
{
	char *res;
	char *p;

	res = alloc(strlen(file) + strlen(ext) + 1);
	if (res == NULL) {
		abort();
	}
#ifndef MSDOS
	p = rindex(file, '.');
#else
	p = strrchr(file, '.');
#endif
	if (p == NULL) {
		p = file + strlen(file);
	}
	strcpy(res, file);
	strcpy(res + (p - file), ext);
	return (res);
}

/*
 * Open output file with given extension 
 */
static void 
open_output(char *infile, char *outfile)
{
	if (outfile == NULL) {
		fout = stdout;
		return;
	}
	if (infile != NULL && streq(outfile, infile)) {
		fprintf(stderr, "%s: output would overwrite %s\n", cmdname,
			infile);
		crash();
	}
	fout = fopen(outfile, "w");
	if (fout == NULL) {
		fprintf(stderr, "%s: unable to open ", cmdname);
		perror(outfile);
		crash();
	}
	record_open(outfile);
}

/*
 * Open input file with given define for C-preprocessor 
 */
static void 
open_input(char *infile, char *define)
{
#ifndef MSDOS
	int pd[2];
#else
	int oldstdout, fd, rc;
#endif

	infilename = (infile == NULL) ? "<stdin>" : infile;
#ifndef MSDOS
	pipe(pd);
	switch (fork()) {
	case 0:
		close(1);
		dup2(pd[1], 1);
		close(pd[0]);
		execl(CPP, CPP, CPPFLAGS, define, infile, NULL);
		perror("execl");
		exit(1);
	case -1:
		perror("fork");
		exit(1);
	}
	close(pd[1]);
	fin = fdopen(pd[0], "r");
#else /* MSDOS */
#if 0
	oldstdout = dup(1);	/* Copy stdout */
	close(1);		/* Close original */

	if (tmpnam(tmprpcgen) == NULL) {
		fprintf(stderr, "tmpnam returns null file name\n");
		exit(-1);
	}

	fd = open(tmprpcgen, O_CREAT | O_WRONLY, S_IREAD | S_IWRITE);
	if (fd == -1) {
		perror("open(tmprpcgen)");
		exit(1);
	}

	/*
	 * fd should be 1 (stdout), if not, make it be and close non-1 copy.
	 */
	if (fd != 1) {
		if (dup2(fd, 1) == -1) {
			perror("dup2(fd)");
			exit(1);
		}
		close(fd);
	}

	rc = spawnlp(P_WAIT, CPP, CPP, CPPFLAGS, define, infile, NULL);
	if (rc == -1) {
		perror("spawnlp");
		exit(1);
	}

	/*
	 * Copy old stdout back to 1, and close copy.
	 */
	if (dup2(oldstdout, 1) == -1) {
		perror("dup2(oldstdout)");
		exit(1);
	}
	close(oldstdout);

	fin = fopen(tmprpcgen, "r");
#else
	/* Borland CPP doesn't have a "quiet" option to suppress the sign-on
	 * banner.  OTOH, both Borland and Microsoft can create .i files.
	 * Besides, this seems less hairy than trying to catch stdout. 
	 */
		
	strcpy(tmprpcgen, extendfile(infile, ".i"));

	rc = spawnlp(P_WAIT, CPP, CPP, CPPFLAGS, define, infile, NULL);
	if (rc == -1) {
		perror("spawnlp");
		exit(1);
	}

	fin = fopen(tmprpcgen, "r");
#endif
#endif /* MSDOS */
	if (fin == NULL) {
		fprintf(stderr, "%s: ", cmdname);
		perror(infilename);
		crash();
	}
}

/*
 * Compile into an XDR routine output file
 */
static void 
c_output(char *infile, char *define, int extend, char *outfile)
{
	definition *def;
	char *include;
	char *outfilename;
	long tell;

	open_input(infile, define);	
	outfilename = extend ? extendfile(infile, outfile) : outfile;
	open_output(infile, outfilename);
	fprintf(fout, "#include <stdio.h>\n");
	fprintf(fout, "#include <rpc/rpc.h>\n");
	if (infile && (include = extendfile(infile, ".h"))) {
		fprintf(fout, "#include \"%s\"\n", include);
		free(include);
	}
	tell = ftell(fout);
	while (def = get_definition()) {
		emit(def);
	}
	if (extend && tell == ftell(fout)) {
		unlink(outfilename);
	}
}

/*
 * Compile into an XDR header file
 */
static void 
h_output(char *infile, char *define, int extend, char *outfile)
{
	definition *def;
	char *outfilename;
	long tell;

	open_input(infile, define);
	outfilename =  extend ? extendfile(infile, outfile) : outfile;
	open_output(infile, outfilename);
	tell = ftell(fout);
	while (def = get_definition()) {
		print_datadef(def);
	}
	if (extend && tell == ftell(fout)) {
		unlink(outfilename);
	}
}

/*
 * Compile into an RPC server
 */
static void 
s_output(
	int argc, 
	char *argv[], 
	char *infile, 
	char *define, 
	int extend, 
	char *outfile, 
	int nomain)
{
	char *include;
	definition *def;
	int foundprogram;
	char *outfilename;

	open_input(infile, define);
	outfilename = extend ? extendfile(infile, outfile) : outfile;
	open_output(infile, outfilename);
	fprintf(fout, "#include <stdio.h>\n");
	fprintf(fout, "#include <rpc/rpc.h>\n");
#ifndef MSDOS
	fprintf(fout, "#include <rpc/pmap_clnt.h>\n");
#else
	fprintf(fout, "#include <rpc/pmap_cln.h>\n");
#endif
	if (infile && (include = extendfile(infile, ".h"))) {
		fprintf(fout, "#include \"%s\"\n", include);
		free(include);
	}
	foundprogram = 0;
	while (def = get_definition()) {
		foundprogram |= (def->def_kind == DEF_PROGRAM);
	}
	if (extend && !foundprogram) {
		unlink(outfilename);
		return;
	}
	if (nomain) {
		write_programs(NULL);
	} else {
		write_most();
		do_registers(argc, argv);
		write_rest();
		write_programs("static");
	}
}

/*
 * Compile into an RPC client
 */
static void 
l_output(char *infile, char *define, int extend, char *outfile)
{
	char *include;
	definition *def;
	int foundprogram;
	char *outfilename;

	open_input(infile, define);
	outfilename = extend ? extendfile(infile, outfile) : outfile;
	open_output(infile, outfilename);
	fprintf(fout, "#include <stdio.h>\n");
	fprintf(fout, "#include <rpc/rpc.h>\n");
#ifndef MSDOS
	fprintf(fout, "#include <rpc/pmap_clnt.h>\n");
#else
	fprintf(fout, "#include <rpc/pmap_cln.h>\n");
#endif
	if (infile && (include = extendfile(infile, ".h"))) {
		fprintf(fout, "#include \"%s\"\n", include);
		free(include);
	}
	foundprogram = 0;
	while (def = get_definition()) {
		foundprogram |= (def->def_kind == DEF_PROGRAM);
	}
	if (extend && !foundprogram) {
		unlink(outfilename);
		return;
	}
	write_stubs();
}

/*
 * Perform registrations for service output 
 */
static void 
do_registers(int argc, char *argv [])
{
	int i;

	for (i = 1; i < argc; i++) {
		if (streq(argv[i], "-s")) {
			write_register(argv[i + 1]);
			i++;
		}
	}
}

/*
 * Parse command line arguments 
 */
static int 
parseargs(int argc, char *argv [], struct commandline *cmd)
{
	int i;
	int j;
	char c;
	char flag[(1 << 8 * sizeof(char))];
	int nflags;
	
	cmdname = argv[0];
	cmd->infile = cmd->outfile = NULL;
	if (argc < 2) {
		return (0);
	}
	flag['c'] = 0;
	flag['h'] = 0;
	flag['s'] = 0;
	flag['o'] = 0;
	flag['l'] = 0;
	flag['m'] = 0;
	for (i = 1; i < argc; i++) {
		if (argv[i][0] != '-') {
			if (cmd->infile) {
				return (0);
			}
			cmd->infile = argv[i];
		} else {
			for (j = 1; argv[i][j] != 0; j++) {
				c = argv[i][j];
				switch (c) {
				case 'c':
				case 'h':
				case 'l':
				case 'm':
					if (flag[c]) {
						return (0);
					}
					flag[c] = 1;
					break;
				case 'o':
				case 's':
					if (argv[i][j - 1] != '-' || 
					    argv[i][j + 1] != 0) {
						return (0);
					}
					flag[c] = 1;
					if (++i == argc) {
						return (0);
					}
					if (c == 's') {
						if (!streq(argv[i], "udp") &&
						    !streq(argv[i], "tcp")) {
							return (0);
						}
					} else if (c == 'o') {
						if (cmd->outfile) {
							return (0);
						}
						cmd->outfile = argv[i];
					}
					goto nextarg;

				default:
					return (0);
				}
			}
	nextarg:
			;
		}
	}
	cmd->cflag = flag['c'];
	cmd->hflag = flag['h'];
	cmd->sflag = flag['s'];
	cmd->lflag = flag['l'];
	cmd->mflag = flag['m'];
	nflags = cmd->cflag + cmd->hflag + cmd->sflag + cmd->lflag + cmd->mflag;
	if (nflags == 0) {
		if (cmd->outfile != NULL || cmd->infile == NULL) {
			return (0);
		}
	} else if (nflags > 1) {
		return (0);
	}
	return (1);
}

/*
 * $Log:   J:/22vcs/srclib/rpcgen/rpc_main.c_v  $
 * 
 *    Rev 1.2   13 May 1992 18:03:08   paul
 *  
 * 
 *    Rev 1.1   30 Jan 1992 00:38:14   arnoff
 *  
 */

