/*
 * $Header:   F:/21vcs/srclib/rpcetc/getserve.c_v   1.1   30 Jan 1992 00:36:38   arnoff  $
 */

/*
 * GETSERVE.C - Socket routines for manipulating "/etc/services".
 *
 * Copyright (C) 1987 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 03-Sep-87	Romkey?	?some change?
 * 16-Nov-87	jbvb	Try environment variable to locate /etc/services.
 * 07-Jan-88	jbvb	Accept trailing '\' or '/' on environment variable.
 * 06-Feb-88	jbvb	Fix bug in above.
 * 25-Apr-88	jbvb	DDP says 4BSD parses protocol names containing '.'
 *  8-Nov-90	paul	prototyped, added return types to all functions
 * 14-Nov-91	paul	changed to new-style function declarators
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <netdb.h>
#include <debug.h>
#include "4bsdconf.h"

#define	dreturn(s, r)	return(r);

#ifndef	SERVFILE
#define	SERVFILE	"/etc/services"
#endif

#ifndef	ETC_LOC
#define	ETC_LOC		"FTP_ETC"	/* Env. vbl. pointing to /etc */
#endif

#define	TEST(c, i)	(isalpha(c) || (i && (isdigit(c)  || ((c) == '-') \
			|| ((c) == '_') || ((c) == '.'))))

static FILE	*sfp = NULL;
static struct servent	se;
static char	buf[128], *ptr[10];
static int	dontclose = 0;

static	char	*server_file = NULL;	/* start out pointing to nothing */
static	char	server_default[] = SERVFILE;	/* default value */
static	char	server_tmp[80];			/* Keep assembled name here */

/*
 * Prototypes
 */
void setservent(int stayopen);
void endservent(void);
struct servent *getservent(void);
struct servent *getservbyport(int port, char *proto);
struct servent *getservbyname(char *name, char *proto);

void 
setservent(int stayopen)
{
	int	i;

	dontclose = stayopen;		/* Save the flag for later */

	if(sfp != NULL)
		rewind(sfp);
	else {				/* We've got to open it... */
		if (!server_file) {	/* Where's it hiding? */
			if ((server_file = getenv(ETC_LOC)) != NULL) {
				strcpy(server_tmp, server_file);
				i = strlen(server_tmp);
				i--;
				if ((server_tmp[i] == '\\') ||
				    (server_tmp[i] == '/'))
					server_tmp[i] = '\0';
				strcat(server_tmp, "\\services");
				server_file = server_tmp;
			} else {
				server_file = server_default;
			}
		}
		sfp = fopen(server_file, "r");
		if (sfp == NULL) {
			perror(server_file);
			exit(1);
		}
	}
	return;
}

void 
endservent(void)
{
	fclose(sfp);
	sfp = NULL;
	return;
}

/* this code is called by the other routines, so it probably isn't
 * worth tracing it.
 */

struct servent *
getservent(void)
{
	char	*p;
	int	i, j;
	long	n;

	if(sfp == NULL)
		setservent(1);

	do {
		if(fgets(buf, sizeof(buf), sfp) == NULL)
			goto quit;
	} while(buf[0] == '#' || buf[0] == '\n');

	se.s_name = buf;
	for(i = 0, p = buf; TEST(*p, i); ++i)
		++p;

	if(! i) {
quit:		endservent();
		return(NULL);
	}
	*p++ = '\0';

	while(isspace(*p))
		++p;

	for(i = n = 0; isdigit(*p); ++i)
		n = n * 10 + *p++ - '0';

	if(! i)
		goto quit;

	se.s_port = htons(n);

	if(*p++ != '/')
		goto quit;

	se.s_proto = p;

	for(i = 0; isalpha(*p) || (i && isdigit(*p)); ++i)
		++p;

	if(! i)
		return(NULL);
	*p++ = '\0';

	for(j = 0; *p;) {
		while(isspace(*p))
			++p;

		if(! *p || *p == '#')
			break;

		ptr[j] = p;

		for(i = 0; TEST(*p, i); ++i)
			++p;
		if(! i)
			continue;

		*p++ = '\0';
		++j;
	}

	ptr[j] = NULL;		/* terminate array of ptr's */
	se.s_aliases = ptr;

#if	DEBUG >= 10
	printf("getservent:\t\"%s\"\t%d/%s\t", se.s_name, se.s_port,
		se.s_proto);
	for(i = 0; se.s_aliases[i]; ++i)
		printf(" \"%s\"", se.s_aliases[i]);
	fputc('\n', stdout);
#endif

	return(&se);
}

struct servent *
getservbyport(int port, char *proto)
{
	struct servent	*sp;

#ifdef	DEBUG
	printf("getservbyport(port = %d, proto = \"%s\")", ntohs(port), proto);
#endif

	setservent(dontclose);

	while((sp = getservent()) != NULL)
		if(sp->s_port == port
		&& (proto == NULL || strcmp(sp->s_proto, proto) == 0))
			break;

	if(! dontclose)
		endservent();

	dreturn(" = x%Np\n", sp);
}

struct servent *
getservbyname(char *name, char *proto)
{
	struct servent	*sp;
	int	i, quit;

#ifdef	DEBUG
	printf("getservbyname(name = \"%s\", proto = \"%s\")", name, proto);
#endif

	setservent(dontclose);

	/* I'm not sure if I'm supposed to search the alias list,
	 * but I might as well, since it doesn't really hurt (too bad).
	 */
	for(quit = 0; ! quit && (sp = getservent()) != NULL; ) {
		if(proto != NULL && strcmp(sp->s_proto, proto) != 0)
			continue;
		if(strcmp(sp->s_name, name) == 0)
			break;
		for(i = 0; sp->s_aliases[i]; ++i)
			if(strcmp(sp->s_aliases[i], name) == 0) {
				++quit;
				break;
			}
	}

	if(! dontclose)
		endservent();

	dreturn(" = x%Np\n", sp);
}

/*
 * $Log:   F:/21vcs/srclib/rpcetc/getserve.c_v  $
 * 
 *    Rev 1.1   30 Jan 1992 00:36:38   arnoff
 *  
 */
