;
; $Header:   F:/21vcs/srclib/netlib/syscall8.asv   1.1   30 Jan 1992 00:32:08   arnoff  $
;

;
; SYSCALL8.ASM - TCP Listen, FIN and flush functions.
;
; Copyright (C) 1986,1990,1991 by FTP Software, Inc., all rights reserved.
; 
; This software is furnished under a license and may be used and copied
; only in accordance with the terms of such license and with the
; inclusion of the above copyright notice. This software or any other
; copies thereof may not be provided or otherwise made available to any
; other person. No title to and ownership of the software is hereby
; transferred.
; 
; The information in this software is subject to change without notice
; and should not be construed as a commitment by FTP Software, Inc.
;
; Edit History
; 22-Sep-89	jbvb	Split off from SYSCALL1.ASM for 2.04
; 29-Aug-91	Ben	Renamed *.def to *.inc
; 22-Oct-91	paul	removed paths from includes
;

	INCLUDE dos.mac 
	INCLUDE mmodel.inc
	INCLUDE pctcp.inc

; first declare find_vec().
IFDEF	LCODE
	EXTRN	__find_vec:FAR
ELSE
_TEXT	segment
	EXTRN	__find_vec:NEAR
_TEXT	ends
ENDIF


_TEXT	SEGMENT 

	EXTRN	__dosyscall:near
	EXTRN	finish_neg1:near	; Common error handler & return
	EXTRN	finish_ax0:near		; Common error handler & return
	EXTRN	fix_pctcp_err: NEAR	; Common error parsing code.

_DATA	SEGMENT 
	EXTRN 	_neterrno:word 	; where we store error codes
	EXTRN	inited:word	; have we found the syscall vector?
_DATA	ENDS 

; macro used at start of every function to perform initialization if it
; hasn't happened already
chkinst	MACRO
	LOCAL	okay

	mov	ax,inited
	or	ax,ax
	jnz	okay

	call	__find_vec
	mov	inited,0FFFFh
okay:
	ENDM

; macro to zero out one register (s) if another (r) is already zero
zseg	MACRO	r,s
	LOCAL	done

	or	r,r
	jnz	done

	mov	s,r
done:
	ENDM


; net_listen(fd, type, addr) 
; 
;	fd	BX 
;	type	DX 
;	addr	DS:SI 

	CPROC	_net_listen

	chkinst

    	push	bp 
    	mov	bp,sp 
	push	si
    	push	ds 

    	mov	dx,[bp+SARG+SINT] 
    	mov	si,[bp+SARG+2*SINT] 
IFDEF	LDATA
	mov	ds,[bp+SARG+2*SINT+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
    	mov	bx,[bp+SARG] 
    	mov	ah,NET_LISTEN 
         
    	call	__dosyscall 
         
    	pop	ds 
	pop	si

    	jmp	finish_neg1 
_net_listen	ENDP


; net_flush(fd) 
; 
;	fd	BX 

	CPROC	_net_flush

	chkinst

	push	bp 
	mov	bp,sp 
 
	mov	ah,NET_FLUSH 
	mov	bx,[bp+SARG]

	call	__dosyscall 
 
	jmp	finish_neg1 
_net_flush	ENDP


; net_eof(nd)
;	int	nd;			BX
;

	CPROC	_net_eof

	chkinst

	push	bp
	mov	bp,sp

	mov	ah,NET_EOF
	mov	bx,[bp+SARG]
 
	call	__dosyscall 
 
	jmp	finish_ax0

_net_eof	ENDP

_TEXT	ENDS 
	END 

;
; $Log:   F:/21vcs/srclib/netlib/syscall8.asv  $
;  
;     Rev 1.1   30 Jan 1992 00:32:08   arnoff
;   
;
