;
; $Header:   F:/21vcs/srclib/netlib/syscall6.asv   1.1   30 Jan 1992 00:32:02   arnoff  $
;

;
; SYSCALL6.ASM - Datagram write & abort-all functions
;
; Copyright (C) 1986,1990,1991 by FTP Software, Inc., all rights reserved.
; 
; This software is furnished under a license and may be used and copied
; only in accordance with the terms of such license and with the
; inclusion of the above copyright notice. This software or any other
; copies thereof may not be provided or otherwise made available to any
; other person. No title to and ownership of the software is hereby
; transferred.
; 
; The information in this software is subject to change without notice
; and should not be construed as a commitment by FTP Software, Inc.
;
; Edit History
; 22-Sep-89	jbvb	Split off from SYSCALL1.ASM for 2.04
; 23-Feb-90	jbvb	Add SS_NE_DS conditional, for Windows DLLs.
; 29-Aug-91	Ben	Renamed *.def to *.inc
; 22-Oct-91	paul	removed paths from includes

	INCLUDE dos.mac 
	INCLUDE mmodel.inc
	INCLUDE pctcp.inc

; first declare find_vec().
IFDEF	LCODE
	EXTRN	__find_vec:FAR
ELSE
_TEXT	segment
	EXTRN	__find_vec:NEAR
_TEXT	ends
ENDIF


_TEXT	SEGMENT 

	EXTRN	__dosyscall:near
	EXTRN	finish_neg1:near	; Common error handler & return
	EXTRN	finish_neg2:near	; Common error handler & return
	EXTRN	finish_ax0:near		; Common error handler & return
	EXTRN	fix_pctcp_err: NEAR	; Common error parsing code.

_DATA	SEGMENT 
	EXTRN 	_neterrno:word 	; where we store error codes
	EXTRN	inited:word	; have we found the syscall vector?
_DATA	ENDS 

; macro used at start of every function to perform initialization if it
; hasn't happened already
chkinst	MACRO
	LOCAL	okay

	mov	ax,inited
	or	ax,ax
	jnz	okay

	call	__find_vec
	mov	inited,0FFFFh
okay:
	ENDM

; macro to zero out one register (s) if another (r) is already zero
zseg	MACRO	r,s
	LOCAL	done

	or	r,r
	jnz	done

	mov	s,r
done:
	ENDM

; net_writeto(fd, buf, len, to, flags) 
; 
;	fd	BX 
;	buf	DS:SI 
;	len	CX 
;	to	ES:DI 
;	flags	DX 
 
	CPROC	_net_writeto

	chkinst

	push	bp 
	mov	bp,sp 
	push	si 
	push	di 
	push	ds
 
IFNDEF	LDATA
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
	mov	es, ax
ELSE
	mov	ax, ds		; Make es = ds
	mov	es, ax
ENDIF
ENDIF

	mov	si,[bp+SARG+SINT] 
IFDEF	LDATA
	mov	ds,[bp+SARG+SINT+2]
ENDIF
	mov	cx,[bp+SARG+SINT+SPTR]
	mov	di,[bp+SARG+2*SINT+SPTR]
IFDEF	LDATA
	mov	es,[bp+SARG+2*SINT+SPTR+2]
ENDIF
	mov	dx,[bp+SARG+2*SINT+2*SPTR]
 
	mov	bx,[bp+SARG] 
	mov	ah,NET_WRITETO 

	call	__dosyscall 
	pop	ds
	pop	di 
	pop	si 
 
	jnc	noerr_write
	call	fix_pctcp_err
	mov	ax,-1

noerr_write:		; Either -1, or length returned is in AX.
	pop	bp
	ret

_net_writeto	ENDP 
 



; net_readfrom(nd, buf, len, addr, flags) 
; 
;	nd	BX 
;	buf	DS:SI 
;	len	CX 
;	addr	ES:DI 
;	flags	DX 

	CPROC	_net_readfrom

	chkinst

	push	bp 
	mov	bp,sp 
	push	si 
	push	di 
	push	ds

IFNDEF	LDATA
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
	mov	es, ax
ELSE
	mov	ax, ds		; Make es = ds
	mov	es, ax
ENDIF
ENDIF
	mov	si,[bp+SARG+SINT] 
IFDEF	LDATA
	mov	ds,[bp+SARG+SINT+2]
ENDIF
	mov	cx,[bp+SARG+SINT+SPTR]
	mov	di,[bp+SARG+2*SINT+SPTR]
IFDEF	LDATA
	mov	es,[bp+SARG+2*SINT+SPTR+2]
ELSE
	zseg	di,es
ENDIF
	mov	dx,[bp+SARG+2*SINT+2*SPTR]
	mov	bx,[bp+SARG] 
	mov	ah,NET_READFROM 

	call	__dosyscall 
 
	pop	ds
	pop	di 
	pop	si 

	jmp	finish_neg2

_net_readfrom  	ENDP


; net_abortall() 
; 
	CPROC	_net_abortall

	chkinst

	push	bp 
	mov	bp,sp 
 
	mov	ah,NET_ABORTALL 
 
	call	__dosyscall 
 
	jmp	finish_neg1 
_net_abortall	ENDP


_TEXT	ENDS 
	END 

;
; $Log:   F:/21vcs/srclib/netlib/syscall6.asv  $
;  
;     Rev 1.1   30 Jan 1992 00:32:02   arnoff
;   
;
