;
; $Header:   K:/21vcs/srclib/netlib/syscall5.asv   1.2   20 Feb 1992 16:20:12   arnoff  $
;

;
; SYSCALL5.ASM -  Configuration & debugging-oriented syscall stubs.
;
; Copyright (C) 1986,1990,1991 by FTP Software, Inc., all rights reserved.
; 
; This software is furnished under a license and may be used and copied
; only in accordance with the terms of such license and with the
; inclusion of the above copyright notice. This software or any other
; copies thereof may not be provided or otherwise made available to any
; other person. No title to and ownership of the software is hereby
; transferred.
; 
; The information in this software is subject to change without notice
; and should not be construed as a commitment by FTP Software, Inc.
;
; Edit History
; 15-Jun-88	jbvb	Split off from SYSLIB.ASM for 2.03
; 06-Jul-88	jbvb	Bug in argument fetching in get_option(). 
; 08-Jul-88	jbvb	Common routine parses AX into neterrno & netsuberrno
; 23-Feb-90	jbvb	Add SS_NE_DS conditional, for Windows DLLs.
; 13-Apr-90     jbvb    Make get_option return right error ((long)-1).
; 29-Aug-91	Ben	Renamed *.def to *.inc
; 22-Oct-91	paul	removed paths from includes
; 18-Feb-92	davec	net_shutdown has error codes now
;

	INCLUDE dos.mac 
	INCLUDE mmodel.inc
	INCLUDE pctcp.inc

; first declare find_vec().
IFDEF	LCODE
	EXTRN	__find_vec:FAR
ELSE
_TEXT	segment
	EXTRN	__find_vec:NEAR
_TEXT	ends
ENDIF


_TEXT	SEGMENT 

	EXTRN	__dosyscall:near
	EXTRN	finish_neg1:near	; Common error handler & return
	EXTRN	finish_ax0:near		; Common error handler & return
	EXTRN	fix_pctcp_err: NEAR	; Common error parsing code.

_DATA	SEGMENT 
	EXTRN 	_neterrno:word 	; where we store error codes
	EXTRN	inited:word	; have we found the syscall vector?
_DATA	ENDS 

; macro used at start of every function to perform initialization if it
; hasn't happened already
chkinst	MACRO
	LOCAL	okay

	mov	ax,inited
	or	ax,ax
	jnz	okay

	call	__find_vec
	mov	inited,0FFFFh
okay:
	ENDM

; macro to zero out one register (s) if another (r) is already zero
zseg	MACRO	r,s
	LOCAL	done

	or	r,r
	jnz	done

	mov	s,r
done:
	ENDM

; unslword get_option(nd, level, option, value, len)
;
;	nd	BX
;	level	SI
;	option	DI
;	value	DS:DX
;	len	CX
; returns:
;	value	DS:DX

	CPROC	_get_option

	chkinst

	push	bp 
    	mov	bp,sp 
	push	si
	push	di

	push	ds

	mov	si,[bp+SARG+SINT]
	mov	di,[bp+SARG+2*SINT]
	mov	dx,[bp+SARG+3*SINT]
IFDEF	LDATA
	mov	ds,[bp+SARG+3*SINT+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	cx,[bp+SARG+3*SINT+SPTR]
    	mov	bx,[bp+SARG]
    	mov	ah,GET_OPTION
     
    	call	__dosyscall 

       	jc	gtopt1

    	mov	ax,dx 
    	mov	dx,ds 
       	jmp	gtopt2

gtopt1:
	call	fix_pctcp_err		; Load neterrno/netsuberrno from AX
	xor	ax,-1			; Error return is (long) -1. 
    	xor	dx,ax 

gtopt2:
    	pop	ds 
	pop	di
	pop	si
    	pop	bp 
	ret
_get_option	ENDP


; icmp_ping(host, len) 
; 
;	host	DX:BX
;	len	CX

	CPROC	_icmp_ping

	chkinst

	push	bp 
	mov	bp,sp 
 
	mov	ah,ICMP_PING 
	mov	bx,[bp+SARG] 
	mov	dx,[bp+SARG+2] 
	mov	cx,[bp+SARG+SLONG] 
 
	call	__dosyscall 
 
	jmp	finish_neg1

_icmp_ping	ENDP



; net_reconfig() - Ask TSR to re-read $IPCUST
; 

	CPROC	_net_reconfig

	chkinst

	push	bp 
	mov	bp,sp 
 
	mov	ah,NET_RECONFIG 
	call	__dosyscall 

	jmp	finish_ax0

_net_reconfig	ENDP
 


; net_shutdown() 
; 

	CPROC	_net_shutdown

	chkinst

	push	bp 
	mov	bp,sp 
 
	mov	ah,NET_SHUTDOWN 
	call	__dosyscall 
 
	jmp	finish_neg1		; davec - has error codes now
;	pop	bp 
;	ret 
 _net_shutdown	ENDP


; get_netversion()
;
	CPROC	_get_netversion

	chkinst

	mov	ah,GET_NETVERSION
	call	__dosyscall
	ret 
_get_netversion	ENDP



; net_info(nd, ni)
;	int	nd;			BX
;	struct netinfo far *ni;		DS:SI
;

	CPROC	_net_info

	chkinst

	push	bp
	mov	bp,sp
	push	si
	push	ds

	mov	si,[bp+SARG+SINT]
IFDEF	LDATA
	mov	ds,[bp+SARG+SINT+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	bx,[bp+SARG]
	mov	ah,NET_INFO
 
	call	__dosyscall 
 
	pop	ds
	pop	si
 
	jmp	finish_ax0	; Common error check & return

_net_info	ENDP



; net_stat(nd, ni)
;	int	nd;			BX
;	struct net_stats far *ns;	DS:DX
;

	CPROC	_net_stat

	chkinst

	push	bp
	mov	bp,sp
	push	ds

	mov	dx,[bp+SARG+SINT]
IFDEF	LDATA
	mov	ds,[bp+SARG+SINT+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	bx,[bp+SARG]
	mov	ah,NET_STAT
 
	call	__dosyscall 
 
	jnc	noerror35

	mov	ax,-1
	jmp	ret35

noerror35:
	xor	ax,ax
ret35:
	pop	ds
	pop	bp 
	ret 
_net_stat	ENDP


; net_get_k_conf(ni)
;	struct kernel_conf far *ni;		DS:SI
;

	CPROC	_net_get_k_conf

	chkinst

	push	bp
	mov	bp,sp
	push	si
	push	ds

	mov	si,[bp+SARG]
IFDEF	LDATA
	mov	ds,[bp+SARG+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss
	mov	ds, ax
ENDIF
ENDIF
	mov	ah, NET_GET_K_CONF
 
	call	__dosyscall 
 
	pop	ds
	pop	si
 
	jmp	finish_ax0	; Go to common error check & return

_net_get_k_conf	ENDP


_TEXT	ENDS 
	END 

;
; $Log:   K:/21vcs/srclib/netlib/syscall5.asv  $
;  
;     Rev 1.2   20 Feb 1992 16:20:12   arnoff
;  net_shutdown has error codes now.   davec
;  
;     Rev 1.1   30 Jan 1992 00:31:58   arnoff
;   
;
