;
; $Header:   J:/devkit.dos/vcs/srclib/netlib/src/syscall1.asv   1.2.1.0   03 May 1993 13:28:22   rcq  $
;

;
; SYSCALL1.ASM - Stubs to do general-purpose system calls.
;
; Copyright (C) 1986,1990,1991 by FTP Software, Inc., all rights reserved.
; 
; This software is furnished under a license and may be used and copied
; only in accordance with the terms of such license and with the
; inclusion of the above copyright notice. This software or any other
; copies thereof may not be provided or otherwise made available to any
; other person. No title to and ownership of the software is hereby
; transferred.
; 
; The information in this software is subject to change without notice
; and should not be construed as a commitment by FTP Software, Inc.
;
; Edit History
; 15-Jun-88	jbvb	Split off from SYSLIB.ASM for 2.03
; 08-Jul-88	jbvb	Create fix_pctcp_err(), to load neterrno & netsuberrno
; 22-Sep-89	jbvb	Remove some functions (to SYSCALL6.ASM)
; 23-Feb-90	jbvb	Add SS_NE_DS conditional, for Windows DLLs.
; 26-Feb-90	jbvb	Get Windows-proof code segment in __net_set_vector().
; 06-Dec-90	jbvb	Generate correct addr pointer in normal _net_read().
; 25-Aug-91  msd@ayuda	Implement 'net_yield' for multitaskers (e.g. MSW3).
; 29-Aug-91	Ben	Renamed *.def to *.inc
; 22-Oct-91	paul	removed paths from includes
; 04-Apr-92	gub	Zero ds if si==0 in net_read() (allows NULL buffers)
; 03-May-93 rcq,arnoff,sasha: copy name to buffer to accomodate kernel bug

	INCLUDE dos.mac 
	INCLUDE mmodel.inc
	INCLUDE pctcp.inc

; first declare find_vec().
IFDEF	LCODE
	EXTRN	__find_vec:FAR
ELSE
_TEXT	segment
	EXTRN	__find_vec:NEAR
_TEXT	ends
ENDIF


_TEXT	SEGMENT 

	PUBLIC	finish_name	; Global common exits for syscall routines.
	PUBLIC	finish_ax0
	PUBLIC	finish_neg1
	PUBLIC	finish_neg2

_DATA	SEGMENT 
       	PUBLIC	_neterrno
       	PUBLIC	_netsuberrno
	PUBLIC	inited
_namebuf	DB	102 DUP (0)	; vaseline buffer
_neterrno	DW	0 	; where we store error codes
_netsuberrno	DW	0	; Where we store sub-error codes
inited		DW	0	; have we found the syscall vector?
_DATA	ENDS 

; macro used at start of every function to perform initialization if it
; hasn't happened already
chkinst	MACRO
	LOCAL	okay

	mov	ax,inited
	or	ax,ax
	jnz	okay

	call	__find_vec
	mov	inited,0FFFFh
okay:
	ENDM

; macro to zero out one register (s) if another (r) is already zero
zseg	MACRO	r,s
	LOCAL	done

	or	r,r
	jnz	done

	mov	s,r
done:
	ENDM


; performs the system call.
; interrupt vector changes via self-modifying code, yipee!
	PUBLIC	__dosyscall
__dosyscall	PROC	NEAR
	int	061h
	ret
__dosyscall	ENDP

; Common code to parse AX into neterrno & netsuberrno.
; Destroys BX.

	PUBLIC	fix_pctcp_err

fix_pctcp_err	PROC	NEAR

IFDEF	LDATA
	push	ds
	mov	bx,SEG DGROUP
	mov	ds,bx
ENDIF
	mov	bh, ah			; Save sub-error code
	cbw				; Sign-extend error code
    	mov	[_neterrno],ax 		;  & store it.
	mov	al, bh			; Get sub-error code
	cbw				; Sign-extend sub-error code
    	mov	[_netsuberrno],ax 	;  & store it.
IFDEF	LDATA
	pop	ds
ENDIF
	ret
fix_pctcp_err	ENDP

; __net_set_vector() - Called at startup to point __dosyscall() at the
; right interrupt vector for the kernel.

	CPROC	__net_set_vector

	push	bp
	mov	bp, sp
	push	es

	mov	ax, cs				; Running in SEG _TEXT.
	mov	es, ax
	mov	ax, [bp+SARG]			; Get the vector to set.
	mov	bx, OFFSET _TEXT: __dosyscall
	mov	es: BYTE PTR [bx+1], al		; Set it.

	pop	es
	pop	bp
	ret
__net_set_vector	ENDP


; net_getdesc() 
; 
; returns 
;	nd	AX 

	CPROC	_net_getdesc

	chkinst

    	push	bp 

	mov	ah,NET_GETDESC 
         
	call	__dosyscall 

				; epilogue which returns -1 on error 
finish_neg1: 			; Assumes only BP on the stack
    	jnc	noerror_1 
	call	fix_pctcp_err	; Load neterrno/netsuberrno
    	mov	ax,-1 

noerror_1: 
    	pop	bp 
	ret 

_net_getdesc	ENDP


; is_netnd(fd) 
; 
;	fd	BX 

	CPROC	_is_netnd

	push	bp 
    	mov	bp,sp 

    	mov	ah,IS_NETND 
    	mov	bx,[bp+SARG] 
     
    	call	__dosyscall 
     
finish_ax0:			; Epilogue, checks error, sets AX == 0
				;  if error, only BP on stack
    	jnc	isnd_noerr
	call	fix_pctcp_err	; Load neterrno/netsuberrno
    	mov	ax,-1 
	jmp	isnd_ret

isnd_noerr:
	xor	ax,ax

isnd_ret:
    	pop	bp 
	ret 
_is_netnd	ENDP



; set_option(nd, level, option, value, len)
;
;	nd	BX
;	level	SI
;	option	DI
;	value	DS:DX
;	len	CX

	CPROC	_set_option

	chkinst

	push	bp 
    	mov	bp,sp 
	push	ds
	push	si
	push	di


    	mov	ah,SET_OPTION
    	mov	bx,[bp+SARG]
	mov	si,[bp+SARG+SINT]
	mov	di,[bp+SARG+2*SINT]
	mov	dx,[bp+SARG+3*SINT]
	mov	ds,[bp+SARG+3*SINT+2]	; independent of memory model
	mov	cx,[bp+SARG+3*SINT+SLONG]
     
    	call	__dosyscall 

	pop	di
	pop	si

    	jnc	so_done
	call	fix_pctcp_err	; Load neterrno/netsuberrno
	mov	ax, -1
	jmp short so_alldone

so_done:
	xor	ax,ax

so_alldone:
	pop	ds
    	pop	bp 
	ret 

_set_option	ENDP


; net_connect(fd, type, addr) 
; 
;	fd	BX 
;	type	DX 
;	addr	DS:SI 

	CPROC	_net_connect

	chkinst

	push	bp 
    	mov	bp,sp 
	push	si
       	push	ds 

    	mov	dx,[bp+SARG+SINT] 
IFDEF	LDATA
	mov	ds,[bp+SARG+2*SINT+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss			; Need to create correct far ptr.
	mov	ds, ax			; BP references off SS.
ENDIF
ENDIF
    	mov	si,[bp+SARG+2*SINT] 
    	mov	bx,[bp+SARG] 		; Network descriptor
    	mov	ah,NET_CONNECT		;  & function code.

    	call	__dosyscall 
 
    	pop	ds 
	pop	si

    	jmp	finish_neg1 
_net_connect	ENDP
 

; net_write(fd, buf, len, flags) 
; 
;	fd	BX 
;	buf	DS:SI 
;	len	CX 
;	flags	DX 

	CPROC	_net_write

	chkinst

	push	bp 
	mov	bp,sp 
	push	si 
	push	ds

IFDEF	LDATA
	mov	ds,[bp+SARG+SINT+2]	; only load DS in large data models
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss			; Need to create correct far ptr.
	mov	ds, ax			; BP references off SS.
ENDIF
ENDIF
	mov	si,[bp+SARG+SINT] 
    	mov	cx,[bp+SARG+SINT+SPTR]
    	mov	dx,[bp+SARG+2*SINT+SPTR]
	mov	bx,[bp+SARG] 
	mov	ah,NET_WRITE 

    	call	__dosyscall 
	pop	ds
    	pop	si 

	jnc	noerr_write
	call	fix_pctcp_err
	mov	ax,-1

noerr_write:		; Either -1, or length returned is in AX.
	pop	bp
	ret

_net_write	ENDP
 

; net_read(nd, buf, len, addr, flags) 
; 
;	nd	BX 
;	buf	DS:SI 
;	len	CX 
;	addr	ES:DI 
;	flags	DX 

	CPROC	_net_read

	chkinst

	push	bp 
	mov	bp,sp 
	push	si 
	push	di 
	push	ds

	mov	si,[bp+SARG+SINT] 
IFDEF	LDATA
	mov	ds,[bp+SARG+SINT+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss			; Need to create correct far ptr.
	mov	es, ax			; BP references off SS.
	mov	ds, ax			; Set correctly above
ELSE
	mov	ax, ds			; Need to create correct far ptr.
	mov	es, ax			; Set ES for addr
ENDIF
	zseg	si,ds			; Handle null buffers correctly
ENDIF
	mov	cx,[bp+SARG+SINT+SPTR]
	mov	di,[bp+SARG+2*SINT+SPTR]
IFDEF	LDATA
	mov	es,[bp+SARG+2*SINT+SPTR+2]
ELSE
	zseg	di,es
ENDIF
	mov	dx,[bp+SARG+2*SINT+2*SPTR]
	mov	bx,[bp+SARG] 
	mov	ah,NET_READ 
 
	call	__dosyscall 
 
	pop	ds
	pop	di 
	pop	si 

finish_neg2:			; Assumes only BP on the stack
	jnc	noerr2
	call	fix_pctcp_err	; Load neterrno/netsuberrno
	mov	ax,-1
	jmp short alldone2

noerr2:
	mov	ax,cx		; get return value in ax from cx
alldone2:
	pop	bp
	ret
_net_read  	ENDP


; net_release(fd) 
; 

	CPROC	_net_release

	chkinst

	push	bp 
	mov	bp,sp 
 
	mov	ah,NET_RELEASE 
	mov	bx,[bp+SARG]
 
	call	__dosyscall 
	jmp	finish_neg1 
_net_release	ENDP
 


; net_releaseall() 
; 

	CPROC	_net_releaseall

	chkinst

	push	bp 
	mov	bp,sp 
 
	mov	ah,NET_RELEASEALL 
 
	call	__dosyscall 
 
	jmp	finish_neg1 
_net_releaseall	ENDP


 
; net_abort(fd) 
; 
;	fd	BX

	CPROC	_net_abort

	chkinst

	push	bp 
	mov	bp,sp 
 
	mov	ah,NET_ABORT 
	mov	bx,[bp+SARG] 
 
	call	__dosyscall 
	jmp	finish_neg1 
_net_abort	ENDP


; nm_res_name(name, cname, len) 
; 
;	name	DS:DX
;	cname	ES:DI
;	len	CX

	CPROC	_nm_res_name

	chkinst

	push	bp 
	mov	bp,sp 
	push	si
	push	di
	push	ds 
 
	mov	si,[bp+SARG]		; name to resolve buffer
	mov	di,[bp+SARG+SPTR]
IFDEF	LDATA
	mov	ds,[bp+SARG+2]		; cononical name buffer
	mov	es,[bp+SARG+SPTR+2]
ELSE
IFDEF	SS_NE_DS
	mov	ax, ss			; Need to create correct far ptr.
	mov	es, ax			; BP references off SS.
	mov	ds, ax			; Set correctly above
ELSE
	mov	ax, ds
	mov	es, ax
ENDIF
	zseg	di,es
ENDIF
	;----------------
	; this section necessary since v2.1 & 2.2 kernels copy 100 bytes
	;  of data no matter how much is provided for name.  Hence, we
	;  put name in a 100 byte buffer to stay in our bounds (Borland
	;  compilers created code which caused a memory fault).
	push	es			;save cname segment
	push	di			;save cname offset

	mov	ax, SEG _DATA 		;_namebuf is dst in ES:DI
	mov	es, ax			;(name (arg) is src in DS:SI)
	mov	di, offset _DATA:_namebuf

	mov	cx, 100			;copy length 100 bytes maximum

	push	di			;this is gonna go in ds later

	cld				;we want to increment SI and DI
gub1:
	lodsb				;byte ptr from ds:[si] to al
	stosb				;byte ptr from al to es:[di]
	dec	cx			;exit if 100 bytes copied
	jcxz	gub2
	
	cmp	al, 0			; -> if so jump out of the loop
	jne	gub1

gub2:	pop	dx			;restore cname offset
	push	es			;transfer segment
	pop	ds			;ds:dx -> _namebuf

	pop	di			;restore cname offset
	pop	es			;restore cname segment
	;----------------

	mov	cx,[bp+SARG+2*SPTR]	;make and store cname length
	mov	ah,NM_RES_NAME		;_nm_res_name call code
 
	call	__dosyscall		;call the kernel
 
	; Return value is in dx:ax, where we want it.
                 
	pop	ds
	pop	di
	pop	si
finish_name:			; BP on stack, AX, DX == 0 on error.

	jnc	noerror14 
	call	fix_pctcp_err	; Load neterrno/netsuberrno
	xor	ax,ax 
	xor	dx,dx 
 
noerror14: 
	pop	bp 
	ret 

_nm_res_name	ENDP

; net_yield()
;
;  Attempt to release the current VM's time-slice, per MS Windows 3.0's
;  desires.  Runs in non-Windows environments invisibly.
;

	CPROC	_net_yield

	chkinst

	push	bp
	mov	bp, sp

	mov	ax, 352FH	; get vector 2F's address -- make sure non-zero
	int	21H
	mov	ax, es		; ES:BX == vector address
	or	ax, bx		; Q: is it zero?
	jz	SHORT @F	;    Y: Skip call
	mov	ax, 1680H	;    N: Tell MSW 3.0 386 we're idling
	int	2FH
@@:
	pop	bp
	ret

_net_yield	ENDP
 
_TEXT	ENDS 
	END 

;
; $Log:   J:/devkit.dos/vcs/srclib/netlib/src/syscall1.asv  $
;  
;     Rev 1.2.1.0   03 May 1993 13:28:22   rcq
;  added copy of name into buffer to compensate for 2.1/2.2 kernel bug
;  
;     Rev 1.2   06 Apr 1992 18:27:52   arnoff
;  On net_read() call, zero out ds if si is zero to correctly deal with
;  small-model apps passing in a NULL buffer.
;  		--Gub
;  
;     Rev 1.1   30 Jan 1992 00:31:44   arnoff
;   
;
