/*
 * $Header:   E:/22vcs/srclib/netlib/find_vec.c_v   1.3   09 Oct 1992 18:50:44   snyders  $
 */

/*
 * SRCLIB\NETLIB\FIND_VEC.C
 *
 * Copyright (C) 1986-1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 
 * EDIT HISTORY:
 * 05-Feb-88	jog	_find_vec now calls vec_search to do work previous
 * 			 versions of _find_vec did itself. vec_search returns
 * 			 vector # or 0 on failure. Functionality of _find_vec 
 * 			 is not changed.
 * 19-Feb-88	jbvb	Change message for HP 
 * 13-Oct-88	jbvb	Use puts() instead of printf().
 * 17-Oct-91	paul	added return type
 * 12-May-92	paul	added void arg to vec_search to satisfy compiler msg
 *			changed "PC\\TCP" to "PC/TCP"
 * 09-Oct-92	snyders	Very odd paul's changes did not stick?
 *			It is still PC\\TCP. Try it again.
 */

#include <stdio.h>
#include <stdlib.h>
#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/syscalls.h>

extern int vec_search(void);   /* routine to search interrupt table */

int
_find_vec()
{
      int vecnum;            /* = vector number or 0(on failure) */
   
      vecnum = vec_search(); /* look for packet driver vector    */
      
      if (vecnum != 0)       /* if found vector, return vector # */ 
          return (vecnum);
  
      /* else, not found */
#ifdef HP
      puts("The ARPA Services/Vectra resident module is not loaded.");
      puts("You should run \"netload\" and try the application again.");
#else
      puts("PC/TCP resident module is not loaded; aborting program...");
#endif
      exit(255);

      /* compiler will complain about "no return value", but that's life */
}

/*
 * $Log:   E:/22vcs/srclib/netlib/find_vec.c_v  $
 * 
 *    Rev 1.3   09 Oct 1992 18:50:44   snyders
 * Changed "PC\\TCP" to "PC/TCP"
 * 
 *    Rev 1.2   13 May 1992 13:43:10   paul
 * added void arg to vec_search to satisfy compiler msg
 * changed "PC\\TCP" to "PC/TCP"
 * updated copyright notice
 * 
 *    Rev 1.1   30 Jan 1992 00:31:16   arnoff
 *  
 */
