/*
 * $Header:   F:/21vcs/srclib/netlib/cleanup.c_v   1.1   30 Jan 1992 00:31:08   arnoff  $
 */

/*
 * SRCLIB\NETLIB\CLEANUP.C
 *
 * Copyright (C) 1988,1991 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 23-Feb-88	jbvb	Written, so we can print a message if net_releaseall()
 *			 fails (when BREAK is ON, or something).
 * 24-Feb-88	jbvb	Restore state of DOS BREAK flag to that at entry.
 * 02-Mar-88	jbvb	Use correct argument to DOS call
 * 06-Jul-88	jbvb	Eliminate error message (2.03 kernel is re-entrant).
 * 14-Dec-89	jbvb	Use net_abortall() to clean up quickly.
 */

#include <dos.h>

#include <pctcp/types.h>
#include <pctcp/error.h>
#include <pctcp/pctcp.h>

extern	int	_dos_break;	/* Non-zero if DOS BREAK was ON at entry */

/* Invoked via onexit() at program termination.
*/
void
pctcp_cleanup()
{
	union REGS reg;

	net_releaseall();		/* Graceful close of network descr. */
	if (_dos_break) {
		reg.x.ax = 0x3301;	/* Set BREAK state back to ON, */
		reg.h.dl = 1;		/*  as it was on entry. */
		intdos(&reg, &reg);
	}
}

/*
 * $Log:   F:/21vcs/srclib/netlib/cleanup.c_v  $
 * 
 *    Rev 1.1   30 Jan 1992 00:31:08   arnoff
 *  
 */
