/*
 * $Header:   F:/21vcs/srclib/netlib/abort.c_v   1.1   30 Jan 1992 00:31:06   arnoff  $
 */

/*
 * SRCLIB\NETLIB\ABORT.C - abnormal termination of network program.
 *
 * Copyright (C) 1989,1991 by FTP Software, Inc., all rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 14-Dec-89	jbvb	Written
 */

#include <stdlib.h>
#include <dos.h>

#include <pctcp/types.h>
#include <pctcp/pctcp.h>

extern	int	_dos_break;	/* Non-zero if DOS BREAK was ON at entry */

/* Invoked via signal(SIGABRT) on abnormal program termination.
*/
void
pctcp_abort()
{
	union REGS reg;

	net_abortall();		/* Ungraceful close on network descr. */
	if (_dos_break) {
		reg.x.ax = 0x3301;	/* Set BREAK state back to ON, */
		reg.h.dl = 1;		/*  as it was on entry. */
		intdos(&reg, &reg);
	}
	_exit(3);		/* Exit code specified by MSC */
}

/*
 * $Log:   F:/21vcs/srclib/netlib/abort.c_v  $
 * 
 *    Rev 1.1   30 Jan 1992 00:31:06   arnoff
 *  
 */
