/*
 * $Header:   J:/22vcs/srccmd/chargen/tchgenc.c_v   1.1   20 Jul 1992 19:18:40   paul  $
 */

/* 
 * TCHGENC.C
 *
 * Copyright (C) 1988,1992 by FTP Software, Inc.
 * 
 * This program is provided as an example of the use of the PC/TCP
 * Developer's Kit socket library.  This program, or modified versions
 * thereof, may be freely distributed, provided that this notice is
 * retained in any modifed versions.
 *          
 * Description: This TCP Client will connect (using a blocking socket)
 *  to the echo port of the IP Address specified on the Command Line,
 *  then sends the "chargen" printable ascii character sequence (reading
 *  what is echoed back).
 *
 * Functions Used: socket(), gethostbyname(), htons(), connect(), 
 *                 write(),  read(),   close()
 * 
 * Edit History:
 *  01-Jan-92	rcq	Created
 *  12-Jun-92	paul	changed <memory.h> to <string.h> for portability
 *			removed unused <errno.h>
 *			set stack size for Turbo/Borland version
 */

#include <stdio.h>
#include <stdlib.h>   /* for atoi() */
#include <conio.h>    /* for kbhit() & getch() */
#include <string.h>   /* for memset() & memcpy() used by bzero() & bcopy() */

#include <4bsddefs.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#ifdef __TURBOC__
extern unsigned _stklen = 8096;
#endif

#define BUF_SIZE     2048
#define BUF_DEFAULT  96
#define ECHO_PORT    7

void	GenChSeq (char*, int);   /* prototype for Char Sequence Generator */
int	getopt(int, char**, char*);
static void usage(void);

void main (int argc, char *argv[])
{
  struct sockaddr_in	stLclAddr;      /* Sockets Address Structure */
  struct hostent	*npstHostent;   /* Host Structure */
  int		wTcpSock;               /* TCP Socket */
  int		cbInLen;                /* Bytes in Input Buffer */
  int		cbOutLen;               /* Bytes in Output Buffer */
  char		achInBuf  [BUF_SIZE];   /* Input Buffer */
  char		achOutBuf [BUF_SIZE];   /* Output Buffer */
  int		cbBufSize;              /* Bytes to be Written */
  int		wDispFlag=1;            /* Display Toggle */
  struct linger	stTimeOut;              /* Linger time(out) structure */ 
  int		wRet;                   /* work variable */
  int		i;                      /* index */
  extern char 	*optarg;		/* getopt() extern */
  extern int 	optind;			/* getopt() extern */
  char	 	*npchOptlist = "b:B:eE";/* getopt() switch list */

  if (argc < 2)
	  usage();
  
  /* Default is # ASCII chars displayed (to get barberpole on screen)*/
  cbBufSize = BUF_DEFAULT;

  /* Parse Command Line options */
  while ((i = getopt(argc, argv, npchOptlist)) != EOF) {
      switch (i) {
	  case 'b':
	  case 'B':
	      cbBufSize = atoi(optarg);
	      if (cbBufSize > BUF_SIZE) {
		  printf ("Buf Size TOO BIG (Max %d)!\n", BUF_SIZE);
		  exit(1);
	      }
	      break;
	  case 'e':
	  case 'E':
	      wDispFlag = 0;
	      printf ("\nDisplaying Errors & Status Only.\n");
	      break;
	  default:
	      usage();
      }
  }

  /* Get a TCP socket */
  wTcpSock = socket (AF_INET, SOCK_STREAM, 0);
  if (wTcpSock < 0)  {
        perror("socket()");
        exit(1);
  }

  /* Get IP Address from a hostname (or IP address string in dot-notation) */
  if (optind < argc) npstHostent = gethostbyname(argv[optind]);
  else usage();

   /* Initialize the Sockets Internet Address (sockaddr_in) structure */
   bzero (&stLclAddr, sizeof(stLclAddr));
   bcopy (npstHostent->h_addr, &(stLclAddr.sin_addr), /* Difficult to cast */
	     sizeof(stLclAddr.sin_addr));
   stLclAddr.sin_family      = AF_INET;      /* Internet Address Family */
   stLclAddr.sin_port        = htons(ECHO_PORT);  /* TCP Echo Port */
    
   if (connect(wTcpSock,(struct sockaddr*)&stLclAddr,sizeof(stLclAddr)) < 0) {
	   perror ("connect()");
	   close(wTcpSock);
	   exit(1);
   }
      
   printf ("Connected to %s echo port, generating %d chars \
 (hit any key to quit)\n",
	   argv[optind], cbBufSize);
	  
   /* Can't Count on a Graceful Close since no Application Protocol */
   /*  to tell the server when to end ...so timeout 0 to send reset! */
   stTimeOut.l_onoff = 1;   /* Linger On */
   stTimeOut.l_linger = 0;  /* 0 Seconds */
   if (setsockopt(wTcpSock,
	           SOL_SOCKET,
		   SO_LINGER,
		   (char *) &stTimeOut,
		   sizeof(stTimeOut)))
	    perror ("setsockopt SO_LINGER");
    
  while (!kbhit()) {   /* Loop until any key pressed */
	    /* put chargen ASCII sequence into write buffer */
	    GenChSeq (achOutBuf, cbBufSize); 
	   
	    /* write to server */
	    cbOutLen = 0;
	    while (cbOutLen < cbBufSize) {
		    wRet = write (wTcpSock, achOutBuf, (cbBufSize-cbOutLen));
		    if (wRet < 0) {
			    printf ("\nsocket: %d; ",wTcpSock);
			    perror("write()");
			    close(wTcpSock);
			    exit(1);
		    }
		    cbOutLen += wRet;
	    }

	    /* read from server (hopefully what we just wrote) */
	    cbInLen = 0;
	    while (cbInLen < cbBufSize) {
		    wRet = read (wTcpSock, achInBuf, (cbBufSize-cbInLen));
		    if (wRet < 0) {
			    printf ("\nsocket %d; ", wTcpSock);
			    perror("read()");
			    close(wTcpSock);
			    exit(1);
		    }
		    else if ((wRet > 0) && (wDispFlag)) {
			    /* EOS & EOL (to print only 79 chars) */
			    i = (wRet < 79) ? wRet:79;
			    achInBuf[i]   = 13; /* CR */
			    achInBuf[i+1] = 10; /* LF */
			    achInBuf[i+2] = 0;  /* EOS */
    
			    printf(achInBuf);
		    }
		    cbInLen += wRet;
            }
    } /* end main loop */
    getch();
    
    printf ("\nClosing connection... ");
    close(wTcpSock);
    printf ("Closed!\n");
} /* main() */

/*
 *  Function: GenChSeq()
 *
 *  Description: Puts chargen sequence into buffer passed, inserting
 *   as many characters as specified in second variable passed.
 */
void GenChSeq (char *npchBuf, int wCount)
{
#define nextBP(c)	((c) == '~' ? ' ' : (c)+1)
	
	static int w = ' ';               /* first char is a space */
	int i;
	
	for (i=0; i<wCount; i++) {
		*(npchBuf+i) = (char) w;
		w = nextBP(w);
	}
}  /* end GenChSeq() */

static void usage(void)
{
    printf ("\n\
Usage: tchgenc [-b#] [-e] host\n\
          host  name or IP addr of echo server\n\
          -b#   size of writes to server\n\
          -e    Display Errors & Status Only\n");
    exit(1);
} /* end usage() */

/*
 * $Log:   J:/22vcs/srccmd/chargen/tchgenc.c_v  $
 * 
 *    Rev 1.1   20 Jul 1992 19:18:40   paul
 * changed <memory.h> to <string.h> for portability
 * removed unused <errno.h>
 * set stack size for Turbo/Borland version
 */
