/*
 * $Header:   J:/22vcs/srccmd/chargen/echod.c_v   1.1   20 Jul 1992 19:17:40   paul  $
 */

/*
 * ECHOD.C
 *
 * Copyright (C) 1988,1992 by FTP Software, Inc.
 * 
 * This program is provided as an example of the use of the PC/TCP
 * Developer's Kit socket library.  This program, or modified versions
 * thereof, may be freely distributed, provided that this notice is
 * retained in any modifed versions.
 *
 *
 *  Description: This TCP Server (non-blocking socket) allows a
 *   single client to connect (to the echo port, 7).  While 
 *   connected, it will echo everything it receives back to the 
 *   remote client (and to the local screen).
 *   If the 'c' command line option is used, it will expect and
 *   verify the chargen ascii character sequence (which can be
 *   generated by tchgenc).
 *
 * Functions used: socket(), gethostid(), getservbyname(), bind(),
 *		   listen(), accept(), ioctl(), setsockopt(), read(),
 *                 write(),  close()
 *
 * Edit History:
 * 01-Jan-92	rcq	Created
 * 12-Jun-92	paul	set stack size for Turbo/Borland version
 */

#include <stdio.h>         /* for putchar() */
#include <stdlib.h>        /* for atoi() */

#include <4bsddefs.h>      /* for standard socket calls */
#include <sys/socket.h>
#include <netdb.h>
#include <errno.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>

#ifdef __TURBOC__
extern unsigned _stklen = 8096;
#endif

#define BUFLEN 2048
#define CR  13
#define LF  10
#define LOOP_LIMIT 0x0000FFFFL

void	ChkChSeq(char*, int);     /* prototype for chargen sequence checker */
int	getopt(int, char**, char*);
static void usage(void);


void main (int argc, char *argv[])
{
    struct sockaddr_in  stLclAddr;      /* Sockets Address Structure */
    struct sockaddr_in  stRemAddr;	                    
    struct linger	stTimeOut;	/* Linger time(out) structure */
    struct servent	*npstServ;	/* Ptr to Services structure */ 
    int		wLstnSock;		/* TCP (Listening) Socket */
    int		wConSock;		/* TCP (Connected) Socket */
    long	lHostID;		/* (Local) Host IP Addr */
    char	achInBuf[BUFLEN];	/* Input Buffer */
    int		wChkFlag = 0;		/* Chargen Check Toggle */
    int		wDispFlag = 1;		/* Display Toggle */
    int		cbInLen;		/* Bytes in Input Buffer */
    int		cbOutLen;		/* Bytes in Output Buffer */
    int		wOpt;				/* work variable */
    int		wAddrLen = sizeof (stLclAddr);	/* work variable */
    u_long	wCntr = 0;			/* work variable */
    int		i;				/* index */
    extern char	*optarg;			/* getopt() extern */
    extern int 	optind;				/* getopt() extern */
    char 	*npchOptlist = "cCeE";		/* getopt() switch list */

    /* parse command line */

    while ((i = getopt(argc, argv, npchOptlist)) != EOF) {
	switch (i) {
	    case 'c':
	    case 'C':
		wChkFlag = 1;
		printf ("\nASCII Sequence Check is ENABLED!\n");
		break;
	    case 'e':
	    case 'E':
		wDispFlag = 0;
		printf ("\nDisplaying Errors & Status Only.\n");
		break;
	    default:
		usage();
	}
    }

    /* get a socket */
    wLstnSock = socket (AF_INET, SOCK_STREAM, 0);
    if (wLstnSock < 0) {
        perror ("socket()");
        exit (2);
    }

    /* get local IP address from pctcp.ini file */
    lHostID = gethostid();
    if (lHostID == 0) {
        perror ("gethostid()");
        exit(3);
    }

    /* The getservbyname() function references the "services" file */
    /*  (to use this you must set the FTP_ETC environment variable to */
    /*  the disk:\path where the services file is located)! */
    if (!(npstServ = getservbyname ("echo","tcp"))) {
	    printf("getservbyname(): Service/Protocol not found");
	    exit(4);
    }
    
    /* initialize local sockaddr_in structure */
    stLclAddr.sin_family      = AF_INET;    /* "Internet" Address Family */
    stLclAddr.sin_addr.s_addr = lHostID;    /* Local IP address */
    stLclAddr.sin_port = npstServ->s_port;  /* Set to "Echo" Port */ 

    /* bind local ip address & port number to the socket */
    if (bind (wLstnSock, (struct sockaddr*)&stLclAddr, wAddrLen) < 0) {
        perror ("bind");
        exit(5);
    }

    /* "passively open" the socket */
    if ((listen (wLstnSock, 1)) < 0) {
        perror("listen()");
        exit (6);
    }

    /* wait for client to connect to local ip addr requesting echo service */
    printf ("\nWaiting for connection from echo client... ");
    wConSock = accept (wLstnSock, (struct sockaddr*) &stRemAddr, &wAddrLen);
    if (wConSock < 0) {
        perror ("accept()");
        exit (7);
    } 
    else
	    printf ("Connected!\n");

    /* close listening socket (not accepting any more connections) */
    close (wLstnSock);  
    
    /* set socket to non-blocking (we're more flexible this way, we */
    /*  can display any data we receive as soon as we receive it,    */
    /*  returning from read() without knowing how much data to expect */
    wOpt = 1;
    if (ioctl(wConSock, FIONBIO, (char *)&wOpt))
        perror ("ioctl (non-block)");

    /* set close linger to 0 to do ABORT on error (Send a Reset)! */
    stTimeOut.l_onoff = 1;
    stTimeOut.l_linger = 0;
    if (setsockopt(wConSock, 
	           SOL_SOCKET,
		   SO_LINGER, 
	           (char *) &stTimeOut, 
		   sizeof(stTimeOut)))
           perror ("setsockopt (SO_LINGER)");

    /* Loop reading from client, displaying and writing back to client */
    for (;;) {
        if ((cbInLen = read (wConSock, achInBuf, BUFLEN)) <= 0) {
		if (errno != EWOULDBLOCK) {
		    perror ("read()");
		    close (wConSock);
		    exit(8);
		}
		else  {
			/* Without examining the data received along with */
			/*  an application level protocol ("quit" message),*/
			/*  its not easily possible to know when the Client */
			/*  has really quit ...this mechanism is one (crude)*/
			/*  alternative (consecutive EWOULDBLOCK err limit) */
			if (wCntr++ > LOOP_LIMIT)  {
				printf ("\nread(): Timeout\n");
				break;
			}
		}
        }
        else {
	    wCntr = 0;   /* init (idle) loop counter ...we rcvd something! */
		
            if (wChkFlag)     /* (if requested) check chargen sequence */
                ChkChSeq (achInBuf, cbInLen);
	
	    /* Add EOL & EOS and display buffer contents */
	    if (wDispFlag) {
		    i = (cbInLen < 79) ? cbInLen:79;
		    achInBuf[i]   = CR;
		    achInBuf[i+1] = LF;
		    achInBuf[i+2] = 0;
		    printf (achInBuf);   /* display it to the screen */
	    }

	    /* Send (echo) back what we received */
	    cbOutLen = 0;
	    while (cbOutLen < cbInLen) {  /* written all that's read? */
		    if ((cbOutLen = write (wConSock, achInBuf, cbInLen)) < 0) {
			    if (errno != EWOULDBLOCK) {
				    perror ("write()");
				    close (wConSock);
				    exit(9);
			    }
		    }
		    cbInLen -= cbOutLen;   /* Subtract what we've written */
            }
        }
    }  /* end for (;;) loop */

    /* Chances are slim we'll ever make it here since we can count on */
    /*  the client sending a RESET to end the connection (since there */
    /*  is no application protocol) and if we get that we abort */
    printf ("Closing Socket... ");
    close (wConSock);
    printf ("Client Disconnected!\n");

    exit(0);

}  /* end main() */

/*
 *  Function: ChkChSeq()
 *
 *  Description: Verifies chargen sequence in buffer (checks number of
 *   characters passed in buffer passed).  An error is displayed if
 *   any descrepancies are found.
 */
void  ChkChSeq (char *npchBuf, int wCount)
{
#define nextBP(c)	((c) == '~' ? ' ' : (c)+1)
	
	static int w = ' ';               /* first char is a space */
	int i;
	
    for (i=0; i<wCount; i++) {
        if (*(npchBuf+i) != (char) w)
            printf ("\nERROR: expected '%c', received '%c'\n",
                    (char) w, *(npchBuf+i));
        w = nextBP(w);
    }
}  /* end ChkChSeq() */

void usage(void)
{
    printf ("\
usage: echod [-c] [-e]\n\
         -c  Check chargen char sequence\n\
         -e  Display Errors & Status Only\n");
    exit(1);
} /* end usage() */

/*
 * $Log:   J:/22vcs/srccmd/chargen/echod.c_v  $
 * 
 *    Rev 1.1   20 Jul 1992 19:17:40   paul
 * set stack size for Turbo/Borland version
 */
