/*
 * $Header:   K:\devkit.dos\vcs\include\syslog.h_v   1.9.1.0   19 Apr 1993 13:35:30   arnoff  $
 */

#ifndef __SYSLOG_HEADER__
#define __SYSLOG_HEADER__



/*
 *
 * Copyright (C) 1986-1993 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 *	edit history
 *	5SEP89		stev	added 4.3 stuff to it.
 */

/*
 *  SYSLOG.H -- declarations for system logging program
 *
 *
 *	LOG_ALERT -- this priority should essentially never
 *		be used.  It applies only to messages that
 *		are so important that every user should be
 *		aware of them, e.g., a serious hardware failure.
 *	LOG_SALERT -- messages of this priority should be
 *		issued only when immediate attention is needed
 *		by a qualified system person, e.g., when some
 *		valuable system resource dissappears.  They get
 *		sent to a list of system people.
 *	LOG_EMERG -- Emergency messages are not sent to users,
 *		but represent major conditions.  An example
 *		might be hard disk failures.  These could be
 *		logged in a separate file so that critical
 *		conditions could be easily scanned.
 *	LOG_ERR -- these represent error conditions, such as soft
 *		disk failures, etc.
 *	LOG_CRIT -- such messages contain critical information,
 *		but which can not be classed as errors, for example,
 *		'su' attempts.
 *	LOG_WARNING -- issued when an abnormal condition has been
 *		detected, but recovery can take place.
 *	LOG_NOTICE -- something that falls in the class of
 *		"important information"; this class is informational
 *		but important enough that you don't want to throw
 *		it away casually.
 *	LOG_INFO -- information level messages.  These messages
 *		could be thrown away without problems, but should
 *		be included if you want to keep a close watch on
 *		your system.
 *	LOG_DEBUG -- it may be useful to log certain debugging
 *		information.  Normally this will be thrown away.
 */

/*
 *  facility codes, all are included for completeness (SP?) sake,
 *  some, like LOG_KERN, have no use in anything you should be porting.
 */

#define LOG_KERN	(0<<3)	/* kernel messages 			*/
#define LOG_USER	(1<<3)	/* random user-level messages 		*/
#define LOG_MAIL	(2<<3)	/* mail system 				*/
#define LOG_DAEMON	(3<<3)	/* system daemons 			*/
#define LOG_AUTH	(4<<3)	/* security/authorization messages 	*/
#define LOG_SYSLOG	(5<<3)	/* messages generated by syslogd 	*/
#define LOG_LPR		(6<<3)	/* line printer subsystem 		*/

/* other codes through 15 reserved for system use 			*/

#define LOG_LOCAL0	(16<<3)	/* reserved for local use 		*/
#define LOG_LOCAL1	(17<<3)	/* reserved for local use 		*/
#define LOG_LOCAL2	(18<<3)	/* reserved for local use 		*/
#define LOG_LOCAL3	(19<<3)	/* reserved for local use 		*/
#define LOG_LOCAL4	(20<<3)	/* reserved for local use 		*/
#define LOG_LOCAL5	(21<<3)	/* reserved for local use 		*/
#define LOG_LOCAL6	(22<<3)	/* reserved for local use 		*/
#define LOG_LOCAL7	(23<<3)	/* reserved for local use 		*/

#define LOG_NFACILITIES	24	/* maximum number of facilities 	*/
#define LOG_FACMASK	0x03f8	/* mask to extract facility part 	*/


/*
 *  Priorities 
 */


#define LOG_EMERG	0	/* system is unusable 			*/
#define LOG_ALERT	1	/* action must be taken immediately 	*/
#define LOG_CRIT	2	/* critical conditions 			*/
#define LOG_ERR		3	/* error conditions 			*/
#define LOG_WARNING	4	/* warning conditions 			*/
#define LOG_NOTICE	5	/* normal but signification condition 	*/
#define LOG_INFO	6	/* informational 			*/
#define LOG_DEBUG	7	/* debug-level messages 		*/
#define LOG_NOTHING	10	/* dont print anything (default)	*/
#define LOG_PRIMASK	0x0007	/* mask to extract priority (internal)	*/

/*
 * arguments to setlogmask.
 */

#define	LOG_MASK(pri)	(1 << (pri))	/* mask for one priority 	*/
#define	LOG_UPTO(pri)	((1 << ((pri)+1)) - 1)	/* priorities through pri */

/*
 *  Option flags for openlog.
 *
 *	LOG_ODELAY no longer does anything; LOG_NDELAY is the
 *	inverse of what it used to be.
 */

#define	LOG_PID		0x01	/* log the pid with each message 	*/
#define	LOG_CONS	0x02	/* log on the con if errors in sending 	*/
#define	LOG_ODELAY	0x04	/* delay open until syslog() is called	*/
#define LOG_NDELAY	0x08	/* don't delay open 			*/
#define LOG_NOWAIT	0x10	/* if forking to log on con, don't wait()*/
				/* ok, so this last one sint useful	*/



/*
 * $Log:   K:\devkit.dos\vcs\include\syslog.h_v  $ * 
 * 
 *    Rev 1.9.1.0   19 Apr 1993 13:35:30   arnoff
 * Removed extra LF chars, updated copyright date
 *    Rev 1.9.1.0   07 Apr 1993 15:23:14   arnoff
 * Protected for multiple inclusion.

 * 
 *    Rev 1.9   29 Jan 1993 10:05:06   sueg
 * updated copyright notice.
 * 
 *    Rev 1.8   30 Jan 1992 08:27:52   arnoff
 *  
 */


#endif /* __SYSLOG_HEADER__ */

