 #ifndef FTP
#define FTP /*Copyright 1992, FTP Software, Inc.  All Rights Reserved.*/
#endif /* FTP */
#ifdef FTP /* added code */
#ifndef RC_INVOKED
#pragma comment (exestr, "$Id: xdr.h%v 1.7 1993/03/31 14:12:11 db Exp $")
#endif /* RC_INVOKED */
/*
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Revision 1.2  1992/06/12  03:06:29  dwh
 * Initial FTP port for OS/2.
 *
 * Revision 1.1  1992/03/13  02:17:37  dwh
 * Sun RPCSRC4.0 Porting Base.
 */
#else /* FTP superceded code */
/* @(#)xdr.h	2.2 88/07/29 4.0 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*      @(#)xdr.h 1.19 87/04/22 SMI      */

/*
 * xdr.h, External Data Representation Serialization Routines.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */
#endif /* FTP */

#ifndef __XDR_HEADER__
#define __XDR_HEADER__

#ifdef FTP /* added code */
#include <stdio.h>
#endif /* FTP */
/*
 * XDR provides a conventional way for converting between C data
 * types and an external bit-string representation.  Library supplied
 * routines provide for the conversion on built-in C data types.  These
 * routines and utility routines defined here are used to help implement
 * a type encode/decode routine for each user-defined type.
 *
 * Each data type provides a single procedure which takes two arguments:
 *
 *	bool_t
 *	xdrproc(xdrs, argresp)
 *		XDR *xdrs;
 *		<type> *argresp;
 *
 * xdrs is an instance of a XDR handle, to which or from which the data
 * type is to be converted.  argresp is a pointer to the structure to be
 * converted.  The XDR handle contains an operation field which indicates
 * which of the operations (ENCODE, DECODE * or FREE) is to be performed.
 *
 * XDR_DECODE may allocate space if the pointer argresp is null.  This
 * data can be freed with the XDR_FREE operation.
 *
 * We write only one procedure per data type to make it easy
 * to keep the encode and decode procedures for a data type consistent.
 * In many cases the same code performs all operations on a user defined type,
 * because all the hard work is done in the component type routines.
 * decode as a series of calls on the nested data types.
 */

/*
 * Xdr operations.  XDR_ENCODE causes the type to be encoded into the
 * stream.  XDR_DECODE causes the type to be extracted from the stream.
 * XDR_FREE can be used to release the space allocated by an XDR_DECODE
 * request.
 */
enum xdr_op {
	XDR_ENCODE=0,
	XDR_DECODE=1,
	XDR_FREE=2
};

/*
 * This is the number of bytes per unit of external data.
 */
#define BYTES_PER_XDR_UNIT	(4)
#define RNDUP(x)  ((((x) + BYTES_PER_XDR_UNIT - 1) / BYTES_PER_XDR_UNIT) \
		    * BYTES_PER_XDR_UNIT)

/*
 * A xdrproc_t exists for each data type which is to be encoded or decoded.
 *
 * The second argument to the xdrproc_t is a pointer to an opaque pointer.
 * The opaque pointer generally points to a structure of the data type
 * to be decoded.  If this pointer is 0, then the type routines should
 * allocate dynamic storage of the appropriate size and return it.
 * bool_t	(*xdrproc_t)(XDR *, caddr_t *);
 */

/*
 * The above seems to be incorrect.  The second argument appears to be
 * an opaque pointer rather than a pointer to one (caddr_t not caddr_t *).
 */
/* typedef moved after XDR def immediately below */

typedef	bool_t (_DLL_FLAGS *xdrproc_t)();


/*
 * The XDR handle.
 * Contains operation which is being applied to the stream,
 * an operations vector for the paticular implementation (e.g. see xdr_mem.c),
 * and two private fields for the use of the particular impelementation.
 */

typedef struct xdr {
	enum xdr_op	x_op;		/* operation; fast additional param */
	struct xdr_ops {
		bool_t	(_DLL_FLAGS *x_getlong)(struct xdr FAR *, long FAR *);
				/* get a long from underlying stream */
		bool_t	(_DLL_FLAGS *x_putlong)(struct xdr FAR *, long FAR *);	
				/* put a long to " */
		bool_t	(_DLL_FLAGS *x_getbytes)(struct xdr FAR *, caddr_t, u_int);
				/* get some bytes from " */
		bool_t	(_DLL_FLAGS *x_putbytes)(struct xdr FAR *, caddr_t, u_int);
				/* put some bytes to " */
		u_int	(_DLL_FLAGS *x_getpostn)(struct xdr FAR *);
				/* returns bytes off from beginning */
		bool_t  (_DLL_FLAGS *x_setpostn)(struct xdr FAR *, u_int);
				/* lets you reposition the stream */
		long FAR *(_DLL_FLAGS *x_inline)(struct xdr FAR *, u_int);	
				/* buf quick ptr to buffered data */
		void	(_DLL_FLAGS *x_destroy)(struct xdr FAR *);	
				/* free privates of this xdr_stream */
	} FAR *x_ops;
	caddr_t 	x_public;	/* users' data */
	caddr_t		x_private;	/* pointer to private data */
	caddr_t 	x_base;		/* private used for position info */
	int		x_handy;	/* extra private word */
} XDR;
typedef	bool_t (_DLL_FLAGS *xdrproc_t)(XDR FAR *, caddr_t);


/*
 * Operations defined on a XDR handle
 *
 * XDR		*xdrs;
 * long		*longp;
 * caddr_t	 addr;
 * u_int	 len;
 * u_int	 pos;
 */
#define XDR_GETLONG(xdrs, longp)			\
	(*(xdrs)->x_ops->x_getlong)((XDR FAR *)xdrs, (u_long FAR *)longp)
#define xdr_getlong(xdrs, longp)			\
	(*(xdrs)->x_ops->x_getlong)((XDR FAR *)xdrs, (u_long FAR *)longp)

#define XDR_PUTLONG(xdrs, longp)			\
	(*(xdrs)->x_ops->x_putlong)((XDR FAR *)xdrs, (u_long FAR *)longp)
#define xdr_putlong(xdrs, longp)			\
	(*(xdrs)->x_ops->x_putlong)((XDR FAR *)xdrs, (u_long FAR *)longp)

#define XDR_GETBYTES(xdrs, addr, len)			\
	(*(xdrs)->x_ops->x_getbytes)((XDR FAR *)xdrs, (caddr_t)addr, len)
#define xdr_getbytes(xdrs, addr, len)			\
	(*(xdrs)->x_ops->x_getbytes)((XDR FAR *)xdrs, (caddr_t)addr, len)

#define XDR_PUTBYTES(xdrs, addr, len)			\
	(*(xdrs)->x_ops->x_putbytes)((XDR FAR *)xdrs, (caddr_t)addr, len)
#define xdr_putbytes(xdrs, addr, len)			\
	(*(xdrs)->x_ops->x_putbytes)((XDR FAR *)xdrs, (caddr_t)addr, len)

#define XDR_GETPOS(xdrs)				\
	(*(xdrs)->x_ops->x_getpostn)((XDR FAR *)xdrs)
#define xdr_getpos(xdrs)				\
	(*(xdrs)->x_ops->x_getpostn)((XDR FAR *)xdrs)

#define XDR_SETPOS(xdrs, pos)				\
	(*(xdrs)->x_ops->x_setpostn)((XDR FAR *)xdrs, pos)
#define xdr_setpos(xdrs, pos)				\
	(*(xdrs)->x_ops->x_setpostn)((XDR FAR *)xdrs, pos)

#define	XDR_INLINE(xdrs, len)				\
	(*(xdrs)->x_ops->x_inline)((XDR FAR *)xdrs, len)
#define	xdr_inline(xdrs, len)				\
	(*(xdrs)->x_ops->x_inline)((XDR FAR *)xdrs, len)

#define	XDR_DESTROY(xdrs)				\
	if ((xdrs)->x_ops->x_destroy) 			\
		(*(xdrs)->x_ops->x_destroy)((XDR FAR *)xdrs)
#define	xdr_destroy(xdrs)				\
	if ((xdrs)->x_ops->x_destroy) 			\
		(*(xdrs)->x_ops->x_destroy)((XDR FAR *)xdrs)

/*
 * Support struct for discriminated unions.
 * You create an array of xdrdiscrim structures, terminated with
 * a entry with a null procedure pointer.  The xdr_union routine gets
 * the discriminant value and then searches the array of structures
 * for a matching value.  If a match is found the associated xdr routine
 * is called to handle that part of the union.  If there is
 * no match, then a default routine may be called.
 * If there is no match and no default routine it is an error.
 */
#define NULL_xdrproc_t ((xdrproc_t)0)
struct xdr_discrim {
	int	value;
	xdrproc_t proc;
};

/*
 * In-line routines for fast encode/decode of primitve data types.
 * Caveat emptor: these use single memory cycles to get the
 * data from the underlying buffer, and will fail to operate
 * properly if the data is not aligned.  The standard way to use these
 * is to say:
 *	if ((buf = XDR_INLINE(xdrs, count)) == NULL)
 *		return (FALSE);
 *	<<< macro calls >>>
 * where ``count'' is the number of bytes of data occupied
 * by the primitive data types.
 *
 * N.B. and frozen for all time: each data type here uses 4 bytes
 * of external representation.
 */
#define IXDR_GET_LONG(buf)		((long)ntohl((u_long)*(buf)++))
#define IXDR_PUT_LONG(buf, v)		(*(buf)++ = (u_long)htonl((u_long)v))

#define IXDR_GET_BOOL(buf)		((bool_t)IXDR_GET_LONG(buf))
#define IXDR_GET_ENUM(buf, t)		((t)IXDR_GET_LONG(buf))
#define IXDR_GET_U_LONG(buf)		((u_long)IXDR_GET_LONG(buf))
#define IXDR_GET_SHORT(buf)		((short)IXDR_GET_LONG(buf))
#define IXDR_GET_U_SHORT(buf)		((u_short)IXDR_GET_LONG(buf))

#define IXDR_PUT_BOOL(buf, v)		IXDR_PUT_LONG((buf), ((long)(v)))
#define IXDR_PUT_ENUM(buf, v)		IXDR_PUT_LONG((buf), ((long)(v)))
#define IXDR_PUT_U_LONG(buf, v)		IXDR_PUT_LONG((buf), ((long)(v)))
#define IXDR_PUT_SHORT(buf, v)		IXDR_PUT_LONG((buf), ((long)(v)))
#define IXDR_PUT_U_SHORT(buf, v)	IXDR_PUT_LONG((buf), ((long)(v)))

/*
 * These are the "generic" xdr routines.
 */

/* xdr.c */
extern bool_t _DLL_FLAGS xdr_void();
extern bool_t _DLL_FLAGS xdr_int(XDR FAR *xdrs, int FAR *ip);
extern bool_t _DLL_FLAGS xdr_u_int(XDR FAR *xdrs, u_int FAR *up);
extern bool_t _DLL_FLAGS xdr_long(XDR FAR *xdrs, long FAR *lp);
extern bool_t _DLL_FLAGS xdr_u_long(XDR FAR *xdrs, u_long FAR *ulp);
extern bool_t _DLL_FLAGS xdr_short(XDR FAR *xdrs, short FAR *sp);
extern bool_t _DLL_FLAGS xdr_u_short(XDR FAR *xdrs, u_short FAR *usp);
extern bool_t _DLL_FLAGS xdr_char(XDR FAR *xdrs, char FAR *cp);
extern bool_t _DLL_FLAGS xdr_u_char(XDR FAR *xdrs, char FAR *cp);
extern bool_t _DLL_FLAGS xdr_bytes(XDR FAR *xdrs, char FAR * FAR *cpp,
                                    u_int FAR *sizep, u_int maxsize);
extern bool_t _DLL_FLAGS xdr_union(XDR FAR *xdrs, enum_t FAR *dscmp,
               char FAR *unp, struct xdr_discrim FAR *choices, xdrproc_t dfault);
extern bool_t _DLL_FLAGS xdr_string(XDR FAR *xdrs, char FAR * FAR *cpp,
                                    u_int maxsize);
extern void _DLL_FLAGS xdr_free(xdrproc_t proc, char FAR *objp);
extern bool_t _DLL_FLAGS xdr_bool(XDR FAR *xdrs, bool_t FAR *bp);
extern bool_t _DLL_FLAGS xdr_enum(XDR FAR *xdrs, enum_t FAR *ep);
extern bool_t _DLL_FLAGS xdr_opaque(XDR FAR *xdrs, caddr_t cp, u_int cnt);
extern bool_t _DLL_FLAGS xdr_wrapstring(XDR FAR *xdrs, char FAR * FAR *cpp);
/* x_array.c */
extern bool_t _DLL_FLAGS xdr_array(XDR FAR *xdrs, caddr_t FAR *addrp,
                                u_int FAR *sizep,
                                u_int maxsize, u_int elsize, xdrproc_t elproc);
extern bool_t _DLL_FLAGS xdr_vector(XDR FAR *xdrs, char FAR *basep, u_int nelem,
                                    u_int elemsize, xdrproc_t xdr_elem);
/* x_float.c */
extern bool_t _DLL_FLAGS xdr_float(XDR FAR *xdrs, float FAR *fp);
extern bool_t _DLL_FLAGS xdr_double(XDR FAR *xdrs, double FAR *dp);
/* x_refere.c */
extern bool_t _DLL_FLAGS xdr_reference(XDR FAR *xdrs, caddr_t FAR  *pp,
                                       u_int size, xdrproc_t proc);
extern bool_t _DLL_FLAGS xdr_pointer(XDR FAR *xdrs, char FAR * FAR *objpp,
                                     u_int obj_size, xdrproc_t xdr_obj);
/* xdr.c */
extern bool_t _DLL_FLAGS xdr_wrapstring(XDR FAR *xdrs, char FAR * FAR *cpp);


#ifdef WINSOCK
#if 0
/* xdr.c */
FARPROC lpfn_xdr_void   = xdr_void;
FARPROC lpfn_xdr_int    = xdr_int;
FARPROC lpfn_xdr_u_int  = xdr_uint;
FARPROC lpfn_xdr_long   = xdr_long;
FARPROC lpfn_xdr_u_long = xdr_u_long;
FARPROC lpfn_xdr_short  = xdr_short;
FARPROC lpfn_xdr_u_short= xdr_u_short;
FARPROC lpfn_xdr_char   = xdr_char;
FARPROC lpfn_xdr_u_char = xdr_u_char;
FARPROC lpfn_xdr_bytes  = xdr_bytes;
FARPROC lpfn_xdr_union  = xdr_union;
FARPROC lpfn_xdr_string = xdr_string;
FARPROC lpfn_xdr_free   = xdr_free;
FARPROC lpfn_xdr_bool   = xdr_bool;
FARPROC lpfn_xdr_enum   = xdr_enum;
FARPROC lpfn_xdr_opaque = xdr_opaque;
FARPROC lpfn_xdr_wrapstring = xdr_wrapstring;
FARPROC lpfn_xdr_array  = xdr_array;
FARPROC lpfn_xdr_vector = xdr_vector;

FARPROC lpfn_xdr_float  = xdr_float;
FARPROC lpfn_xdr_double = xdr_double;
/* x_refere.c */
FARPROC lpfn_xdr_reference = xdr_reference;
FARPROC lpfn_xdr_pointer= xdr_pointer;
/* xdr.c */
FARPROC lpfn_xdr_wrapstring = xdr_wrapstring;

#else
/* xdr.c */
#define lpfn_xdr_void     xdr_void 
#define lpfn_xdr_int      xdr_int 
#define lpfn_xdr_u_int    xdr_uint 
#define lpfn_xdr_long     xdr_long 
#define lpfn_xdr_u_long   xdr_u_long 
#define lpfn_xdr_short    xdr_short 
#define lpfn_xdr_u_short  xdr_u_short 
#define lpfn_xdr_char     xdr_char 
#define lpfn_xdr_u_char   xdr_u_char 
#define lpfn_xdr_bytes    xdr_bytes 
#define lpfn_xdr_union    xdr_union 
#define lpfn_xdr_string   xdr_string 
#define lpfn_xdr_free     xdr_free 
#define lpfn_xdr_bool     xdr_bool 
#define lpfn_xdr_enum     xdr_enum 
#define lpfn_xdr_opaque   xdr_opaque 
#define lpfn_xdr_wrapstring   xdr_wrapstring 
#define lpfn_xdr_array    xdr_array 
#define lpfn_xdr_vector   xdr_vector 

#define lpfn_xdr_float    xdr_float 
#define lpfn_xdr_double   xdr_double 
/* x_refere.c */
#define lpfn_xdr_reference   xdr_reference 
#define lpfn_xdr_pointer  xdr_pointer 
/* xdr.c */
#define lpfn_xdr_wrapstring   xdr_wrapstring 

#endif


#endif


/*
 * Common opaque bytes objects used by many rpc protocols;
 * declared here due to commonality.
 */
#define MAX_NETOBJ_SZ 1024 
struct netobj {
	u_int	n_len;
	char	FAR *n_bytes;
};
typedef struct netobj netobj;

extern bool_t _DLL_FLAGS xdr_netobj(XDR FAR *xdrs, struct netobj FAR *np);


/*
 * These are the public routines for the various implementations of
 * xdr streams.
 */

/* x_mem.c */
extern void _DLL_FLAGS xdrmem_create(XDR FAR *xdrs, caddr_t addr, u_int size, enum xdr_op op);
extern void _DLL_FLAGS xdrrec_create(XDR FAR *xdrs, u_int sendsize, u_int recvsize, caddr_t tcp_handle, int (_DLL_FLAGS *readit )(), int (_DLL_FLAGS *writeit )());
extern bool_t _DLL_FLAGS xdrrec_skiprecord(XDR FAR *xdrs);
extern bool_t _DLL_FLAGS xdrrec_eof(XDR FAR *xdrs);
extern bool_t _DLL_FLAGS xdrrec_endofrecord(XDR FAR *xdrs, bool_t sendnow);


/* x_rec.c */

  
/* x_stdio.c */
extern void _DLL_FLAGS xdrstdio_create(XDR FAR *xdrs, FILE FAR *file, enum xdr_op op);


#ifdef FTP /* added code */
/* Can't use ifdef to change endif so arg on final endif made into comment */
#endif /* FTP */
#endif /*!__XDR_HEADER__*/


/*
 *
 * RCS automatic edit history:
 * $Log:   J:/devkit.dos/vcs/include/rpc/xdr.h_v  $
 * 
 *    Rev 1.13.1.2   08 Apr 1993 15:24:30   rcq
 * added #ifndef RC_INVOKED
 * 
 *    Rev 1.13.1.1   06 Apr 1993 09:57:28   natalia
 * No change.
 * 
 *    Rev 1.13.1.0   04 Apr 1993 15:05:24   db
 * RPC Update 4/4 for 2.21
 * 
 *    Rev 1.0   31 Mar 1993 17:28:56   db
 * Initial revision.
 * Revision 1.7  1993/03/31  14:12:11  db
 * added some #defines for xdrs in windows,
 * to allow the functions through pointers to work
 *
 * Revision 1.6  1993/02/24  20:24:49  db
 * windows stable
 *
 * Revision 1.5  1993/02/23  13:54:06  db
 * merge with Dos and Windows seemingly complete
 * pre Borland merge
 *
 * Revision 1.4  1993/01/29  22:30:09  db
 * added proper FAR casting for all structures
 * and prototypes
 *
 * Revision 1.3  1993/01/15  20:28:47  db
 * removed redefinition of _DLL_FLAGS
 *
 * Revision 1.2  1993/01/15  18:45:45  db
 * changed prototypes and data structures to far pointers
 * for windows .DLL
 *
 * Revision 1.1  1993/01/07  01:13:58  bala
 * Initial revision
 */
