#ifndef FTP
#define FTP /*Copyright 1992, FTP Software, Inc.  All Rights Reserved.*/
#endif /* FTP */
#ifdef FTP /* added code */
#ifndef RC_INVOKED
#pragma comment (exestr, "$Id: svc.h%v 1.5 1993/03/09 15:13:25 db Exp $")
#endif /* RC_INVOKED */
/*
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * RCS automatic edit history:
 * $Log:   J:/devkit.dos/vcs/include/rpc/svc.h_v  $
 * 
 *    Rev 1.12.1.2   08 Apr 1993 15:24:20   rcq
 * added #ifndef RC_INVOKED
 * 
 *    Rev 1.12.1.1   06 Apr 1993 09:57:04   natalia
 * No change.
 * 
 *    Rev 1.12.1.0   04 Apr 1993 14:45:18   db
 * RPC Update 4/4 for 2.21
 * 
 *    Rev 1.0   31 Mar 1993 17:28:48   db
 * Initial revision.
 * Revision 1.5  1993/03/09  15:13:25  db
 * addded _DLL_FLAGS declarations for svc_getreqset
 *
 * Revision 1.4  1993/02/24  20:24:18  db
 * windows stable
 *
 * Revision 1.3  1993/01/29  22:28:06  db
 * added casting for function pointers, etc.
 * first working win16 .dll
 *
 * Revision 1.2  1993/01/15  18:37:37  db
 * Changed prototypes and data structures to FAR pointers
 * for windows .DLL
 *
 * Revision 1.1  1993/01/07  01:13:53  bala
 * Initial revision
 *
 * Revision 1.2  1992/06/12  03:06:29  dwh
 * Initial FTP port for OS/2.
 *
 * Revision 1.1  1992/03/13  02:17:25  dwh
 * Sun RPCSRC4.0 Porting Base.
 */
#else /* FTP superceded code */
/* @(#)svc.h	2.2 88/07/29 4.0 RPCSRC; from 1.20 88/02/08 SMI */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
 * svc.h, Server-side remote procedure call interface.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */
#endif /* FTP */

#ifndef __SVC_HEADER__
#define __SVC_HEADER__


/*
 * This interface must manage two items concerning remote procedure calling:
 *
 * 1) An arbitrary number of transport connections upon which rpc requests
 * are received.  The two most notable transports are TCP and UDP;  they are
 * created and registered by routines in svc_tcp.c and svc_udp.c, respectively;
 * they in turn call xprt_register and xprt_unregister.
 *
 * 2) An arbitrary number of locally registered services.  Services are
 * described by the following four data: program number, version number,
 * "service dispatch" function, a transport handle, and a boolean that
 * indicates whether or not the exported program should be registered with a
 * local binder service;  if true the program's number and version and the
 * port number from the transport handle are registered with the binder.
 * These data are registered with the rpc svc system via svc_register.
 *
 * A service's dispatch function is called whenever an rpc request comes in
 * on a transport.  The request's program and version numbers must match
 * those of the registered service.  The dispatch function is passed two
 * parameters, struct svc_req * and SVCXPRT *, defined below.
 */

enum xprt_stat {
	XPRT_DIED,
	XPRT_MOREREQS,
	XPRT_IDLE
};

/*
 * Server side transport handle
 */

typedef struct svcxprt {
	int		xp_sock;
	u_short		xp_port;	 /* associated port number */
	struct xp_ops {
	    bool_t	(_DLL_FLAGS *xp_recv)(struct svcxprt FAR *,
					      struct rpc_msg FAR *);
					/* receive incoming requests */
	    enum xprt_stat (_DLL_FLAGS *xp_stat)(struct svcxprt FAR *);
					/* get transport status */
	    bool_t	(_DLL_FLAGS *xp_getargs)(struct svcxprt FAR *,
						 xdrproc_t,
						 caddr_t);
					/* get arguments */
	    bool_t	(_DLL_FLAGS *xp_reply)(struct svcxprt FAR *,
					       struct rpc_msg FAR *);
					/* send reply */
	    bool_t	(_DLL_FLAGS *xp_freeargs)(struct svcxprt FAR *,
						  xdrproc_t,
						  caddr_t);
					/* free mem allocated for args */
	    void	(_DLL_FLAGS *xp_destroy)(struct svcxprt FAR *);
					/* destroy this struct */
	} FAR *xp_ops;
	int		xp_addrlen;	 /* length of remote address */
	struct sockaddr_in xp_raddr;	 /* remote address */
	struct opaque_auth xp_verf;	 /* raw response verifier */
	caddr_t		xp_p1;		 /* private */
	caddr_t		xp_p2;		 /* private */
} SVCXPRT;

/*
 *  Approved way of getting address of caller
 */
#define svc_getcaller(x) (&(x)->xp_raddr)

/*
 * Operations defined on an SVCXPRT handle
 *
 * SVCXPRT		*xprt;
 * struct rpc_msg	*msg;
 * xdrproc_t		 xargs;
 * caddr_t		 argsp;
 */
#define SVC_RECV(xprt, msg)				\
	(*(xprt)->xp_ops->xp_recv)((xprt), (msg))
#define svc_recv(xprt, msg)				\
	(*(xprt)->xp_ops->xp_recv)((xprt), (msg))

#define SVC_STAT(xprt)					\
	(*(xprt)->xp_ops->xp_stat)(xprt)
#define svc_stat(xprt)					\
	(*(xprt)->xp_ops->xp_stat)(xprt)


#define SVC_GETARGS(xprt, xargs, argsp)			\
	(*(xprt)->xp_ops->xp_getargs)			\
	((xprt), ((xdrproc_t)xargs), ((caddr_t)argsp))
#define svc_getargs(xprt, xargs, argsp)			\
	(*(xprt)->xp_ops->xp_getargs)			\
	((xprt), ((xdrproc_t)xargs), ((caddr_t)argsp))

#define SVC_REPLY(xprt, msg)				\
	(*(xprt)->xp_ops->xp_reply) ((xprt), (msg))
#define svc_reply(xprt, msg)				\
	(*(xprt)->xp_ops->xp_reply) ((xprt), (msg))

#define SVC_FREEARGS(xprt, xargs, argsp)		\
	(*(xprt)->xp_ops->xp_freeargs)			\
	((xprt), ((xdrproc_t)xargs), ((caddr_t)argsp))
#define svc_freeargs(xprt, xargs, argsp)		\
	(*(xprt)->xp_ops->xp_freeargs)			\
	((xprt), ((xdrproc_t)xargs), ((caddr_t)argsp))

#define SVC_DESTROY(xprt)				\
	(*(xprt)->xp_ops->xp_destroy)(xprt)
#define svc_destroy(xprt)				\
	(*(xprt)->xp_ops->xp_destroy)(xprt)


/*
 * Service request
 */
struct svc_req {
	u_long		rq_prog;	/* service program number */
	u_long		rq_vers;	/* service protocol version */
	u_long		rq_proc;	/* the desired procedure */
	struct opaque_auth rq_cred;	/* raw creds from the wire */
	caddr_t		rq_clntcred;	/* read only cooked cred */
	SVCXPRT	FAR *rq_xprt;		/* associated transport */
};


/*
 * Service registration
 *
 * svc_register(xprt, prog, vers, dispatch, protocol)
 *	SVCXPRT *xprt;
 *	u_long prog;
 *	u_long vers;
 *	void (*dispatch)();
 *	int protocol;  /* like TCP or UDP, zero means do not register 
 */

/* svc.c */
extern bool_t _DLL_FLAGS svc_register(SVCXPRT FAR *xprt, u_long prog,
        u_long vers, void (_DLL_FLAGS *dispatch )(), int protocol);

/*
 * Service un-registration
 *
 * svc_unregister(prog, vers)
 *	u_long prog;
 *	u_long vers;
 */

/* svc.c */
extern void _DLL_FLAGS svc_unregister(u_long prog, u_long vers);

/*
 * Transport registration.
 *
 * xprt_register(xprt)
 *	SVCXPRT *xprt;
 */
/* svc.c */
extern void _DLL_FLAGS xprt_register(SVCXPRT FAR *xprt);


/*
 * Transport un-register
 *
 * xprt_unregister(xprt)
 *	SVCXPRT *xprt;
 */

/* svc.c */
extern void _DLL_FLAGS xprt_unregister(SVCXPRT FAR *xprt);

/*
 * When the service routine is called, it must first check to see if it
 * knows about the procedure;  if not, it should call svcerr_noproc
 * and return.  If so, it should deserialize its arguments via 
 * SVC_GETARGS (defined above).  If the deserialization does not work,
 * svcerr_decode should be called followed by a return.  Successful
 * decoding of the arguments should be followed the execution of the
 * procedure's code and a call to svc_sendreply.
 *
 * Also, if the service refuses to execute the procedure due to too-
 * weak authentication parameters, svcerr_weakauth should be called.
 * Note: do not confuse access-control failure with weak authentication!
 *
 * NB: In pure implementations of rpc, the caller always waits for a reply
 * msg.  This message is sent when svc_sendreply is called.  
 * Therefore pure service implementations should always call
 * svc_sendreply even if the function logically returns void;  use
 * xdr.h - xdr_void for the xdr routine.  HOWEVER, tcp based rpc allows
 * for the abuse of pure rpc via batched calling or pipelining.  In the
 * case of a batched call, svc_sendreply should NOT be called since
 * this would send a return message, which is what batching tries to avoid.
 * It is the service/protocol writer's responsibility to know which calls are
 * batched and which are not.  Warning: responding to batch calls may
 * deadlock the caller and server processes!
 */


/* svc.c */
extern bool_t _DLL_FLAGS svc_sendreply(SVCXPRT FAR *xprt, xdrproc_t xdr_results,
                                       caddr_t xdr_location);
extern void _DLL_FLAGS svcerr_decode(SVCXPRT FAR *xprt);
extern void _DLL_FLAGS svcerr_weakauth(SVCXPRT FAR *xprt);
extern void _DLL_FLAGS svcerr_noproc(SVCXPRT FAR *xprt);
extern void _DLL_FLAGS svcerr_progvers(SVCXPRT FAR *xprt, u_long low_vers,
                                       u_long high_vers);
extern void _DLL_FLAGS svcerr_auth(SVCXPRT FAR *xprt, enum auth_stat why);
extern void _DLL_FLAGS svcerr_noprog(SVCXPRT FAR *xprt);
extern void _DLL_FLAGS svcerr_systemerr(SVCXPRT FAR *xprt);
    
/*
 * Lowest level dispatching -OR- who owns this process anyway.
 * Somebody has to wait for incoming requests and then call the correct
 * service routine.  The routine svc_run does infinite waiting; i.e.,
 * svc_run never returns.
 * Since another (co-existant) package may wish to selectively wait for
 * incoming calls or other events outside of the rpc architecture, the
 * routine svc_getreq is provided.  It must be passed readfds, the
 * "in-place" results of a select system call (see select, section 2).
 */

/*
 * Global keeper of rpc service descriptors in use
 * dynamic; must be inspected before each call to select 
 */
#ifdef FD_SETSIZE
extern fd_set svc_fdset;

#define svc_fds svc_fdset.fds_bits[0]	/* compatibility */

#else

extern unsigned long svc_fds;

#endif /* def FD_SETSIZE */

/*
 * a small program implemented by the svc_rpc implementation itself;
 * also see clnt.h for protocol numbers.
 */
extern void rpctest_service();

/* svc.c */
extern void _DLL_FLAGS svc_getreq(unsigned long rdfds);
#ifdef FD_SETSIZE
extern void _DLL_FLAGS svc_getreqset(fd_set FAR *readfds);
#else /* FD_SETSIZE */
extern void _DLL_FLAGS svc_getreqset(unsigned long rdfds);
#endif /* FD_SETSIZE */

/* s_run.c */
#ifdef WINSOCK
int _DLL_FLAGS svc_run(HWND hWnd);
int _DLL_FLAGS cancel_svc_run(HWND hWnd);
#else
extern void _DLL_FLAGS svc_run(void);
#endif /* winsock */


/*
 * Socket to use on svcxxx_create call to get default socket
 */
#define	RPC_ANYSOCK	-1

/*
 * These are the existing service side transport implementations
 */

/*
 * Memory based rpc for testing and timing.
 */

/* s_raw.c */
extern SVCXPRT FAR * _DLL_FLAGS svcraw_create(void);


/*
 * Udp based rpc.
 */

/* s_udp.c */
extern SVCXPRT FAR * _DLL_FLAGS svcudp_create(SOCKET sock);
extern SVCXPRT FAR * _DLL_FLAGS svcudp_bufcreate(SOCKET sock, u_int sendsz,
                                                 u_int recvsz);

                                                 
/*
 * Tcp based rpc.
 */

/* s_tcp.c */
extern SVCXPRT FAR * _DLL_FLAGS svctcp_create(SOCKET sock, u_int sendsize,
                                         u_int recvsize);

/*
 * Ops vector for TCP/IP rendezvous handler
 */

 bool_t _DLL_FLAGS rendezvous_request(SVCXPRT FAR *xprt,
                                            struct rpc_msg FAR *msg);
 enum xprt_stat _DLL_FLAGS rendezvous_stat(SVCXPRT FAR *);



 SVCXPRT FAR * _DLL_FLAGS makefd_xprt(int fd, u_int sendsize,
                                            u_int recvsize);



#endif /*!__SVC_HEADER__*/
