#ifndef FTP
#define FTP /*Copyright 1992, FTP Software, Inc.  All Rights Reserved.*/
#endif /* FTP */
#ifdef FTP /* added code */
#ifndef RC_INVOKED
#pragma comment (exestr, "$Id: pmap_cln.h%v 1.6 1993/02/24 20:23:42 db Sta $")
#endif /* RC_INVOKED */
/*
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Revision 1.2  1992/06/12  03:06:29  dwh
 * Initial FTP port for OS/2.
 *
 * Revision 1.1  1992/03/13  02:17:14  dwh
 * Sun RPCSRC4.0 Porting Base.
 */
#else /* FTP superceded code */
/* @(#)pmap_clnt.h	2.1 88/07/29 4.0 RPCSRC; from 1.11 88/02/08 SMI */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
 * pmap_clnt.h
 * Supplies C routines to get to portmap services.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */
#endif /* FTP */

#ifndef _RPC_PMAP_CLNT_H_
#define _RPC_PMAP_CLNT_H_

/*
 * Usage:
 *	success = pmap_set(program, version, protocol, port);
 *	success = pmap_unset(program, version);
 *	port = pmap_getport(address, program, version, protocol);
 *	head = pmap_getmaps(address);
 *	clnt_stat = pmap_rmtcall(address, program, version, procedure,
 *		xdrargs, argsp, xdrres, resp, tout, port_ptr)
 *		(works for udp only.) 
 * 	clnt_stat = clnt_broadcast(program, version, procedure,
 *		xdrargs, argsp,	xdrres, resp, eachresult)
 *		(like pmap_rmtcall, except the call is broadcasted to all
 *		locally connected nets.  For each valid response received,
 *		the procedure eachresult is called.  Its form is:
 *	done = eachresult(resp, raddr)
 *		bool_t done;
 *		caddr_t resp;
 *		struct sockaddr_in raddr;
 *		where resp points to the results of the call and raddr is the
 *		address if the responder to the broadcast.
 */


/* get_myad.c */
extern void  _DLL_FLAGS get_myaddress(struct sockaddr_in FAR *addr);

/* p_clnt.c */
extern bool_t _DLL_FLAGS pmap_set(u_long program, u_long version,
                                  int protocol, u_short port);
extern bool_t _DLL_FLAGS pmap_unset(u_long program, u_long version);

/* p_getmap.c */
extern struct pmaplist FAR * _DLL_FLAGS pmap_getmaps
                        (struct sockaddr_in FAR *address);

extern enum clnt_stat _DLL_FLAGS pmap_rmtcall(struct sockaddr_in FAR *addr,
            u_long prog, u_long vers, u_long proc, xdrproc_t xdrargs,
            caddr_t argsp, xdrproc_t xdrres, caddr_t resp, struct timeval tout,
            u_long FAR *port_ptr);
typedef bool_t (_DLL_FLAGS *resultproc_t)(caddr_t, struct sockaddr_in FAR *);
extern enum clnt_stat _DLL_FLAGS clnt_broadcast(u_long prog, u_long vers,
            u_long proc, xdrproc_t xargs, caddr_t argsp, xdrproc_t xresults,
            caddr_t resultsp, resultproc_t eachresult);

/* p_getpor.c */
extern u_short _DLL_FLAGS pmap_getport(struct sockaddr_in FAR *address,
                        u_long program, u_long version, u_int protocol);

/* bindresv.c */
extern _DLL_FLAGS bindresvport(SOCKET sd, struct sockaddr_in FAR *sin);

#endif /*_RPC_PMAP_CLNT_H_*/


/*
 * RCS automatic edit history:
 * $Log:   J:/devkit.dos/vcs/include/rpc/pmap_cln.h_v  $
 * 
 *    Rev 1.10.1.2   08 Apr 1993 15:23:52   rcq
 * added #ifndef RC_INVOKED
 * 
 *    Rev 1.10.1.1   06 Apr 1993 09:56:36   natalia
 * No change.
 * 
 *    Rev 1.10.1.0   04 Apr 1993 14:41:12   db
 * RPC Update 4/4 for 2.21
 * 
 *    Rev 1.0   31 Mar 1993 17:28:38   db
 * Initial revision.
 * Revision 1.6  1993/02/24  20:23:42  db
 * windows stable
 *
 * Revision 1.5  1993/02/23  13:54:33  db
 * pre Borland merge
 *
 * Revision 1.4  1993/01/29  22:27:51  db
 * first working win16 .dll
 *
 * Revision 1.3  1993/01/15  20:26:29  db
 * removed redefinition of _DLL_FLAGS
 *
 * Revision 1.2  1993/01/15  19:58:59  db
 * altered data structures to have FAR pointers for
 * conversion to windows .DLL
 *
 * Revision 1.1  1993/01/07  01:13:43  bala
 * Initial revision
 */
