#ifndef FTP
#define FTP /*Copyright 1992, FTP Software, Inc.  All Rights Reserved.*/
#endif /* FTP */
#ifdef FTP /* added code */
#ifndef RC_INVOKED
#pragma comment (exestr, "$Id: auth.h%v 1.6 1993/02/24 20:23:06 db Sta $")
#endif /* RC_INVOKED */
/*
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Revision 1.2  1992/06/12  03:06:29  dwh
 * Initial FTP port for OS/2.
 *
 * Revision 1.1  1992/03/13  02:17:25  dwh
 * Sun RPCSRC4.0 Porting Base.
 */
#else /* FTP superceded code */
/* @(#)auth.h	2.3 88/08/07 4.0 RPCSRC; from 1.17 88/02/08 SMI */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
 * auth.h, Authentication interface.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 *
 * The data structures are completely opaque to the client.  The client
 * is required to pass a AUTH * to routines that create rpc
 * "sessions".
 */
#endif /* FTP */

#ifndef _RPC_AUTH_H_
#define _RPC_AUTH_H_


#define MAX_AUTH_BYTES	400
#define MAXNETNAMELEN	255	/* maximum length of network user's name */

/*
 * Status returned from authentication check
 */
enum auth_stat {
	AUTH_OK=0,
	/*
	 * failed at remote end
	 */
	AUTH_BADCRED=1,			/* bogus credentials (seal broken) */
	AUTH_REJECTEDCRED=2,		/* client should begin new session */
	AUTH_BADVERF=3,			/* bogus verifier (seal broken) */
	AUTH_REJECTEDVERF=4,		/* verifier expired or was replayed */
	AUTH_TOOWEAK=5,			/* rejected due to security reasons */
	/*
	 * failed locally
	*/
	AUTH_INVALIDRESP=6,		/* bogus response verifier */
	AUTH_FAILED=7			/* some unknown reason */
};

#ifdef FTP /* added code */
typedef u_long u_int32;	/* 32-bit unsigned integers */
#else /* FTP superceded code */
#if (mc68000 || sparc || vax || i386)
typedef u_long u_int32;	/* 32-bit unsigned integers */
#endif
#endif /* FTP */

union des_block {
	struct {
		u_int32 high;
		u_int32 low;
	} key;
	char c[8];
};
typedef union des_block des_block;

#include <rpc/xdr.h>
extern bool_t _DLL_FLAGS xdr_des_block(XDR FAR *xdrs, des_block FAR *blkp);


/*
 * Authentication info.  Opaque to client.
 */
struct opaque_auth {
	enum_t	oa_flavor;		/* flavor of auth */
	caddr_t	oa_base;		/* address of more auth stuff */
	u_int	oa_length;		/* not to exceed MAX_AUTH_BYTES */
};


/*
 * Auth handle, interface to client side authenticators.
 */
#ifdef FTP /* added code */
typedef struct auth {
	struct	opaque_auth	ah_cred;
	struct	opaque_auth	ah_verf;
	union	des_block	ah_key;
	struct auth_ops {
		void	(_DLL_FLAGS *ah_nextverf)(struct auth FAR *);
		int	(_DLL_FLAGS *ah_marshal)(struct auth FAR *, XDR FAR*);
				/* nextverf & serialize */
		int	(_DLL_FLAGS *ah_validate)(struct auth FAR*,
						  struct opaque_auth FAR*);
				/* validate varifier */
		int	(_DLL_FLAGS *ah_refresh)(struct auth FAR*);
				/* refresh credentials */
		void	(_DLL_FLAGS *ah_destroy)(struct auth FAR*);
				/* destroy this structure */
	} FAR *ah_ops;
	caddr_t ah_private;
} AUTH;
#endif /* FTP */


/*
 * Authentication ops.
 * The ops and the auth handle provide the interface to the authenticators.
 *
 * AUTH	*auth;
 * XDR	*xdrs;
 * struct opaque_auth verf;
 */
#define AUTH_NEXTVERF(auth)		\
		((*((auth)->ah_ops->ah_nextverf))( (auth) ))
#define auth_nextverf(auth)		\
		((*((auth)->ah_ops->ah_nextverf))( (auth) ))

#define AUTH_MARSHALL(auth, xdrs)	\
		((*((auth)->ah_ops->ah_marshal))( (auth), \
                                                   xdrs))
#define auth_marshall(auth, xdrs)	\
		((*((auth)->ah_ops->ah_marshal))( (auth), \
                                                   xdrs))

#define AUTH_VALIDATE(auth, verfp)	\
		((*((auth)->ah_ops->ah_validate))( (auth), \
                                                    verfp))
#define auth_validate(auth, verfp)	\
		((*((auth)->ah_ops->ah_validate))( (auth), \
                                                    verfp))
                                          
#define AUTH_REFRESH(auth)		\
		((*((auth)->ah_ops->ah_refresh))( (auth) ))
#define auth_refresh(auth)		\
		((*((auth)->ah_ops->ah_refresh))( (auth) ))

#define AUTH_DESTROY(auth)		\
		((*((auth)->ah_ops->ah_destroy))( (auth) ))
#define auth_destroy(auth)		\
		((*((auth)->ah_ops->ah_destroy))( (auth) ))


extern struct opaque_auth _null_auth;


/*
 * These are the various implementations of client side authenticators.
 */

/*
 * Unix style authentication
 * AUTH *authunix_create(machname, uid, gid, len, aup_gids)
 *	char *machname;
 *	int uid;
 *	int gid;
 *	int len;
 *	int *aup_gids;
 */

/* a_none.c */
extern AUTH FAR * _DLL_FLAGS authnone_create(void);

/* a_unix.c */
extern AUTH FAR * _DLL_FLAGS authunix_create(char FAR *machname,
                        int uid, int gid, int len, int FAR *aup_gids);
extern AUTH FAR * _DLL_FLAGS authunix_create_default(void);

/* a_des.c */
extern AUTH FAR * _DLL_FLAGS authdes_create(char FAR *servername, u_int window,
                            struct sockaddr FAR *syncaddr, des_block FAR *ckey);

/* r_prot.c */
extern bool_t _DLL_FLAGS xdr_opaque_auth(XDR FAR *xdrs,
                                         struct opaque_auth FAR *ap);

#define AUTH_NONE	0		/* no authentication */
#define	AUTH_NULL	0		/* backward compatibility */
#define	AUTH_UNIX	1		/* unix style (uid, gids) */
#define	AUTH_SHORT	2		/* short hand unix style */
#define AUTH_DES	3		/* des style (encrypted timestamps) */

#define MAX_MARSHEL_SIZE 20

#endif /* _RPC_AUTH_H_ */

/*
 *
 * RCS automatic edit history:
 * $Log:   J:/devkit.dos/vcs/include/rpc/auth.h_v  $
 * 
 *    Rev 1.13.1.2   08 Apr 1993 15:23:12   rcq
 * added #ifndef RC_INVOKED
 * 
 *    Rev 1.13.1.1   06 Apr 1993 09:56:16   natalia
 * No change.
 * 
 *    Rev 1.13.1.0   04 Apr 1993 14:38:38   db
 * RPC Update 4/4 for 2.21
 * 
 *    Rev 1.0   31 Mar 1993 17:28:30   db
 * Initial revision.
 * Revision 1.6  1993/02/24  20:23:06  db
 * windows stable
 *
 * Revision 1.5  1993/01/29  22:28:52  db
 * added strong casting for function pointers.
 * first "working win16 .dll
 *
 * Revision 1.4  1993/01/15  20:44:51  db
 * removed redefinition of _DLL_FLAGS
 *
 * Revision 1.3  1993/01/15  18:39:28  db
 * changed prototypes and data structures to far pointers
 * for windows .DL
 *
 * Revision 1.2  1993/01/13  16:58:02  db
 * changed fucntion, return pointers, and pointer args to
 * FAR for conversion to windows .DLL
 *
 * Revision 1.1  1993/01/07  01:12:31  bala
 * Initial revision
 */
