/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\wildcard.h_v   1.10.1.1   08 Apr 1993 17:32:20   arnoff  $
 */

#ifndef __WILDCARD_HEADER__
#define __WILDCARD_HEADER__



/*
 * Copyright (C) 1986, 1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit history:
 * 15-Jun-92	paul	added parameters to prototypes
 */

/* structure that the Disk Transfer Address gets pointed at by
	the wildcard routines.
*/
/* wildcard descriptor
*/
typedef struct wilddesc {
	struct {			/* disk transfer address structure */
		char	pad[21];
		char	attrib;
		char	time[2];
		char	date[2];
		long	size;
		char	name[13];
		} 	dta;
	int		error;		/* error flag */
	int		first;		/* first file flag */
	} wilddesc;

/* wildcard macros - use these, don't access the DTA structure directly
*/
#define	wild_attrib(w)	((w)->attrib)	/* attribute of current file */
#define	wild_size(w)	((w)->size)	/* size of current file */

/* wildcard routines
*/
wilddesc *wild_start(char *filespec);	/* create a wildcard descriptor */
char *wild_next(wilddesc *w);		/* get next file off a descriptor */
void wild_finish(wilddesc *w);		/* release a wildcard descriptor */

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\wildcard.h_v  $
 * 
 *    Rev 1.10.1.1   08 Apr 1993 17:32:20   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.10   17 Jun 1992 14:05:24   paul
 * added parameters to prototypes
 * 
 *    Rev 1.9   03 Feb 1992 23:27:26   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:49:28   arnoff
 *  
 */


#endif /* __WILDCARD_HEADER__ */

