/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\wftp.h_v   1.12.1.1   08 Apr 1993 17:31:50   arnoff  $
 */

#ifndef __WFTP_HEADER__
#define __WFTP_HEADER__



/*
 * INCLUDE\PCTCP\WFTP.H
 *
 * Copyright (C) 1986-1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 
 * EDIT HISTORY:
 * 08-Dec-87	romkey	declare ftp_response() as int declare ftp_cmd()
 * 09-Dec-87	romkey	added missing LINT_ARGS section and missing ftp
 *			library functions removed extra arguments from
 *			ftp_pwd()
 * 24-Mar-88	jbvb	'ftpcon' changed to be same size packed or unpacked.
 * 14-Oct-88    jog     added ftp_pasv() to list, passive to structure
 * 02-Nov-88    jog     added 4th argument to ftp_open() list
 * 28-Dec-88    jog     added data_idx, data_in_buf & cr_last to structure
 * 17-Aug-89	jbvb	Always use function prototypes.
 * 25-Oct-89	jbvb	Packed/unpacked was broken in 10/14/88 edit, fix it.
 * 25-Jul-91	towfiq	Cut over to Windows version, funcs now return void.
 * 28-Aug-91	towfiq	Added some #define's for the messages returned.
 * 16-Dec-91	towfiq	Changed the constant values for FTP_GOAHEAD, FTP_NEEDX
 * 07-Jan-92	towfiq	Changed the #define's do be more logical.
 * 14-Feb-92	towfiq	added prototype for ftp_process_async
 * 08-Apr-92	towfiq	added field for data_function to ftpcon.
 * 10-Apr-92	towfiq	moved a lot of WFTPLIB static variables into ftpcon.
 */

#include <pctcp/types.h>

/* control structure for FTP connections */
typedef struct ftpcon {
	int		nd;		/* control network descriptor  */
	int		dnd;		/* data network descriptor */
	char		passive;	/* true if server is passive */
	char		mode;		/* 'S'tream */
	char		type;		/* 'A'scii, 'I'mage, 'L'ocal 8 */
	in_name		pasv_fhost;	/* store server's addr and port--  */
	unsigned	pasv_fsocket;   /* only when doing PASV connection */
	struct addr	a;		/* holds the remote address */
	char            cr_last;        /* last byte of prev block = CR */
	int		byte_size;	/* for `local byte size n' */
	unsigned long	bytes_moved;	/* bytes moved in last transfer */
	unsigned long	num_seconds;	/* number of seconds to transfer */
	char _far	*msgbuf;	/* buffer for server messages */
	int		msgbuflen;	/* length of the buffer */
	int		code;		/* First digit of the response code */
	int		dash;		/* Seen a dash in the right place? */
	int		column;		/* incremental length (col. pos.) */
	int		total;		/* data we have read so far */
	char _far	*resp;		/* response pointer */
	char _far	*thisline;	/* start of response's current line */
	char _far	*data;		/* data buffer */
	unsigned        data_idx;       /* index into data buffer    */
	unsigned        data_in_buf;    /* # of bytes of data in buf */
	unsigned	datalen;	/* length of data buffer     */
	int		debug;		/* TRUE if debugging is enabled */
	HWND		hwnd;		/* Window receiving network data */
	WORD		message;	/* Message we send back to app. */
	int (_far _pascal *data_function)/* Used in NLST, LIST, STOR, RETR */
	  (struct ftpcon _far *, char _far *,unsigned);
	int		type_of_transfer;/* variables common to the three async data handlers */
	int		connection_open;
	long		timer;
	int		state;
} ftpcon;

/* first digit of response code from remote FTP server */
#define	FTP_GOAHEAD		2		/* no error, all done */
#define	FTP_NEED_PASSWORD	3		/* needs a password */
#define	FTP_NEED_ACCOUNT	3		/* needs an account name */
#define	FTP_ERROR		5		/* an error */

/* Subdefines used in PostMessages back to the application */
#define	FTP_CONTROL_ERROR	20		/* there was an error */
#define FTP_CONTROL_CLOSE	30		/* control conn. closed */
#define	FTP_DATA_ERROR		40		/* there was a data error */
#define FTP_DATA_CLOSE		50		/* data connection closed */
#define FTP_RESPONSE		60		/* response to a command */

/* type names for FTP */
#define	FTP_ASCII_TYPE	'A'		/* network ASCII */
#define	FTP_IMAGE_TYPE	'I'		/* no translation */
#define	FTP_LOCAL_TYPE	'L'		/* local byte size mode */

/* some macros for FTP */
#define	ftp_cur_type(f)	(f)->type
#define	ftp_bytesize(f)	(f)->byte_size
#define	ftp_bytes(f)	(f)->bytes_moved
#define	ftp_time(f)	(f)->num_seconds
#define	ftp_msgbuf(f)	(f)->msgbuf

/* Handy typedef used to declare function which
   handle data delivered asynchronously in NLST, LIST, STOR, RETR */
typedef int (_far _pascal *data_handler)(ftpcon _far *, char _far *,unsigned);

/* declarations of FTP client functions */
void _far		ftp_abort(ftpcon _far *);
void _far		ftp_acct(ftpcon _far *, char _far *);
int _far		ftp_choose_port(ftpcon _far *);
void _far		ftp_close(ftpcon _far *);
void _far		ftp_cmd(ftpcon _far *, char _far *, char _far *);
void _far		ftp_cwd(ftpcon _far *, char _far *);
int _far		ftp_debug(ftpcon _far *, int);
void _far		ftp_delete(ftpcon _far *, char _far *);
void _far		ftp_dir(ftpcon _far *, char _far *, data_handler);
void _far		ftp_get(ftpcon _far *, char _far *, data_handler);
void _far		ftp_ls(ftpcon _far *,  char _far *, data_handler);
void _far		ftp_mkdir(ftpcon _far *, char _far *);
ftpcon _far * _far	ftp_openw(in_name, unsigned, unsigned, unsigned,
								HWND, WORD);
void _far		ftp_parent(ftpcon _far *);
void _far		ftp_pass(ftpcon _far *, char _far *);
void _far		ftp_pasv(ftpcon _far *);
void _far		ftp_process_async (int, int, unsigned long, ftpcon _far *);
void _far		ftp_put(ftpcon _far *, char _far *, int,data_handler);
void _far		ftp_pwd(ftpcon _far *);
void _far		ftp_quit(ftpcon _far *);
void _far		ftp_quote(ftpcon _far *, char _far *);
void _far		ftp_rename_from(ftpcon _far *, char _far *);
void _far		ftp_rename_to(ftpcon _far *, char _far *);
int _far		ftp_response(ftpcon _far *);
void _far		ftp_rmdir(ftpcon _far *, char _far *);
void _far		ftp_stat(ftpcon _far *, char _far *);
void _far		ftp_type(ftpcon _far *, char, int);
void _far		ftp_user(ftpcon _far *, char _far *);
void _far		ftp_xcwd(ftpcon _far *, char _far *);
void _far		ftp_xmkdir(ftpcon _far *, char _far *);
void _far		ftp_xparent(ftpcon _far *);
void _far		ftp_xpwd(ftpcon _far *);
void _far		ftp_xrmdir(ftpcon _far *, char _far *);
void _far		ftp_dll_close(void);

#ifdef	FTPDLL_PRIVATE

/* From "ftp.c": */
/* This is really the best way to reverse lookup an ftpcon * from an nd.... */
ftpcon FAR *ftp_conn_lookup(int);

/* From "dllglue.asm": */
int FAR _control_alarm();	/* assembly routine to catch 'net_alarm's */
int FAR _control_asynch();	/* assembly routine to catch 'net_asynch's */
int FAR _data_alarm();		/* assembly routine to catch 'net_alarm's */
int FAR _data_asynch();		/* assembly routine to catch 'net_asynch's */

/* From "ftp.c": */
int FAR ControlProcessAlarm(int, int, unsigned long, ftpcon _far *) ;
int FAR PASCAL LibMain(HANDLE, WORD, WORD, LPSTR);
int FAR PASCAL	WEP(int);

/* From "xfer.c": */
int FAR DataProcessAlarm(int, int, unsigned long, ftpcon _far *) ;
int FAR DataProcessAsync(int, int, unsigned long, ftpcon _far *) ;

#endif	/* FTPDLL_PRIVATE */

#ifdef DEBUG

#define	debug(x,y)	MessageBox(NULL, x, y, MB_OK | MB_ICONINFORMATION)

#else

#define	debug(x,y)

#endif

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\wftp.h_v  $
 * 
 *    Rev 1.12.1.1   08 Apr 1993 17:31:50   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.12   10 Apr 1992 17:16:04   arnoff
 * towfiq	moved a lot of WFTPLIB static variables into ftpcon.
 * 
 *    Rev 1.11   18 Feb 1992 11:10:04   arnoff
 * removed extraneous f.
 * 
 *    Rev 1.11   18 Feb 1992 11:05:28   arnoff
 * joined lines 106 and 107 into 106
 * 
 *    Rev 1.10   14 Feb 1992 17:49:56   arnoff
 * Added prototype for ftp_process_async.
 * 
 *    Rev 1.9   03 Feb 1992 23:27:24   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:49:24   arnoff
 *  
 */


#endif /* __WFTP_HEADER__ */

