/* $Header:   D:/22vcs/include/wdetect.h_v   1.3   18 Nov 1992 06:39:56   karen  $
*/

/*
 * srclib\wdllchk\wdetect.h
 *
 * Copyright (C) 1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 05-Jun-92	kek	Created.
 * 22-Jun-92	kek	Add Windows Std mode retcode, and enhance comments.
 * 22-Jul-92	kek	Prototype routines as FAR!
 * 31-Jul-92	paul	added void parameter to detect_pctcp prototype
 * 18-Nov-92	kek	fix typo (DP_OK, not PD_OK in pctcp_21plus_available)
 */

/* detect_pctcp() prototype */

int FAR detect_pctcp(void);

/* 
 * detect_pctcp() - A return of 0 indiciates 2.1(+) kernel, VxD and DLL found!
 *		    Non-zero returns indicate reason for "failure".
 *	            Use the masks below to determine results!
 */

#define DP_OK		0x00	/* 2.1 kernel, VxD, and DLL available */
#define DP_NO_VXD	0x01	/* 2.1 kernel detected, no VxD found  */
				/* ret from Windows Enh mode only     */
#define DP_NO_KERNEL	0x02	/* 2.1 kernel (and VxD) not found     */
#define DP_OLD_KERNEL	0x04	/* pre 2.1 kernel [and VxD] found     */
#define DP_OLD_DLL	0x08	/* pre 2.1 PCTCPAPI.DLL in path	      */
#define DP_NON_STD_DLL	0x10	/* 2.1 PCTCPAPI.DLL, but not 286/386  */
				/* ret from Windows Std mode only     */

#define pctcp_21plus_available() (detect_pctcp() == PD_OK)

/*
 * $Log:   D:/22vcs/include/wdetect.h_v  $
 * 
 *    Rev 1.3   18 Nov 1992 06:39:56   karen
 * kek fix typo (DP_OK not PD_OK in check_21plus_available)
 * 
 *    Rev 1.2   13 Oct 1992 15:52:12   seven
 * Copied wdetect.h from ../srclib/wdllchk (Karen changed prototype
 * for detect_pctcp().   ---Ben
 * 
 *    Rev 1.3   31 Jul 1992 17:29:28   paul
 * added void parameter to detect_pctcp prototype
 * 
 *    Rev 1.2   23 Jul 1992 11:37:20   arnoff
 * kek	Define and prototype detect_pctcp() and dll_check() as FAR!
 * 
 *    Rev 1.1   23 Jun 1992 13:35:04   arnoff
 * kek	Add Windows Std mode retcode, and enhance comments.
 * 
 *    Rev 1.0   07 Jun 1992 22:05:04   arnoff
 * Initial revision.
 */

