/*
 * $Header:   K:/21vcs/include/pctcp/types.h_v   1.10   27 Feb 1992 16:23:20   arnoff  $
 */

/*
 * TYPES.H
 *
 * Copyright (C) 1986,1988,1991 by FTP Software, Inc.  All rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 11-Nov-88	jbvb	Fix compile-time byte-swap macros.
 * 17-Jun-91	gub	Protected against multiple inclusion
 * 21-Aug-91	Ben	Prevent multiply defined TRUEs
 * 07-Nov-91	paul	added parameters to function prototypes
 * ??-Dec-91	Ben	added #define FTP_VER_2_1	1
 * 27-Feb-92	Gakio	Added DLLFAR for Windows.
 */

#ifndef _TYPES_H
#define _TYPES_H INCLUDED

#define FTP_VER_2_1	1

/* attempt some semblance of machine independence. These data types should
	always be used in machine dependent code (especially packet headers).
*/
typedef	char byte;			/* signed 8 bit quantity */
typedef	unsigned char unsbyte;		/* unsigned 8 bit quantity */
typedef int word;			/* signed 16 bit quantity */
typedef unsigned unsword;		/* unsigned 16 bit quantity */
typedef long lword;			/* signed 32 bit quantity */
typedef unsigned long unslword;		/* signed 32 bit quantity */

typedef	unsigned *pointer;		/* a "generic" pointer */

typedef	long in_name;

/* compile-time byte swapping */
#define	ct_ntohs(w)	(((((w)&0xFF)<<8)&0xFF00) | ((((w)&0xFF00)>>8)&0xFF) )
#define	ct_htons(w)	(((((w)&0xFF)<<8)&0xFF00) | ((((w)&0xFF00)>>8)&0xFF) )

#ifndef	TRUE
#define	FALSE		0
#define	TRUE		!FALSE
#endif

/* In Windows, functions must have the _far keyword.  Else, do nothing. */
#ifdef MSW3
#ifndef DLLFAR
#define DLLFAR FAR
#endif
#else	/* MSW3 not defined, i.e. not in Windows environment */
#define DLLFAR
#endif /* MSW3 not defined */

/* runtime byte swapping routines */
#ifndef	_NTOHL
#define	_NTOHL
extern unsword	DLLFAR	ntohs(unsword);
extern unsword	DLLFAR	htons(unsword);
extern unslword	DLLFAR	ntohl(unslword);
extern unslword	DLLFAR	htonl(unslword);
#endif
extern unsword  bswap(unsword);
extern unslword	lswap(unslword);

#endif /* _TYPES_H */

/*
 * $Log:   K:/21vcs/include/pctcp/types.h_v  $
 * 
 *    Rev 1.10   27 Feb 1992 16:23:20   arnoff
 * Added DLLFAR for Windows.   Gakio
 * 
 *    Rev 1.9   03 Feb 1992 23:27:20   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:49:22   arnoff
 *  
 */
