/* $Header:$ */

/*
 * Copyright (C) 1989 - 1993 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 * 
*/

/* $Log:$ */

/* file: snmpsys.h
 * description:
     General include file to write applications in the snmp system.
 * change record:
 * 08-dec-89 MG	File created.
 * 13-dec-89 MG	Trap specific stuff added to snmpTalkType.
 * 28-feb-90 MG	merged Encode error numbers with all other error numbers.
 * 06-mar-90 MG	added udpSetErrStream().
 * 08-mar-90 MG	SNMPKINDxxxxxx added.
 * 09-mar-90 MG	auth added to snmpTalkType.
 * 11-jun-90 mg tl_ltooid() and tl_oidtol() added.  tl_makeOid() renamed to
     tl_symtooid().  tl_getId() renamed to tl_oidtosym().
 * 13-jun-90 mg tl_encode() renamed to tl_symtol().
 * 20-jun-90 mg bad packet variables and define.
 * 25-jun-90 mg added SNMP_NOINIT_ERR for conversions attemped before
     tl_init() called.
 * 23-jul-90 mg removed auth pointer from snmpTalkType.  SNMP_NOTFREEABLE_ERR.
     tl_free() returns int.
 * 25-jul-90 mg converted all of the indirect ctypes.h types to regular
     c types for clarity.  comments on error messages.
 * 26-jul-90 mg simplified snmpTalkType.
 * 27-jul-90 mg SNMP_COMMINIT_ERR and SNMP_COMMFILE_ERR.
 * 02-aug-90 mg reordered snmpTalkType for byte boundaries.
 * 22-aug-90 mg opaque defineds added.
 * 30-aug-90 mg SNMP_ILLEGALOID_ERR created.  tl_oidtol() and tl_ltooid()
     cdecl's modified
 * 22-oct-90 mg converted trap pointers (agent, enterprise) in snmpTalkType
     to inline snmpVals and added opts field.
 * 23-oct-90 mg tl_oidtos() returns an int (err code) rather than a void.
 * 20-nov-90 mg ordered and verified all prototypes with code and manual.
 * 21-nov-90 mg moved ASNltype out to tl_symbl.c (only module used).
     added error code directory.
 * 27-nov-90 mg release for 2.05 distribution.
 * 10-dec-90 mg changed tl_time_pretty() arg labels to label.
 * 17-dec-90 mg added SP_VARNOTINSEQ (variable not in ASN.1 sequence).
 * 25-feb-91 mg	added trapDescrGlobalize() and snmpDescrGlobalize().
 * 18-mar-91 mg	added tl_udp_mode for Agent and/or NMS UDP Port assignments.
 * 19-mar-91 mg	added SU_ errors and decls for snmpDescr() and trapDescr().
     added host_addr to snmpTalkType and reshuffled pointers for maximum
     structure packing under large and small models.
 */

typedef struct {
    unsigned opts:8;	/* options associated with struct		    */
    unsigned type:8;	/* asn.1 type of variable (see SMI RFC 1065)	    */
    unsigned int	len;	/* length of poss. Object Id or Octet String*/
    union {
	unsigned long	Unsl;	/* for IPAddr, Counter and Gauge types	    */
	long		Intl;	/* for Integer types			    */
	char		*asn;	/* for Object Id and Octet String types     */
    } v;
} snmpVal;

typedef struct {
    long	  req_id;	/* id of this request			    */
    unsigned long err_code;	/* error code				    */
    unsigned long err_index;	/* which query generated error		    */
    snmpVal	  enterprise;	/* trap associated enterprise		    */
    snmpVal	  agent;		/* trap associated agent	    */
    unsigned long generic_trap;	/* generic trap (coldstart, warmstart, etc) */
    unsigned long specific_trap;/* enterprise specific trap		    */
    unsigned long time_stamp;	/* trap: time from init of agent to trap    */
    unsigned long var_len;	/* number of variables requested	    */
    unsigned long val_len;	/* number of values returned		    */
    snmpVal	 *vars;		/* oids:  sent and returned (variables)	    */
    snmpVal	 *vals;		/* values returned			    */
    char	 *community;	/* community name of machine		    */
    char	 *host;		/* host name to be queried		    */
    unsigned long host_addr;	/* IP address of host			    */
    unsigned	  opts:8;	/* options				    */
    unsigned	  req_code:8;	/* get, set, next, response or trap	    */
} snmpTalkType;

#define TL_REQ_ID(stt)		((stt)->req_id)
#define TL_ERR_CODE(stt)	((stt)->err_code)
#define TL_ERR_INDEX(stt)	((stt)->err_index)
#define TL_ENTERPRISE(stt)	((stt)->enterprise)
#define TL_AGENT(stt)		((stt)->agent)
#define TL_GENERIC_TRAP(stt)	((stt)->generic_trap)
#define TL_SPECIFIC_TRAP(stt)	((stt)->specific_trap)
#define TL_TIME_STAMP(stt)	((stt)->time_stamp)
#define TL_VAR_LEN(stt)		((stt)->var_len)
#define TL_VARS(stt)		((stt)->vars)
#define TL_VAL_LEN(stt)		((stt)->val_len)
#define TL_VALS(stt)		((stt)->vals)
#define TL_HOST(stt)		((stt)->host)
#define TL_COMMUNITY(stt)	((stt)->community)
#define TL_OPTS(stt)		((stt)->opts)
#define TL_REQ_CODE(stt)	((stt)->req_code)
#define TL_HOST_ADDR(stt)	((stt)->host_addr)

			    /******* snmpVal UNION DEFINES *****************/
		/* It is recommended that you use these macros to reference
		** the snmpTalkType structure in the code.
		*/

		/* "Avoid rug burn, wear knee pads." */

#define TL_KIND		type

#define TL_TIMETICKS	v.Unsl
#define TL_GAUGE	v.Unsl
#define TL_COUNTER	v.Unsl
#define TL_INTEGER	v.Intl

#define TL_IPADDRVAL	v.asn
#define TL_IPADDRLEN	len
#define	TL_OCTETSVAL 	v.asn
#define	TL_OCTETSLEN 	len
#define	TL_OIDVAL	v.asn
#define TL_OIDLEN	len
#define	TL_OPAQUEVAL	v.asn
#define TL_OPAQUELEN	len


#define TL_VAR(stt,n)		(TL_VARS(stt)[n])	/* get nth variable */
#define TL_VAL(stt,n)		(TL_VALS(stt)[n])	/* get nth value    */
#define TL_INT(sv)		((sv).v.Intl)		/* get integer	    */
#define TL_UNT(sv)		((sv).v.Unsl)		/* get unsigned int */
#define TL_ASN(sv)		((sv).v.asn)		/* get ptr to asn   */
#define TL_LEN(sv)		((sv).len)		/* get asn length   */

#define TL_TIM(sv)		((sv).v.Unsl)		/* get time	    */
#define TL_GAU(sv)		((sv).v.Unsl)		/* get gauge	    */
#define TL_COU(sv)		((sv).v.Unsl)		/* get counter	    */

#define TL_IPV(sv)		((sv).v.asn)	/* ptr to ip address value  */
#define TL_OCV(sv)		((sv).v.asn)	/* ptr to octet string value*/
#define TL_OIV(sv)		((sv).v.asn)	/* ptr to oid value	    */
#define TL_OPV(sv)		((sv).v.asn)	/* ptr to opaque value	    */

#define TL_IPL(sv)		((sv).len)		/* ip addr length   */
#define TL_OCL(sv)		((sv).len)		/* octet string len */
#define TL_OIL(sv)		((sv).len)		/* oid length	    */
#define TL_OPL(sv)		((sv).len)		/* opaque length    */

#define TL_TYP(sv)		((sv).type)	/* var type (int, oct, ...) */

			    /******* snmpTalk OPTIONS ***********************/

#define SOPT_NONE		0x00	/* no options			    */
#define SOPT_ALLOCBINDS		0x01	/* return vars in malloced memory   */
#define SOPT_NOTFREEABLE	0x02	/* tells free routines not to free  */

/*******		KINDS OF SNMP DATA TYPES USED BY TL_KIND **********/

#define SNMPKINDNONE		0x00
#define SNMPKINDINTEGER		0x02
#define SNMPKINDOCTETSTRING	0x04
#define SNMPKINDNULL		0x05
#define SNMPKINDOBJECTID	0x06
#define SNMPKINDSEQUENCE	0x30
#define SNMPKINDIPADDR		0x40
#define SNMPKINDCOUNTER		0x41
#define SNMPKINDGUAGE		0x42
#define SNMPKINDTIMETICKS	0x43
#define SNMPKINDOPAQUE		0x44


    /******************** TYPES OF SNMP PACKETS ***************************/

#define SNMPCMDGET		0xA0
#define SNMPCMDNEXT		0xA1
#define SNMPCMDRESP    		0xA2
#define SNMPCMDSET		0xA3
#define SNMPCMDTRAP		0xA4

    /******************** ERROR CODES RETURNED FROM SNMP SYSTEM **********/

	/* These error codes are all prefixed by a code that indicates what,
	** and (to an extent) where each code came from:
	**	SE_	general snmp system error type
	**	SM_	message, not an error
	**	SF_	from free routines
	**	ST_	from tl_talk()
	**	SI_	from tl_fill()
	**	SS_	syntax error from symboic conversion routines
	**	SA_	from community or authentication routines
	**	SP_	from parser (asn.1 decoder)
	**	SC_	from constructor (asn.1 encoder)
	**	SU_	from UDP transport modules
	*/

#define SNMP_OK			0	/* no error			    */
#define SE_HOSTRES		1	/* name resolution error	    */
#define SE_SETUP		2	/* setup of snmp system error 	    */
#define SE_XMIT			3	/* transmit error		    */
#define SE_RECV			4	/* receive error		    */
#define SE_OTHER		5	/* other (general) error	    */
#define SE_TOOBIG		6	/* response pkt too big to parse    */
#define SE_VERIFY		7	/* bad community name		    */
#define SE_DECODE		8	/* unable to decode packet	    */
#define SE_BADSYMBOL		9
#define SE_BADTYPE		10	/* bad data type name to a set	    */
#define SM_USRABORT		11	/* tl_talk terminated by user	    */
#define SE_BADVAL		12
#define SE_COMMTOOBIG		13	/* bad community name (redefined?)  */
#define SE_NORESPONSE		14	/* no response from agent (timeout) */
#define SE_INIT			15	/* tl_init failed (chk config files)*/
#define SM_NOINIT		16	/* conversion with out tl_init	    */
#define SE_COMMINIT		17	/* tl_comm_init failed in config    */
#define SE_COMMFILE		18	/* comm/auth file wouldn't open	    */
#define SE_NULLSOCKET		19
#define SE_NULLARG		20	/* null argument to routine	    */
#define SE_BUFTOOSMALL		21	/* storage buffer was too small	    */
#define SE_ILLEGALOIDVAL	22	/* second value of an oid is > 39   */
#define SF_NOTFREEABLE		23	/* tl_free cannot free static data  */
#define SF_NOTHINGTOFREE	24	/* tl_free routines passed 0 length */
#define SF_NULLVAL		25	/* tl_snmpVal_free cannot free null */
#define SF_NULLSNMPTALKTYPE	26	/* tl_free cannot free a null	    */
#define ST_NODESCR		27
#define ST_NOHOST		28
#define ST_NOCOMMUNITY		29
#define ST_NOSNMPTALKTYPE	30
#define ST_MODEOUTOFRANGE	31
#define ST_NULLSTRING		32
#define SI_NULLARG		33	/* null argument was passed	    */
#define SI_OVERFLOW		34	/* not enough var, val or buf space */
#define SS_HEAD			35	/* problem with 'mib'		    */
#define SS_BODY			36	/* problem with 'node'		    */
#define SS_TAIL			37	/* 'tail' (only digits and '.'s)    */
#define SS_MULTI		38	/* multiple valid 'mib's	    */
#define SS_SYNTAX		39	/* lack of 'a;b_c' syntax	    */
#define SE_OUTOFMEMORY		40	/* generic out of memory error	    */
				    /* from community or authentication fun */
#define SA_REDEFAUTH		41
#define SA_REDEFCOMM		42
#define SA_NOSCHEME		43
#define SA_COMMUNITYNOTFOUND	44
				    /* from tl_construct() */
#define SP_NULLARG		45
#define SP_FIRSTNOTSEQ		46
#define SP_NOVERSION		47
#define SP_BADVERSIONTYPE	48
#define SP_WRONGVERSION		49
#define SP_NOCOMMUNITY		50
#define SP_BADCOMMUNITYTYPE	51
#define SP_ZEROLENGTHID		52
#define SP_ZEROLENGTHERR	53
#define SP_ZEROLENGTHINDX	54
#define SP_NOENTERPRISE		55
#define SP_NOAGENT		56
#define SP_NOGENERIC		57
#define SP_NOSPECIFIC		58
#define SP_NOTIMESTAMP		59
#define SP_UNKNOWNAPPTYPE	60
#define SP_NOSEQOFVARSEQS	61

#define SC_CONSTR_OVRFLW	62	/* buffer too small for packet	*/
#define SP_OUTOFMEMVARS		63	/* too many variable binds	*/
#define SP_OUTOFMEMVALS		64	/* too many variable binds	*/
#define SP_VARNOTINSEQ		65	/* variable not in ASN.1 sequence */

    /* see neterrno and netsuberrno variables for more info on SU errors */
#define SU_MODEOUTOFRANGE	66
#define SU_CANT_SET_OPTION	67
#define SU_CANTASYNCSNMPRECV	68
#define SU_CANTASYNCSNMPERRO	69
#define SU_CANTASYNCTRAPRECV	70
#define SU_NET_CONNECT_FAILED	71
#define SU_NET_WRITETO_FAILED	72
#define SU_NET_READ_FAILED	73
#define SU_NET_RELEASE_FAILED	74

#define SNMP_LAST_ERROR		SU_NET_RELEASE_FAILED	/* bounds of list   */

/*************************** SNMP AGENT ERRORS FROM RFC 1067 **************/

#define SNMP_NOERROR		0
#define SNMP_TOOBIG		1
#define SNMP_NOSUCHNAME		2
#define SNMP_BADVALUE		3
#define SNMP_READONLY		4
#define SNMP_GENERR		5

/*************************** GLOBAL ERROR VARIABLES ***********************/

    /**** These varaibles refer specifically to any packet parsing error.
    ***** These errors can refer to a packet that is too big, or an asn.1
    ***** parsing error, or an authentication failure.  On error up to
    ***** SNMP_BAD_PKT_SIZE of the packet is copied into tl_bad_pkt, the
    ***** length is put in tl_bad_pkt_len, and the index to the octet upon
    ***** which the parse failed is put in tl_bad_pkt_index.
    ***** tl_bad_pkt_cnt holds the total number of bad packets received.
    ***** tl_parse() sets tl_bad_pkt_index, tl_recv() sets the rest.
    ****/

#define SNMP_BAD_PKT_SIZE (1024)	/* max recorded size bad of packets */

					/* where asn.1 error pkts are put*/
extern unsigned char tl_bad_pkt[SNMP_BAD_PKT_SIZE];
extern int tl_bad_pkt_len;		/* length of packet with asn.1 error*/
extern int tl_bad_pkt_index;		/* where asn.1 error occured in pkt */
extern unsigned long tl_bad_pkt_cnt;	/* total num asn.1 error pkts recv'd*/


/******************** UDP PORT (AGENT/MANAGEMENT STATION) MODES *************/

    /*
    **   These definitions effect UDP Port assignments.  A Network Management
    ** Station (NMS) will expect to send to an SNMP Agent which listens on
    ** UDP Port 161, and receive responses from that Agent on the same UDP
    ** Port.  Thus, if you are implementing a NMS then SNMP_NMS_ONLY is
    ** appropriate (and is the default when the system starts up).  An Agent
    ** expects to have UDP Port 161 local at all times, so SNMP_AGENT_ONLY
    ** is appropriate.  If your application expects to do NMS and Agent
    ** functions then you want to have UDP Port 161 as your local and foreign
    ** port, so SNMP_NMS_AGENT is appropriate.
    **   Set the global variable 'tl_udp_mode' to one of these values before
    ** using tl_send(), tl_recv() or tl_talk().
    **   This variable does not effect UDP Port assignments for SNMP Traps.
    */

#define SNMP_NMS_ONLY	0x00	/* UDP port 161 is foreign (DEFAULT)	    */
#define SNMP_AGENT_ONLY	0x01	/* UDP port 161 is local		    */
#define SNMP_NMS_AGENT	0x02	/* UDP port 161 is foreign and local	    */

extern int tl_udp_mode;		/* mode variable for Agent or NMS	    */

    /* tl_snmp_port and tl_trap_port define the standard UDP ports used by the
    ** SNMP library.  They are initially set to 161 and 162.  Change them
    ** before any calls to tl_send() or tl_talk() if you wish to change the
    ** standard snmp or trap ports for any reason.  You can call udpClose and
    ** change them before calls to tl_send() or tl_talk().  These variables
    ** are typically used for agents.  These variables allow you to change
    ** the ports on which the SNMP library is listening.
    */

extern int tl_snmp_port;			/* initial snmp port 161    */
extern int tl_trap_port;			/* initial trap port 162    */

    /* The variables tl_snmp_send_fport and tl_trap_send_fport are for
    ** sending packets to ports other than the standard snmp and trap ports.
    ** If either is set to 0 then it is ignored and the standard port is
    ** used.  Either must be set (tl_trap_send_fport for sending a trap, or
    ** tl_snmp_send_fport for any other type of snmp send) before a call to
    ** tl_talk() or tl_send().  After using either, setting it back to 0
    ** will return sending to the standard snmp and trap ports.  These
    ** variables can be used individually or in combination.
    ** 
    ** tl_snmp_recv_fport and tl_trap_recv_fport contain the foreign UDP
    ** port that the last packet was received from.
    */

extern int tl_snmp_recv_fport;			/* from UDP SNMP port	    */
extern int tl_trap_recv_fport;			/* from UDP SNMP-TRAP port  */
extern int tl_snmp_send_fport;			/* to   UDP SNMP port	    */
extern int tl_trap_send_fport;			/* to   UDP SNMP-TRAP port  */

/*************************** TL_PRETTY() do_hex DEFINITIONS *****************/

#define TRAILING_SPACE	0x8000
#define OCTSTR_ASCII	0x0000
#define OCTSTR_HEX	0x0001
#define OCTSTR_CHOICE	0x0002

/*************************** FUNCTION DECLARATIONS ***********************/

extern int   tl_comm_free(char *name);
extern int   tl_comm(char *cname,char *sname,unsigned long cookie);
extern int   tl_scheme(char *name,unsigned long (*encode)(),
		    unsigned long (*decode)());
extern int   tl_comm_init(void);
extern int   tl_erro_snmp(void);
extern char *tl_error(int errno);
extern int   tl_fill(snmpTalkType *result, char *host, char *community,
		    char **str, long sequence, int mode, char *buf,int buflen,
		    snmpVal *var, int varlen, snmpVal *val, int vallen);
extern int   tl_free(snmpTalkType *result);
extern int   tl_init(void);
extern int   tl_ltooid(unsigned long *text,int len,char *oid,int *n);
extern int   tl_ltosym(long *inbuf,int inlen,char *outbuf,int outlen);
extern int   tl_oidtol(unsigned char *oid,int n,unsigned long *result,int *m);
extern int   tl_oidtos(snmpVal *var,char *buf,long len);
extern int   tl_oidtosym(snmpVal *oid,char *result,int len);
extern void  tl_pretty(snmpTalkType *result,int runt,char *labels[],
		    int dohex,char **intlabels);
extern int   tl_recv (snmpTalkType *rreq);
extern int   tl_recv_snmp(void);
extern int   tl_send (snmpTalkType *rreq);
extern int   tl_snmpVal_free(snmpVal *val,unsigned long len);
extern int   tl_stosym(char *s,char *buf,int len);
extern int   tl_stooid(char *oid,int *n,char *text);
extern int   tl_symtol(char *symbol,long *result,int *reslen);
extern int   tl_symtooid(char *str,snmpVal *var,char *buf,int len);
extern int   tl_talk(unsigned char **str,char *hoststr,char *community,
		    snmpTalkType *result,int mode,int tmo,int retry_limit,
		    int opts);
extern void  tl_time_pretty(snmpTalkType *result,char *label);
extern int   tl_trap_snmp(void);
extern void  udpClose(void);
extern void  udpSetErrStream(FILE *streamp,int len);

extern int   udpDescr(void);	/* returns network descriptor for snmp	    */
extern int   trapDescr(void);	/* returns network descriptor for traps	    */

					/* these 2 useful for net_asynch()  */
extern int   snmpDescrGlobalize(void);	/* globalizes snmp network descriptr*/
extern int   trapDescrGlobalize(void);	/* globalizes trap network descriptr*/

extern void  tl_pr_notice(char *str);	/* print program "str" banner	    */
