/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\rwconf.h_v   1.16.1.1   08 Apr 1993 17:28:06   arnoff  $
 */

#ifndef __RWCONF_HEADER__
#define __RWCONF_HEADER__



/* rwconf.h	definitions for config_{open,seek,read,write}() routines.
 */

/*
 * Copyright (C) 1991, 1992 by FTP Software, Inc.  All rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 23-Jun-91	rehmi	created this in the source tree.
 * 30-Dec-91	Ben	Added flag SKIP_OLD_INIT.
 * 07-Jan-92	Ben	Added two new error numbers (1001, 1002)
 * 16-Jan-92	paul	added MAX_CONFIG_ERR, conf_errlist, pconferror
 * 23-Jan-92	Ben	Added CE_PERMISSION
 * 19-Feb-92	Ben	Changed define for SKIP_OLD_INIT
 * 06-mar-92	wls	added configure_setconf() and SETCONF_FLAG_NOBACKUP
 * 24-Mar-92	Ben	Added _cont_FILE & _curr_FILE.
 * 30-Mar-92	Ben	Added CONF_TRAILING_WHITSPACE and _config_warning_done
 * 13-May-92	Ben	Changed setconf_end() to a macro and added 
 *			 config_flush(). Dropped configure_setconf().  
 *			 Renamed SETCONF_FLAG_NOBACKUP to CF_FLAG_NOBACKUP.
 * 14-May-92	Ben	Changed setconf() to a macro and added config_write().
 * 04-Nov-92	Ben	Added CE_FILE_NOT_OPEN, CE_SEEK_NOT_CALLED &
 *			 CE_FILE_OPEN.
 * 06-Nov-92	Ben	Bumped MAX_CONFIG_ERR to 12.
 */

extern FILE *_config_FILE;
extern FILE *_cont_FILE;
extern FILE *_curr_FILE;

extern char *_config_wildcard;
extern char *_config_pctcp_package;
extern char *_config_token_delimiter;

/* If _config_warning_done is non-zero, the config library will not 
 * print a warning for using FTP_CONFIG.
 */
extern char _config_warning_done;

#define MAX_SECTION_LEN		64
#define MAX_LABEL_LEN		64

#define CONF_ANY		_config_wildcard
#define CONF_NONE		0L
#define CONF_ANY_NAME		_config_wildcard
#define CONF_PCTCP		_config_pctcp_package
#define CONF_TOKEND		_config_token_delimiter
#define CONF_ANY_INSTANCE	-1

#define CONF_SAME_SECTION	0x0001
#define CONF_NEXT_SECTION	0x0002
#define CONF_REWIND		0x0004
#define CONF_LEADING_WHITESPACE		0x0010
#define CONF_TRAILING_WHITESPACE	0x0020

#define SKIP_OLD_INIT		0x8000 /* don't check for use_old_init */

extern int config_open (char *, int);
/* config_open (fname, flags);
 *
 * if fname is NULL then a getenv("PCTCP") is done to determine the file name.
 * no flags are currently defined for this.
 * returns TRUE or FALSE to reflect success.
 */

extern int config_close (int);
/* config_close (flags);
 *
 * no flags are currently defined for this.
 * returns TRUE or FALSE to reflect success.
 */

extern int config_seek (char *, char *, char *, int);
/* config_seek (package, sect, subsection, flags);
 *
 * performs a seek in the config file. package is usually "pctcp".
 * if a string argument points to an empty string, a wildcard is signified
 * and the string pointed to is filled in with the found name. if a string
 * argument is CONF_ANY, any name matches and no string is filled in.
 * if subsection is NULL, the absence of a subsection name is indicated.
 * valid flags are CONF_SAME_SECTION and CONF_NEXT_SECTION. this puts the
 * read pointer at the beginning of the appropriate section.
 * returns TRUE or FALSE to reflect success.
 */

extern int config_read (char *, int, char *, int, int);
/*config_read (name, instance, value, size, flags);
 *
 * searches a section for an occurrence of the named field, and fills
 * in the value if found. instance may be CONF_ANY_INSTANCE to accept any
 * occurrence of the name, 0 for the first, 1 for the second, etc.
 * if name points to an empty string it is filled in by the first match.
 * CONF_ANY may be used as a wildcard for name.
 * returns TRUE or FALSE to reflect success.
 */

extern int config_errno;

#define CE_OK		0	/* no error */
#define CE_ENV		1	/* no PCTCP environment var defined */
#define CE_FILE		2	/* file specified by PCTCP env var not found*/
#define CE_SECTION	3	/* specified config section not found  */
#define CE_ENTRY	4	/* specified config entry not found */
#define CE_OVERFLOW	5	/* specified buffer too small to hold entry */
#define CE_PARM_ERROR	6	/* illegal NULL section/subsection spec'ed */
#define CE_FILE_ERROR	7	/* file positioning problem, file rewound */
#define CE_CONT_FILE	8	/* specified continuation file not found */
#define CE_PERMISSION	9	/* Couldn't change ini file		*/
#define CE_FILE_NOT_OPEN    10	/* Called config_seek before opening file */
#define CE_SEEK_NOT_CALLED  11  /* Called config_seek or config_read before
				    config_open() */
#define CE_FILE_OPEN	12	/* Called config_flush before closing file */

#define MAX_CONFIG_ERR	12	/* highest numbered error */

/* Added for use-old-init-scheme, eventually they'll go away */
#define CE_NO_STACK_MEM	1001	/* not enough memory for strucures */
#define CE_NO_CUST_FILE 1002	/* couldn't find a cust file in memory */

extern char *conf_errlist[];
extern void pconferror(char *str);

extern int config_write(char *, char *, char *, char *, char *, int);
/* config_write(package, section, subsection, name, value, flags);
 *
 * adds to a list of changes to be made.
 * returns TRUE or FALSE to reflect success
 */

#define	setconf(section,subsection,name,value)		\
    config_write (_config_pctcp_package,section,subsection,name,value, 0)

extern int config_flush (char *, char *, unsigned int);
/* config_flush (cfname, bakname, flags)
 *
 * writes queued changes to the config file.
 * if fname is non-NULL it is taken as the file name, otherwise
 * the value of the PCTCP environment variable is used.
 * returns TRUE or FALSE to reflect success.
 *
 * set a backup filename to be used by setconf end(), and set the
 * value of the backup_flags word
 *
 * interpretation of bakname (given a config file name of ABCD.ini)
 *
 *    if(bakname[0] == 0) ==> backups will go to ABCD.001, ABCD.002, etc.
 *    if(bakname[0] == '.') (e.g., ".OLD")  backups will go to ABCD.OLD
 *    else  backups will go to the exact filename specified
 *     
 * values for the flags are defined immediately below    
 */

#define  setconf_end(fname)    config_flush(fname, "", 0)

#define CF_FLAG_NOBACKUP 0x01  /* don't make a backup copy of the file */
  

int getconf(char *, char *, char *, int);
/* getconf(section, name, value, len)
 *
 */

/* everything from here to EOF *will* go away in 3.0 */

int getconf_init(int);
/* getconf_init(flags);
 *
 */

#define getconf_error config_errno

/* these defines used by getconf_init() */

#define CI_NORMAL		0x01 /* same as LAST_SECTION_REWIND */
#define CI_LAST_SECTION_REWIND	0x01 /* remember pos by sect,rewind if */
				     /* no match*/
#define CI_LAST_POSITION	0x02 /* remember file position by entry */
#define CI_REWIND		0x04 /* don't change parse_type, just rewind */
#define CI_CLOSE		0x08 /* close the config file */

#define GE_OK		CE_OK
#define GE_ENV		CE_ENV
#define GE_FILE		CE_FILE
#define GE_SECTION	CE_SECTION
#define GE_ENTRY	CE_ENTRY
#define GE_OVERFLOW	CE_OVERFLOW
#define GE_PARM_ERROR	CE_PARM_ERROR
#define GE_FILE_ERROR	CE_FILE_ERROR

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\rwconf.h_v  $
 * 
 *    Rev 1.16.1.1   08 Apr 1993 17:28:06   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.16   05 Nov 1992 15:51:20   seven
 * Bumped MAX_CONFIG_ERR to 12.
 * 
 *    Rev 1.15   04 Nov 1992 15:52:08   seven
 * Added CE_FILE_NOT_OPEN, CE_SEEK_NOT_CALLED & CE_FILE_OPEN.
 * 
 *    Rev 1.14   22 Jun 1992 16:34:28   paul
 * track changes from 2.1
 * 
 *    Rev 1.15   14 May 1992 23:07:20   arnoff
 * Changed setconf() to a macro and added config_write.   ---Ben
 * 
 * 
 *    Rev 1.14   14 May 1992 16:49:46   arnoff
 * Changed setconf_end to a macro and added config_flush.  Dropped
 * configure_setconf().  Renamed SETCONF_FLAG_NOBACKUP to
 * CF_FLAG_NOBACKUP.   ---Ben
 * 
 * 
 * 
 *    Rev 1.5   30 Mar 1992 15:38:42   arnoff
 * Added CONF_TRAILING_WHITSPACE and _config_warning_done.   ---Ben
 * 
 *    Rev 1.4   27 Mar 1992 19:41:28   arnoff
 * Added _cont_FILE & _curr_FILE.   ---Ben
 * 
 *    Rev 1.3   06 Mar 1992 20:45:08   arnoff
 * wls	added configure_setconf() and SETCONF_FLAG_NOBACKUP
 * 
 *    Rev 1.2   19 Feb 1992 19:03:22   arnoff
 * changed define for SKIP_OLD_INIT
 * 
 *    Rev 1.1   30 Jan 1992 00:06:20   arnoff
 *  
 */


#endif /* __RWCONF_HEADER__ */

