/*
 * $Header:   E:/22vcs/include/pctcp/options.h_v   1.11   12 Nov 1992 12:58:08   snyders  $
 */

/*
 * INCLUDE\PCTCP\OPTIONS.H
 *
 * Copyright (C) 1986,1987,1988,1991,1992 by FTP Software, Inc.
 *  All rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * EDIT HISTORY:
 * 08-Dec-87	romkey	changed set/get_option value type to long from
 *			 char far *
 * 24-Mar-88	jbvb	get_option() is passed a char *.  set_option() is
 *			 passed a char far *.
 * 06-Jul-88	jbvb	Precedence, TOS & Keepalives are implemented, add
 *			 definitions for IP security support.
 * 13-Jul-88	jbvb	Add definitions for IP options, fix auth. values
 * 20-Jul-88	jbvb	Clean up unused stuff...
 * 29-Jul-88	jbvb	Correct definitions of IP TOS & Precedence
 * 05-Dec-88	dab	Fixed AUTH_* values.
 * 30-Nov-90	gub	Add NET_OPT_WAITFLUSH
 * 05-Dec-91	gub	Merge vitaly's changes (add AUTH_DOE and sec_opt)
 * 10-Dec-91	gub	Add AUTH_SCI and AUTH_NSA
 * 14-Jan-92	Ben	Protected against multiple inclusion
 * 17-jAN-92	Ben	Added IP_TOS_LOW_COST, and adjusted TOS_MASK.
 * 23-Jul-92	wcl	Added NET_OPT_TTL.
 */


#ifndef _PCTCP_OPTIONS_H
#define _PCTCP_OPTIONS_H INCLUDED

/* values for set_option() and get_option() system calls.
*/
#define	NET_OPT_NONBLOCKING	0x01	/* don't block on system calls */
#define	NET_OPT_TIMEOUT		0x02	/* timeout system calls */
#define	NET_OPT_HINT		0x03	/* set a user-supplied "hint" */
#define	NET_OPT_BUFSIZE		0x04	/* set the window or packet q len */
#define	NET_OPT_NETASCII	0x05	/* do netascii xlation - not impl. */
#define	NET_OPT_KEEPALIVE	0x06	/* do TCP keepalives */
#define	NET_OPT_DEBUG		0x07	/* enable debugging - not impl. */
#define	NET_OPT_DONTROUTE	0x08	/* "don't route" - not impl. */
#define	NET_OPT_PRECEDENCE	0x09	/* set IP precedence */
#define	NET_OPT_TOS		0x0A	/* set IP type of service */
#define	NET_OPT_PRIV		0x0B	/* make lcl socket number be < 1K*/
#define	NET_OPT_WAITFLUSH	0x0C	/* Honor NET_FLG_PUSH on this nd */
#define	NET_OPT_TTL		0x0D	/* Set TTL for each connection */

/* precedence values
*/
#define	IP_PREC_MASK		0xE0
#define	IP_PREC_ROUTINE		0
#define	IP_PREC_PRIORITY	0x20
#define	IP_PREC_IMMEDIATE	0x40
#define	IP_PREC_FLASH		0x60
#define	IP_PREC_FLASH_OVERRIDE	0x80
#define	IP_PREC_CRITICECP	0xA0
#define	IP_PREC_INET_CONTROL	0xC0
#define	IP_PREC_NET_CONTROL	0xE0

/* Some IP option values, sorted by 'number'
*/
#define	IPOPT_EOL	0x00	/* End of option list */
#define	IPOPT_NOP	0x01	/* No operation */
#define	IPOPT_BAS_SEC	0x82	/* Basic Security */
#define	IPOPT_LSRR	0x83	/* Loose Source & Record Route */
#define	IPOPT_TS	0x44	/* Timestamp */
#define	IPOPT_EXT_SEC	0x85	/* Extended Security */
#define	IPOPT_RR	0x07	/* Record Route */
#define	IPOPT_SID	0x08	/* Stream ID (obsolete) */
#define	IPOPT_SSRR	0x89	/* Strict Source & Record Route */

/* type of service values - | them together
*/
#define	IP_TOS_MASK		0x1E
#define	IP_TOS_LOW_COST		0x02
#define	IP_TOS_HIGH_RELIABILITY	0x04
#define	IP_TOS_HIGH_THROUGHPUT	0x08
#define	IP_TOS_LOW_DELAY	0x10

/*
 * Define values for new (RFC-1038) IP Basic & Extended Security options
 * (in addition, 1, 66, CC and F1 are reserved values).
 */
#define	IP_TOPS		0x3D
#define	IP_SECR		0x5A
#define	IP_CONFI	0x96
#define	IP_UNCLA	0xAB

#define	AUTH_GENSER	0x80
#define	AUTH_SIOP	0x40

#if 0
#define	AUTH_SPINT	0x20
#define	AUTH_CRITI	0x10
#endif

#define AUTH_SCI	0x20
#define AUTH_NSA	0x10
#define	AUTH_DOE 	0x08

#define	AUTH_LENGTH	0x01    /* Field Length */ 

struct	sec_opt {            /* Basic Security Option */
   unsbyte opt_type;
   unsbyte opt_len;
   unsbyte opt_class;
   unsbyte opt_auth[2];  /* Oct.,91 IPSO required minimum of    */
                         /* 2 octets Protection Authority flags */
};

int set_option(int, int, int, char far *, int);
char far *get_option(int, int, int, char *, int);

#endif /* _PCTCP_OPTIONS_H */

/*
 * $Log:   E:/22vcs/include/pctcp/options.h_v  $
 * 
 *    Rev 1.11   12 Nov 1992 12:58:08   snyders
 * Fixed IP_TOS_LOW_COST value and IP_TOS_MASK.
 * 
 *    Rev 1.10   07 Aug 1992 23:41:44   bill
 * Added NOT_OPT_TTL
 * 
 *    Rev 1.9   03 Feb 1992 23:26:52   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:48:54   arnoff
 *  
 */
