/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\k_config.h_v   1.12.1.1   08 Apr 1993 17:26:30   arnoff  $
 */

#ifndef __K_CONFIG_HEADER__
#define __K_CONFIG_HEADER__



/*
 * INCLUDE\PCTCP\K_CONFIG.H
 *
 * Copyright (C) 1988-1992 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 23-Feb-88	jbvb	First written.
 * 27-Feb-88	jbvb	Add broadcast address field.
 * 24-Mar-88	jbvb	Add function definition & prototype.
 * 09-Sep-88	jbvb	Add printout routine definition
 * 09-Jan-89	jbvb	k_cticks is now milliseconds.
 * 06-May-91	gub	Add SBUFS for small buffers
 * 22-Jun-91	Ben	Added k_LBUF define
 * 27-Nov-91	Ben	Assume LINT_ARG always set and removed ifdef,
 *			updated prototype for display_config
 * 16-Mar-92	gub	Remove SBUF_SIZE field for 2.05 compatibility
 * 07-Apr-92	kek	Warning for structure size changes affecting VxD.
 * 03-Nov-92	snyders	ifdef net_get_k_conf prototype on MSW3.
 */

/*
 * WARNING: If you change the size of this structure, make sure to 
 *	    reflect the change in srcdrv/vxd/vpctcp.inc's LEN_K_CONF EQUATE!
 */
struct kernel_conf {
	unsbyte	k_max_tcp;	/* # of TCP connections allowed */
	unsbyte	k_max_udp;	/* # of UDP connections allowed */
	unsbyte	k_max_ip;	/* # of IP connections allowed */
	unsbyte	k_max_raw;	/* # of RAW_NET connections allowed */
	unsbyte	k_act_tcp;	/* # of TCP connections in use */
	unsbyte	k_act_udp;	/* # of UDP connections in use */
	unsbyte	k_act_ip;	/* # of IP connections in use */
	unsbyte	k_act_raw;	/* # of RAW_NET connections in use */
	unsword	k_act_lcl;	/* # of active Local network descriptors */
	unsword	k_act_gbl;	/* # of active Global network descriptors */
	unsbyte	k_MaxLnh;	/* Maximum header on an attached network */
	unsbyte	k_MaxLnt;	/* Maximum trailer on an attached network */
	unsword	k_LBUF_SIZE;	/* Size of a large packet buffer */
	unsword	k_Nnet;		/* Number of network interfaces attached */
	unslword k_cticks;	/* Milliseconds since kernel started */
	in_name	k_broadcast;	/* IP broadcast address in use */
};


/* define for old applications */
#define k_LBUF	k_LBUF_SIZE

#ifndef	MSW3
int	net_get_k_conf(struct kernel_conf *);
#endif	/*MSW3*/
void	display_config(int (*io_rtn)(char *));

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\k_config.h_v  $
 * 
 *    Rev 1.12.1.1   08 Apr 1993 17:26:30   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.12   03 Nov 1992 15:41:52   snyders
 * ifdef net_get_k_conf prototype on MSW3. checked by paul.
 * 
 *    Rev 1.11   07 Apr 1992 21:15:24   arnoff
 *  * 07-Apr-92	kek	Warning for structure size changes affecting VxD.
 * 
 *    Rev 1.10   17 Mar 1992 15:33:22   arnoff
 * Remove SBUF_SIZE field for 2.05 compatibility.
 * 		--Gub
 * 
 *    Rev 1.9   03 Feb 1992 23:26:46   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:48:46   arnoff
 *  
 */


#endif /* __K_CONFIG_HEADER__ */

