/*
 * $Header:   F:/21vcs/include/pctcp/ipconfig.h_v   1.9   03 Feb 1992 23:26:42   arnoff  $
 */

/*
 * INCLUDE\IPCONFIG.H - IP configuration information
 *
 * Copyright (C) 1986,1988,1991,1992 by FTP Software, Inc.  All rights 
 *  reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * EDIT HISTORY:
 *	6/16/86	Romkey	added mail relay field.
 * 06-Jul-88	jbvb	Add c_ip_tos, c_ip_opt_flag, c_ip_options[],
 *			 c_old_security, c_bas_security, c_ext_security.
 * 07-Jul-88	jbvb	Added c_ip_opt_len, current IP option length.
 * 12-Jul-88	jbvb	Don't bother with old ip security option.
 * 28-Oct-88	jbvb	Restore INMEMORY_IPCONFIG definition.
 * 20-Jun-91	paul	add support for init code (make extern data far)
 * 05-Dec-91	gub	Merge in vitaly's IPSO port stuff
 * 06-Dec-91	vitaly	Add msk bits
 * 14-Jan-92	Ben	Protected against multiple inclusion
 */


#ifndef _IPCONFIG_H
#define _IPCONFIG_H INCLUDED

#define	IPC_VERSION	1
#define	IPC_TYPE	1

struct ipconfig {
	char		c_dummy[18];
	char		c_iver;
	char		c_type;		/* is it ipconfig or ifconfig? */
	unsigned	c_debug;
	unsigned	c_emulators;	/* emulator defaults */

#define	HOSTNAME_LEN	64
	char		c_hostname[HOSTNAME_LEN];
#define	DOMAIN_LEN	64
	char		c_domain[DOMAIN_LEN];
#define	USERID_LEN	16	/* name, like "Romkey" */
	char		c_userid[USERID_LEN];
#define	USERNAME_LEN	64	/* fullname like "John Romkey" */
	char		c_username[USERNAME_LEN];
#define	OFFICE_LEN	64
	char		c_office[OFFICE_LEN];
#define	PHONE_LEN	32
	char		c_phone[PHONE_LEN];

	/* time server stuff 	*/
#define	MAXTIMES	5
	int		c_tmoffset;
	char		c_tmlabel[4];
	unsigned	c_numtime;
	in_name		c_time[MAXTIMES];

	/* old style name server stuff */
#define	MAXNAMES	3
	unsigned	c_numname;
	in_name		c_names[MAXNAMES];

	/* domain name server info */
#define	MAXDNAMES	3
	unsigned	c_numdname;
	in_name		c_dm_servers[MAXDNAMES];

	/* other servers */
	in_name		c_defgw;	/* default gateway */
	in_name		c_servers[25];		/* logging server */
	unsigned	c_window;
	unsigned	c_lowwindow;
#define	HOSTTABLE_LENGTH	66
	char		c_hosttable[HOSTTABLE_LENGTH];
#define	MAILRELAY_LENGTH	80
	char		c_mailrelay[MAILRELAY_LENGTH];
	char		c_ip_tos;		/* IP TOS value */
	char		c_ip_opt_flag;		/* Are indices valid? */
	int		c_bas_security;	/* Offset of Basic IP security... */
	int		c_ext_security;	/* Offset of Extended IP security */
#define IP_OPTION_MAX		40		/* IP maximum */
	char		c_ip_options[IP_OPTION_MAX];	/* The options */
	int		c_ip_opt_len;			/*  & total length */
/* vitaly > */
	int		c_ip_opt_numports;	/* Number of IPSO ports */
#define MAX_PORT	25
struct opt_port {
  in_name port;         /* name of port - IP address  */
  unsbyte rcv : 1;      /* port-BSO-required-receive  */
  unsbyte trn : 1;      /* port-BSO-required-transmit */
  unsbyte msk : 4;      /* byte mask IP addr          */
  unsbyte rsv : 2;      /* reserv                     */
  unsbyte class;        /* port implicit label        */
}  c_ip_opt_port[MAX_PORT]; /* 6 bytes for 1 port */
/* < vitaly */
	char		c_space[50];
	};

/* structure is 888 bytes long */

/* specific server indexes for c_servers[] */
#define	SRV_LOG		0
#define	SRV_COOKIE	1
#define	SRV_LPR		2
#define	SRV_IPRINT	3

/* terminal emulator bit masks */
#define	EM_BS		0x0001		/* <- sends BS instead of DEL */
#define	EM_WRAP		0x0002		/* h19 emulator wraps around */

/* IP option flag bit masks
*/
#define	C_IP_STRICT	0x1		/* Strict precedence checking */
#define	C_IP_SECURE	0x2		/* Strict security checking */
#define	C_IP_BAS	0x4		/* Basic (RFC1038) IP Security */
#define	C_IP_EXT	0x8		/* Extended IP Security */

#define INMEMORY_IPCONFIG	"$ipcust"

int get_ipconfig(char *, struct ipconfig *);
int set_ipconfig(char *, struct ipconfig *);

#ifndef INIT
extern struct ipconfig ipconf;
#else
extern struct ipconfig far ipconf;
#endif /* INIT */

#endif /* _IPCONFIG_H */

/*
 * $Log:   F:/21vcs/include/pctcp/ipconfig.h_v  $
 * 
 *    Rev 1.9   03 Feb 1992 23:26:42   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:48:44   arnoff
 *  
 */
