/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\error.h_v   1.13.1.1   08 Apr 1993 17:24:28   arnoff  $
 */

#ifndef __ERROR_HEADER__
#define __ERROR_HEADER__



/*
 * INCLUDE\PCTCP\ERROR.H
 *
 * Copyright (C) 1986,1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 03-Feb-88	jbvb	Add NET_ERR_REENTRY.
 * 24-Jun-88	jbvb	Add prototype for pneterror()
 * 05-Jul-88	jbvb	Add NET_ERR_ICMPMSG and sub-error codes.
 * 08-Jul-88	jbvb	Add definitions for sub-error string array, etc.
 * 09-Sep-88	jbvb	Add output-routine form of error display.
 * 17-Aug-89	jbvb	Always use function prototypes.
 * 15-Sep-89	jbvb	Add MAX_PCTCP_ERR
 * 15-Sep-89	jbvb	Add MAX_PCTCP_SUBERR
 * 15-May-91	gub	Add NET_ERR_TERMINATING for unload upcalls
 * 16-May-91	gub	Add tag locked and bad interface errors for new config
 * 20-May-91	gub	Add NET_ERR_BADCONFIG for kernel startup check
 * xx-Jun-91  msd@ayuda	Begin work on 2.10 version.
 * 11-Jul-91	gub	Make neterrno a far in the INIT layer...(whoops!)
 * xx-Aug-91  msd@ayuda	To FTP for 2.10 beta testing.
 * 05-Dec-91	gub	Add NET_SUB_ADMIN_PROHIB, adjust MAX_PCTCP_SUBERR
 * 15-Jan-92	davec	Added EMM Error code to list
 *		&Irina
 * 20-Mar-92	gub	Add NET_ERR_PARKED_IN
 * 27-Apr-92	kek	Add NET_ERR_NOACCESS for 286 DLL.
 * 08-May-92	kek	Change MAX_PCTCP_ERR to 1 less than NET_ERR_NOACCESS.
 * 20-May-92	gub	Add NET_ERR_NOQIOS and NET_ERR_WOULD_TRUNCATE; also
 *			 make NET_ERR_NOACCESS dynamically defined
 * 04-Jun-92	kek	**********WARNING************
 *			Please notify a windev person if you add a NET_ERR_*
 *			or NET_SUB_* value BEFORE you submit changes to the 
 *			library. PCTCPAPI.DLL must be updated with the new 
 *			error text.
 */

/* definitions of error codes that pc/tcp system calls can return
*/
#define	NET_NOERR			0
#define	NET_ERR_INUSE			1
#define	NET_DOS_ERR			2
#define	NET_ERR_NOMEM			3
#define	NET_ERR_NOTNETCONN		4
#define	NET_ERR_ILLEGALOP		5
#define	NET_ERR_BADPKT			6
#define	NET_ERR_NOHOST			7
#define	NET_ERR_CANTOPEN		8
#define	NET_ERR_NET_UNREACHABLE		9
#define	NET_ERR_HOST_UNREACHABLE	10
	#define	NET_SUB_NO_ERROR	0	/* no error */
	#define	NET_SUB_ICMP_UNR	1	/* icmp dest. unreachable */
	#define	NET_SUB_ARP		2	/* direct arp failed */
	#define	NET_SUB_IF_FAILURE	3	/* hardware failure */
	#define	NET_SUB_IF_UNR		4	/* hardware link failure */
	#define	NET_SUB_NOROUTE		5	/* no route */
	#define	NET_SUB_GW		6	/* first hop gateway down */
#define	NET_ERR_PROT_UNREACHABLE	11
#define	NET_ERR_PORT_UNREACHABLE	12
#define	NET_ERR_TIMEOUT			13
#define	NET_ERR_HOSTUNKNOWN		14
#define	NET_ERR_NOSERVERS		15
#define	NET_ERR_SERVER_ERR		16
#define	NET_ERR_BADFORMAT		17
#define	NET_ERR_BADARG			18
#define	NET_ERR_EOF			19
#define	NET_ERR_RESET			20
#define	NET_ERR_WOULD_BLOCK		21
#define	NET_ERR_UNBOUND			22
#define	NET_ERR_NODESC			23
#define	NET_ERR_BADSYSCALL		24
#define	NET_ERR_CANTBROADCAST		25
#define	NET_ERR_NOTESTAB		26
#define	NET_ERR_REENTRY			27
#define	NET_ERR_ICMPMSG			28	/* Other ICMP */
	#define	NET_SUB_ICMP_UNREC	7	/* Unknown other ICMP */
	#define	NET_SUB_CANTFRAG	8	/* DESTIN: code 4 */
	#define	NET_SUB_SRCR_FAIL	9	/* DESTIN: code 5 */
	#define	NET_SUB_SORCEQ		10	/* Source Quench */
	#define	NET_SUB_TIMEX		11	/* Time Exceeded */
	#define	NET_SUB_PARAM		12	/* Parameter Problem */
	#define	NET_SUB_ADMIN_PROHIB	13	/* Communication Prohibited */

#define NET_ERR_TERMINATING		29	/* Kernel unloading */
#define NET_ERR_TAG_LOCKED		30	/* Can't set this tag */
#define NET_ERR_BAD_INTERFACE		31	/* No such device! */
#define NET_ERR_BADCONFIG		32	/* Kernel can't run yet... */
#define NET_ERR_EMM			33      /* EMM manager complains ...*/
#define NET_ERR_CANT_SHUTDOWN		34      /* In a multi-tasker */
#define NET_ERR_PARKED_IN		35	/* Someone else has INT2F */
#define NET_ERR_NOQIOS			36	/* No qios left */
#define NET_ERR_WOULD_TRUNCATE		37	/* Your datagram's too big */
#define	NET_ERR_APPENDED		38	/* We've appended nut didn't */
						/*   write yet... */

#define	MAX_PCTCP_ERR			38	/* Highest numbered error */
#define	MAX_PCTCP_SUBERR		13	/* Highest sub-error code */

#define NET_ERR_NOACCESS  (MAX_PCTCP_ERR + 1)	/* Kernel access failed */
/****************************************************************************
   NOTE: NET_ERR_NOACCESS is used by the 286/386 DLL on failed net_taskInit().
         The net_errname() routine handles the error by itself, and expects
	 it to be one greater than MAX_PCTCP_ERR. No string exists for it in
	 neterr_list[]. 
 ****************************************************************************/

#ifdef	INIT
extern int far neterrno;
#else	/*INIT*/
#ifndef	neterrno
extern int neterrno;
#endif
#endif	/*INIT*/
#ifndef	netsuberrno
extern int netsuberrno;
#endif
extern char *neterr_list[];
extern char *netsuberr_list[];
extern int net_nerr;
extern int net_nsuberr;

void pneterror(char *);
void ppneterror(char *, int (*)());

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\error.h_v  $
 * 
 *    Rev 1.13.1.1   08 Apr 1993 17:24:28   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.13   03 Jul 1992 17:09:02   bill
 * Added NET_ERR_APPENDED (#38)
 * 
 *    Rev 1.12   22 Jun 1992 16:58:12   paul
 * track changes from 2.1
 * 
 *    Rev 1.14   05 Jun 1992 11:21:36   arnoff
 *  04-Jun-92	kek	**********WARNING************
 * 			Please notify a windev person if you add a NET_ERR_*
 * 			or NET_SUB_* value BEFORE you submit changes to the 
 * 			library. PCTCPAPI.DLL must be updated with the new 
 * 			error text.
 * 
 *    Rev 1.13   20 May 1992 15:04:30   arnoff
 * Added NET_ERR_NOQIOS and NET_ERR_WOULD_TRUNCATE; also fixed the
 * definition of NET_ERR_NOACCESS so it dynamically depends on the value
 * of MAX_PCTCP_ERR.  Removed Karen's warning.
 * 
 * 		--Gub
 * 
 *    Rev 1.12   08 May 1992 12:25:50   arnoff
 *  08-May-92	kek	Change MAX_PCTCP_ERR to 1 less than NET_ERR_NOACCESS.
 *  			**************************************************
 * 			PLEASE SEE NOTE BELOW BEFORE ADDING ERROR CODES!!!
 * 			**************************************************
 * 
 *    Rev 1.11   28 Apr 1992 19:33:22   arnoff
 *  * 27-Apr-92	kek	Add NET_ERR_NOACCESS for 286 DLL.
 * 
 *    Rev 1.10   26 Mar 1992 14:14:28   arnoff
 * Add NER_ERR_PARKED_IN.     gub
 * 
 *    Rev 1.9   03 Feb 1992 23:26:28   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:48:28   arnoff
 *  
 */


#endif /* __ERROR_HEADER__ */

