/*
 * $Header:   J:\devkit.dos\vcs\include\pctcp\dns_lib.h_v   1.11.1.2   16 Apr 1993 19:35:46   arnoff  $
 */

#ifndef __DNS_LIB_HEADER__
#define __DNS_LIB_HEADER__



/*
 * DNS_LIB.H
 *
 * Copyright (C) 1989,1990 by FTP Software, Inc, all rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * EDIT HISTORY:
 * 88.12.07 MG	Creation, under modification.
 * 89.02.01 MG	Added '#include's to unify all routines.
 * 24-Aug-89	jbvb	Converted to DM_LIB.H for 2.04 release
 * 25-Aug-89	jbvb	Add timeout field, rename some routines.
 * 28-Aug-89	jbvb	Reorganized data_tags to make freeing easier.
 * 09-Nov-90  msd@ayuda	Expanded to cover explictly FAR data structures, used
 *			by the MSW3 version.  Add 'host_*' API.
 * 01-Apr-91  msd@ayuda	To FTP for 2.05 pl 2 beta.
 * 26-Apr-91  wcl	Added dns_lib_class variable that was missing.
 * 21-Oct-91  msd@ayuda	Add 'class' field (correlary to 'dns_lib_class')
 *			in the query control structure under MSW3.
 * 23-Oct-91	paul	changed dns_print, dns_h_print protos to return void
 * 06-Jan-92	kek	Incorporated msd version into source tree.
 * 04-Nov-92	Arnoff	prototype for free_domain_resp() (routine doesn't
 *			exist) changed to free_resp_list() (does exist).
 */

/*
 * Containing the structure for a parsed domain query suitable for user
 * consumption.
 * Specs can be found in RFC1035: Domain Implementation and Specification.
*/

#define	MAX_CNAME	128		/* max # bytes in a full DNS name */

/* In the MS Windows WinApp environment, various pointers are DLLFAR and
   the location of the structures allocated by these calls is within the
   DLL itself.  Also, simplified access is provided via 'host_nm_query'
   and 'host_ad_query'.

   NOTE: When used in the MS Windows environment, this header MUST be
   included AFTER "pctcp/winapp.h".
*/
#ifndef	MSW3
#define	DLLFAR
#endif

/* Domain name server protocol definitions */
struct dm_hdr {
	unsigned	dm_id;
	unsigned	dm_flags;
	unsigned	dm_qd_count;
	unsigned	dm_an_count;
	unsigned	dm_ns_count;
	unsigned	dm_ar_count;
	};

/* bits in flags */
#define	DM_RESPONSE	0x8000
#define	DM_AUTHORITY	0x0400
#define	DM_TRUNCATED	0x0200
#define	DM_DO_RECURSE	0x0100
#define	DM_CAN_RECURSE	0x0080

/* field masks */
#define	OPCODE_MASK	0x7800
#define	RESPONSE_MASK	0x000F

/* opcodes in flags */
#define	OP_QUERY	0
#define	OP_IQUERY	1
#define	OP_CQUERYM	2
#define	OP_CQUERYU	3

/* response codes in flags */
#define	RC_NO_ERR	0
#define	RC_FORMAT	1
#define	RC_SERVER	2
#define	RC_NAME		3
#define	RC_NOT_IMP	4
#define	RC_REFUSED	5

#define	get_opcode(p)	(((p)->dm_flags & OPCODE_MASK) >> 11)
#define	put_opcode(p, c)	{ (p)->dm_flags &= ~OPCODE_MASK; \
				  (p)->dm_flags |= (c << 11); }

#define	get_rc(p)	((p)->dm_flags & RESPONSE_MASK)
#define	put_rc(p, c)	{ (p)->dm_flags &= ~RESPONSE_MASK; \
			  (p)->dm_flags |= c; }

/* resource record types */
#define	A	1
#define	NS	2
#define	MD	3
#define	MF	4
#define	CNAME	5
#define	SOA	6
#define	MB	7
#define	MG	8
#define	MR	9
#define	RT_NULL	10
#define	WKS	11
#define	PTR	12
#define	HINFO	13
#define	MINFO	14
#define MX	15
#define	TXT	16

/* query types */
#define	AXFR	252
#define	MAILB	253
#define	MAILA	254
#define	QT_STAR	255

/* class types */
#define	IN	1
#define	CS	2
#define	CH	3
#define	HS	4

/* qclass types */
#define	QC_STAR	255

/* Domain library interface definitions */
#define DSTRING	0	/* a domain name string 			*/
#define STRING	1	/* an ordinary string 				*/
#define EIGHT	2	/* 8 bit quantity 				*/
#define SIXTE	3	/* 16 bit quantity 				*/
#define THIRT	4	/* 32 bit quantity 				*/
#define DNUL	5	/* unknown.  for NULL type rr. 			*/
#define BITMAP	6	/* variable size bitmap 			*/

union data_tag {
	struct {
		char DLLFAR *qcname;
	} qcname;
   
	struct {
		char DLLFAR *machine;
		char DLLFAR *os;
	} hinfo;
   
	struct {
		char DLLFAR *madname;
	} mb;
   
	struct {
		char DLLFAR *madname;
	} md;
    
	struct {
		char DLLFAR *madname;
	} mf;
    
	struct {
		char DLLFAR *mgmname;
	} mg;
    
	struct {
		char DLLFAR *rmailbx;
		char DLLFAR *emailbx;
	} minfo;

	struct {
		char DLLFAR *newname;
	} mr;

	struct {
		char DLLFAR *exchange;
		unsigned preference;
	} mx;
    
	struct {
		char DLLFAR *anything;
	} null;
    
	struct {
		char DLLFAR *nsdname;
	} nsdname;
    
	struct {
		char DLLFAR *ptrdname;
	} ptr;
	
	struct {
		char DLLFAR *mname;
		char DLLFAR *rname;
		long serial;
		long refresh;
		long retry;
		long expire;
		long minimum;
	} soa;
    
	struct {
		char DLLFAR *txtdata;
	} txt;
    
	struct {
		long address;
	} qa;
    
	struct {
		char DLLFAR *bitmap;
		long address;
		char protocol;
	} wks;
}; /* end union */

struct domain_resp {
	struct domain_resp DLLFAR *next;	/* link to next domain_resp */
	char		DLLFAR *rr;		/* resources record name */
	unsigned	type;			/* response type */
	unsigned	class;			/* response class */
	long		ttl;			/* time to live */
	unsigned	len;			/* length of data */
	union data_tag	data;			/* response data */
}; /* end struct */

struct d_q {
	char			DLLFAR *name;	/* machine name to resolve */
	unsigned		q_type;		/* query type */
};

struct domain_q {
	int			nd;		/* network descriptor */
	struct addr		a;		/* IP address of server */
	int			id;		/* ID for this query */
	struct d_q DLLFAR * 	DLLFAR *nq;	/* ptr to array of queries */
	struct dm_hdr		DLLFAR *dmp;	/* domain query/reply buffer */
	int			dmp_len;	/* size of buffer for above */
	struct domain_resp 	DLLFAR *dr;	/* domain response list */
	time_t			timeout;	/* # of msec to wait */
#ifdef	MSW3
	unsigned long		basetime;	/* Windows' basetime of query */
#endif	/*MSW3*/
	unsigned		recurse : 1;	/* recursion flag */
	unsigned		inverse : 1;	/* inverse query flag */
	unsigned		partial : 1;	/* partial query flag */
#ifdef	MSW3
	unsigned 		class;		/* query class */
#endif	/*MSW3*/
}; /* end struct */

/* 4.3-style hostent structure definition */
#if 0
struct hostent {
	char *h_name;		/* official name of host */
	char **h_aliases;	/* alias name list */
	int h_addrtype;		/* address type */
	int h_length;		/* length (in bytes) of address */
	char **h_addr_list;	/* addr ptr to net addr for host */
#define h_addr h_addr_list[0];
};
#endif /*0*/

#ifdef	MSW3

/* Simplified name-to-address(es) and address-to-name(s) API.  Similar
   to the 4.3 BSD 'gethostbyname' and 'gethostbyaddr' calls, but interfaced
   to MS Windows and simplified for PC/TCP.  Only handles IP address types.
   As with the raw DNS API, all pointers are into the DLL's data space. */
/* Host name/address structure. */
struct whostent {
	char DLLFAR		*h_name;	/* official hostname */
	char DLLFAR		* DLLFAR *h_aliases;	/* alias list */
	in_name DLLFAR		*h_addrs;	/* host address list */
	struct domain_q DLLFAR	*h_dnsq;	/* underlying DNS query */
	unsigned char		h_ix;		/* RESERVED -- index */
	unsigned		h_any : 1;	/* RESERVED -- any replies? */
	unsigned		h_done : 1;	/* RESERVED -- complete? */
	int			h_errno;	/* RESERVED -- AS_ERROR */
};
/* shorthand for the network descriptor of the above structure */
#define h_basetime		h_dnsq->basetime
#define h_nd			h_dnsq->nd
#define h_timeout		h_dnsq->timeout
/* values of operation enablers for 'host_ad_query2' and 'host_nm_query2' */
#define HQ_DOMAIN		0x1	/* query DNS */
#define HQ_HTABLE		0x2	/* '*_htable' before DNS */
#define HQ_INVERSE		0x80	/* do "d.d.d.d" -> name mapping */

/* Formal declarations of DNS function entrypoints which are found in
   the PC/TCP DLL.  Defined is a macro (with the familiar name) and a
   prototype of the actual DLL entrypoint. */

#define alloc_domain_q(BFSIZ) \
	_alloc_domain_q(DOPEP, BFSIZ, -1)
struct domain_q DLLFAR * FAR _alloc_domain_q(DOPEPT, int, int);

#define	dns_query(DQ) \
	_dns_query(DOPEP, DQ)
int FAR _dns_query(DOPEPT, struct domain_q FAR *);

#define dns_rcv(DQ) \
	_dns_rcv(DOPEP, DQ)
int FAR _dns_rcv(DOPEPT, struct domain_q FAR *);

#define free_domain_q(DQ) \
	_free_domain_q(DOPEP, DQ)
int FAR _free_domain_q(DOPEPT, struct domain_q FAR *);

#define free_resp_list(DQ) \
	_free_resp_list(DOPEP, DQ)
int FAR _free_resp_list(DOPEPT, struct domain_q FAR *);

#define host_ad_query(IN, ND) \
	_host_ad_query(DOPEP, IN, ND)
struct whostent FAR * FAR _host_ad_query(DOPEPT, in_name, int);

#define host_ad_query2(IN, MASK, HOW, ND, FHPP) \
	_host_ad_query2(DOPEP, IN, MASK, HOW, ND, FHPP)
struct whostent FAR * FAR _host_ad_query2(DOPEPT, in_name, in_name, int, int
  , struct whostent FAR * FAR *);

#define host_adnm_rcv(HOSTP) \
	_host_adnm_rcv(DOPEP, HOSTP)
int FAR _host_adnm_rcv(DOPEPT, struct whostent FAR *);

#define host_free(HOSTP) \
	_host_free(DOPEP, HOSTP)
int FAR _host_free(DOPEPT, struct whostent FAR *);

#define host_nm_query(NAMEP, ND) \
	_host_nm_query(DOPEP, NAMEP, ND)
struct whostent FAR * FAR _host_nm_query(DOPEPT, char FAR *, int);

#define host_nm_query2(NAMEP, HOW, ND, FHPP) \
	_host_nm_query2(DOPEP, NAMEP, HOW, ND, FHPP)
struct whostent FAR * FAR _host_nm_query2(DOPEPT, char FAR *, int, int
  , struct whostent FAR * FAR *);

#else	/*MSW3*/

/* Prototypes for the library functions */
int dns_query(struct domain_q *);	/* send query to a server */
int dns_rcv(struct domain_q *);		/* rcv response from a server */
int free_resp_list(struct domain_q *);	/* free any responses */
int dns_print(struct domain_resp *);	/* Print resp to stdout */
int dns_h_print(struct dm_hdr *);	/* Print header to stdout */
struct domain_q *alloc_domain_q(int);	/* allocate a query struct */
int free_domain_q(struct domain_q *);	/* free the query structure */

/* This global contains the query-class the library will use: default is IN.
 */
extern unsbyte	dns_lib_class;

#endif	/*MSW3*/

/* eof */

/*
 * $Log:   J:\devkit.dos\vcs\include\pctcp\dns_lib.h_v  $
 * 
 *    Rev 1.11.1.2   16 Apr 1993 19:35:46   arnoff
 * fixed the prototypes for free_resp_list and the 2 print routines
 * to return int.
 * 
 *    Rev 1.11.1.1   08 Apr 1993 17:23:52   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.11   06 Nov 1992 09:08:36   paul
 * fixed arnoff's prototype for free_resp_list 
 * (return type void, rather than int)
 * 
 *    Rev 1.10   04 Nov 1992 14:00:16   arnoff
 *  * 04-Nov-92	Arnoff	prototype for free_domain_resp() (routine doesn't
 *  *			exist) changed to free_resp_list() (does exist).
 * 
 *    Rev 1.9   03 Feb 1992 23:26:24   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.8   30 Jan 1992 19:48:24   arnoff
 *  
 */


#endif /* __DNS_LIB_HEADER__ */

