/*
 * $Header:   K:\devkit.dos\vcs\include\pctcp\config.h_v   1.16.1.1   08 Apr 1993 17:23:32   arnoff  $
 */

#ifndef __CONFIG_HEADER__
#define __CONFIG_HEADER__



/*
 * CONFIG.H - Definitions and extern declarations for 2.1 tagged config system
 *
 * Copyright (C) 1991-1992 by FTP Software, Inc.  All rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 02-May-91	gub	Begin work: created from Squirt-O-Matic spec
 * 21-May-91	gub	Create mult_item struct for multiple value
 * 			 items, remove max field from conf_item
 * 05-Jun-91	gub	Add [tcp/udp]_maxconns
 * 16-Jun-91	gub	Add BAUDRATE, PORT (port should be changed)
 * 17-Jun-91	gub	#define ip_opt_len for backwards compatibility
 * 18-Jun-91	paul	add support for init code (make extern data far)
 * 19-Jun-91	gub	Add TAG_OPT_FLAGS, remove TAG_DEF_GATEWAY
 * 25-Jun-91    davec   Add TAG_USE_EMM
 * 27-Jun-91	gub	Add TAG_SM_PKT_SIZ in place of old DEF_GATEWAY (0x0D)
 * 01-Jul-91	gordon	Changed TAG defines to include a byte conversion
			 This cuts down on compile time warnings
 * 01-Jul-91	gordon	Removed TAG_DEVICE_ID, was 0x80
 * 21-Aug-91	gub	Add VxD-specific stuff and TAG_EOL (getting rid of
 *			 TFLAG_LAST)
 *			Add TAG_ODI_PKTS for Irina (internal only for now)
 * 23-Aug-91	paul	added flag values
 * 29-Aug-91	gub	Add TAG_OFFENDER to make copy protection bearable
 * 09-Sep-91	gub+	Add TAG_BSERVER for banyan helper program
 *		paul
 * 12-Sep-91	gub	Replace TAG_DEVICE_ID (shouldn't have been removed)
 *			Remove TAG_OFFENDER (no longer needed)
 * 18-Sep-91	gub	Add TAG_INFO_FLAGS to get interface information
 * 07-Nov-91	gordon	Changed all (byte) types to (unsbyte)
 * 05-Dec-91	gub	Merge in vitaly's ip security changes, add
 *			 TAG_IPSO_PORTS
 * 18-Dec-91	gub	Add TAG_IP_TTL
 * 19-Dec-91	gub	Add username and TAG_USERNAME
 * 23-Dec-91	gub	Add def_ip_ttl extern declaration
 * 15-Jan-92	davec	fixed prototype for Squirt_Item and Start Kernel
 * 12-Mar-92	davec&vitaly made use_emm based
 * 04-Jun-92	davec	Move prototype for Start_Kernel to kdefs.h
 * 19-Jun-92	gub	Add TAG_IP_MTU
 * 05-Aug-92	vitaly	Add TAG_VJCOMP
 * 03-Sep-92	gordon	Add TAG_IPCP_ESTATS and TAG_IPCP_PSTATS
 * 16-Sep-92	gordon	Add TAG_IPCP_LADDR and TAG_IPCP_RADDR
 * 29-Sep-92	snyders propagated changes from \include\config.h
 *			to \include\pctcp\config.h. These files must stat
 *			in sync until \include\config.h goes away.
 * 02-Oct-92	gordon	Add TAG_IPCP_TB_WRITE, TAG_IPCP_TB_CURSZ, 
 *			 TAG_IPCP_TB_READ, TAG_IPCP_TB_LRSZ, TAG_IPCP_TB_BUFP
 *			 for the IPCP trace mechanism
 * 06-Oct-92	wcl	Removed TAG_EOL, use TFLAG_LAST instead.
 * 20-Nov-92	vitaly	Add TAG_IPCP_PARAMS
 */


typedef struct {
    unsbyte tag;		/* Tag number */
    unsbyte flags;		/* Flags (see below) */
    byte size;		/* Size of datum */
    void *data;		/* Pointer to the actual data */
} conf_item;

typedef struct {
    unsbyte max;	/* How many we can handle */
    unsbyte num;	/* How many we've got */
    void *data;		/* Pointer to the actual stuff */
} mult_item;

#define	TFLAG_INITED	((unsbyte)0x01)	/* Tag has been initialized? */
#define TFLAG_LOCKED	((unsbyte)0x02)	/* Tag is unmodifiable? */
#define TFLAG_MULTI	((unsbyte)0x04)	/* Multiple values supported? */
#define TFLAG_LATCH	((unsbyte)0x10)	/* Lock after initialization */
#define TFLAG_REQUIRED	((unsbyte)0x20)	/* Necessary for kernel to start */
#define TFLAG_STRING	((unsbyte)0x40)	/* This is a string value */
#define TFLAG_LAST	((unsbyte)0x80)	/* Marker for last tag in array */

/* Kernel configuration values */

#define TAG_SMALL_PKTS	((unsbyte)0x01) /* # of small packets, (size = 2) */
#define TAG_LARGE_PKTS	((unsbyte)0x02) /* # of large packets, (size = 2) */
/* Sump'n for IP */
#define	TAG_TCPCONS	((unsbyte)0x04) /* # of TCP connects,  (size = 2) */
#define TAG_UDPCONS	((unsbyte)0x05) /* # of UDP connects,  (size = 2) */
#define TAG_DOMAIN	((unsbyte)0x07) /* Def domain <string>, */
					/* (size < DOMAIN_STRLEN) */
#define TAG_HOSTTABLE	((unsbyte)0x08) /* Host table <string>, */
					/* (size < HTABLE_STRLEN) */
#define TAG_DNS_SRVS	((unsbyte)0x09) /* Domain servers <IP addr array>, */
					/* (size <= MAX_DNS_SRVS * 4) */
#define TAG_DEF_WINDOW	((unsbyte)0x0A) /* Def TCP window size, (size = 2) */
#define TAG_DEF_LOWWIN	((unsbyte)0x0B) /* TCP low-water mark, (size = 2) */
#define TAG_IP_TOS	((unsbyte)0x0C) /* IP Type-of-service, (size = 1) */
#define TAG_SM_PKT_SIZ	((unsbyte)0x0D) /* Small buffer size,  (size = 2) */
#define TAG_IP_EXT_SEC	((unsbyte)0x0E) /* IP extended security, (size = 1) */
#define TAG_IP_BAS_SEC	((unsbyte)0x0F) /* IP basic security,	 (size = 1) */
#define	TAG_IP_OPTIONS	((unsbyte)0x10) /* IP options <byte array>, */
					/* (size <= IP_OPT_MAXLEN) */
#define TAG_DEBUG_FLAGS	((unsbyte)0x11) /* Debugging flags,	 (size = 2) */
#define TAG_OPT_FLAGS	((unsbyte)0x12) /* IP option flags,	 (size = 1) */
#define TAG_USE_EMM     ((unsbyte)0x13) /* Expanded mem toggle,  (size = 1) */
#define TAG_SERIAL_NUM	((unsbyte)0x14) /* Serial number,	 (size = 6) */
#define TAG_IPSO_PORTS	((unsbyte)0x15)	/* IP security ports */
					/* <struct opt_port array>, */
					/* (size <= MAX_PORT * 6) */
#define TAG_IP_TTL	((unsbyte)0x16) /* Default IP TTL,	 (size = 2) */
#define TAG_IP_MTU	((unsbyte)0x18)	/* IP MTU,		 (size = 2) */
#define TAG_ODI_PKTS	((unsbyte)0x1F) /* Packets to give ODI,  (size = 2) */
#define TAG_HOST_DS	((unsbyte)0x20) /* Host DS (for VxD),	 (size = 2) */
#define TAG_VxD_0	((unsbyte)0x21) /* VxD tag			    */
#define TAG_VxD_1	((unsbyte)0x22) /* VxD tag	reserved	    */
#define TAG_VxD_2	((unsbyte)0x23) /* VxD tag	reserved	    */
#define TAG_VxD_3	((unsbyte)0x24) /* VxD tag	reserved	    */
#define TAG_VxD_4	((unsbyte)0x25) /* VxD tag	reserved	    */
#define TAG_VxD_5	((unsbyte)0x26) /* VxD tag	reserved	    */
#define TAG_VxD_6	((unsbyte)0x27) /* VxD tag	reserved	    */
#define TAG_VxD_7	((unsbyte)0x28) /* VxD tag	reserved	    */
#define TAG_VxD_8	((unsbyte)0x29) /* VxD tag	reserved	    */
#define TAG_VxD_9	((unsbyte)0x2A) /* VxD tag	reserved	    */
#define TAG_VxD_A	((unsbyte)0x2B) /* VxD tag	reserved	    */
#define TAG_VxD_B	((unsbyte)0x2C) /* VxD tag	reserved	    */
#define TAG_VxD_C	((unsbyte)0x2D) /* VxD tag	reserved	    */
#define TAG_VxD_D	((unsbyte)0x2E) /* VxD tag	reserved	    */
#define TAG_VMID	((unsbyte)0x30)	/* Debugging */
#define	TAG_DNS_CMPS	((unsbyte)0x31) /* DNS completion list */
					/* <fixed len string array>, */
			/* (size <= COMP_DOMAIN_STRLEN * MAX_DNS_CMPS ) */

#define	TAG_RTT_MLT	((unsbyte)0x32)	/* TCP round-trip time multiplier */

/* Device specific values */
#define TAG_PER_DEV	((unsbyte)0x80)

#define TAG_DEVICE_ID	((unsbyte)0x80)	/* IF_INFO interface ID for card, */
					/* (size = 2) */
#define TAG_MAC_ADDR	((unsbyte)0x81)	/* MAC address for this interface */
#define TAG_IP_ADDR	((unsbyte)0x82)	/* This interface's IP address, */
					/* (size = 4) */
#define TAG_GATEWAY	((unsbyte)0x83)	/* Gateways, <IP addr array>, */
					/* (size <= MAX_DEF_GWS * 4) */
#define TAG_BCAST_ADDR	((unsbyte)0x84)	/* Broadcast address, (size = 4) */
#define TAG_SUBNET_MSK	((unsbyte)0x85)	/* Subnet mask, (size = 4) */
#define TAG_DEV_FLAGS	((unsbyte)0x86)	/* Flags <FL_ bits>, (size = 2) */
#define TAG_BSERVER	((unsbyte)0x87)	/* Banyan server programme,
					/* (size = 6) */
#define TAG_INFO_FLAGS	((unsbyte)0x88)	/* if_info flags <IFF_ bits>, */
					/* (size = 4) */
#define TAG_VJCOMP	((unsbyte)0x89)	/* VJ Compression config parameters */
 					/* size = sizeof(struct vj_config) */
#define	TAG_IPCP_LADDR	((unsbyte)0x8A)	/* IPCP layer local IP address */
 					/* size = sizeof(in_name) */
#define	TAG_IPCP_RADDR	((unsbyte)0x8B)	/* IPCP layer remote IP address */
 					/* size = sizeof(in_name) */

#define TAG_DRIVER_VER	((unsbyte)0x8F)	/* Driver version (not implemented) */

#define TAG_PKDRV_CLASS	((unsbyte)0x90)	/* Packet driver class (size = 2) */

/* Hardware configuration */
#define	TAG_INT_VEC	((unsbyte)0xA0)	/* HW interrupt vector, (size = 2) */
					/* or chain vector */
#define TAG_BASE_IO	((unsbyte)0xA1)	/* Base IO address, (size = 2) */
#define TAG_XMT_DMA	((unsbyte)0xA2)	/* Transmit dma channel, (size = 2) */
#define TAG_RCV_DMA	((unsbyte)0xA3)	/* Receive dma channel, (size = 2) */
#define TAG_MEMORY_BASE	((unsbyte)0xA4)	/* Base memory address, (size = 2) */
#define TAG_MEMORY_SIZE	((unsbyte)0xA5)	/* Shared memory size, (size = 2) */
#define TAG_ROM_ADDR	((unsbyte)0xA6)	/* On-board ROM addr, */
#define TAG_ROM_SIZE	((unsbyte)0xA7)
#define TAG_BAUDRATE	((unsbyte)0xA8)	/* Serial line speed, (size = 2)  */
#define TAG_PORT	((unsbyte)0xA9)	/* "Port" value (should be specific)*/
					/* (size = 2) */
/* Statistics */
#define TAG_IPCP_ESTATS	((unsbyte)0xB1)	/* IPCP event stats for PPPDRV */
#define TAG_IPCP_PSTATS	((unsbyte)0xB2)	/* IPCP packet stats for PPPDRV */
#define TAG_IPCP_PARAMS	((unsbyte)0xB3)	/* IPCP params for PPPDRV */

/* IPCP trace data, for PPP only */
#define TAG_IPCP_TB_READ  ((unsbyte)0xD0) /* IPCP trace buffer read ptr */
#define TAG_IPCP_TB_WRITE ((unsbyte)0xD1) /* IPCP trace buffer write ptr */
#define TAG_IPCP_TB_CURSZ ((unsbyte)0xD2) /* IPCP trace buf current size */
#define TAG_IPCP_TB_LRSZ  ((unsbyte)0xD3) /* IPCP trace buf last read size */
#define TAG_IPCP_TB_BUFP  ((unsbyte)0xD4) /* IPCP trace buffer itself */

/* Special statistics for particular boards */


/* all the flags in TAG_DEV_FLAGS */
#define	FL_DOWN		0x0001		/* interface is "turned off" */
#define	FL_RARP		0x0002		/* choose ip address via RARP */
#define	FL_ARP		0x0004		/* use ARP */
#define	FL_DMA		0x0008		/* use DMA */
#define	FL_NOSETIP	0x0010		/* user can't set IP address */
#define	FL_1822		0x0020		/* select 1822 */
#define	FL_X25standard	0x0040		/* select X.25 standard */
#define	FL_X25basic	0x0080		/* select X.25 basic */
#define	FL_DCE		0x0100		/* be DCE instead of DTE */
#define	FL_ADDR		0x0200		/* local net address is set */


/* ------------- DECLARATIONS FOR CONFIGURABLE GLOBALS ----------------- */

#define NUM_DEVICES 1		/* No multi-homed support yet */

#define MAX_DEF_GWS	3
#define MAX_CFG_GWS	4

#define IP_OPT_MAXLEN 40
#define ip_opt_len ip_opts.num	/* Backwards compatibility */

/* Internet Draft Oct.1991 IP Security Options: */

#define MAX_PORT     25          /* max number of ports */

#define IP_PREC_STRICT	((unsbyte)0x1)	/* Strict precedence checking */
#define IP_SEC_STRICT	((unsbyte)0x2)	/* Strict security checking */
#define IP_SEC_BAS	((unsbyte)0x4)	/* Basic (RFC 1038) security */
#define IP_SEC_EXT	((unsbyte)0x8)	/* Extended IP security */

#define MAX_DNS_SRVS	3
#define MAX_DNS_CMPS	3

#define DOMAIN_STRLEN	64
#define HTABLE_STRLEN	66

#define COMP_DOMAIN_STRLEN	32

#ifndef INIT
/* These live in the TSR, but need to be visible to the init */

extern unsword def_tcp_window;		/* Default tcp window size */
extern unsword def_tcp_lowwin;		/* Default tcp lowwindow */

extern unsword tcp_rtt_mlt;		/* TCP round-trip time multiplier */

extern unsbyte def_ip_tos;		/* Default ip TOS */

extern in_name 	 def_gateway[MAX_DEF_GWS];	/* Default gateway(s) */
extern mult_item def_gws;

extern unsbyte ip_opt_flag;		/* IP option flags */

extern unsbyte   ip_options[IP_OPT_MAXLEN];	/* IP options */
extern mult_item ip_opts;

extern int def_ip_ttl;

#define ip_opt_numports  opt_ports.num  /* number of ports */
extern struct   opt_port ip_opt_port[MAX_PORT]; 
extern mult_item opt_ports;

extern unsbyte ip_ext_security;
extern unsbyte ip_bas_security;

extern in_name   domain_servers[MAX_DNS_SRVS];	/* DNS servers */
extern mult_item domain_srvs;

/*
Completion domains
*/
extern unsbyte   completion_domains[MAX_DNS_CMPS][COMP_DOMAIN_STRLEN];
extern mult_item completion_dmns;

extern unsbyte def_domain[DOMAIN_STRLEN];

extern unsbyte hosttable[HTABLE_STRLEN];

extern unsigned NDEBUG;

extern in_name my_ip_addr;
extern in_name my_subnet_mask;
extern in_name ip_broadcast_addr;
extern unsigned my_device_id;

extern int tcp_maxconns;
extern int udp_maxconns;

extern conf_item kernel_conf[];

extern unsbyte use_emm;

extern long my_if_flags;

#else /* INIT */

extern unsword far def_tcp_window;		/* Default tcp window size */
extern unsword far def_tcp_lowwin;		/* Default tcp lowwindow */
extern unsbyte far def_ip_tos;		/* Default ip TOS */

extern in_name 	 far def_gateway[MAX_DEF_GWS];	/* Default gateway(s) */
extern mult_item far def_gws;

extern unsbyte far ip_opt_flag;		/* IP option flags */

extern unsbyte   far ip_options[IP_OPT_MAXLEN];	/* IP options */
extern mult_item far ip_opts;

extern int far def_ip_ttl;

#define ip_opt_numports  opt_ports.num  /* number of ports */
extern struct   opt_port far ip_opt_port[MAX_PORT]; 
extern mult_item far opt_ports;

extern unsbyte far ip_ext_security;
extern unsbyte far ip_bas_security;

extern in_name   far domain_servers[MAX_DNS_SRVS];	/* DNS servers */
extern mult_item far domain_srvs;

/*
Completion domains
*/
extern unsbyte far   completion_domains[MAX_DNS_CMPS][COMP_DOMAIN_STRLEN];
extern mult_item far completion_dmns;

extern unsbyte far def_domain[DOMAIN_STRLEN];

extern unsbyte far hosttable[HTABLE_STRLEN];

extern unsigned far NDEBUG;

extern in_name far my_ip_addr;
extern in_name far my_subnet_mask;
extern in_name far ip_broadcast_addr;
extern unsigned far my_device_id;

extern int far tcp_maxconns;
extern int far udp_maxconns;

extern conf_item far kernel_conf[];

extern _segment far kernel_ds_i;
extern unsbyte _based((_segment)kernel_ds_i) use_emm;

extern long far my_if_flags;

#endif /* INIT */

extern int Squirt_Item(unsbyte, byte, int, void far *);
/* moved prototype for Start_Kernel to kdefs.h */
/* extern int Start_Kernel(int *); */

/*
 * $Log:   K:\devkit.dos\vcs\include\pctcp\config.h_v  $
 * 
 *    Rev 1.16.1.1   08 Apr 1993 17:23:32   arnoff
 * Protected from multiple includes.
 * 
 *    Rev 1.16   14 Dec 1992 11:24:48   vitaly
 *  * 20-Nov-92	vitaly	Add TAG_IPCP_PARAMS
 * 
 * 
 *    Rev 1.15   19 Nov 1992 17:53:14   bill
 * Added TAG_RTT_MLT
 * 
 *    Rev 1.14   12 Nov 1992 12:44:08   snyders
 * Removed tags that are not implemented.  Removed unused structures
 * related to those tags. Improved/corrected comments on tags.
 * 
 *    Rev 1.13   09 Oct 1992 12:59:08   bill
 * Copied from include directory, so that changes made there are
 * propagated.
 * 
 *    Rev 1.23   09 Oct 1992 12:52:20   bill
 * No change.
 * 
 *    Rev 1.22   08 Oct 1992 12:24:18   bill
 * Removed references to hostname, username, UNAME_STRLEN, and HNAME_STRLEN;
 * Added COMP_DOMAIN_STRLEN
 * 
 *    Rev 1.21   07 Oct 1992 16:40:14   bill
 * Removed TAG_HOSTNAME, TAG_USERNAME, and TFLAG_PER_CON.
 * 
 *    Rev 1.20   07 Oct 1992 16:31:54   bill
 * Removed TAG_EOL; use TFLAG_LAST instead.
 * 
 *    Rev 1.19   02 Oct 1992 15:15:24   gordon
 * Added tags for the IPCP trace mechanism
 * 
 *    Rev 1.18   29 Sep 1992 15:09:14   snyders
 * propagated changes from \include\config.h to \include\pctcp\config.h
 * These files must stay in sync until \include\config.h goes away.
 * 
 *    Rev 1.17   16 Sep 1992 13:28:06   gordon
 * Added TAG_IPCP_LADDR and TAG_IPCP_RADDR
 * 
 *    Rev 1.16   11 Sep 1992 08:14:46   gordon
 * Added tags for the IPCP statistics structures
 * 
 *    Rev 1.15   25 Aug 1992 12:46:22   bill
 * Added DNS search list entries and TAGs
 * 
 *    Rev 1.14   13 Aug 1992 17:13:38   bill
 * Removed "init_router"
 * 
 *    Rev 1.13   13 Aug 1992 17:07:28   bill
 * Added "extern int init_router"
 * 
 *    Rev 1.12   10 Aug 1992 17:41:10   vitaly
 *  * 05-Aug-92	vitaly	Add TAG_VJCOMP
 * 
 * 
 *    Rev 1.11   14 Jul 1992 20:34:04   bill
 * Added MAX_CFG_GW
 * 
 *    Rev 1.10   22 Jun 1992 16:31:50   paul
 * track changes from 2.1
 * 
 *    Rev 1.11   21 Jun 1992 23:49:50   arnoff
 * gub	Add TAG_IP_MTU
 * 
 *    Rev 1.10   18 Jun 1992 20:12:12   arnoff
 * davec	Move prototype for Start_Kernel to kdefs.h
 * 
 *    Rev 1.9   12 Mar 1992 17:24:24   arnoff
 * davec&vitaly made use_emm based
 * 
 *    Rev 1.8   30 Jan 1992 08:23:02   arnoff
 *  
 */


#endif /* __CONFIG_HEADER__ */

