/*
 * $Header:   K:\devkit.dos\vcs\include\netinet\in.h_v   1.3.1.0   08 Apr 1993 17:14:00   arnoff  $
 */

#ifndef __IN_HEADER__
#define __IN_HEADER__



/* Constants and structures for the Internet system.
 *
 *	INCLUDE/NETINET/IN.H
 *
 * Copyright (C) 1987,1988 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 25-Apr-88	jbvb	Add IPPORT_RESERVED, rename filler to match 4BSD.
 * 29-Jun-89	dab	Fixed typo where htons() was declared twice and
 *			ntohs() was omitted.
 * 07-Nov-91	paul	added parameters to function prototypes
 */

/* Protocols
*/
#define	IPPROTO_ICMP	1	/* IP control message protocol */
#define	IPPROTO_TCP	6	/* Transmission control protocol */
#define	IPPROTO_UDP	17	/* User datagram protocol */

#define	IPPROTO_RAW	255	/* Raw IP packets */
#define	IPPROTO_MAX	256

#define	IPPORT_RESERVED	1024	/* BSD believes (port < 1024) == secure */

/* Internet Address structure
*/
struct in_addr {
    union {
	struct { u_char	 s_b1, s_b2, s_b3, s_b4; }	S_un_b;
	struct { u_short s_w1, s_w2; }			S_un_w;
	u_long S_addr;
    } S_un;
#define s_addr	S_un.S_addr
#define	s_net	S_un.S_un_b.s_b1
#define	s_host	S_un.S_un_b.s_b2
#define	s_lh	S_un.S_un_b.s_b3
#define	s_impno	S_un.S_un_b.s_b4
#define	s_imp	S_un.S_un_w.s_w2
};

#define	INADDR_ANY		0x00000000L
#define	INADDR_BROADCAST	0xFFFFFFFFL

struct sockaddr_in {
    short		sin_family;
    u_short		sin_port;
    struct in_addr	sin_addr;
    char		sin_zero[8];
};

#ifndef	_NTOHL
#define	_NTOHL
u_long	htonl(u_long), ntohl(u_long);
u_short	htons(u_short), ntohs(u_short);
#endif

#include <4bsddefs.h>

/*
 * $Log:   K:\devkit.dos\vcs\include\netinet\in.h_v  $
 * 
 *    Rev 1.3.1.0   08 Apr 1993 17:14:00   arnoff
 * Protected against multiple includes.
 * 
 *    Rev 1.3   24 Feb 1992 17:49:54   arnoff
 * correct in.h path
 * 
 *    Rev 1.2   03 Feb 1992 23:27:52   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.1   30 Jan 1992 19:50:00   arnoff
 *  
 */


#endif /* __IN_HEADER__ */

