/*
 * $Header:   J:/22vcs/include/4bsddefs.h_v   1.13   04 Oct 1992 12:49:22   rcq  $
 */

/*
 * 4BSDDEFS.H - Definitions for PC/TCP SOCKET emulation library routines.
 *
 * Copyright (C) 1986-1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 30-Oct-87	jbvb	Fix definition of select(), per HGM and HP.
 * 07-Jan-88	jbvb	Correct invocation of memset() in bzero().
 * 21-Jan-88	jbvb	Add definition of sleep(3)
 * 23 AUG 89	stev	add #define for SOCKETS and _BSDDEFS_
 * 25 OCT 89	stev	copied unix.h (signal stuff) into here
 * 22 NOV 89	stev	fixed signal #define to not require signal.h
 *			to be loaded if your not using signal()
 * 26 NOV 89	stev	added more signals (found in UTBIND)
 * 13-Dec-89	jbvb	Flush TRUE/FALSE definitions, fix R_OK & W_OK.
 * 21MAR90	stev	added sys/types.h, should be OK
 * 31-Jan-91	wcl	Prototyped bsd_close()
 * 28-Aug-91	gakio	Added FAR declarations in function arguments for Win3
 * 19-Sep-91	gakio	Replaced memcpy() with _fmemcpy() for Windows.
 * 04-Sep-91	Ben	Added prototypes for get/setdomainname() and bsd_write
 * 18-Sep-91	clennox	prototyped bsd_read()
 * 13-Nov-91	gakio	prototyped bsd_errno()
 * 25-Feb-92	paul	rearranged status flag definitions slightly
 *			moved ITIMER_TIMEOUT_VALUE, int_routine to recv.c
 * 23-Sep-92	rcq	sleep() prototype removed if TURBOC (they have one)
 *			changed ioctl() prototype to bsd_ioctl() and made it
 *			match Borland's; added macro for ioctl()->bsd_ioctl()
 * 01-Oct-92	rcq	changed bsd_write() & bsd_read() prototype so 2nd
 *			parm is void* not char* and 3rd is unsigned not int
 * 04-Oct-92	rcq	changed ioctl->bsd_ioctl macro (eliminated parms)
 */

#ifndef _BSDDEFS_	/* protect against #include twice		*/
#define _BSDDEFS_	

/* In the MS Windows WinApp environment, various pointers are DLLFAR and
   the location of the structures allocated by these calls is within the
   DLL itself.  Also, simplified access is provided via 'host_nm_query'
   and 'host_ad_query'.

   NOTE: When used in the MS Windows environment, this header MUST be
   included AFTER "pctcp/winapp.h". */

#ifndef MSW3
#define DLLFAR
#endif /* MSW3 */

#define SOCKETS

/* the following include file should be protected from multiple includes*/
#include <sys/types.h>	/* to get fd_set				*/
int DLLFAR	accept(int, struct sockaddr DLLFAR *, int DLLFAR *);
int DLLFAR	bind(int, struct sockaddr DLLFAR *, int);
void DLLFAR	closelog(void);
int DLLFAR	connect(int, struct sockaddr DLLFAR *, int);
int DLLFAR	fcntl(int, int, int);
long DLLFAR	gethostid(void), DLLFAR sethostid(long);
int DLLFAR	gethostname(char DLLFAR *, int), DLLFAR sethostname(char DLLFAR *, int);
int DLLFAR	getdomainname(char DLLFAR *, int), DLLFAR setdomainname(char DLLFAR *, int);
int DLLFAR	getpeername(int, struct sockaddr DLLFAR *, int DLLFAR *);
int DLLFAR	getsockname(int, struct sockaddr DLLFAR *, int DLLFAR *);
int DLLFAR	getsockopt(int, int, int, char DLLFAR *, int DLLFAR *);
int DLLFAR	setsockopt(int, int, int, char DLLFAR *, int);
int DLLFAR	bsd_ioctl(int, int, ...);
int DLLFAR	listen(int, int);
void DLLFAR	openlog(char DLLFAR *, int, int);
int DLLFAR	recv(int, char DLLFAR *, int, int);	/* flags should be long? */
int DLLFAR	recvfrom(int, char DLLFAR *, int, int, struct sockaddr DLLFAR *, int DLLFAR *);
int DLLFAR	select(int, fd_set DLLFAR *, fd_set DLLFAR *, fd_set DLLFAR *, struct timeval DLLFAR *);
int DLLFAR	send(int, char DLLFAR *, int, int);	/* flags should be long? */
int DLLFAR	sendto(int, char DLLFAR *, int, int, struct sockaddr DLLFAR *, int);
void DLLFAR	setlogmask(int);
void DLLFAR	syslog(int, char DLLFAR *, ...);
int DLLFAR	shutdown(int, int);
int DLLFAR	socket(int, int, int);
int DLLFAR	bsd_close(int);
int DLLFAR	bsd_read(int, void DLLFAR *, unsigned);
int DLLFAR	bsd_write(int,void DLLFAR *, unsigned);
int DLLFAR	bsd_close(int);
int DLLFAR * DLLFAR _bsd_errno(void);

#ifndef __TURBOC__
/* Borland has sleep() in their runtime library, Microsoft does not
   (so we have one in our MSC Sockets Library, in the BCC version) */
int DLLFAR	sleep(unsigned);
#endif

#ifndef	FTP_4BSD
#define	FTP_4BSD
#define	read(a,b,c)	bsd_read(a,b,c)
#define	write(a,b,c)	bsd_write(a,b,c)
#define	close(a)	bsd_close(a)

/* Unfortunately ioctl() takes variable # parms, so not so clean as others */
#define ioctl		bsd_ioctl

#include <string.h>	/* prototypes for memcpy, memcmp, memset */
#ifdef MSW3 /* for Windows */
#define	bcopy(a,b,c)	_fmemcpy(b,a,c)
#else
#define	bcopy(a,b,c)	memcpy(b,a,c)
#endif /* for Windows */

#define	bcmp(a,b,c)	memcmp(a,b,c)
#define	bzero(a,b)	memset(a,0,b)
#endif /*FTP_4BSD*/


/* for MSC 5.1 signal() routine						*/

/* the following assumes that signal.h will be loaded if you are using	*/
/* signal(). if you have other BSD only signals defined, you need to add*/
/* them below, and add them to the first part of the switch statement,	*/
/* so they are ignored.							*/

extern int (*int_routine)();	  

#define SIGALRM	99		/* used to hear packet timeouts		*/
#define SIGHUP	98		/* restart (choose another signal?)	*/
#define SIGPIPE	97		/* error on pipe			*/
#define SIGWINCH 96		/* window change (no, really)		*/
#define SIGIO	95		/* i/o pending for read			*/
#define SIGCHLD	94		/* error in child process		*/
#define SIGCLD	SIGCHLD		/* SYSV uses diffrent name (thanx, guys)*/
#define SIGSYS	93		/* system error				*/
#define SIGQUIT	92		/* bail out				*/
#define SIGIOT	91		/* IOT instruction(makes sense on VAXEN)*/
#define SIGEMT	90		/* EMT instruction (as above)		*/

#define signal(sig,function)  \
	switch (sig)  {\
	    case(SIGHUP):\
	    case(SIGPIPE):\
	    case(SIGWINCH):\
	    case(SIGIO):\
	    case(SIGCHLD):\
	    case(SIGSYS):\
	    case(SIGQUIT):\
	    case(SIGIOT):\
	    case(SIGEMT):\
		break;\
	    case(SIGALRM):\
		int_routine = function;\
		break;\
	    default:\
		signal(sig,function);\
		break;\
	    }

/* and the following assume MSC's sys\stat.h has been loaded		*/

#ifndef S_IFMT
#define S_IFMT      0170000         /* file type mask 			*/
#define S_IFDIR     0040000         /* directory 			*/
#define S_IFCHR     0020000         /* character special 		*/
#define S_IFREG     0100000         /* regular 				*/
#define S_IEXEC     0000100         /* execute/search permission, owner */
#endif /*S_IFMT*/

/* R_OK and W_OK are not in MSC's or TC's sys/stat.h (they both have S_IREAD
 * and S_IWRITE).  I suspect that R_OK and W_OK are obsolete, but I have no
 * idea who might be depending on them, so I'll leave them in.
 */
#ifndef R_OK
#define R_OK	          4	    /* read permission, owner 		*/
#define W_OK		  2	    /* write permission, owner 		*/
#endif /*R_OK*/
	
/*
itimerval stuff (from sys\time.h). i also include time.h incase it hasnt
been included (this is safe to do)
*/

#include <sys/time.h>			/* struct timeval		*/

struct itimerval {
	struct timeval it_interval;	/* timer interval 		*/
	struct timeval it_value;	/* current value		*/
	};
    
#define ITIMER_REAL	0		/* the setitimer() call will 	*/
#define ITIMER_VIRTUAL	1		/* these things, but never use	*/
#define ITIMER_PROF	2		/* them (no signals in dos)	*/

extern u_long ITIMER_TIMEOUT_VALUE;

#define setitimer(which,value,ovalue) \
	ITIMER_TIMEOUT_VALUE = *value.it_value.tv_sec


#endif /*BSDDEFS*/

/*
 * $Log:   J:/22vcs/include/4bsddefs.h_v  $
 * 
 *    Rev 1.13   04 Oct 1992 12:49:22   rcq
 * changed ioctl->bsd_ioctl macro (eliminated parms)
 * 
 *    Rev 1.12   02 Oct 1992 19:27:42   rcq
 *  * 23-Sep-92	rcq	sleep() prototype removed if TURBOC (they have one)
 *  *			changed ioctl() prototype to bsd_ioctl() and made it
 *  *			match Borland's; added macro for ioctl()->bsd_ioctl()
 *  * 01-10-92	rcq	changed bsd_write() & bsd_read() prototype so 2nd
 *  *			parm is void* not char* and 3rd is unsigned not int
 * 
 *    Rev 1.11   17 Jun 1992 14:03:56   paul
 * added void parameter to gethostid prototype
 * 
 *    Rev 1.10   12 Apr 1992 21:14:58   arnoff
 * Rearranged status flag definitions slightly (separated R_OK, W_OK from S_I*).
 * Moved variables ITIMER_TIMEOUT_VALUE, int_routine to srclib/socket/recv.c.
 * 
 *    Rev 1.9   16 Feb 1992 14:48:16   arnoff
 * removed //
 * 
 *    Rev 1.8   30 Jan 1992 08:22:22   arnoff
 *  
 */
