/*
 * $Header:   H:/22vcs/srclib/socket/4bsd.h_v   1.3   14 Sep 1992 17:15:12   paul  $
 */

/*
 * 4BSD.H - Internal socket library definitions.
 *
 * Copyright (C) 1986,1987,1991 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 18-Dec-87	jbvb	Explain some of Philip's lossage for posterity...
 * 03-Aug-89	jbvb	Add ST_LISTEN_ERR, indicating bsd_relisten() failed.
 * 27 OCT 89 	stev	change MAXSOCK from 32 to 20.
 * 13-May-92	paul	removed NO_EXT_SYM condition (always true)
 * 17-AUG-92	rcq	changed dreturn macro so ';' after printf not ','
 */

/* Include if you are building the library routines. */

#define	bomb(x)		{ errno = x; return -1; }

#define	SADDR(p)		((ADDR *) &((p)->fhost))
#define	STATE(p)		((p)->state & SI_MASK)
#define	SOPTIONS(p)		((p)->options)
#define	SFLAGS(p)		((p)->flags)
#define	NSOCK(s)		(sock[s])

/* maximum number of incoming connections per socket */
#define	MAXLISTEN		5
#define	MAXSOCK			20

#define	SI_MASK			0xff
#define	SI_OPEN			0x01
#define	SI_BOUND		0x02
#define	SI_LISTENING		0x04
#define	SI_CONNECTED		0x08
#define	SI_CAN_SEND		0x10
#define	SI_CAN_RECV		0x20
#define	SI_LISTEN_ERR		0x40

typedef	struct addr	ADDR;

typedef	struct conn_t {
	struct conn_t	*next;
	long		lhost;
	long		fhost;
	u_short		fsocket;
	u_short		lsocket;
	u_char		protocol;
	u_char		l_intrvl;	/* Interval for SO_LINGER */
	short		nd;
} NCONN;

/*
 * This is the socket structure.  Why it uses long pointers to struct addr
 * instead of the struct addr itself is a mystery to me.  Maybe Philip
 * just *liked* to fragment memory...
 */
typedef struct sock_t {
	short		cd;
	short		nd;
	short		state;
	short		flags;
	short		options;
	char		af;
	char		type;
	long		lhost;		/* Actually used as "struct addr *" */
	long		fhost;		/* Actually used as "struct addr *" */
	u_short		fsocket;
	u_short		lsocket;
	u_char		protocol;
	u_char		l_intrvl;	/* Linger interval (sec) */
	short		max_q_len;
	short		cur_q_len;
	NCONN		*nconn_q;
} SOCKET;

extern long		myaddr;
extern SOCKET		*sock[];

#ifdef DEBUG
#define	dreturn(s, r)	printf(s); return (r)
#else
#define	dreturn(s, r)	return (r)
#endif



/*
 * $Log:   H:/22vcs/srclib/socket/4bsd.h_v  $
 * 
 *    Rev 1.3   14 Sep 1992 17:15:12   paul
 *  * 17-AUG-92	rcq	changed dreturn macro so ';' after printf not ','
 * 
 *    Rev 1.2   13 May 1992 14:26:18   paul
 * removed NO_EXT_SYM condition (always true)
 * 
 *    Rev 1.1   30 Jan 1992 00:50:40   arnoff
 *  
 */
