C     @(#)fabricat.for	5.1 as of 3/19/93 15:33:27

      INCLUDE 'usercode.fi'

      SUBROUTINE USRSET

C     Establish options for USERGET fabricate.

C     Commons
      INCLUDE 'cmnset.for'

C     Generate up to 128 variables
      MXNEWV = 128

C     Utilize SPSS lexical analysis
      QSTACK = .TRUE.

      END

      SUBROUTINE USRGET(WRKSPC,NDBLES)

C     Primary entry for USERGET fabricate.  It partitions the
C     workspace into 3 vectors of type OBSTYPE and 1 of LOGICAL.

C     Arguments
      DOUBLE PRECISION WRKSPC(*)
      INTEGER NDBLES

C     Commons
      INCLUDE 'cmnusr.for'

C     Local variables
C     IXHIV    Workspace index of high value vector
            INTEGER IXHIV
C     IXLOV    Workspace index of low value vector
            INTEGER IXLOV
C     IXOBS    Workspace index of observation vector
            INTEGER IXOBS
C     IXQNOM   Workspace index of nominal value switches
            INTEGER IXQNOM
C     MAXNEW   Maximum new variables permitted in workspace
            INTEGER MAXNEW
C     NNEW     Number of variables to generate
            INTEGER NNEW
C     OKPARS   Returns .TRUE. parsing successful
            LOGICAL OKPARS
            EXTERNAL OKPARS

C     Partition the workspace insuring alignment
      MAXNEW = (8*NDBLES)/(8+8+8+4)
      MAXNEW = MIN(128,(8*MAXNEW)/8)
      IXOBS = 1
      IXLOV = IXOBS+MAXNEW
      IXHIV = IXLOV+MAXNEW
      IXQNOM = IXHIV+MAXNEW

C     Parse the command
      IF (OKPARS(WRKSPC(IXLOV),WRKSPC(IXHIV),WRKSPC(IXQNOM),
     +   MAXNEW,NNEW) .AND. .NOT. QFATAL .AND. .NOT. QEDIT) THEN

C        Generate the data values
         CALL GENVAL(WRKSPC(IXOBS),WRKSPC(IXLOV),WRKSPC(IXHIV),
     +      WRKSPC(IXQNOM),NNEW)
      ENDIF

      END

      LOGICAL FUNCTION OKPARS(LOVAL,HIVAL,QNOM,MAXNEW,NNEW)

C     Parse the FABRICATE command.
C
C     Syntax:
C        USERGET NAME=FABRICATE <new var> [<label>] (<lo> <hi> [D])/
C           <new var>...

C     Arguments
C     LOVAL    Returned as lower value limits
            DOUBLE PRECISION LOVAL(*)
C     HIVAL    Returned as upper value limits
            DOUBLE PRECISION HIVAL(*)
C     QNOM     Returned set to nominal variables ("D" specified)
            LOGICAL QNOM(*)
C     MAXNEW   Maximum new variables
            INTEGER MAXNEW
C     NNEW     Returned as number of new variables
            INTEGER NNEW

C     Commons and parameters
      INCLUDE 'cmnusr.for'
      INCLUDE 'cmnpar.for'
      INCLUDE 'usercode.fd'

C     Local variables
C     FMTWID   Field width
            INTEGER FMTWID
C     NEWNAM   Name of new variable
            CHARACTER*8 NEWNAM
C     NEWVAR   Index of new variable
            INTEGER NEWVAR
C     QBDMFT   Set if problem defining formats
            LOGICAL QBDFMT
C     QERR     Set if an error is detected
            LOGICAL QERR
C     VARSYN   Syntactic type of variable name
            INTEGER VARSYN

C     Initialize
      QERR = .FALSE.
      NNEW = 0

C     Obtain first token - we're expecting a name
      CALL USNEXT

C     Skip any initial slash
      IF (QSPECL .AND. QSLASH) THEN
         CALL USNEXT
      ENDIF

C     Loop until end of command or an error
 1000 IF (.NOT. QERR .AND. .NOT. QEOCMD) THEN

C        Check for too many new variables
         QERR = NNEW .GE. MAXNEW
         IF (QERR) THEN
            CALL UERROR(13611,ERDICC,ERSERS)
         ELSE

C           Validate new variable name
            CALL UVARCK(SYLNCH,SYCHRP,VARSYN)
            QERR = .NOT. QNAME .OR. VARSYN .NE. 0
            IF (.NOT. QERR) THEN
               NEWNAM = SYCHRP(1:8)
               CALL UDICSC(NEWVAR,NEWNAM)
               QERR = NEWVAR .NE. 0
            ENDIF
            IF (QERR) THEN
               CALL UERROR(13681,ERDISYM,ERSERS)
            ELSE

C              Attempt to add new variable to the dictionary
               NNEW = NNEW+1
               CALL UNEWVR(NEWNAM,0,NEWVAR,QERR)
               IF (.NOT. QERR) THEN

C                 Look for optional variable label
                  CALL USNEXT
                  IF (QLITRL) THEN
                     CALL UNEWLB(NEWVAR,SYCHRP,MIN(120,SYLNCH))
                     CALL USNEXT
                  ENDIF

C                 Look for parenthesized value range
                  QERR = .NOT. QLPAR
                  IF (.NOT. QERR) THEN
                     CALL USNEXT
                     QERR = .NOT. QNUMB
                     LOVAL(NNEW) = SYINRP
                  ENDIF
                  IF (.NOT. QERR) THEN
                     CALL USNEXT
                     QERR = .NOT. QNUMB
                     HIVAL(NNEW) = SYINRP
                     QERR = QERR .OR. HIVAL(NNEW) .LE. LOVAL(NNEW)
                  ENDIF
                  IF (.NOT. QERR) THEN
                     CALL USNEXT

C                    Look for optional "D" for "discrete"
                     QNOM(NNEW) = QNAME .AND. SYCHRP .EQ. 'D'
                     IF (QNOM(NNEW)) THEN
                        LOVAL(NNEW) = DINT(LOVAL(NNEW))
                        HIVAL(NNEW) = DINT(HIVAL(NNEW))
                        HIVAL(NNEW) = HIVAL(NNEW)+0.9999
                        FMTWID = IDINT(LOG10(MAX(ABS(LOVAL(NNEW)),
     +                     ABS(HIVAL(NNEW)))))+1
                        IF (LOVAL(NNEW) .LT. 0.D0) THEN
                           FMTWID = FMTWID+1
                        ENDIF
                        CALL UNEWFM(NEWVAR,FMCF,FMTWID,0,
     +                     FMCF,FMTWID,0,QBDFMT)
                        CALL USNEXT
                     ENDIF
                     QERR = .NOT. QRPAR
                  ENDIF
                  IF (QERR) THEN
                     CALL UERROR(13627,ERDISYM,ERSERS)
                  ELSE

C                    Get to next new name skipping any slash
                     CALL USNEXT
                     IF (QSPECL .AND. QSLASH) THEN
                        CALL USNEXT
                     ENDIF
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
         GOTO 1000
      ENDIF

      OKPARS = .NOT. QERR

      END

      SUBROUTINE GENVAL(OBS,LOVAL,HIVAL,QNOM,NNEW)

C     Generate the data values for USERGET fabricate.  We simply
C     generate random numbers in the range specified and write a
C     case at a time to the working data file by calling UOBADD.

C     Arguments
C     OBS      The observation vector
            DOUBLE PRECISION OBS(*)
C     LOVAL    Low value for each variable
            DOUBLE PRECISION LOVAL(*)
C     HIVAL    High value for each variable
            DOUBLE PRECISION HIVAL(*)
C     QNOM     Set for variables which are to have nominal values
            LOGICAL QNOM(*)
C     NNEW     Number of variables to generate
            INTEGER NNEW

C     Local variables
C     IOBS     Index of the observations
            INTEGER IOBS
C     IV       Index of the variables
            INTEGER IV
C     RANVAL   Random number uniformly distributed from 0 to 1
            REAL*4 RANVAL

C     Loop thru the observations
      DO 3000 IOBS = 1,500

C        Loop thru the variables
         DO 2000 IV = 1,NNEW

C           Generate an appropriate value
            CALL RANDOM(RANVAL)
            OBS(IV) = LOVAL(IV)+(HIVAL(IV)-LOVAL(IV))*DBLE(RANVAL)
            IF (QNOM(IV)) THEN
               OBS(IV) = DINT(OBS(IV))
            ENDIF
 2000    CONTINUE

C        Write out the observation vector for this case
         CALL UOBADD(OBS,NNEW)
 3000 CONTINUE

      END
