/*  @(#)cmnusr.h	5.1 as of 3/19/93 15:33:24  */

/*
 * This structure parallels the global FORTRAN common block CMNUSR
 *
 * USAGE:
 * 
 *   #include "usercode.h"
 *   #include "cmnusr.h"
 *   ...
 *   ...  CmnUsr->...
 *
 *   SPSS Userproc initialization sets the pointer CmnUsr
 *   to point to the common block CMNUSR.
 *
 * MODIFICATIONS:
 *   12 Sep 89 - cbh - Original version in support of release 4.0
 *   19 Feb 93 - Tex - Revisions for release 5.0
 *   26 Feb 93 - Tex - Add CmaUsr for character variables
 *   05 Mar 93 - Tex - Clean up the comments
 *   14 Mar 93 - Tex - Declare syinrp as LR rather than as OBS
 */

struct CmnUsr_map {
    OBS caswgt;                 /* Weight for current case */
    OBS dimval[3];              /* Missing values */
    LR syinrp;                  /* Current token as a number */
    OBS sysmis;                 /* System missing value */
    INTEGER dinmv;              /* Number of missing values */
    INTEGER dipfmt;             /* Encoded print format */
    INTEGER ditype;             /* Type of current var - 0 for num */
    INTEGER diwfmt;             /* Encoded write format */
    INTEGER iousr2;             /* Available logical unit */
    INTEGER iousr3;             /* Available logical unit */
    INTEGER iousr4;             /* Available logical unit */
    INTEGER ipage;              /* Page number */
    INTEGER kobsln;             /* Length of observation vector */
    INTEGER line;               /* Lines remaining on current page */
    INTEGER linemx;             /* Maximum lines per page */
    INTEGER linwid;             /* Page width */
    INTEGER sylnch;             /* Length of token in characters */
    INTEGER syopcd;             /* Code for special chararacter */
    INTEGER sytype;             /* Type of current token */
    LOGICAL qedit;              /* Set if this is an "edit" run */
    LOGICAL qfatal;             /* Set if fatal error occurred */
    LOGICAL qfinal;             /* Set before calling upinit */
    LOGICAL qfinf;              /* Set by uread at end of data */
    LOGICAL qfing;              /* Set at end of splitfile */
};

struct CmaUsr_map {
    char boxstr[12];            /* Box characters */
    char diname[8];             /* Name of current variable */
    char sychrp[255];           /* Current token */
};

extern struct CmnUsr_map *CmnUsr;
extern struct CmaUsr_map *CmaUsr;
