/*  @(#)cmnpar.h	5.1 as of 3/19/93 15:33:19  */

/*
 * This structure parallels the global FORTRAN common block CMNPAR
 *
 * USAGE:
 * 
 *   #include "usercode.h"
 *   #include "cmnpar.h"
 *   ...
 *   ...  CmnPar->...
 *
 *   SPSS Userproc initialization sets the pointer CmnPar
 *   to point to the common block CMNPAR.
 *
 * MODIFICATIONS:
 *   12 Sep 89 - cbh - Original version in support of release 4.0
 *   19 Feb 93 - Tex - Modifications for release 5.0
 *   26 Feb 93 - Tex - Drop QRSVD
 *   05 Mar 93 - Tex - Clean up comments
 */

struct CmnPar_map {
    LOGICAL qlt;                /* Token is LT or < */
    LOGICAL qgt;                /* Token is GT or > */
    LOGICAL qeq;                /* Token is EQ or = */
    LOGICAL qle;                /* Token is LE or <= */
    LOGICAL qge;                /* Token is GE or >= */
    LOGICAL qne;                /* Token is NE or ~= or <> */
    LOGICAL qnot;               /* Token is ~ */
    LOGICAL qplus;              /* Token is + */
    LOGICAL qdash;              /* Token is - */
    LOGICAL qstar;              /* Token is * */
    LOGICAL qslash;             /* Token is / */
    LOGICAL q2star;             /* Token is ** */
    LOGICAL qlpar;              /* Token is ( */
    LOGICAL qrpar;              /* Token is ) */
    LOGICAL qcomma;             /* Token is , */
    LOGICAL qcolon;             /* Token is : */
    LOGICAL qsemic;             /* Token is ; */
    LOGICAL qdot;               /* Token is . */
    LOGICAL qeocmd;             /* Token is end of command */
    LOGICAL qchar;              /* Token is a character string */
    LOGICAL qnumb;              /* Token is a number */
    LOGICAL qname;              /* Token is a non-reserved name */
    LOGICAL qlitrl;             /* Token is a quoted string */
    LOGICAL qspecl;             /* Token is a special character */
    LOGICAL qto;                /* Token is TO */
    LOGICAL qwith;              /* Token is WITH */
    LOGICAL qand;               /* Token is AND */
    LOGICAL qor;                /* Token is OR */
    LOGICAL qby;                /* Token is BY */
    LOGICAL qall;               /* Token is ALL */
};

extern struct CmnPar_map *CmnPar;
