
DECLARE FUNCTION CbGetVersionOfFile LIB "msdetstf.dll" (szFile$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION LGetVersionNthField LIB "msdetstf.dll" (szVersion$, nField%) AS LONG
DECLARE FUNCTION LcbGetSizeOfFile LIB "msdetstf.dll" (szFile$) AS LONG
DECLARE FUNCTION FGetValidDrivesList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION FGetLocalHardDrivesList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION FGetRemovableDrivesList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION FGetNetworkDrivesList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION LcbTotalDrive LIB "msdetstf.dll" (nDrive%) AS LONG
DECLARE FUNCTION LcbFreeDrive LIB "msdetstf.dll" (nDrive%) AS LONG
DECLARE FUNCTION FIsValidDrive LIB "msdetstf.dll" (nDrive%) AS INTEGER
DECLARE FUNCTION FIsLocalHardDrive LIB "msdetstf.dll" (nDrive%) AS INTEGER
DECLARE FUNCTION FIsRemoveDrive LIB "msdetstf.dll" (nDrive%) AS INTEGER
DECLARE FUNCTION FIsRemoteDrive LIB "msdetstf.dll" (nDrive%) AS INTEGER
DECLARE FUNCTION FDirExists LIB "msdetstf.dll" (szDir$) AS INTEGER
DECLARE FUNCTION FDoesFileExist LIB "msdetstf.dll" (szFileName$, mode%) AS INTEGER
DECLARE FUNCTION CbGetDateOfFile LIB "msdetstf.dll" (szFile$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION FDoesIniSectionExist LIB "msdetstf.dll" (szFile$, szSect$) AS INTEGER
DECLARE FUNCTION FDoesIniKeyExist LIB "msdetstf.dll" (szFile$, szSect$, szKey$) AS INTEGER
DECLARE FUNCTION CbGetIniKeyString LIB "msdetstf.dll" (szFile$, szSect$, szKey$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION WGetDOSMajorVersion LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION WGetDOSMinorVersion LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION CbGetEnvVariableValue LIB "msdetstf.dll" (szEnvVar$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION WGetNumWinApps LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION FGetParallelPortsList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION FGetSerialPortsList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION FHas87MathChip LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION FHasMonochromeDisplay LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION FHasMouseInstalled LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION WGetConfigSmartdrvSize LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION WGetConfigRamdriveSize LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION WGetConfigNumBuffers LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION WGetConfigNumFiles LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION WGetConfigLastDrive LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION FIsDriverInConfig LIB "msdetstf.dll" (szDrv$) AS INTEGER
DECLARE FUNCTION CbFindTargetOnEnvVar LIB "msdetstf.dll" (szFile$, szEnvVar$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION CbFindFileInTree LIB "msdetstf.dll" (szFile$, szDir$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION GetTypeFaceNameFromTTF LIB "msdetstf.dll" (szFile$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION GetExistingFOTFileForTTF LIB "msdetstf.dll" (szFile$, szBuf$, cbBuf%) AS INTEGER


DECLARE FUNCTION IsDriveValid (szDrive$) AS INTEGER
DECLARE FUNCTION IsDriveLocalHard (szDrive$) AS INTEGER
DECLARE FUNCTION IsDriveRemovable (szDrive$) AS INTEGER
DECLARE FUNCTION IsDriveNetwork (szDrive$) AS INTEGER
DECLARE SUB GetValidDrivesList (szSymbol$)
DECLARE SUB GetLocalHardDrivesList (szSymbol$)
DECLARE SUB GetRemovableDrivesList (szSymbol$)
DECLARE SUB GetNetworkDrivesList (szSymbol$)
DECLARE FUNCTION GetTotalSpaceForDrive (szDrive$) AS LONG
DECLARE FUNCTION GetFreeSpaceForDrive (szDrive$) AS LONG

DECLARE FUNCTION GetDOSMajorVersion AS INTEGER
DECLARE FUNCTION GetDOSMinorVersion AS INTEGER
DECLARE FUNCTION GetEnvVariableValue (szEnvVar$) AS STRING
DECLARE FUNCTION GetNumWinApps AS INTEGER

DECLARE FUNCTION DoesFileExist (szFile$, mode%) AS INTEGER
DECLARE FUNCTION GetDateOfFile (szFile$) AS STRING
DECLARE FUNCTION GetYearFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetMonthFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetDayFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetHourFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetMinuteFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetSecondFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetVersionOfFile (szFile$) AS STRING
DECLARE FUNCTION GetVersionNthField (szVersion$, nField%) AS LONG
DECLARE FUNCTION GetSizeOfFile (szFile$) AS LONG
DECLARE FUNCTION FindTargetOnEnvVar (szFile$, szEnvVar$) AS STRING
DECLARE FUNCTION FindFileInTree (szFile$, szDir$) AS STRING
DECLARE FUNCTION DoesDirExist (szDir$) AS INTEGER

DECLARE FUNCTION DoesIniSectionExist (szFile$, szSect$) AS INTEGER
DECLARE FUNCTION DoesIniKeyExist (szFile$, szSect$, szKey$) AS INTEGER
DECLARE FUNCTION GetIniKeyString (szFile$, szSect$, szKey$) AS STRING

DECLARE FUNCTION GetConfigSmartdrvSize AS INTEGER
DECLARE FUNCTION GetConfigRamdriveSize AS INTEGER
DECLARE FUNCTION GetConfigNumBuffers AS INTEGER
DECLARE FUNCTION GetConfigNumFiles AS INTEGER
DECLARE FUNCTION GetConfigLastDrive AS STRING
DECLARE FUNCTION IsDriverInConfig (szDrv$) AS INTEGER

DECLARE FUNCTION GetProcessorType AS INTEGER
DECLARE SUB GetParallelPortsList (szSymbol$)
DECLARE SUB GetSerialPortsList (szSymbol$)
DECLARE FUNCTION Has87MathChip AS INTEGER
DECLARE FUNCTION HasMonochromeDisplay AS INTEGER
DECLARE FUNCTION HasMouseInstalled AS INTEGER


'FUNCTION IsDriveValid (szDrive$) STATIC  AS INTEGER
'    IsDriveValid = FIsValidDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
'END FUNCTION


'FUNCTION IsDriveLocalHard (szDrive$) STATIC  AS INTEGER
'    IsDriveLocalHard = FIsLocalHardDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
'END FUNCTION


'FUNCTION IsDriveRemovable (szDrive$) STATIC  AS INTEGER
'    IsDriveRemovable = FIsRemoveDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
'END FUNCTION


'FUNCTION IsDriveNetwork (szDrive$) STATIC  AS INTEGER
'    IsDriveNetwork = FIsRemoteDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
'END FUNCTION


FUNCTION GetTotalSpaceForDrive (szDrive$) STATIC  AS LONG
    GetTotalSpaceForDrive = LcbTotalDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


FUNCTION GetFreeSpaceForDrive (szDrive$) STATIC  AS LONG
    GetFreeSpaceForDrive = LcbFreeDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


'SUB GetValidDrivesList (szSymbol$) STATIC
'    if FGetValidDrivesList(szSymbol$) = 0 then
'        ERROR STFERR
'    end if
'END SUB


'SUB GetLocalHardDrivesList (szSymbol$) STATIC
'    if FGetLocalHardDrivesList(szSymbol$) = 0 then
'        ERROR STFERR
'    end if
'END SUB


'SUB GetRemovableDrivesList (szSymbol$) STATIC
'    if FGetRemovableDrivesList(szSymbol$) = 0 then
'        ERROR STFERR
'    end if
'END SUB


'SUB GetNetworkDrivesList (szSymbol$) STATIC
'    if FGetNetworkDrivesList(szSymbol$) = 0 then
'        ERROR STFERR
'    end if
'END SUB


FUNCTION GetDOSMajorVersion STATIC  AS INTEGER
    GetDOSMajorVersion = WGetDOSMajorVersion
END FUNCTION


FUNCTION GetDOSMinorVersion STATIC  AS INTEGER
    GetDOSMinorVersion = WGetDOSMinorVersion
END FUNCTION


FUNCTION GetEnvVariableValue (szEnvVar$) STATIC  AS STRING
    cb% = 1024
    szBuf$ = STRING$(cb%, 32)
    cbRet% = CbGetEnvVariableValue(szEnvVar$, szBuf$, cb%)
    GetEnvVariableValue = szBuf$
    szBuf$ = ""
END FUNCTION


'FUNCTION GetNumWinApps STATIC  AS INTEGER
'    GetNumWinApps = WGetNumWinApps
'END FUNCTION


FUNCTION DoesFileExist (szFileName$, mode%) STATIC  AS INTEGER
    DoesFileExist = FDoesFileExist(szFileName$, mode%)
END FUNCTION


'FUNCTION GetDateOfFile (szFile$) STATIC  AS STRING
'    cb% = 20
'    szBuf$ = STRING$(cb%, 32)
'    cbRet% = CbGetDateOfFile(szFile$, szBuf$, cb%)
'    GetDateOfFile = szBuf$
'    szBuf$ = ""
'END FUNCTION


'FUNCTION GetYearFromDate (szDate$) STATIC  AS INTEGER
'    GetYearFromDate = VAL(MID$(szDate$, 1, 4))
'END FUNCTION


'FUNCTION GetMonthFromDate (szDate$) STATIC  AS INTEGER
'    GetMonthFromDate = VAL(MID$(szDate$, 6, 2))
'END FUNCTION


'FUNCTION GetDayFromDate (szDate$) STATIC  AS INTEGER
'    GetDayFromDate = VAL(MID$(szDate$, 9, 2))
'END FUNCTION


'FUNCTION GetHourFromDate (szDate$) STATIC  AS INTEGER
'    GetHourFromDate = VAL(MID$(szDate$, 12, 2))
'END FUNCTION


'FUNCTION GetMinuteFromDate (szDate$) STATIC  AS INTEGER
'    GetMinuteFromDate = VAL(MID$(szDate$, 15, 2))
'END FUNCTION


'FUNCTION GetSecondFromDate (szDate$) STATIC  AS INTEGER
'    GetSecondFromDate = VAL(MID$(szDate$, 18, 2))
'END FUNCTION


'FUNCTION GetVersionOfFile (szFile$) STATIC  AS STRING
'    cb% = 30
'    szBuf$ = STRING$(cb%, 32)
'    cbRet% = CbGetVersionOfFile(szFile$, szBuf$, cb%)
'    GetVersionOfFile = szBuf$
'    szBuf$ = ""
'END FUNCTION


'FUNCTION GetVersionNthField (szVersion$, nField%) STATIC  AS LONG
'    GetVersionNthField = LGetVersionNthField(szVersion$, nField%)
'END FUNCTION


'FUNCTION GetSizeOfFile (szFile$) STATIC  AS LONG
'    GetSizeOfFile = LcbGetSizeOfFile(szFile$)
'END FUNCTION


FUNCTION FindTargetOnEnvVar (szFile$, szEnvVar$) STATIC  AS STRING
    cb% = 512
    szBuf$ = STRING$(cb%, 32)
    cbRet% = CbFindTargetOnEnvVar(szFile$, szEnvVar$, szBuf$, cb%)
    IF cbRet% >= cb% THEN
        ERROR STFERR
    END IF
    szBuf$ = RTRIM$(szBuf$)
    IF MID$(szBuf$, 1, 1) = "\" THEN
       szBuf$ = MID$(CURDIR$, 1, 2) + szBuf$
    ELSEIF Len(szBuf$) > 0 AND MID$(szBuf$, 2, 1) <> ":" THEN
       szBuf$ = MID$(CURDIR$, 1, 3) + szBuf$
    END IF
    FindTargetOnEnvVar = szBuf$
    szBuf$ = ""
END FUNCTION


'FUNCTION FindFileInTree (szFile$, szDir$) STATIC  AS STRING
'    cb% = 512
'    szBuf$ = STRING$(cb%, 32)
'    cbRet% = CbFindFileInTree(szFile$, szDir$, szBuf$, cb%)
'    FindFileInTree = szBuf$
'    szBuf$ = ""
'END FUNCTION


'FUNCTION GetConfigSmartdrvSize STATIC  AS INTEGER
'    GetConfigSmartdrvSize = WGetConfigSmartdrvSize
'END FUNCTION


'FUNCTION GetConfigRamdriveSize STATIC  AS INTEGER
'    GetConfigRamdriveSize = WGetConfigRamdriveSize
'END FUNCTION


'FUNCTION GetConfigNumBuffers STATIC  AS INTEGER
'    GetConfigNumBuffers = WGetConfigNumBuffers
'END FUNCTION


'FUNCTION GetConfigNumFiles STATIC  AS INTEGER
'    GetConfigNumFiles = WGetConfigNumFiles
'END FUNCTION


'FUNCTION GetConfigLastDrive STATIC  AS STRING
'    chRet% = WGetConfigLastDrive
'    if chRet% = 0 then
'        GetConfigLastDrive = ""
'    else
'        GetConfigLastDrive = CHR$(chRet%)
'    end if
'END FUNCTION


'FUNCTION IsDriverInConfig (szDrv$) STATIC  AS INTEGER
'    IsDriverInConfig = FIsDriverInConfig(szDrv$)
'END FUNCTION


FUNCTION GetProcessorType STATIC  AS INTEGER
    GetProcessorType = 0
    longTmp& = GetWinFlags()
    IF longTmp& AND WF_CPU486 THEN
        GetProcessorType = 4
    ELSEIF longTmp& AND WF_CPU386 THEN
        GetProcessorType = 3
    ELSEIF longTmp& AND WF_CPU286 THEN
        GetProcessorType = 2
    ELSEIF longTmp& AND WF_CPU186 THEN
        GetProcessorType = 1
    END IF
END FUNCTION


'SUB GetParallelPortsList (szSymbol$) STATIC
'    if FGetParallelPortsList(szSymbol$) = 0 then
'        ERROR STFERR
'    end if
'END SUB


SUB GetSerialPortsList (szSymbol$) STATIC
    if FGetSerialPortsList(szSymbol$) = 0 then
        ERROR STFERR
    end if
END SUB


'FUNCTION Has87MathChip STATIC  AS INTEGER
'    Has87MathChip = FHas87MathChip
'END FUNCTION


'FUNCTION HasMonochromeDisplay STATIC  AS INTEGER
'    HasMonochromeDisplay = FHasMonochromeDisplay
'END FUNCTION


'FUNCTION HasMouseInstalled STATIC  AS INTEGER
'    HasMouseInstalled = FHasMouseInstalled
'END FUNCTION


FUNCTION DoesDirExist (szDir$) STATIC  AS INTEGER
    DoesDirExist = FDirExists(szDir$)
END FUNCTION


FUNCTION DoesIniSectionExist (szFile$, szSect$) STATIC  AS INTEGER
    DoesIniSectionExist = FDoesIniSectionExist(szFile$, szSect$)
END FUNCTION


FUNCTION DoesIniKeyExist (szFile$, szSect$, szKey$) STATIC  AS INTEGER
    DoesIniKeyExist = FDoesIniKeyExist(szFile$, szSect$, szKey$)
END FUNCTION


FUNCTION GetIniKeyString (szFile$, szSect$, szKey$) STATIC  AS STRING
    cb% = 512
    szBuf$ = STRING$(cb%, 32)
    cbRet% = CbGetIniKeyString(szFile$, szSect$, szKey$, szBuf$, cb%)
    GetIniKeyString = szBuf$
    szBuf$ = ""
END FUNCTION



