/********************************************************************
 * PC installer (aldsetup) control file for PageMaker 5.0  1.44mb Disks
 * Copyright (C) 1992 - 1993 Aldus Corporation.  All rights reserved.
 * Control file administrator: Dave Perkins
 ********************************************************************/

PRODUCT "PageMaker 5.0"

VERSIONREQ "2.3"

ALDUSDIRECTORY "Aldus" "AldusDirectory" "C:\ALDUS"


/********   DBUILD SECTION  ***********/


DISK "(1)"
   {
   (C)ALDUS.'93         62,
   2INTGRT.BMP       38878,
   ALDSETUP.EXE     284720  CHECKDATE,
   PM5_144.CTL       67857,
   README.WRI        43904,
   READTHIS.TXT       5502,
   PKWTUTOR.EX~     166272  "ALDUS",
   PM5.HL~          465820  "ALDUS\USENGLSH"  VITAL,
   LEARNPM5.PK~     275627  "PM5\LEARNPM5",
   LEARNPM5.HL~     335226  "PM5\LEARNPM5",
   NET.CTL           75790  "NET",
   NETINST.EX~        8672  "NET",
   MAXNET.SR~        10685  "NET",
   IMAGENET.SR~      61878  "NET",
   MINNET.SR~        54065  "NET",
   SETUP.WR~          4992  "NET",
   NETWORK.WRI       14976  "NET"
   }


DISK "(2)"
   {
   (C)ALDUS.'93         62,
   PM5part1.12~     1581056  VITAL,
   LEARNPM5.IC~        766,
   X7.RT~             2567,
   X1.PT~             7296,
   X2.PT~             7424,
   X3.PT~             8384,
   X4.PT~             8576,
   X5.PT~             7296,
   X9.TB~              681,
   X6.PT~            16512,
   X8.PT~             9664,
   X10.PT~           18624,
   TABLE.WM~         10138,
   GRAPHIC.TIF       10892,
   LOGOTYPE.TIF      10892,
   BIGTABLE.TIF      49511,
   VIATEXT.RT~        1949,
   SMLTABLE.TIF        950,
   ALDCLP5.DL~      133001  CHECKDATE  VITAL,
   ALDFS.DL~         66399  CHECKDATE  VITAL,
   ALDIM3.DL~       213616  CHECKDATE  VITAL,
   ALDWPLS.DL~      160912  CHECKDATE  VITAL,
   ALDPLS2.DL~      136208  CHECKDATE  VITAL,
   PICTWMF.DL~      115368  CHECKDATE  VITAL,
   PRXLNGST.DL~       6144  CHECKDATE  VITAL,
   ALDNCD.DL~        15742  CHECKDATE  VITAL,
   NWNETAPI.DL~     106047  CHECKDATE  VITAL
   }


DISK "(3)"
   {
   1REGSTR.BMP       38878,
   PM5.EX~           25088  VITAL,
   PM5part2.12~     1186240  VITAL,
   MAI.DL~           88640  CHECKDATE  VITAL,
   ALDVM.DL~         84286  CHECKDATE  VITAL,
   ALDFONTA.FO~      22512  CHECKDATE  VITAL,
   ALDFONTB.FO~      17776  CHECKDATE  VITAL,
   ALDFONTE.FO~      30896  CHECKDATE  VITAL,
   ALDFONTF.FO~      32672  CHECKDATE  VITAL,
   PKWTUT3.DL~        4064,
   PKWTUT2.DL~        3104,
   PKWTUT1.DL~        6122,
   PM5RES.RS~       261856  VITAL,
   ALDVMRES.RS~       5120  CHECKDATE  VITAL,
   PRXLNGST.RS~       3072  CHECKDATE  VITAL,
   TE.HL~            49445,
   ALDWPLSR.RS~       9232  CHECKDATE  VITAL,
   TRAKVALS.BI~        730  VITAL,
   LEARNPM5.TR~      50672
   }

DISK "( 3 )"
   {
   PCSG.BC~         162950  "COLOR",
   TOYOPC.BC~        57326  "COLOR",
   TRUMATCH.BC~     114242  "COLOR",
   CRAYON.AC~         2748  "COLOR",
   FOCOLTON.BC~      47066  "COLOR",
   DIC-PCN.BC~       70178  "COLOR",
   GREYS.AC~          6841  "COLOR",
   PCSGE.BC~        162950  "COLOR",
   mhicpc.BC~        29678  "COLOR",
   MUNPC.BC~        119318  "COLOR",
   PANTONEC.BC~      51980  "COLOR",
   PANTONEU.BC~      51980  "COLOR",
   PANTONPE.BC~      51980  "COLOR",
   PANTONEP.BC~      51980  "COLOR",
   CHREXPC.TB~        3811  "WINDOWS"  NOREPLACE,
   CHRIMPC.TB~        3785  "WINDOWS"  NOREPLACE,
   PKWTUTOR.IN~        549  "WINDOWS"  NOREPLACE,
   PANOSE.DA~       135483  "WINDOWS"  NOREPLACE,
   PCDLIB.DL~        84672  "WINDOWS"  CHECKDATE,
   PCDIMP.HL~         3559  "WINDOWS"  CHECKDATE,
   TWAIN.DL~         22944  "WINDOWS"  CHECKDATE,
   PXENGWIN.DL~     236734  "WINDOWS"  CHECKDATE,
   ALDLEARN.DL~      29184  "WINDOWS"  CHECKDATE,
   4PRE_US.BMP       38878
   }


DISK "(4)"
   {
   (C)ALDUS.'93         62,
   3VERS_US.BMP      38878,
   DATETIME.TY~        296  "PM5",
   CLIP.AR~         171534  "PM5",
   TE.EX~            22016  "PM5",
   TEAPP.EX~        274896  "PM5",
   CHARSET.PT~       25472  "PM5",
   CALIBRAT.PT~      36800  "PM5",
   BIKEWEEL.TX~       1290  "PM5\SCRIPTS",
   CROP&COL.TX~       2225  "PM5\SCRIPTS",
   ENVELOP.TX~        5266  "PM5\SCRIPTS",
   FRACTION.TX~        623  "PM5\SCRIPTS",
   HORIZFRC.TX~       3365  "PM5\SCRIPTS",
   RECIPE.TX~         4203  "PM5\SCRIPTS",
   STARWRAP.TX~        378  "PM5\SCRIPTS",
   CRAYON.TX~         5414  "PM5\SCRIPTS",
   CRAYONME.TX~       3282  "PM5\SCRIPTS",
   ARTIMP.FL~       133328  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   ARTIMP.HL~        43239  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   CGMIMP.FL~        51920  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   EPSIMP.FL~       104885  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   CHARTIMP.FL~       9840  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   PICTIMP.FL~        6956  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   AMIIMP.FL~        16480  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   TWAINIMP.FL~      39344  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   TEIMP.FL~         68416  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   123IMP.FL~        61808  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   ADIIMP.FL~         3680  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   WPGIMP.FL~        38256  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   ASCIIEXP.FL~       2896  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   EXCELIMP.FL~      62096  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   DBSIMP.FL~        41168  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   DCAEXP.FL~         7952  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   RTFEXP.FL~         9312  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   MSWDIMP.FL~       44032  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   DXFIMP.FL~        44576  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   GEMIMP.FL~        34000  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   PCDIMP.FL~        25600  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   PCXIMP.FL~        14336  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   PMIMP.P5~         18752  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   PM5IMP.FL~        23760  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   RTFIMP.FL~        31424  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   TEXTIMP.FL~       18384  "ALDUS\USENGLSH\FILTERS"  CHECKDATE
   }

DISK "( 4 )"
   {
   WP5IMP.FL~        40960  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   TEKIMP.FL~         7160  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   TIMEIMP.FL~       18432  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   VIDSHIMP.FL~     107008  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   VPIMP.FL~        125203  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   WINWDIMP.FL~      39936  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   WMFIMP.FL~         4461  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   WNWD2IMP.FL~      47104  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   WP4IMP.FL~         7248  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   WP5EXP.FL~        11264  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   WSTRIMP.FL~       32768  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   XY3EXP.FL~        39831  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   XY3IMP.FL~        29297  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   DCAIMP.FL~         8768  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   DECWPIMP.FL~       8690  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   DRAWIMP.FL~       26624  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   HPGLIMP.FL~       39936  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   LOTUSIMP.FL~       7680  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   MSWDEXP.FL~       17520  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   MULTIIMP.FL~       5683  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   EPSIMPND.FL~     104885  "ALDUS\USENGLSH\FILTERS\AFILTERS"  CHECKDATE,
   SCRPTSPL.TX~       5435  "ALDUS\USENGLSH\UTILITY",
   PPDLIST.WR~       40704  "ALDUS\USENGLSH\UTILITY",
   COPYFIT.TX~       18000  "ALDUS\USENGLSH\UTILITY",
   DICTED.WR~        15360  "ALDUS\USENGLSH\UTILITY",
   DE.EX~            22016  "ALDUS\USENGLSH\UTILITY"  CHECKDATE,
   DEAPP.EX~        380800  "ALDUS\USENGLSH\UTILITY"  CHECKDATE,
   WINBUMPS.EX~      37896  "ALDUS\USENGLSH\UTILITY",
   IDUPDATE.EX~      12048  "ALDUS\USENGLSH\UTILITY"  CHECKDATE,
   IDREADME.TX~        798  "ALDUS\USENGLSH\UTILITY",
   PPDSHELL.PS~      43584  "ALDUS\USENGLSH\UTILITY\PS_TOOLS",
   PPDSHELL.TX~       6751  "ALDUS\USENGLSH\UTILITY\PS_TOOLS",
   5CROSSUS.BMP      38878
   }


DISK "(5)"
   {
   (C)ALDUS.'93         62,
   8ONLINE.BMP       38878,
   _TEXT.TX~           543  "PM5\TUTORIAL\EXPLORE",
   TEXT_.TX~          3508  "PM5\TUTORIAL\LESSON1",
   BROC_US.PT~        5248  "PM5\TUTORIAL\LESSON2",
   BROC_INT.PT~       5504  "PM5\TUTORIAL\LESSON2",
   PM5SHORT.HL~      55348  "ALDUS\USENGLSH"  VITAL,
   ALDUSN.BP~        32319  "ALDUS\USENGLSH"  CHECKDATE  VITAL,
   ALDUSN.MS~         1024  "ALDUS\USENGLSH"  CHECKDATE  VITAL,
   ALDUSN00.VP~     339968  "ALDUS\USENGLSH"  CHECKDATE  VITAL,
   ALDUSN.NF~           66  "ALDUS\USENGLSH"  CHECKDATE  VITAL,
   ALDUSN.UD~         1024  "ALDUS\USENGLSH"  CHECKDATE,
   ALDCOLOR.AD~      60928  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   OPENTEMP.AD~     359424  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   BALANCEC.AD~      17920  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   BLDBKLT.AD~       70144  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   ACQUIRE.AD~       57344  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   CONTINUE.AD~       9728  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   DINGWIN.CH~        3293  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   DROPCAP.AD~       19968  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   OPENSTOR.AD~       5120  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   EXPWIN.CH~         4900  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   HEADERS.AD~       77808  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   HOLEHOP.AD~        7168  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   GROUPIT.AD~       40960  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   HOLEINFO.AD~      14848  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   EXPKERN.AD~      197632  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   KERNWIN.CH~        4900  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   KEYLINE.AD~       18944  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   LISTSTYL.AD~       6656  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   NUMPARAS.AD~      20992  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   OVERSET.AD~        6144  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   PAGESORT.AD~      76120  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   PUBINFO.AD~       11776  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   PSTYLES.AD~      147456  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   RUNSCRIP.AD~       8704  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   STRYINFO.AD~      14848  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   TRACKER.AD~      152180  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   LIBLOADR.AD~       7168  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   LIBRARY.PA~      126464  "ALDUS\USENGLSH\ADDITION"  CHECKDATE
   }

DISK "( 5 )"
   {
   ATG.TR~           54099  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   AVERY.AT~          7660  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   BROCHUR1.AT~      15405  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   BROCHUR2.AT~       8315  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CALENDAR.AT~       7353  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CASSLAB.AT~        1953  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CASSLINE.AT~       6645  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CDLINER.AT~        4564  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CDNOTES.AT~        3939  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   DISKETTE.AT~       3260  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   ENVELOPE.AT~       4780  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   FAX.AT~            8849  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   INVOICE.AT~        7541  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   MANUAL.AT~        42702  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   NEWSLTR1.AT~      33102  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   NEWSLTR2.AT~      31863  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   PURCHASE.AT~       8018  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   VHS.AT~            3836  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   AGACCSF1.PP~      31636  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGACCST1.PP~      26884  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGP94SF1.PP~      27173  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGP95SF1.PP~      27173  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGP96SF1.PP~      27171  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGP97SF1.PP~      28035  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGP98SF1.PP~      35599  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGPR9551.PP~      23408  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGPRO941.PP~      23464  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGPRO971.PP~      27440  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGPRO981.PP~      27985  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGPRS961.PP~      26576  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGSELS51.PP~      28704  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGSELS71.PP~      29338  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGSL5SF1.PP~      35955  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGSL7SF1.PP~      36584  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   AGSTDS21.PP~      23902  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   ALJII523.PP~      11342  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   APLWIIG1.PP~      15362  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   APPLE422.PP~      11941  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   APTOLD81.PP~      22167  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   APTOLLD1.PP~      22240  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   APTOLLW1.PP~      22376  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CG94_493.PP~      15893  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CGENERAL.PP~       8006  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CN_500J1.PP~      20400  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CN_500_1.PP~      14158  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CP301503.PP~      10088  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CPPER241.PP~      24255  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CPPMQ151.PP~      29466  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CPPMQ201.PP~      31050  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CPPRO518.PP~       9970  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CPPSA241.PP~      22698  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   CPPSB241.PP~      23179  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   DCLPS201.PP~      22869  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   DCLPS401.PP~      20449  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   DP_US470.PP~      21780  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   GENERAL.PP~        8855  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   HP3SI_L1.PP~      20616  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   HP3SI_L2.PP~      22496  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   HP4M3_1.PP~       14618  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   HP4M6_1.PP~       14963  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   HP4SI3_1.PP~      25587  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   HP4SI6_1.PP~      25168  "ALDUS\USENGLSH\PPD4a"  CHECKDATE,
   6CUSTFIR.BMP      38878
   }


DISK "(6)"
   {
   (C)ALDUS.'93         62,
   7FAXYI.BMP        38878,
   APR_1993.TX~        638  "CALDATES",
   APR_1994.TX~        633  "CALDATES",
   AUG_1993.TX~        639  "CALDATES",
   AUG_1994.TX~        643  "CALDATES",
   DEC_1993.TX~        647  "CALDATES",
   DEC_1994.TX~        642  "CALDATES",
   FEB_1993.TX~        635  "CALDATES",
   FEB_1994.TX~        638  "CALDATES",
   JAN_1993.TX~        639  "CALDATES",
   JAN_1994.TX~        642  "CALDATES",
   JUL_1993.TX~        633  "CALDATES",
   JUL_1994.TX~        637  "CALDATES",
   JUN_1993.TX~        637  "CALDATES",
   JUN_1994.TX~        633  "CALDATES",
   MAR_1993.TX~        628  "CALDATES",
   MAR_1994.TX~        631  "CALDATES",
   MAY_1993.TX~        635  "CALDATES",
   MAY_1994.TX~        630  "CALDATES",
   NOV_1993.TX~        646  "CALDATES",
   NOV_1994.TX~        649  "CALDATES",
   OCT_1993.TX~        644  "CALDATES",
   OCT_1994.TX~        647  "CALDATES",
   SEP_1993.TX~        644  "CALDATES",
   SEP_1994.TX~        647  "CALDATES",
   PSCRIPT.DRV      138594,
   UNIDRV.DLL        77841,
   UNIDRV.HLP        45107,
   HPPCL5MS.DRV     113705,
   PRINTER.TXT        2608,
   OEMSETUP.INF        288,
   courb.fo_          8118,
   coure.fo_          8612,
   courf.fo_         11021,
   license.txt        4046,
   serifb.fo_        18777,
   serife.fo_        21454,
   seriff.fo_        27241,
   smallb.fo_        10928,
   smalle.fo_        12501,
   smallf.fo_        10489,
   sserifb.fo_       18968,
   sserife.fo_       21643,
   sseriff.fo_       27627,
   symbolb.fo_       19890,
   symbole.fo_       21296,
   symbolf.fo_       27198,
   HP_3D522.PP~      14926  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   HP_3P522.PP~      13307  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   HPIID522.PP~      14139  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   HPIII522.PP~      13112  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   HPIIP522.PP~      12863  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   HPLJ_31.PP~       14742  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   HPLJ_3D1.PP~      19225  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   HPLJ_3P1.PP~      16213  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   HPPJXL31.PP~      19323  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   IB4029A1.PP~      19729  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   IB4029B1.PP~      18361  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   IBM17523.PP~      15372  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   IBM30505.PP~      12196  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   IBM39523.PP~      16775  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   L100_425.PP~      15343  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   L200_471.PP~      20804  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   L200_493.PP~      20802  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   L300_471.PP~      22527  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   L300_493.PP~      22523  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   L3330523.PP~      35580  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   L500_493.PP~      20780  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   L5330523.PP~      29398  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   LH300__1.PP~      24521  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   LH330__1.PP~      35217  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   LH500__1.PP~      19700  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   LH530__1.PP~      32676  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   LH630__1.PP~      25390  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   LWNT_470.PP~      12164  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   LWNTX470.PP~      12301  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   LWNTX518.PP~      12352  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   N2090522.PP~      11451  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   N2290520.PP~      10402  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   N890_470.PP~      11522  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   N890X505.PP~      12036  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   NC95FAX1.PP~      18714  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   NC97FAX1.PP~      18297  "ALDUS\USENGLSH\PPD4b"  CHECKDATE,
   NCN4SF21.PP~      16378  "ALDUS\USENGLSH\PPD4b"  CHECKDATE
   }

DISK "( 6 )"
   {
   NCN4SF51.PP~      20468  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NCOL_519.PP~      11904  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NCS29901.PP~      12467  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NCSW_951.PP~      13960  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC1200B.PP~      19241  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC1200T.PP~      18820  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC440ND.PP~      14895  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_300P.PP~      12043  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_400P.PP~      12522  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_440B.PP~      13435  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_440N.PP~      15074  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_600T.PP~      14543  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_630_.PP~      14702  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_660_.PP~      13860  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_660B.PP~      19440  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_660P.PP~      14494  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_840E.PP~      15924  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_880_.PP~      15346  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   NSC_880P.PP~      16025  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   OL830525.PP~      13169  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   OL840518.PP~      12829  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   P4455514.PP~      12800  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   Q810T517.PP~      11822  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   Q820_517.PP~      12194  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   Q820T517.PP~      11862  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   QCS10503.PP~      10686  "ALDUS\USENGLSH\PPD4c"  CHECKDATE,
   QCS30503.PP~      10708  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QM1700_1.PP~      15870  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QM2000_1.PP~      14397  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QM815MR1.PP~      15436  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QM825MR1.PP~      15688  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QMPS4101.PP~      12932  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QMPS8151.PP~      13386  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QMPS8251.PP~      13633  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QMS81470.PP~      11153  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QMS8_461.PP~      10035  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QMS8P461.PP~      11406  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   QMSCS494.PP~      10708  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   SCTXDOLV.PP~       9103  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   STDLV400.PP~       9493  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   T1535470.PP~      11877  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TI08_450.PP~       9973  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TIM17521.PP~      14479  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TIM35521.PP~      15595  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TITRB161.PP~      16746  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TITRBO61.PP~      16743  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TITRBO91.PP~      16743  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TIX17521.PP~      14503  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TIX35521.PP~      15602  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TK200171.PP~      11779  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TK200391.PP~      13147  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TKP200I1.PP~      13464  "ALDUS\USENGLSH\PPD4d"  CHECKDATE,
   TKPH2SD1.PP~      13217  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   TKPHZR21.PP~      13140  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   TKPHZR22.PP~      13054  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   TKPHZR31.PP~      19553  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   TKPHZR32.PP~      20924  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   TKPXE171.PP~      11884  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   TKPXE391.PP~      13217  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   TT1000-4.PP~      13150  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   TT1200.PP~        15240  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   TT1200XL.PP~      21230  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   U1000.PP~         19017  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   U1200XL4.PP~      20926  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   V5334522.PP~      30262  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT42P522.PP~      17102  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT43P522.PP~      19576  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4510A1.PP~      17430  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4530A1.PP~      43448  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4530B1.PP~      32771  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4530C1.PP~      27304  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4533B1.PP~      48937  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4533C1.PP~      39692  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT453EA1.PP~      44141  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT453EB1.PP~      33443  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4550A1.PP~      27134  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4550B1.PP~      30443  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4550C1.PP~      27010  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4551A1.PP~      19236  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4563A1.PP~      33581  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4563B1.PP~      32621  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT49901.PP~       26634  "ALDUS\USENGLSH\PPD4e"  CHECKDATE,
   VT4L3001.PP~      80513  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   VT4L3301.PP~      89168  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   VT4L5001.PP~      82331  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   VT4L5301.PP~      82300  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   VT550522.PP~      13258  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   VT600P1.PP~       10294  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   VT600W1.PP~       10598  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   VT60P480.PP~       9937  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   WJ1200.PP~        17039  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   WJ800.PP~         13789  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   WP800.PP~         13878  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   XRDT0901.PP~      16520  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   XRDT1351.PP~      24671  "ALDUS\USENGLSH\PPD4f"  CHECKDATE,
   ALDCLP5R.RS~      18432  CHECKDATE  VITAL,
   ALDFSRES.RS~       4272  CHECKDATE  VITAL,
   ALDIM3RS.RS~       5888  CHECKDATE  VITAL,
   MONDAY.TX~          247  "DAYS",
   TUESDAY.TX~         249  "DAYS",
   WED.TX~             252  "DAYS",
   THURSDAY.TX~        252  "DAYS",
   FRIDAY.TX~          252  "DAYS",
   SATURDAY.TX~        255  "DAYS",
   SUNDAY.TX~          246  "DAYS",
   DAYS.TX~           1631  "DAYS"
   }


/*********** DBUILD END ******************/


/*****   DIALOG & VARIABLE INITIALIZATION  *****/

INITIAL PM5Dir "C:\PM5"
	{
	"Type the name of the drive and directory where"
	"you want to install Aldus PageMaker 5.0 files."
	" "
	"If this is the directory you want, click OK."
	}


DIALOG AldusLocation "OK" "Cancel" 
{
	CAPTION "Aldus Directory Creation"
	TEXT
	{
	"Type the drive letter and subdirectory where"
	"you want to install the Aldus files.  This"
	"directory will be used by all Aldus products"
	"to store files such as dictionaries and filters."
	}
}

DIALOG BuffersWarning "&Continue" "&Exit"
{
	CAPTION "Low BUFFERS setting"
	TEXT
	{
	"Aldus Setup has detected that the BUFFERS setting in your "
	"CONFIG.SYS file is below 20.  You can successfully install "
	"with the current settings, but the installation process may"
	"be slowed considerably.  Increasing the value of this setting"
	"and rebooting your computer will speed up the installation time."
	}
}

DIALOG PrintInfo "&OK"
{
	CAPTION "Must install Drivers"
	TEXT
	{
	"If you will be using a PostScript printer with PageMaker"
	"or a HP LaserJet III, please install the drivers from the"
	"last disk of the set.  If newer versions of the drivers"
	"are available, use them instead."
	" "
	"The Windows Control Panel will start when you click"
	"OK."
	}
}

DIALOG PPDwarning "&OK"
{
	CAPTION "Selecting PPDs (PostScript ONLY)"
	TEXT
	{
	"If you will be using a PostScript printer, you will need to"
	"install a PostScript Printer Description (PPD) file for each"
	"printer.  Select only the printers you need.  Installing more"
	"PPDs than you need (ten or more) may slow the performance of"
	"PageMaker's ""Print"" dialog."
	" "
	"The printer files you select work with the Windows Postscript"
	"driver supplied on the PageMaker disk set.  At the end of this"
	"installation, you will be asked to install a printer driver."
	}
}

DIALOG AldusGroup "&Continue"
{
	CAPTION "Aldus Group"
	TEXT
	{
	"The Aldus Setup program has created the Aldus"
	"group window."
	" "
	"Aldus Setup, Aldus PageMaker 5.0, Table Editor, Dictionary"
	"Editor and Learning PageMaker 5.0 (if installed) have been"
	"added to the Aldus Group.  To start any one of these applic-"
	"ations double-click on the program icon."
	}
}

DIALOG SucRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been"
	"successfully installed."
	}
}

DIALOG MoreInfo "&OK"
{
	CAPTION "Installer Diagnostics"
	TEXT
	{
	" "
	"You may now exit this program or choose to read the Aldus"
	"PageMaker 5.0 READTHIS.TXT file, which has been added to the" 
	"View menu.  You may also choose to examine other information"
	"provided from the Diagnostics or View menus in Aldus Setup."
	" "
	"Thank you for purchasing Aldus PageMaker 5.0. Your installation"
	"is complete.  Please fill out and send in your registration card."
	}
}

DIALOG SucNoRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been successfully installed."
	" "
	"You may now exit this program or choose to examine the"
	"information provided from the Diagnostics or View menu"
	"in Aldus Setup."
	}
}

/*********** INITIALIZATION END *************/


/*****   PACKAGE DEFINITION SECTION *********/


PACKAGE PROLOGUE "" SELECTED INVISIBLE
{
/***** Global Variable Declarations & System Min. Config Checks *****/
GETALDDIR AldDir AldusLocation
GETBOOTDRIVE BootDrive
SET ExeInstalled "FALSE"
SET PrinterDrivers "FALSE"
SET Serialize "FALSE"
SET FullInstallation "FALSE"
GETWINDIR WinDir
GETWINSYSDIR WinSysDir

CONCAT BootDrive "CONFIG.SYS" ConfigFullName

GETSYSVARVALUE ConfigFullName "BUFFERS" BufferAmount
IF BufferAmount LT 20 
	{
	DISPLAY BuffersWarning BufferResponse
	IF  BufferResponse EQS "&Exit" 
		{
		EXIT
		}
	} 

}   /** End PROLOGUE **/

PACKAGE InstallEverything "Install Everything (14MB)" SELECTED
	{
	/**** Package Initializations *****/

	GETALDDIR AldDir AldusLocation
	CONFIRMDIR PM5Dir
	SET Serialize "TRUE"
	
	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "SETUP" SetupDir
	CONCAT EngDir "FILTERS" AFiltDir
	CONCAT AFiltDir "AFILTERS" AddFiltDir
	CONCAT EngDir "COLOR" AColorDir
	CONCAT EngDir "ADDITION" AADDitionDir
	CONCAT AADDitionDir "TEMPLATE" TemplateDir
	CONCAT TemplateDir "CALDATES" CalDir
	CONCAT CalDir "DAYS" DayDir
	CONCAT EngDir "PPD4" APPD4Dir
	CONCAT EngDir "UTILITY" AUtilDir
	CONCAT AUtilDir "PS_TOOLS" PSTDir
	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "tutorial" TutRootDir
	CONCAT PM5Dir "SCRIPTS" ScriptDir
	CONCAT TutRootDir "explore" TutExpDir
	CONCAT TutRootDir "LESSON1" TutLess1Dir
	CONCAT TutRootDir "LESSON2" TutLess2Dir

	BMPFILE 2INTGRT.BMP
	BMPFILE 1REGSTR.BMP
	BMPFILE 4PRE_US.BMP 
	BMPFILE 3VERS_US.BMP
	BMPFILE 5CROSSUS.BMP
	BMPFILE 8ONLINE.BMP
	BMPFILE 7FAXYI.BMP
	BMPFILE 6CUSTFIR.BMP  

	/**** File Subdirectory Assignments *****/

	FILES AldDir     
		{
		ALDFONTB.FO~
		ALDFONTE.FO~
		ALDFONTF.FO~
		ALDFS.DL~
		ALDFONTA.FO~
		ALDPLS2.DL~
		ALDWPLS.DL~
		ALDIM3.DL~
		ALDCLP5.DL~
		ALDNCD.DL~
		ALDVM.DL~
		PKWTUTOR.EX~
		PICTWMF.DL~
		NWNETAPI.DL~
		PRXLNGST.DL~
		PKWTUT1.DL~
		PKWTUT2.DL~
		PKWTUT3.DL~
		}

	FILES EngDir
		{
		ALDCLP5R.RS~
		PM5RES.RS~
		MAI.DL~
		ALDFSRES.RS~
		ALDUSN.MS~
		ALDVMRES.RS~
		ALDUSN.UD~
		ALDUSN.NF~
		ALDUSN.BP~
		ALDUSN00.VP~
		PM5.HL~
		ALDIM3RS.RS~
		PRXLNGST.RS~
		PM5SHORT.HL~
		TE.HL~
		TRAKVALS.BI~
		ALDWPLSR.RS~
		}
	

	FILES SetupDir
		{
		ALDSETUP.EXE
		PM5_144.CTL
		}

	FILES AFiltDir
		{
		ARTIMP.FL~
		ARTIMP.HL~
		CGMIMP.FL~
		EPSIMP.FL~
		CHARTIMP.FL~
		PICTIMP.FL~
		AMIIMP.FL~
		TEIMP.FL~
		TWAINIMP.FL~
		123IMP.FL~
		ADIIMP.FL~
		WPGIMP.FL~
		ASCIIEXP.FL~
		EXCELIMP.FL~
		DBSIMP.FL~
		DCAEXP.FL~
		RTFEXP.FL~
		MSWDIMP.FL~
		DXFIMP.FL~
		GEMIMP.FL~
		PCDIMP.FL~
		PMIMP.P5~
		PCXIMP.FL~
		PM5IMP.FL~
		RTFIMP.FL~
		TEXTIMP.FL~
		WP5IMP.FL~
		TEKIMP.FL~
		TIMEIMP.FL~
		VIDSHIMP.FL~
		VPIMP.FL~
		WINWDIMP.FL~
		WMFIMP.FL~
		WNWD2IMP.FL~
		WP4IMP.FL~
		WP5EXP.FL~
		WSTRIMP.FL~
		XY3EXP.FL~
		XY3IMP.FL~
		DCAIMP.FL~
		DECWPIMP.FL~
		DRAWIMP.FL~
		HPGLIMP.FL~
		LOTUSIMP.FL~
		MSWDEXP.FL~
		MULTIIMP.FL~
		}

	FILES AddFiltDir
		{
		EPSIMPND.FL~
		}

	FILES AColorDir
		{
		PCSG.BC~
		TOYOPC.BC~
		TRUMATCH.BC~
		CRAYON.AC~
		FOCOLTON.BC~
		DIC-PCN.BC~
		GREYS.AC~
		PCSGE.BC~
		MHICPC.BC~
		MUNPC.BC~
		PANTONEC.BC~
		PANTONEU.BC~
		PANTONPE.BC~
		PANTONEP.BC~
		}

	FILES AADDitionDir
		{
		DROPCAP.AD~
		BLDBKLT.AD~
		RUNSCRIP.AD~
		ALDCOLOR.AD~
		ACQUIRE.AD~
		CONTINUE.AD~
		OPENSTOR.AD~
		HOLEHOP.AD~
		HOLEINFO.AD~
		LISTSTYL.AD~
		NUMPARAS.AD~
		OVERSET.AD~
		PUBINFO.AD~
		PSTYLES.AD~
		GROUPIT.AD~
		STRYINFO.AD~
		LIBLOADR.AD~
		LIBRARY.PA~
		BALANCEC.AD~
		HEADERS.AD~
		DINGWIN.CH~
		EXPWIN.CH~
		EXPKERN.AD~
		KERNWIN.CH~
		OPENTEMP.AD~
		TRACKER.AD~
		PAGESORT.AD~
		KEYLINE.AD~
		}

	FILES TemplateDir
		{
		ATG.TR~
		AVERY.AT~
		BROCHUR1.AT~
		BROCHUR2.AT~
		CALENDAR.AT~
		CASSLAB.AT~
		CASSLINE.AT~
		CDLINER.AT~
		CDNOTES.AT~
		DISKETTE.AT~
		ENVELOPE.AT~
		FAX.AT~
		INVOICE.AT~
		MANUAL.AT~
		NEWSLTR1.AT~ 
		NEWSLTR2.AT~
		PURCHASE.AT~
		VHS.AT~
		}

	FILES CalDir
		{
		APR_1993.TX~
		APR_1994.TX~
		AUG_1993.TX~
		AUG_1994.TX~
		DEC_1993.TX~
		DEC_1994.TX~
		FEB_1993.TX~
		FEB_1994.TX~
		JAN_1993.TX~
		JAN_1994.TX~
		JUL_1993.TX~
		JUL_1994.TX~
		JUN_1993.TX~
		JUN_1994.TX~
		MAR_1993.TX~
		MAR_1994.TX~
		MAY_1993.TX~
		MAY_1994.TX~
		NOV_1993.TX~
		NOV_1994.TX~
		OCT_1993.TX~
		OCT_1994.TX~
		SEP_1993.TX~
		SEP_1994.TX~
		}

	FILES DayDir
		{
		MONDAY.TX~
		TUESDAY.TX~
		WED.TX~
		THURSDAY.TX~
		FRIDAY.TX~
		SATURDAY.TX~
		SUNDAY.TX~
		DAYS.TX~
		}

	FILES AUtilDir
		{
		DICTED.WR~
		SCRPTSPL.TX~
		DE.EX~
		DEAPP.EX~
		PPDLIST.WR~
		COPYFIT.TX~
		WINBUMPS.EX~
		IDUPDATE.EX~
		IDREADME.TX~
		}

	FILES PSTDir
		{
		PPDSHELL.PS~
		PPDSHELL.TX~
		}
	
	FILES PM5Dir
		{
		CALIBRAT.PT~
		NETWORK.WRI
		CLIP.AR~
		README.WRI
		READTHIS.TXT
		TE.EX~
		TEAPP.EX~
		DATETIME.TY~
		CHARSET.PT~
		PM5.EX~
		PM5PART1.12~
		PM5PART2.12~
		}

	FILES ScriptDir
		{
		BIKEWEEL.TX~
		CROP&COL.TX~
		ENVELOP.TX~
		FRACTION.TX~
		HORIZFRC.TX~
		RECIPE.TX~
		STARWRAP.TX~
		CRAYON.TX~
		CRAYONME.TX~
		}		

	FILES LearnDir
		{
		LEARNPM5.HL~
		X2.PT~
		LEARNPM5.PK~
		X3.PT~
		X4.PT~
		X5.PT~
		X6.PT~
		X7.RT~
		X8.PT~
		X9.TB~
		LEARNPM5.TR~
		X1.PT~
		TABLE.WM~
		LEARNPM5.IC~
		X10.PT~
		}

	FILES TutExpDir
		{
		GRAPHIC.TIF
		_TEXT.TX~
		}
	FILES TutLess1Dir
		{
		LOGOTYPE.TIF
		TEXT_.TX~
		}

	FILES TutLess2Dir
		{
		BROC_US.PT~
		BROC_INT.PT~
		SMLTABLE.TIF
		VIATEXT.RT~
		BIGTABLE.TIF
		}		  

	FILES WinDir
		{
		ALDLEARN.DL~
	   	PKWTUTOR.IN~	
		PCDLIB.DL~
		PCDIMP.HL~
		PANOSE.DA~
		TWAIN.DL~
		CHREXPC.TB~
		CHRIMPC.TB~
		PXENGWIN.DL~
		}			    

	Files APPD4Dir
		{
		CGENERAL.PP~
		GENERAL.PP~
		}

	/**** end File Subdirectory Assignments ****/

	DISPLAY PPDwarning

	SELECT1 "Select Printer Devices" APPD4Dir NOSELECTALL
		{
		TEXT
			{
			"Select the Printer Files you wish to install:"
			}
		ITEMS
			{
/*list updated */	ALJII523.PP~	"Adobe LaserJet II Cartridge v52.3",
/*on 6-11-93 5:30pm */	AGACCST1.PP~	"AGFA_AccuSet v52.3",
			AGACCSF1.PP~	"AGFA_AccuSetSF v52.3",
			CG94_493.PP~	"Agfa-Compugraphic 9400P v49.3",
			AGPRO941.PP~	"AGFA_ProSet9400 v52.3",
			AGP94SF1.PP~	"AGFA_ProSet9400SF v52.3",
			AGPR9551.PP~	"AGFA_ProSet9550 v52.3",
			AGP95SF1.PP~	"AGFA_ProSet9550SF v52.3",
			AGPRS961.PP~	"AGFA_ProSet9600 v52.3",
			AGP96SF1.PP~	"AGFA_ProSet9600SF v52.3",
			AGPRO971.PP~	"AGFA_ProSet9700 v52.3",
			AGP97SF1.PP~	"AGFA_ProSet9700SF v52.3",
			AGPRO981.PP~	"AGFA_ProSet9800 v52.3",
			AGP98SF1.PP~	"AGFA_ProSet9800SF v52.3",
			AGSELS51.PP~	"AGFA_SelectSet5000 v52.3",
			AGSL5SF1.PP~	"AGFA_SelectSet5000SF v52.3",
			AGSELS71.PP~	"AGFA_SelectSet7000 v52.3",
			AGSL7SF1.PP~	"AGFA_SelectSet7000SF v52.3",
			AGSTDS21.PP~	"AGFA_StudioSet2000 v49.3, 52.3",
			LWNT_470.PP~	"Apple LaserWriter II NT v47.0",
			LWNTX470.PP~	"Apple LaserWriter II NTX v47.0",
			LWNTX518.PP~	"Apple LaserWriter II NTX v51.8",
			APLWIIG1.PP~	"Apple LaserWriter IIg v2010.113",
			APTOLLD1.PP~	"Apple LaserWriterPro 600-4MB v2010.130",
			APTOLD81.PP~	"Apple LaserWriterPro 600-8MB v2010.130",
			APTOLLW1.PP~	"Apple LaserWriterPro 630 v2010.130",
			APPLE422.PP~	"Apple LaserWriter Plus v42.2",
			CN_500_1.PP~	"Canon PS-IPU Color Copier v52.3",
			CN_500J1.PP~	"Canon PS-IPU Kanji Color Copier v52.3",
			NCOL_519.PP~	"Colormate PS v51.9",
			CPPSA241.PP~	"ColorPoint PS Seiko",
			CPPSB241.PP~	"ColorPoint PSX Seiko",
			CPPMQ151.PP~	"COMPAQ PAGEMARQ 15 v2012.015",
			CPPMQ201.PP~	"COMPAQ PAGEMARQ 20 v2012.015",
			CP301503.PP~	"CorrectPrint 300i v50.3",
			DP_US470.PP~	"Dataproducts LZR 1260 v47.0",
			DCLPS201.PP~	"Digital PrintServer 20 v48.3",
			DCLPS401.PP~	"Digital PrintServer 40 Plus v48.3",
			HPIID522.PP~	"HP LaserJet IID PS Cart. v52.2",
			HPIIP522.PP~	"HP LaserJet IIP PS Cart. v52.2",
			HPIII522.PP~	"HP LaserJet III PS Cart. v52.2",
			HPLJ_31.PP~	"HP LaserJet III PS Plus v2010.118",
			HP_3D522.PP~	"HP LaserJet IIID PS Cart. v52.2",
			HPLJ_3D1.PP~	"HP LaserJet IIID PS Plus v2010.118",
			HP_3P522.PP~	"HP LaserJet IIIP PS Cart. v52.2",
			HPLJ_3P1.PP~	"HP LaserJet IIIP PS Plus v2010.118",
			HP3SI_L1.PP~	"HP LaserJet IIISi v52.3",
			HP3SI_L2.PP~	"HP LaserJet IIISi v2012.021", 
			HP4M6_1.PP~	"HP LaserJet 4",
			HP4M3_1.PP~	"HP LaserJet 4 (300 dpi)",
			HP4SI3_1.PP~	"HP LaserJet 4Si (300 DPI)",
			HP4SI6_1.PP~	"HP LaserJet 4Si v2011.110",
			HPPJXL31.PP~	"HP PaintJet XL300 v2011.112",
			IB4029B1.PP~	"IBM 4029 with 17 Fonts v52.3",
			IB4029A1.PP~	"IBM 4029 with 39 Fonts v52.3",
			IBM17523.PP~	"IBM 4019 17 fonts v52.3 or 52.1",
			IBM39523.PP~	"IBM 4019 39 fonts v52.3 or 52.1",
			IBM30505.PP~	"IBM 4216-030 v50.5",
			L100_425.PP~	"Linotronic 100 v42.5",
			L200_471.PP~	"Linotronic 200 v47.1",
			L200_493.PP~	"Linotronic 200 v49.3",
			L300_471.PP~	"Linotronic 300 v47.1",
			L300_493.PP~	"Linotronic 300 v49.3",
			LH300__1.PP~    "Linotronic 300 v52.3",
			L3330523.PP~	"Linotronic 330-RIP 30 v52.3",
			LH330__1.PP~    "Linotronic 330 v52.3",
			L500_493.PP~	"Linotronic 500 v49.3",
			LH500__1.PP~    "Linotronic 500 v52.3",
			L5330523.PP~	"Linotronic 530-RIP 30 v52.3",
			LH530__1.PP~    "Linotronic 530 v52.3",
			LH630__1.PP~	"Linotronic 630 v52.3",  
			TT1000-4.PP~	"LM TrueImage KX 1000/4",
			TT1200.PP~	"LM TrueImage KX 1200H",
			TT1200XL.PP~	"LM TrueImage KX 1200XL",
			NC95FAX1.PP~	"NEC Silentwriter 95 v2011.111",
			NC97FAX1.PP~	"NEC Silentwriter 97 v2011.111",
			NCN4SF21.PP~	"NEC Silentwriter 80PS2 v2011.110",
			NCN4SF51.PP~	"NEC Silentwriter 80PS5 v2011.110",
			NCSW_951.PP~	"NEC SilentWriter 95 v2010.119",
			NCS29901.PP~	"NEC Silentwriter2 990 v52.3",
			OL830525.PP~	"Oki OL830-PS v52.5", 
			OL840518.PP~	"Oki OL840-PS v51.8", 
			P4455514.PP~	"Panasonic KX-P4455 v51.4",
			CPPER241.PP~	"Personal ColorPoint PS",
			CPPRO518.PP~	"Professional ColorPoint",
			QMSCS494.PP~	"QMS ColorScript 100 v49.4",
			QCS10503.PP~	"QMS ColorScript 100 Model 10 v50.3",
			QCS30503.PP~	"QMS ColorScript 100 Model 30 v50.3",
			QMPS4101.PP~	"QMS-PS 410 v52.4",
			QMS8_461.PP~	"QMS-PS 800 v46.1",
			QMS8P461.PP~	"QMS-PS 800 Plus v46.1",
			QMS81470.PP~	"QMS-PS 810 v47.0",
			Q810T517.PP~	"QMS-PS 810 Turbo v. 51.7",
			QMPS8151.PP~	"QMS-PS 815 v52.4",
			QM815MR1.PP~	"QMS-PS 815 MR v52.4",
			Q820_517.PP~	"QMS-PS 820 v51.7",
			Q820T517.PP~	"QMS-PS 820 Turbo v51.7",
			QMPS8251.PP~	"QMS-PS 825 v52.4",
			QM825MR1.PP~	"QMS-PS 825 MR v52.4",
			QM1700_1.PP~	"QMS-PS 1700 v52.4",
			QM2000_1.PP~	"QMS-PS 2000 v52.4",
			SCTXDOLV.PP~	"Scitex Dolev PS.PPD",
			STDLV400.PP~	"Scitex Dolev400 PS.PPD",
			NCSW_951.PP~	"SilentWriter 95",
			N890_470.PP~	"Silentwriter LC 890 v47.0",
			N890X505.PP~	"Silentwriter LC 890XL v50.5",
			N2290520.PP~	"Silentwriter2",
			N2290520.PP~	"Silentwriter2 290 v52.0",
			N2090522.PP~	"Silentwriter2 Model 90 v52.2",
			TK200171.PP~	"Tektronix Phaser 200e, 17 fonts",
			TK200391.PP~	"Tektronix Phaser 200e, 39 fonts",
			TKP200I1.PP~	"Tektronix Phaser 200i v2011.108",
			TKPXE171.PP~	"Tek.Phaser IIPXe 2010.128-17 fonts",
			TKPXE391.PP~	"Tek.Phaser IIPXe 2010.128-39 fonts",
			TKPHZR21.PP~	"Tek.Phaser IIPXi 2010.116",
			TKPHZR22.PP~	"Tek.Phaser IIPXi 2011.108",
			TKPH2SD1.PP~	"Tek.Phaser IISD 2011.108",
			TKPHZR32.PP~	"Tek.Phaser III PXi v2011.108",
			TKPHZR31.PP~	"Tek.Phaser III PXi v2010.116",
			T1535470.PP~	"TI 2115 35 fonts v47.0",
			TI08_450.PP~	"TI OmniLaser 2108 v45.0",
			TIM17521.PP~	"TI microLaser PS17 v.52.1",
			TIM35521.PP~	"TI microLaser PS35 v.52.1",
			TIX17521.PP~	"TI microLaser XL PS17 v.52.1",
			TIX35521.PP~	"TI microLaser XL PS35 v.52.1",
			TITRBO61.PP~	"TI microLaser6 Turbo v2010.119",
			TITRBO91.PP~	"TI microLaser9 Turbo v2010.119",
			TITRB161.PP~	"TI microLaser16 Turbo v2010.119",
			NSC_300P.PP~	"TurboPS/300p",
			NSC_400P.PP~	"TurboPS/400p",
			NSC_440B.PP~	"TurboPS/440B",
			NSC_440N.PP~	"TurboPS/440N",
			NSC440ND.PP~	"TurboPS/440ND",
			NSC_600T.PP~	"TurboPS/600T",
			NSC_630_.PP~	"TurboPS/630",
			NSC_660_.PP~	"TurboPS/660",
			NSC_660B.PP~	"TurboPS/660B",
			NSC_660P.PP~	"TurboPS/660p",
			NSC_840E.PP~	"TurboPS/840",
			NSC_880_.PP~	"TurboPS/880",
			NSC_880P.PP~	"TurboPS/880p",
			NSC1200B.PP~	"TurboPS/1200B",
			NSC1200T.PP~	"TurboPS/1200T",
			U1000.PP~	"Unity 1000 v47.0",
			U1200XL4.PP~	"Unity 1200XL v47.0",
			VT4L3001.PP~	"Varityper 4000-L300 v52.3",
			VT4L3301.PP~	"Varityper 4000-L330 v52.3",
			VT4L5001.PP~	"Varityper 4000-L500 v52.3",
			VT4L5301.PP~	"Varityper 4000-L530 v52.3",
			V5334522.PP~	"Varityper 4000-5300 v49.3or52.2", 
			VT550522.PP~	"Varityper 4000-5500 v52.2",
			VT42P522.PP~	"Varityper 4200B-P v49.3or52.2",
			VT43P522.PP~	"Varityper 4300P v49.3or52.2",
			VT600P1.PP~	"Varityper VT-600P",
			VT60P480.PP~	"Varityper VT-600P v48.0",
			VT600W1.PP~	"Varityper VT-600W v48.0",
			VT49901.PP~	"Varityper VT4990 v52.3",
			VT4510A1.PP~	"Varityper VT4_510A v52.3",
			VT4530A1.PP~	"Varityper VT4_530A v52.3",
			VT4530B1.PP~	"Varityper VT4_530B v52.3",
			VT4530C1.PP~	"Varityper VT4_530C v52.3",
			VT4533B1.PP~	"Varityper VT4_533B v52.3",
			VT4533C1.PP~	"Varityper VT4_533C v52.3",
			VT453EA1.PP~	"Varityper VT4_53EA v52.3",
			VT453EB1.PP~	"Varityper VT4_53EB v52.3",
			VT4550A1.PP~	"Varityper VT4_550A v52.3",
			VT4550B1.PP~	"Varityper VT4_550B v52.3",
			VT4550C1.PP~	"Varityper VT4_550C v52.3",
			VT4551A1.PP~	"Varityper VT4_551A v52.3",
			VT4563A1.PP~	"Varityper VT4_563A v52.3",
			VT4563B1.PP~	"Varityper VT4_563B v52.3",
			WJ1200.PP~	"WinJet 1200",
			WJ800.PP~	"WinJet 800",
			WP800.PP~	"WinPrinter 800",
			XRDT1351.PP~	"Xerox DocuTech 135 v2010.130",
			XRDT0901.PP~	"Xerox DocuTech 90 v2010.130"
			}
		HELP
			{
			"PageMaker uses printer description files when"
			"printing on PostScript printers.  Select the printer"
			"description file that best matches your PostScript"
			"printer type.  (If you don't have a PostScript printer"
			"you do not have to select a file.)"
			" "
			"Hold the Ctrl key down as you click to select"
			"multiple files to install."
			}

		}  /**** end select ppds  ***/	


	/**** INI Initializations ****/

	CONCAT PM5Dir "pm5.exe ^.pt5" PT5_ExtText
	CONCAT PM5Dir "pm5.exe ^.pm5" PM5_ExtText
	CONCAT PM5Dir "te.exe ^.tbl"  TE_ExtText


	/**** INI Settings ****/

	ALDUSINI
		{
		"ATG" "Templates" TemplateDir,
		"Bullets" "Bullet1" "149,12,18,Times New Roman",
		"Bullets" "Bullet2" "110,12,18,Wingdings",
		"Bullets" "Bullet3" "111,12,18,Wingdings",
		"Bullets" "Bullet4" "168,12,2,Symbol",
		"Bullets" "Bullet5" "214,12,18,Symbol",
		"PageMaker5" "Maximize" "1",	      
		"PageMaker5" "AltTextWrap" "0",	      
		"PageMaker5" "ListVectors" "0",
		"PageMaker5" "SlideTimer" "2",
		"PageMaker5" "Color" "1",
		"PageMaker5" "RGBShade" "1",
		"PageMaker5" "ColorBitmaps" "1",
		"PageMaker5" "StyleBar" "1",
		"PageMaker5" "DisplayMarks" "0",
		"PageMaker5" "LearnPM5" LearnDir
		} 

	WININI
		{
		"Aldus" "AldusDirectory" AldDir,
		"Aldus" "NetAldusDirectory" "NONE",
		"Aldus" "PPD4" APPD4Dir,
		"Aldus"	"PM5LangDir" "USENGLSH",
		"Aldus"	"PM5AppDir" PM5Dir,
		"Extensions" "pt5" PT5_ExtText,
		"Extensions" "pm5" PM5_ExtText,
		"Extensions" "tbl" TE_ExtText,
		"Extensions" "HLP" "WINHELP.EXE ^.hlp"
		}

	/*** Oninstall initializations ***/

	SET ExeInstalled "TRUE"
	SET PrinterDrivers "TRUE"
	SET FullInstallation "TRUE"
	CONCAT SetupDir "aldsetup.exe /I" FullInstallerName
	CONCAT PM5Dir "PM5.exe" FullPMName
	CONCAT PM5Dir "te.exe" TableEditorName		    
	CONCAT PM5Dir "README.WRI" ReadMeName		    
	CONCAT PM5Dir "READTHIS.TXT" ReadThisName		    
	CONCAT WinDir "NOTEPAD.EXE" NoteIconName		    
	CONCAT AutilDir "de.exe" DictEdName		    
	CONCAT LearnDir "learnpm5.hlp" LearnTutorName
	CONCAT LearnDir "learnpm5.ico" LearnIconName

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		COPY AldDir "ALDFONTA.FON" EngDir "ALDFONTA.FON"
		COPY AldDir "ALDFONTB.FON" EngDir "ALDFONTB.FON"
		COPY AldDir "ALDFONTE.FON" EngDir "ALDFONTE.FON"
		COPY AldDir "ALDFONTF.FON" EngDir "ALDFONTF.FON"

		ASSEMBLE "PM5APP.EXE"
			{
			PM5PART1.12~
			PM5PART2.12~
			}		      

		PERSONALIZE EngDir "PM5RES.RSL"
		
		DELETEPROGRAMITEM "Aldus" "Aldus Setup"
		DELETEPROGRAMITEM "Aldus" "Aldus PageMaker 5.0"
		DELETEPROGRAMITEM "Aldus" "Table Editor 2.1"
		DELETEPROGRAMITEM "Aldus" "Learning PageMaker 5.0"
		DELETEPROGRAMITEM "Aldus" "Dictionary Editor 1.0" 
		DELETEPROGRAMITEM "Aldus" "PageMaker 5.0 ReadMe"
		DELETEPROGRAMITEM "Aldus" "PageMaker 5.0 Install Notes"
  

		ADDPROGRAMITEM "Aldus" FullInstallerName "Aldus Setup" FullInstallerName 0
		ADDPROGRAMITEM "Aldus" FullPMName "Aldus PageMaker 5.0" FullPMName 0
		ADDPROGRAMITEM "Aldus" TableEditorName "Table Editor 2.1" TableEditorName 0  
		ADDPROGRAMITEM "Aldus" LearnTutorName "Learning PageMaker 5.0" LearnIconName 0	
		ADDPROGRAMITEM "Aldus" DictEdName "Dictionary Editor 1.0" DictEdName 0	
		ADDPROGRAMITEM "Aldus" ReadMeName "PageMaker 5.0 ReadMe" NoteIconName 0	
		ADDPROGRAMITEM "Aldus" ReadThisName "PageMaker 5.0 Install Notes" NoteIconName 0	

		DISPLAY AldusGroup

		WINDOWSMENU PM5Dir "READTHIS.TXT" "&READTHIS.TXT" 



		}	/** End Oninstall **/

	}	/***** END PageMaker Easy Install *****/


PACKAGE BlankLine "----------------------------------------------------" UNSELECTED
{
SET Fred "Barney"
}

PACKAGE PageMaker "PageMaker 5.0 (9MB)" UNSELECTED
	{
	/**** Package Initializations *****/

	GETALDDIR AldDir AldusLocation
	CONFIRMDIR PM5Dir
	SET Serialize "TRUE"

	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "SETUP" SetupDir
	CONCAT EngDir "FILTERS" AFiltDir
	CONCAT AFiltDir "AFILTERS" AddFiltDir
	CONCAT EngDir "COLOR" AColorDir
	CONCAT EngDir "ADDITION" AADDitionDir
	CONCAT AADDitionDir "TEMPLATE" TemplateDir
	CONCAT TemplateDir "CALDATES" CalDir
	CONCAT CalDir "DAYS" DayDir
	CONCAT EngDir "PPD4" APPD4Dir
	CONCAT EngDir "UTILITY" AUtilDir
	CONCAT AUtilDir "PS_TOOLS" PSTDir
	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "tutorial" TutRootDir
	CONCAT PM5Dir "SCRIPTS" ScriptDir
	CONCAT TutRootDir "explore" TutExpDir
	CONCAT TutRootDir "LESSON1" TutLess1Dir
	CONCAT TutRootDir "LESSON2" TutLess2Dir

	BMPFILE 2INTGRT.BMP
	BMPFILE 1REGSTR.BMP
	BMPFILE 4PRE_US.BMP 
	BMPFILE 3VERS_US.BMP
	BMPFILE 5CROSSUS.BMP
	BMPFILE 8ONLINE.BMP
	BMPFILE 7FAXYI.BMP
	BMPFILE 6CUSTFIR.BMP 

	/**** File Subdirectory Assignments *****/


	FILES AldDir     
		{
		ALDFONTB.FO~
		ALDFONTE.FO~
		ALDFONTF.FO~
		ALDFS.DL~
		ALDFONTA.FO~
		ALDPLS2.DL~
		ALDWPLS.DL~
		ALDIM3.DL~
		ALDCLP5.DL~
		ALDNCD.DL~
		ALDVM.DL~
		PCDLIB.DL~
		PICTWMF.DL~
		NWNETAPI.DL~
		PRXLNGST.DL~
		}

	FILES EngDir
		{
		ALDCLP5R.RS~
		PM5RES.RS~
		ALDFSRES.RS~
		ALDUSN.MS~
		ALDVMRES.RS~
		ALDUSN.UD~
		ALDUSN.NF~
		ALDUSN.BP~
		ALDUSN00.VP~
		PM5.HL~
		ALDIM3RS.RS~
		PRXLNGST.RS~
		MAI.DL~
		PM5SHORT.HL~
		TE.HL~
		TRAKVALS.BI~
		ALDWPLSR.RS~
		}

	FILES SetupDir
		{
		ALDSETUP.EXE
		PM5_144.CTL
		}

	FILES AFiltDir
		{
		ASCIIEXP.FL~
		RTFIMP.FL~
		TEXTIMP.FL~
		EPSIMP.FL~
		WMFIMP.FL~
		}

	FILES AddFiltDir
		{
		EPSIMPND.FL~
		}

	FILES AColorDir
		{
		PCSG.BC~
		TOYOPC.BC~
		TRUMATCH.BC~
		CRAYON.AC~
		FOCOLTON.BC~
		DIC-PCN.BC~
		GREYS.AC~
		PCSGE.BC~
		MHICPC.BC~
		MUNPC.BC~
		PANTONEC.BC~
		PANTONEU.BC~
		PANTONPE.BC~
		PANTONEP.BC~
		}

	FILES AADDitionDir
		{
		LIBRARY.PA~
		LIBLOADR.AD~
		OPENTEMP.AD~
		RUNSCRIP.AD~
		ALDCOLOR.AD~
		}

	FILES TemplateDir
		{
		ATG.TR~
		AVERY.AT~
		BROCHUR1.AT~
		BROCHUR2.AT~
		CALENDAR.AT~
		CASSLAB.AT~
		CASSLINE.AT~
		CDLINER.AT~
		CDNOTES.AT~
		DISKETTE.AT~
		ENVELOPE.AT~
		FAX.AT~
		INVOICE.AT~
		MANUAL.AT~
		NEWSLTR1.AT~ 
		NEWSLTR2.AT~
		PURCHASE.AT~
		VHS.AT~
		}

	FILES CalDir
		{
		APR_1993.TX~
		APR_1994.TX~
		AUG_1993.TX~
		AUG_1994.TX~
		DEC_1993.TX~
		DEC_1994.TX~
		FEB_1993.TX~
		FEB_1994.TX~
		JAN_1993.TX~
		JAN_1994.TX~
		JUL_1993.TX~
		JUL_1994.TX~
		JUN_1993.TX~
		JUN_1994.TX~
		MAR_1993.TX~
		MAR_1994.TX~
		MAY_1993.TX~
		MAY_1994.TX~
		NOV_1993.TX~
		NOV_1994.TX~
		OCT_1993.TX~
		OCT_1994.TX~
		SEP_1993.TX~
		SEP_1994.TX~
		}

	FILES DayDir
		{
		MONDAY.TX~
		TUESDAY.TX~
		WED.TX~
		THURSDAY.TX~
		FRIDAY.TX~
		SATURDAY.TX~
		SUNDAY.TX~
		DAYS.TX~
		}

	FILES APPD4Dir
		{
		LWNT_470.PP~
		CGENERAL.PP~
		GENERAL.PP~
		}

	FILES AUtilDir
		{
		DICTED.WR~
		SCRPTSPL.TX~
		PPDLIST.WR~
		COPYFIT.TX~
		DE.EX~
		DEAPP.EX~
		WINBUMPS.EX~
		IDUPDATE.EX~
		IDREADME.TX~
		}

	FILES PSTDir
		{
		PPDSHELL.PS~
		PPDSHELL.TX~
		}

	FILES PM5Dir
		{
		CALIBRAT.PT~
		NETWORK.WRI
		README.WRI
		READTHIS.TXT
		TE.EX~
		TEAPP.EX~
		CHARSET.PT~
		PM5.EX~
		PM5PART1.12~
		PM5PART2.12~
		}

	FILES ScriptDir
		{
		BIKEWEEL.TX~
		CROP&COL.TX~
		ENVELOP.TX~
		FRACTION.TX~
		HORIZFRC.TX~
		RECIPE.TX~
		STARWRAP.TX~
		CRAYON.TX~
		CRAYONME.TX~
		}		

	FILES WinDir
		{
		PCDIMP.HL~
		PCDLIB.DL~
		TWAIN.DL~
		PANOSE.DA~
		PXENGWIN.DL~
		}

	/**** end File Subdirectory Assignments ****/


	/**** INI Initializations ****/

	CONCAT PM5Dir "pm5.exe ^.pt5" PT5_ExtText
	CONCAT PM5Dir "pm5.exe ^.pm5" PM5_ExtText
	CONCAT PM5Dir "te.exe ^.tbl"  TE_ExtText

	/**** INI Settings ****/

	ALDUSINI
		{
		"Bullets" "Bullet1" "149,12,18,Times New Roman",
		"Bullets" "Bullet2" "110,12,18,Wingdings",
		"Bullets" "Bullet3" "111,12,18,Wingdings",
		"Bullets" "Bullet4" "168,12,2,Symbol",
		"Bullets" "Bullet5" "214,12,18,Symbol",
		"PageMaker5" "Maximize" "1",	      
		"PageMaker5" "AltTextWrap" "0",	      
		"PageMaker5" "ListVectors" "0",
		"PageMaker5" "SlideTimer" "2",
		"PageMaker5" "Color" "1",
		"PageMaker5" "RGBShade" "1",
		"PageMaker5" "ColorBitmaps" "1",
		"PageMaker5" "StyleBar" "1",
		"PageMaker5" "DisplayMarks" "0"
		} 

	WININI
		{
		"Aldus" "AldusDirectory" AldDir,
		"Aldus" "NetAldusDirectory" "NONE",
		"Aldus"	"PM5LangDir" "USENGLSH",
		"Aldus"	"PM5AppDir" PM5Dir,
		"Aldus" "PPD4" APPD4Dir,
		"Extensions" "pt5" PT5_ExtText,
		"Extensions" "pm5" PM5_ExtText,
		"Extensions" "tbl" TE_ExtText,
		"Extensions" "HLP" "WINHELP.EXE ^.hlp"
		}


	/*** Oninstall initializations ***/

	SET ExeInstalled "TRUE"
	SET PrinterDrivers "TRUE"
	CONCAT SetupDir "aldsetup.exe /I" FullInstallerName
	CONCAT PM5Dir "PM5.exe" FullPMName
	CONCAT AutilDir "de.exe" DictEdName		    
	CONCAT PM5Dir "te.exe" TableEditorName
	CONCAT PM5Dir "README.WRI" ReadMeName		    
	CONCAT PM5Dir "READTHIS.TXT" ReadThisName		    
	CONCAT WinDir "NOTEPAD.EXE" NoteIconName		    

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		COPY AldDir "ALDFONTA.FON" EngDir "ALDFONTA.FON"
		COPY AldDir "ALDFONTB.FON" EngDir "ALDFONTB.FON"
		COPY AldDir "ALDFONTE.FON" EngDir "ALDFONTE.FON"
		COPY AldDir "ALDFONTF.FON" EngDir "ALDFONTF.FON"

		IF FullInstallation EQS "FALSE"
			{

			ASSEMBLE "PM5APP.EXE"
				{
				PM5PART1.12~
				PM5PART2.12~
				}		      

			PERSONALIZE EngDir "PM5RES.RSL"

			} 


		DELETEPROGRAMITEM "Aldus" "Aldus Setup"
		DELETEPROGRAMITEM "Aldus" "Aldus PageMaker 5.0"
		DELETEPROGRAMITEM "Aldus" "Table Editor 2.1"
		DELETEPROGRAMITEM "Aldus" "Dictionary Editor 1.0" 
		DELETEPROGRAMITEM "Aldus" "PageMaker 5.0 ReadMe"
		DELETEPROGRAMITEM "Aldus" "PageMaker 5.0 Install Notes"

		ADDPROGRAMITEM "Aldus" FullInstallerName "Aldus Setup" FullInstallerName 0
		ADDPROGRAMITEM "Aldus" FullPMName "Aldus PageMaker 5.0" FullPMName 0
		ADDPROGRAMITEM "Aldus" TableEditorName "Table Editor 2.1" TableEditorName 0 
		ADDPROGRAMITEM "Aldus" DictEdName "Dictionary Editor 1.0" DictEdName 0	
		ADDPROGRAMITEM "Aldus" ReadMeName "PageMaker 5.0 ReadMe" NoteIconName 0	
		ADDPROGRAMITEM "Aldus" ReadThisName "PageMaker 5.0 Install Notes" NoteIconName 0	

		DISPLAY AldusGroup

		WINDOWSMENU PM5Dir "READTHIS.TXT" "&READTHIS.TXT" 


		}	/** End Oninstall **/

	}	/***** END PageMaker *****/


PACKAGE Tutorial "Tutorial (2MB)" UNSELECTED
	{
	/**** Package Initializations *****/
	GETALDDIR AldDir AldusLocation
	CONFIRMDIR PM5Dir

	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "FILTERS" AFiltDir
	CONCAT AFiltDir "AFILTERS" AddFiltDir
	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "tutorial" TutRootDir
	CONCAT TutRootDir "explore" TutExpDir
	CONCAT TutRootDir "LESSON1" TutLess1Dir
	CONCAT TutRootDir "LESSON2" TutLess2Dir

	/**** File Subdirectory Assignments *****/

	FILES AFiltDir
		{
		WMFIMP.FL~
		EPSIMP.FL~
		}
	
	FILES AddFiltDir
		{
		EPSIMPND.FL~
		}

	FILES AldDir     
		{
		PKWTUTOR.EX~
		PKWTUT1.DL~
		PKWTUT2.DL~
		PKWTUT3.DL~
		}

	FILES LearnDir
		{
		LEARNPM5.HL~
		X2.PT~
		LEARNPM5.PK~
		X3.PT~
		X4.PT~
		X5.PT~
		X6.PT~
		X7.RT~
		X8.PT~
		X9.TB~
		LEARNPM5.TR~
		X1.PT~
		TABLE.WM~
		LEARNPM5.IC~
		X10.PT~
		}

	FILES TutExpDir
		{
		GRAPHIC.TIF
		_TEXT.TX~
		}
	FILES TutLess1Dir
		{
		LOGOTYPE.TIF
		TEXT_.TX~
		}

	FILES TutLess2Dir
		{
		BROC_US.PT~
		BROC_INT.PT~
		SMLTABLE.TIF
		VIATEXT.RT~
		BIGTABLE.TIF
		}		  

	FILES WinDir
		{
		ALDLEARN.DL~
	   	PKWTUTOR.IN~	
		}			    

	/**** INI Settings ****/

	ALDUSINI
		{
		"PageMaker5" "LearnPM5" LearnDir
		}

	/*** Oninstall initializations ***/

	CONCAT LearnDir "learnpm5.hlp" LearnTutorName
	CONCAT LearnDir "learnpm5.ico" LearnIconName

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		DELETEPROGRAMITEM "Aldus" "Learning PageMaker 5.0" 

		ADDPROGRAMITEM "Aldus" LearnTutorName "Learning PageMaker 5.0" LearnIconName 0	
		}

	}	/***** END Tutorial *****/


PACKAGE Filters "Filters (2MB)" UNSELECTED
	{
	/**** Package Initializations *****/

	CONFIRMDIR PM5Dir
	GETALDDIR AldDir AldusLocation
	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "FILTERS" AFiltDir
	CONCAT AFiltDir "AFILTERS" AddFiltDir

	FILES PM5Dir
		{
		DATETIME.TY~
		CLIP.AR~
		}

	FILES WinDir
		{
		PCDLIB.DL~
		PCDIMP.HL~
		TWAIN.DL~
		PANOSE.DA~
		CHREXPC.TB~
		CHRIMPC.TB~
		}

	FILES AddFiltDir
		{
		EPSIMPND.FL~
		}

	SELECT1 "Select filters" AFiltDir
		{
		TEXT
			{
			"Select the filters you want to install:"
			}
		ITEMS
			{
			ADIIMP.FL~ "ADI (.PLT) Import",
			ADIIMP.FL~ "ADI (.ADI) Import",
			AMIIMP.FL~ "Ami Pro Import",      
			CGMIMP.FL~ "CGM Graphics Import",	  
			ARTIMP.HL~+
			ARTIMP.FL~ "Clip ART Import",	  
			DBSIMP.FL~ "dBase Import",
			DCAIMP.FL~ "DCA Import",
			DXFIMP.FL~ "AutoCAD (.DXF) Import",	    
			DECWPIMP.FL~ "DEC-WPS Import",    
			EPSIMP.FL~ "EPS Import",
			EXCELIMP.FL~ "Excel Spreadsheet Import",	   
			CHARTIMP.FL~ "Excel Chart Import",
			GEMIMP.FL~ "GEM Import",	   
			HPGLIMP.FL~ "HPGL Import",
			LOTUSIMP.FL~ "Lotus 1-2-3 (.PIC) Import",
			123IMP.FL~ "Lotus 1-2-3 Rel 1A (.WKS) Import",
			123IMP.FL~ "Lotus 1-2-3 Rel 2-2.2 (.WK1) Import",
			123IMP.FL~ "Lotus 1-2-3 Rel 3 (.WK3) Import",
			MSWDIMP.FL~ "Microsoft Windows Write Import",
			MSWDIMP.FL~ "Microsoft Word Import",
			MULTIIMP.FL~ "MultiMate/Advantage II Import",
			PM5IMP.FL~ "PageMaker Pub (.PM5) Import",
			PMIMP.P5~ "PageMaker Story Import",
			PM5IMP.FL~ "PageMaker Template (.PT5) Import",
			PCDIMP.FL~ "Kodak PhotoCD (.PCD) Import",	
			PCXIMP.FL~ "ZSoft Format (.PCX) Import",
			PICTIMP.FL~ "PICT Import",
			DCAIMP.FL~ "RFT Import",
			RTFIMP.FL~ "Rich Text Format (RTF) Import",
			123IMP.FL~ "Symphony 1.0-1.01 (.WRK) Import",
			123IMP.FL~ "Symphony 1.1-2.0 (.WR1) Import",
			TEIMP.FL~ "Table Editor Import",
			TEKIMP.FL~ "Tektronix PLOT-10 Import",
			TEXTIMP.FL~ "Text-Only Import",	      
			TIMEIMP.FL~ "Time Stamp Import",
			TWAINIMP.FL~ "Twain Image Acquisition Import",
			VIDSHIMP.FL~ "VideoShow (NAPLPS) Import",
			DRAWIMP.FL~ "Windows Draw Import",	       
			WMFIMP.FL~ "Windows Metafile Import",
			WINWDIMP.FL~ "Word for Windows 1.0 Import",
			WNWD2IMP.FL~ "Word for Windows 2.0 Import",
			WP4IMP.FL~ "WordPerfect 4.2 Import",
			WP5IMP.FL~ "WordPerfect 5.0-5.1 Import",
			WPGIMP.FL~ "WordPerfect Graphics (.WPG) Import",	   
			WSTRIMP.FL~ "WordStar (.WS) Import",
			WSTRIMP.FL~ "WordStar (.WST) Import",
			VPIMP.FL~ "Ventura Publisher Import",
			XY3IMP.FL~ "XYWrite III Import",
			/*					*/
			/* These are the export filters         */
			/*					*/
			ASCIIEXP.FL~ "ASCII Text Export",
			DCAEXP.FL~ "DCA/RFT Export",
			MSWDEXP.FL~ "Microsoft Windows Write Export",
			MSWDEXP.FL~ "Microsoft Word 3.0 - 5.x Export",
			RTFEXP.FL~ "Rich Text Format (RTF) Export",
			WP5EXP.FL~ "WordPerfect 5.0-5.1 Export",	    
			XY3EXP.FL~ "XYWrite III Export"
			}
		HELP
			{
			"PageMaker uses filters to export and"
			"import files to and from other applications."
			" "
			"Select multiple filters by holding the"
			"Ctrl key down as you click on the filter"
			"name.  You can install additional filters"
			"at any time."
			}

		}  /*** End Select Filters ****/


	}   /*** END Filters Package ***/


PACKAGE Additions  "Additions (2.5MB)"  UNSELECTED
{
	/**** Package Initializations *****/

	GETALDDIR AldDir AldusLocation
	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "ADDITION" AADDitionDir
	CONCAT EngDir "FILTERS" AFiltDir
	CONCAT AADDitionDir "TEMPLATE" TemplateDir

	/**** File Subdirectory Assignments *****/
	
	FILES WinDir
		{
		PXENGWIN.DL~
		}
	
	SELECT1 "Select Additions" AADDitionDir
		{
		TEXT
			{
			"Select the Additions you want to install:"
			}
		ITEMS
			{
			ACQUIRE.AD~	"Acquire image...",
			CONTINUE.AD~	"Add cont'd line...",
			BALANCEC.AD~	"Balance columns...",
			BLDBKLT.AD~	"Build booklet...",
			NUMPARAS.AD~	"Bullets and numbering...",
			ALDCOLOR.AD~	"Create color library...",
			KEYLINE.AD~	"Create keyline...",
			PUBINFO.AD~	"Display pub info...",
			STRYINFO.AD~	"Display story info...",
			HOLEINFO.AD~	"Display textblock info",
			DROPCAP.AD~	"Drop cap...",
			TRACKER.AD~	"Edit tracks...",
			DINGWIN.CH~+
			EXPWIN.CH~+
			KERNWIN.CH~+
			EXPKERN.AD~	"Expert kerning...",
			OVERSET.AD~	"Find overset text",
			LIBRARY.PA~+
			LIBLOADR.AD~	"Library palette",
			LISTSTYL.AD~	"List styles used",
			OPENSTOR.AD~	"Open stories",
			PSTYLES.AD~	"Printer Styles",
			GROUPIT.AD~	"PS Group it",
			RUNSCRIP.AD~	"Run script...",
			HEADERS.AD~	"Running headers/footers...",
			PAGESORT.AD~	"Sort pages...",
			HOLEHOP.AD~	"Traverse textblocks..."
			}
		HELP
			{
			"Aldus Additions customize and extend"
			"PageMaker capabilities."
			" "
			"We recommend that you install all of the"
			"Additions; they do not take up much disk"
			"space or affect PageMaker's speed."
			}
		}  /****  End Select Additions ****/
	
	ALDUSINI
		{
		"Bullets" "Bullet1" "149,12,18,Times New Roman",
		"Bullets" "Bullet2" "110,12,18,Wingdings",
		"Bullets" "Bullet3" "111,12,18,Wingdings",
		"Bullets" "Bullet4" "168,12,2,Symbol",
		"Bullets" "Bullet5" "214,12,18,Symbol"
		}
		
	}  /*** END of ADDITIONS package ***/


PACKAGE PPDs "Printer files (1MB)" UNSELECTED
{
	GETALDDIR AldDir AldusLocation
	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "UTILITY" AUtilDir
	CONCAT AUtilDir "PS_TOOLS" PSTDir
	CONCAT EngDir "PPD4" APPD4Dir

	FILES PSTDir
		{
		PPDSHELL.PS~
		PPDSHELL.TX~
		}

	Files APPD4Dir
		{
		CGENERAL.PP~
		GENERAL.PP~
		}

	DISPLAY PPDwarning

	SELECT1 "Select Printer Devices" APPD4Dir NOSELECTALL
		{
		TEXT
			{
			"Select the Printer files you wish to install:"
			}
		ITEMS
			{
/*list updated */	ALJII523.PP~	"Adobe LaserJet II Cartridge v52.3",
/*on 6-11-93 5:30pm */	AGACCST1.PP~	"AGFA_AccuSet v52.3",
			AGACCSF1.PP~	"AGFA_AccuSetSF v52.3",
			CG94_493.PP~	"Agfa-Compugraphic 9400P v49.3",
			AGPRO941.PP~	"AGFA_ProSet9400 v52.3",
			AGP94SF1.PP~	"AGFA_ProSet9400SF v52.3",
			AGPR9551.PP~	"AGFA_ProSet9550 v52.3",
			AGP95SF1.PP~	"AGFA_ProSet9550SF v52.3",
			AGPRS961.PP~	"AGFA_ProSet9600 v52.3",
			AGP96SF1.PP~	"AGFA_ProSet9600SF v52.3",
			AGPRO971.PP~	"AGFA_ProSet9700 v52.3",
			AGP97SF1.PP~	"AGFA_ProSet9700SF v52.3",
			AGPRO981.PP~	"AGFA_ProSet9800 v52.3",
			AGP98SF1.PP~	"AGFA_ProSet9800SF v52.3",
			AGSELS51.PP~	"AGFA_SelectSet5000 v52.3",
			AGSL5SF1.PP~	"AGFA_SelectSet5000SF v52.3",
			AGSELS71.PP~	"AGFA_SelectSet7000 v52.3",
			AGSL7SF1.PP~	"AGFA_SelectSet7000SF v52.3",
			AGSTDS21.PP~	"AGFA_StudioSet2000 v49.3, 52.3",
			LWNT_470.PP~	"Apple LaserWriter II NT v47.0",
			LWNTX470.PP~	"Apple LaserWriter II NTX v47.0",
			LWNTX518.PP~	"Apple LaserWriter II NTX v51.8",
			APLWIIG1.PP~	"Apple LaserWriter IIg v2010.113",
			APTOLLD1.PP~	"Apple LaserWriterPro 600-4MB v2010.130",
			APTOLD81.PP~	"Apple LaserWriterPro 600-8MB v2010.130",
			APTOLLW1.PP~	"Apple LaserWriterPro 630 v2010.130",
			APPLE422.PP~	"Apple LaserWriter Plus v42.2",
			CN_500_1.PP~	"Canon PS-IPU Color Copier v52.3",
			CN_500J1.PP~	"Canon PS-IPU Kanji Color Copier v52.3",
			NCOL_519.PP~	"Colormate PS v51.9",
			CPPSA241.PP~	"ColorPoint PS Seiko",
			CPPSB241.PP~	"ColorPoint PSX Seiko",
			CPPMQ151.PP~	"COMPAQ PAGEMARQ 15 v2012.015",
			CPPMQ201.PP~	"COMPAQ PAGEMARQ 20 v2012.015",
			CP301503.PP~	"CorrectPrint 300i v50.3",
			DP_US470.PP~	"Dataproducts LZR 1260 v47.0",
			DCLPS201.PP~	"Digital PrintServer 20 v48.3",
			DCLPS401.PP~	"Digital PrintServer 40 Plus v48.3",
			HPIID522.PP~	"HP LaserJet IID PS Cart. v52.2",
			HPIIP522.PP~	"HP LaserJet IIP PS Cart. v52.2",
			HPIII522.PP~	"HP LaserJet III PS Cart. v52.2",
			HPLJ_31.PP~	"HP LaserJet III PS Plus v2010.118",
			HP_3D522.PP~	"HP LaserJet IIID PS Cart. v52.2",
			HPLJ_3D1.PP~	"HP LaserJet IIID PS Plus v2010.118",
			HP_3P522.PP~	"HP LaserJet IIIP PS Cart. v52.2",
			HPLJ_3P1.PP~	"HP LaserJet IIIP PS Plus v2010.118",
			HP3SI_L1.PP~	"HP LaserJet IIISi v52.3",
			HP3SI_L2.PP~	"HP LaserJet IIISi v2012.021", 
			HP4M6_1.PP~	"HP LaserJet 4",
			HP4M3_1.PP~	"HP LaserJet 4 (300 dpi)",
			HP4SI3_1.PP~	"HP LaserJet 4Si (300 DPI)",
			HP4SI6_1.PP~	"HP LaserJet 4Si v2011.110",
			HPPJXL31.PP~	"HP PaintJet XL300 v2011.112",
			IB4029B1.PP~	"IBM 4029 with 17 Fonts v52.3",
			IB4029A1.PP~	"IBM 4029 with 39 Fonts v52.3",
			IBM17523.PP~	"IBM 4019 17 fonts v52.3 or 52.1",
			IBM39523.PP~	"IBM 4019 39 fonts v52.3 or 52.1",
			IBM30505.PP~	"IBM 4216-030 v50.5",
			L100_425.PP~	"Linotronic 100 v42.5",
			L200_471.PP~	"Linotronic 200 v47.1",
			L200_493.PP~	"Linotronic 200 v49.3",
			L300_471.PP~	"Linotronic 300 v47.1",
			L300_493.PP~	"Linotronic 300 v49.3",
			LH300__1.PP~    "Linotronic 300 v52.3",
			L3330523.PP~	"Linotronic 330-RIP 30 v52.3",
			LH330__1.PP~    "Linotronic 330 v52.3",
			L500_493.PP~	"Linotronic 500 v49.3",
			LH500__1.PP~    "Linotronic 500 v52.3",
			L5330523.PP~	"Linotronic 530-RIP 30 v52.3",
			LH530__1.PP~    "Linotronic 530 v52.3",
			LH630__1.PP~	"Linotronic 630 v52.3",  
			TT1000-4.PP~	"LM TrueImage KX 1000/4",
			TT1200.PP~	"LM TrueImage KX 1200H",
			TT1200XL.PP~	"LM TrueImage KX 1200XL",
			NC95FAX1.PP~	"NEC Silentwriter 95 v2011.111",
			NC97FAX1.PP~	"NEC Silentwriter 97 v2011.111",
			NCN4SF21.PP~	"NEC Silentwriter 80PS2 v2011.110",
			NCN4SF51.PP~	"NEC Silentwriter 80PS5 v2011.110",
			NCSW_951.PP~	"NEC SilentWriter 95 v2010.119",
			NCS29901.PP~	"NEC Silentwriter2 990 v52.3",
			OL830525.PP~	"Oki OL830-PS v52.5", 
			OL840518.PP~	"Oki OL840-PS v51.8", 
			P4455514.PP~	"Panasonic KX-P4455 v51.4",
			CPPER241.PP~	"Personal ColorPoint PS",
			CPPRO518.PP~	"Professional ColorPoint",
			QMSCS494.PP~	"QMS ColorScript 100 v49.4",
			QCS10503.PP~	"QMS ColorScript 100 Model 10 v50.3",
			QCS30503.PP~	"QMS ColorScript 100 Model 30 v50.3",
			QMPS4101.PP~	"QMS-PS 410 v52.4",
			QMS8_461.PP~	"QMS-PS 800 v46.1",
			QMS8P461.PP~	"QMS-PS 800 Plus v46.1",
			QMS81470.PP~	"QMS-PS 810 v47.0",
			Q810T517.PP~	"QMS-PS 810 Turbo v. 51.7",
			QMPS8151.PP~	"QMS-PS 815 v52.4",
			QM815MR1.PP~	"QMS-PS 815 MR v52.4",
			Q820_517.PP~	"QMS-PS 820 v51.7",
			Q820T517.PP~	"QMS-PS 820 Turbo v51.7",
			QMPS8251.PP~	"QMS-PS 825 v52.4",
			QM825MR1.PP~	"QMS-PS 825 MR v52.4",
			QM1700_1.PP~	"QMS-PS 1700 v52.4",
			QM2000_1.PP~	"QMS-PS 2000 v52.4",
			SCTXDOLV.PP~	"Scitex Dolev PS.PPD",
			STDLV400.PP~	"Scitex Dolev400 PS.PPD",
			NCSW_951.PP~	"SilentWriter 95",
			N890_470.PP~	"Silentwriter LC 890 v47.0",
			N890X505.PP~	"Silentwriter LC 890XL v50.5",
			N2290520.PP~	"Silentwriter2",
			N2290520.PP~	"Silentwriter2 290 v52.0",
			N2090522.PP~	"Silentwriter2 Model 90 v52.2",
			TK200171.PP~	"Tektronix Phaser 200e, 17 fonts",
			TK200391.PP~	"Tektronix Phaser 200e, 39 fonts",
			TKP200I1.PP~	"Tektronix Phaser 200i v2011.108",
			TKPXE171.PP~	"Tek.Phaser IIPXe 2010.128-17 fonts",
			TKPXE391.PP~	"Tek.Phaser IIPXe 2010.128-39 fonts",
			TKPHZR21.PP~	"Tek.Phaser IIPXi 2010.116",
			TKPHZR22.PP~	"Tek.Phaser IIPXi 2011.108",
			TKPH2SD1.PP~	"Tek.Phaser IISD 2011.108",
			TKPHZR32.PP~	"Tek.Phaser III PXi v2011.108",
			TKPHZR31.PP~	"Tek.Phaser III PXi v2010.116",
			T1535470.PP~	"TI 2115 35 fonts v47.0",
			TI08_450.PP~	"TI OmniLaser 2108 v45.0",
			TIM17521.PP~	"TI microLaser PS17 v.52.1",
			TIM35521.PP~	"TI microLaser PS35 v.52.1",
			TIX17521.PP~	"TI microLaser XL PS17 v.52.1",
			TIX35521.PP~	"TI microLaser XL PS35 v.52.1",
			TITRBO61.PP~	"TI microLaser6 Turbo v2010.119",
			TITRBO91.PP~	"TI microLaser9 Turbo v2010.119",
			TITRB161.PP~	"TI microLaser16 Turbo v2010.119",
			NSC_300P.PP~	"TurboPS/300p",
			NSC_400P.PP~	"TurboPS/400p",
			NSC_440B.PP~	"TurboPS/440B",
			NSC_440N.PP~	"TurboPS/440N",
			NSC440ND.PP~	"TurboPS/440ND",
			NSC_600T.PP~	"TurboPS/600T",
			NSC_630_.PP~	"TurboPS/630",
			NSC_660_.PP~	"TurboPS/660",
			NSC_660B.PP~	"TurboPS/660B",
			NSC_660P.PP~	"TurboPS/660p",
			NSC_840E.PP~	"TurboPS/840",
			NSC_880_.PP~	"TurboPS/880",
			NSC_880P.PP~	"TurboPS/880p",
			NSC1200B.PP~	"TurboPS/1200B",
			NSC1200T.PP~	"TurboPS/1200T",
			U1000.PP~	"Unity 1000 v47.0",
			U1200XL4.PP~	"Unity 1200XL v47.0",
			VT4L3001.PP~	"Varityper 4000-L300 v52.3",
			VT4L3301.PP~	"Varityper 4000-L330 v52.3",
			VT4L5001.PP~	"Varityper 4000-L500 v52.3",
			VT4L5301.PP~	"Varityper 4000-L530 v52.3",
			V5334522.PP~	"Varityper 4000-5300 v49.3or52.2", 
			VT550522.PP~	"Varityper 4000-5500 v52.2",
			VT42P522.PP~	"Varityper 4200B-P v49.3or52.2",
			VT43P522.PP~	"Varityper 4300P v49.3or52.2",
			VT600P1.PP~	"Varityper VT-600P",
			VT60P480.PP~	"Varityper VT-600P v48.0",
			VT600W1.PP~	"Varityper VT-600W v48.0",
			VT49901.PP~	"Varityper VT4990 v52.3",
			VT4510A1.PP~	"Varityper VT4_510A v52.3",
			VT4530A1.PP~	"Varityper VT4_530A v52.3",
			VT4530B1.PP~	"Varityper VT4_530B v52.3",
			VT4530C1.PP~	"Varityper VT4_530C v52.3",
			VT4533B1.PP~	"Varityper VT4_533B v52.3",
			VT4533C1.PP~	"Varityper VT4_533C v52.3",
			VT453EA1.PP~	"Varityper VT4_53EA v52.3",
			VT453EB1.PP~	"Varityper VT4_53EB v52.3",
			VT4550A1.PP~	"Varityper VT4_550A v52.3",
			VT4550B1.PP~	"Varityper VT4_550B v52.3",
			VT4550C1.PP~	"Varityper VT4_550C v52.3",
			VT4551A1.PP~	"Varityper VT4_551A v52.3",
			VT4563A1.PP~	"Varityper VT4_563A v52.3",
			VT4563B1.PP~	"Varityper VT4_563B v52.3",
			WJ1200.PP~	"WinJet 1200",
			WJ800.PP~	"WinJet 800",
			WP800.PP~	"WinPrinter 800",
			XRDT1351.PP~	"Xerox DocuTech 135 v2010.130",
			XRDT0901.PP~	"Xerox DocuTech 90 v2010.130"
			}
		HELP
			{
			"PageMaker uses printer description files when"
			"printing on PostScript printers.  Select the printer"
			"description file that best matches your PostScript"
			"printer type.  (If you don't have a PostScript printer"
			"you do not have to select a file.)"
			" "
			"Hold the Ctrl key down as you click to select"
			"multiple files to install."
			}
		}  /*** End select ppds *****/	

	/**** INI Settings ****/

	WININI
		{
		"Aldus" "PPD4" APPD4Dir
		} 

	SET PrinterDrivers "TRUE"


	}  /*** END of PPD package ***/



PACKAGE LastPREinstall "" SELECTED INVISIBLE
	{
	IF Serialize EQS "TRUE"
		{
        	GETPERSONAL
		}
	}

PACKAGE LastOninstalls "" SELECTED INVISIBLE
	{

	/***  Stuff to be done after all other ONINSTALL's are completed ***/

	CONCAT WinDir "CONTROL.EXE" WinCtl	
	CONCAT WinDir "CONTROL.EXE" WinCtl	

	ONINSTALL
		{
		IF ExeInstalled EQS "FALSE"
			{
	        	DISPLAY SucNoRead
			}

		IF ExeInstalled EQS "TRUE"
			{
			CONCAT PM5Dir "PM5.EXE %1" FullOpenName
			CONCAT PM5Dir "PM5.EXE /p %1" FullPrintName

			ADDOLEREGKEY "OLE_ROOT" "PageMaker5\shell\open\command"
			ADDOLEREGKEY "OLE_ROOT" "PageMaker5\shell\print\command"

			SETOLEREGVALUE "PageMaker5" "PageMaker 5.0 Publication"
			SETOLEREGVALUE "PageMaker5\shell\open\command" FullOpenName
			SETOLEREGVALUE "PageMaker5\shell\print\command" FullPrintName

			ADDOLEREGKEY "OLE_ROOT" ".pm5"
			SETOLEREGVALUE ".pm5" "PageMaker5"
			
			ADDOLEREGKEY "OLE_ROOT" ".pt5"
			SETOLEREGVALUE ".pt5" "PageMaker5"

			}
		
		IF PrinterDrivers EQS "TRUE"
			{
			CD WinDir
			DISPLAY PrintInfo    
			LAUNCH WinCtl "Printers"    
			DISPLAY SucRead 
			}

		IF ExeInstalled EQS "TRUE"
			{
			DISPLAY MoreInfo
			}

		}  /**** End Oninstall ****/

	}  /***** End LastOninstalls ****/




/****
	Use EPILOGUE only for options which should be run when the
	user clicks the EXIT button from ALDSETUP

PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
    {
        DISPLAY RebootReminder

    }
****/

