%==Variables================================================================%

"true" 1 set
"false" 0 set

%---------------------------------------------------------------------------%

% for quick-search feature: the font and char for the next search %
"_qfind" 0 set
"_Qft" 0 set
"_Qch" 0 set

%---------------------------------------------------------------------------%

; directory for reading document and ascii file
"_Readdir" (docdir) getinfo xchg pop 0 get set

%---------------------------------------------------------------------------%

% used to access the info of a cursor list %
"_Para" 0 set
"_Line" 1 set
"_Offset" 2 set
; "_Column" 3 set

%---------------------------------------------------------------------------%

% insert mode %
"_Ins" 0 set
; "_Type" 1 set
; "_strike" 2 set

%---------------------------------------------------------------------------%

% cursor position %
"_Intext" 0 set
"_Inbox" 1 set
"_Intab" 2 set

%---------------------------------------------------------------------------%

"_Rubnames"
(  (AHNormalH AHBoldH AHDoubleH AHDottedH)
   (AVNormalH AVBoldH AVDoubleH AVDottedH)
) set

%---------------------------------------------------------------------------%

"_Mathbox" boxlist qsort set

%---------------------------------------------------------------------------%

; search and replace options
"_SearchOpt" (0 0 0) set
"_ReplOpt" (0 0 0 0) set

%--Utility functions--------------------------------------------------------%

"case"
; selects and executes an expression from a list
; x (x1 y1 x2 y2 ... NIL y0) case
; ==> if( x == xi || xi == NIL ) eval yi
(  "_Tmp" undef
   length 0
   (dup 2 ndup lt?)
   (  2 ndup 1 ndup get
      dup NIL eq?
      (pop "_Tmp" xchg set dup)
      (4 ndup eq? ("_Tmp" xchg set dup) if)
      ifelse
      2 add
   ) while
   pop pop xchg pop
   "_Tmp" def?
   (_Tmp 1 add get eval)
   (pop)
   ifelse
) def

%---------------------------------------------------------------------------%

"dbox"
(  xchg
   getinfo
   2 rol
   dialog
   0 eq?
   (putinfo) (pop pop) ifelse
)
def

%---------------------------------------------------------------------------%

"equal?"
(  length 2 rol length dup
   3 rol eq?
   (  true
      (1 ndup 1 ndup and)
      (  pop 1 sub
         2 ndup 1 ndup get
         2 ndup 2 ndup get
         eq?
      ) while
      -3 rol -2 rol pop pop
      0 eq? and
   )
   (pop pop pop NIL)
   ifelse
) def

%---------------------------------------------------------------------------%

"fontkey"
(  (0 do-font) copy xchg pop     % make fresh copy %
   1 ndup 0 put
   2 ndup xchg assign
   setfontkey
) def

%---------------------------------------------------------------------------%

"forall"
(  xchg
   0
   ( dup 2 rol length 2 rol gt? )
   ( dup 2 rol dup -2 rol get 3 rol dup -4 rol eval 1 add )
   while
   pop pop pop
) def

%---------------------------------------------------------------------------%

"getoffset"
;; usage: l x getoffset => o
;; search for element x in list l and returns the offset
(  0
   (  dup 3 ndup length xchg pop ge?
      ( false )
      ( 2 ndup 1 ndup get 2 ndup ne? )
      ifelse
   )
   (  1 add )
   while
   xchg pop xchg pop
)
def

%---------------------------------------------------------------------------%

"insertstr"
(  length
   0
   (1 ndup 1 ndup gt?)
   (  2 ndup 1 ndup get
      getfont xchg
      _Ins insert  ; ft ch mode insert
      1 add
   )
   while
   pop pop pop
) def

%---------------------------------------------------------------------------%

"menu"
(  getoption
   dup
   (  length
      3 ge?
      ( 2 get eval )
      ( pop % <Sorry--not implemented> message % )
      ifelse
   )
   ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"menu2"
(  getoption
   dup (2 get eval) if
) def

%==Menu and Keyboard Actions================================================%

"*addcol"
(  wherecursor
   dup _Inbox eq?
   (pop _addboxcol)
   (  _Intab eq?
      (0 xchg addcol)
      (Curbox message)
      ifelse
   )
   ifelse
) def

%---------------------------------------------------------------------------%

"*addband"
(  (0 0 0)
   AddbandDlg dialog
   0 eq?
   (  _Rubnames
      1 ndup 0 get get
      1 ndup 1 get get
      xchg 2 get neg -1 -1 1 -4 rol addrb
   )
   (pop)
   ifelse
) def

%---------------------------------------------------------------------------%

"*again" (1 cmove _search) def
; called by: Ctrl-L key

%---------------------------------------------------------------------------%

"*boxfmt"
(  "_Tmpcur" wherecursor set
   _Tmpcur _Intext eq?
   (Curbox message beep)
   (  _Tmpcur _Inbox eq?
      ((boxcolalign boxtabchar boxbline boxlevelx))
      ((boxcolalign boxtabchar boxtabpos boxcolwidth))
      ifelse
      getinfo
      _Tmpcur _Inbox eq? (BoxDlg) (TableDlg) ifelse
      dialog 0 eq?
      (  ;switch to the following order: (width tabchar align tabpos...)
         copy xchg
         0 get xchg
         dup 3 get 0 put
         dup 2 get 3 put
         xchg 2 put
         xchg
         copy xchg
         0 get xchg
         dup 3 get 0 put
         dup 2 get 3 put
         xchg 2 put
         xchg
         putinfo
      )
      (pop pop)
      ifelse
   )
   ifelse
) def

%---------------------------------------------------------------------------%

"*cellfmt"
(  (cellAlign) getinfo
   CellfmtDlg
   dialog 0 eq? (putinfo) (pop pop) ifelse
) def

%---------------------------------------------------------------------------%

"*center"
(  wherecursor _Intext eq? 0 grid? and
   (  (dpwid dlmrg drmrg) getinfo xchg pop
      column neg cmove
      dup 1 get unit2col cmove
      dup 0 get xchg dup 1 get xchg 2 get addunit subunit unit2col
      end home sub
      sub 2 div
      cmove
      *lm
   )
   (formatnextpar (pformat) (2) putinfo)
   ifelse
) def

%---------------------------------------------------------------------------%

"*change" (marked? (mark change) (_warnmark) ifelse) def

%---------------------------------------------------------------------------%

"*chgfmt"
; offset in Paragraph dialog     *chgfmt ==>
; 1 = justification
; 2 = left margin
; 3 = right margin
; 4 = indent
; 5 = spacing
(  formatnextpar
   dup (pformat plmrg prmrg pindent pspace) xchg 1 sub get ; get getinfo name
   (NIL) xchg 0 put ; put getinfo name in list
   ChgfmtDlg
   ParDlg
   3 rol ; get offset in ParDlg dialog
   get ; get that line from ParDlg dialog
   1 put ; and put it into the ChgFmdDlg dialog
   dbox
) def

%---------------------------------------------------------------------------%

"*chgname"
(  windowtype 0 ne? (endHF) if
   (dname) getinfo
   ChgnameDlg dialog
   0 eq?
   (  dup 0 get checkname dup
      0 eq?
      ( pop dup 0 get ( docextn docdir ) getinfo xchg pop dup 0 get xchg 1 get filename 0 put putinfo )
      (  1 eq?
         ( Nameused message beep pop pop )
         (  Overwrite menu2
            0 eq? 
            ( dup 0 get ( docextn docdir ) getinfo xchg pop dup 0 get xchg 1 get filename 0 put putinfo )
            ( pop pop )
            ifelse
         )
         ifelse
      )
      ifelse
   )
   ( pop pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*chgwin"
(
  _markoff
  windowtype 0 ge?
  windowtype 3 le?
  and
  ( windowtype dup
    dup 0 ne? (endHF) if
    2 rol 1 eq? ( nextwindow ) ( prevwindow ) ifelse
    xchg
    dup 3 eq? 
    ( pop *openhdr )
    ( dup 2 eq?
      ( pop *openftr )
      ( 1 eq?
        ( moveto *openfn )
        ( switchdoc )
        ifelse
      )
      ifelse
    )
    ifelse
  )
  ( pop )
  ifelse
) def

%---------------------------------------------------------------------------%

"*clip"
(  graphpar?
   (  Cliplist menu2
      dup NIL ne? ( clipgraph ) if pop
   )
   (  Curgr message beep  )
   ifelse
) def

%---------------------------------------------------------------------------%

"*cut"
(  marked?
   (  mark cut saveitem
      Cut message
   )
   (_warnmark)
   ifelse
) def

%---------------------------------------------------------------------------%

"*ctrlret" ; ADDED IN 4.20
; for when Control-Return is hit
; if cursor is inside a box, add column (old Control-Return definition)
; if cursor is in normal text, apply current style
(  wherecursor          ; 0: in text, 1: in a box, 2: in a table paragraph
   ( 0 1 addrow )
   ( getstyle split applystyle )
   ifelse
) def

%---------------------------------------------------------------------------%

"*defkey"
; called by: Keyseq menu, Ctrl-D key
(  keyrec?
   (NIL keyseq)
   (  "_Keyname"
      Attachto menu2
      (_ksname) (_kskey) ifelse
      set
      _Keyname
      (  true _Keyname def?
         (  pop
            Prevassign menu2
            dup (_Keyname undef) if
         ) if
         (_Keyname keyseq Endks message) if
      ) if
   )
   ifelse
) def

%---------------------------------------------------------------------------%

"*del"
; used by: Del key
(  marked?
   ( kill )
   ( delete ) ifelse
) def

%---------------------------------------------------------------------------%

"*delline"
; delete the line containing the cursor
; called by: delRow, Ctrl-Bksp key
(  column
   getcur _Line get
   home cmoveto
   0 grid?
   (  (height depth) getinfo xchg pop
      dup 0 get 3 sub newoffset
      1 get
   ) if
   mark end cmoveto
   0 grid? (neg newoffset) if
   kill
   emptypar?
   ( pop deletepar )
   ( getcur _Line get gt? ( 1 lmove ) if ) ifelse
   cmoveto
) def

%---------------------------------------------------------------------------%

"*delword"
; called by: Ctrl-W key
(  marked? (beep) (wordstart moveto mark wordend moveto kill) ifelse
) def

%---------------------------------------------------------------------------%

"*docfmt"
(  _markoff
   windowtype 0 ne? (endHF) if
   ( dorient ) getinfo 0 get
   ( dtmrg dbmrg dlmrg drmrg dpwid dplen dtabstop dhthres dorient dwidow )
   DocDlg dbox
   xchg getinfo xchg pop 0 get
   ne?
   ( _evalstyle ) if
) def

%---------------------------------------------------------------------------%

"*doclist"
(  _markoff
   windowtype 0 ne? (endHF) if
   ( NIL ) curdoc 1 sub 0 put
   DoclistDlg
   ( table "" NIL 5 1 )
   doclist 2 put 1 put
   dialog
   xchg 0 get 1 add xchg
   (  0     ( switchdoc )
      1     ( switchdoc Write menu )
      2     ( writeall pop pop )
      NIL   ( pop )
   ) case
) def

%---------------------------------------------------------------------------%

"*dup"
(  marked?
   (  mark duplicate saveitem
      Copy message
   )
   (_warnmark)
   ifelse
) def

%---------------------------------------------------------------------------%

"*editgr"
(  graphpar?
   (  ( NIL NIL NIL NIL NIL NIL NIL NIL )
      0 prepgraph EditgrDlg dialog
      0 eq? ( 0 editgraph ) if
      pop
   )
   (  Curgr message beep  )
   ifelse
) def

%---------------------------------------------------------------------------%

"*fontchg"
(  marked?
   (  Fromfont message
      readkey
      dup 'Return' eq?
      (pop 0 do-font)
      (  getkeyfont dup 0 gt?
         (do-font)
         (pop beep)
         ifelse
      )
      ifelse
   )
   (_warnmark)
   ifelse
) def

%---------------------------------------------------------------------------%

"*fontlst"
(  ( 0 )
   FontlstDlg
   dup 1 get
   1 fontlist
   2 put pop
   dialog
   (  0     (  marked? not
               (0 get 1 add dup changefont changefont)
               ( 0 get 1 add dup 0 -2 rol *change)
               ifelse
            )
      1     (0 get dup
               _warnf1
               (1 add dup Assgft message _readfont Main setmenuline)
               (pop)
               ifelse
            )
      2     (0 get dup
               _warnf1
               (1 add deletefont display)
               (pop)
               ifelse
            )
      NIL   (pop)
   )
   case
) def

%---------------------------------------------------------------------------%

"*fnfmt"
(  (dseptor fspace dfnote) getinfo
   FnDlg dialog
   0 eq?
   ( putinfo )
   ( pop pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*global" ;
(  (docdir) getinfo 0 get
   (  defunit stline mnline scbar insmode docdir docextn backdir backfreq ksfile
      stylefile ; ADDED IN 4.20
   )
   getinfo
   GlobDlg dialog
   (  0     (putinfo)
      1     (putinfo *writecon)
      NIL   (pop pop)
   )
   case
   xchg getinfo xchg pop 0 get dup 2 rol
   ne? ("_Readdir" xchg set) (pop) ifelse
) def

%---------------------------------------------------------------------------%

"*gopg"
; used by: Ctrl-G, click on page number in status line
(  "_Tmp" ( dpgstart ) getinfo 0 get 1 sub xchg pop set
   ( NIL 1 ) NIL 0 put 1 1 put
   GotopgDlg
   dialog 0 ne?
   windowtype or
   ( pop )
   (  dup 0 get 1 sub _Tmp sub pagetop moveto
      1 get
      dup 1 gt?
      (  0 setrefresh
         <Repositioning cursor...> message
         ( dup 1 gt? )
         ( 1 lmove 1 sub )
         while
         1 setrefresh refresh
      )
      if
      pop
   )
   ifelse
) def

%---------------------------------------------------------------------------%

"*grow"
(  graphpar?
   (  ( NIL NIL ) 2 prepgraph
      GrowDlg
      dialog 0 eq? ( 2 editgraph ) if pop
   )
   (  Curgr message beep  )
   ifelse
) def

%---------------------------------------------------------------------------%

"*hyphen" ; ADDED IN 4.20
(  Hychoice
   menu2
   dup 3 eq? 
   (pop _thresh) 
   (  dup NIL eq? 
      (pop) 
      (hyphenate) 
      ifelse
   )
   ifelse
) def

%---------------------------------------------------------------------------%

"*indent"
(  (pindent)(NIL)
;  column col2unit
   column
   ( dlmrg plmrg ) getinfo xchg pop dup 0 get xchg 1 get addunit unit2col
   sub col2unit
; Comment the following line if you want to use default unit instead of column
;  'c' tounit
   0 put putinfo
) def

%---------------------------------------------------------------------------%

"*index" ; ADDED IN 4.20
;;
;; 1. will only work for normal text
;; 2. get index associated with the current text if one is present
;;    or returns the current text for user editing
;; 3. insert index token
;;
(  windowtype 0 eq?
   (  wherecursor						
      (  beep  )                  ;if in box or tabular paragraph, exit
      (  getcur
         (  NIL  )
         marked?
         (  duplicate mark  )
         (  getindex  )
         ifelse
         0 put                    ;make ( #<block> )
         IndexDlg
         dialog	
         0 eq?
         (  0 get                 ;item to be indexed 
            addindex              ;C module
         )
         (  pop  )
         ifelse
         moveto                   ;restore original position
      )
      ifelse
   ) 
   ( beep )
   ifelse
)
def

%---------------------------------------------------------------------------%

"*ins"
(  (insmode) getinfo dup 0 get not
   0 put putinfo
)def

%---------------------------------------------------------------------------%

"*insctr"
( windowtype 2 eq?
  windowtype 3 eq?
  or
  ( 0 'h' _Ins insert )
  ( windowtype 1 eq? ( 1 _newlevel 0 'x' _Ins insert ) if )
  ifelse
) def

%---------------------------------------------------------------------------%

"*labels" ; ADDED IN 4.20
(  windowtype 0 ne? (endHF) if
   ( 0 0 <TABLE.CHI                   > 1 9999 1 2 6 0 1 NIL 0 )
   (dpmrg pquality) getinfo xchg pop dup -2 rol 0 get 10 put xchg 1 get 11 put
   LabelDlg
   dialog
   0 eq?
      (
         dup 10 get (NIL NIL) xchg 0 put xchg
         dup 11 get 2 rol xchg 1 put

         (dpmrg pquality) xchg putinfo
         labelmerge pop
      )
      ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*linedraw"
(  (0 0)
   LinedrawDlg dialog 0 eq?
   (dup 0 get xchg 1 get 16 mul add linedraw)
   (pop)
   ifelse
) def

%---------------------------------------------------------------------------%

"*lm"
(  (plmrg pindent)(NIL NIL)
   _fromlft 0 put <0> 1 put
   putinfo
) def

%---------------------------------------------------------------------------%

"*mailmrg" ; ADDED IN 4.20
(  windowtype 0 ne? (endHF) if
   ( 0 0 <TABLE.CHI                   > 1 9999 1 0 1 NIL 0)
   (dpmrg pquality) getinfo xchg pop dup -2 rol 0 get 8 put xchg 1 get 9 put
   MailmrgDlg
   dialog
   0 eq?
      (
         dup 8 get (NIL NIL) xchg 0 put xchg
         dup 9 get 2 rol xchg 1 put

         (dpmrg pquality) xchg putinfo
         mailmerge pop
      )
      ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*math"
(  ( 0 )
   MathboxDlg
   dup 1 get
   _Mathbox
   2 put pop
   dialog
   0 eq?
   ( 0 get _Mathbox xchg get createbox )
   ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*matrix"
(  (0 2 2)
   MatrixDlg
   dialog 0 eq?
   (  dup 1 get
      1 ndup 2 get
      2 rol 0 get
      MatrixDlg 1 get 2 get ; get list of box names
      xchg get ; get name of selected box
      dup
      _Tables case ; go to _newtable/_newmatrix
   )
   (pop pop)
   ifelse
) def

%---------------------------------------------------------------------------%

"*newdoc"
(  windowtype 0 ne? (endHF) if
   docmodified?
   (  Docmod menu
      dup 2 eq? (0 0 writedoc pop) if ; Write: first write old doc
      (_newdoc) if   ; Yes or Write: new it
   )
   (_newdoc)
   ifelse
) def

%---------------------------------------------------------------------------%

"*openfn"
; used by: New menu, *chgwin, Ctrl-N key
( windowtype 0 eq?
  graphpar? not
  and
  ( _markoff footnote )
  ( beep ) ifelse
) def

%---------------------------------------------------------------------------%

"*openftr"
; used by: Layout menu, *chgwin
( windowtype 2 eq?
  windowtype 3 eq?
  or
  ( endHF ) if
  windowtype 0 eq?
  ( _markoff footer )
  ( pop beep ) ifelse
) def

%---------------------------------------------------------------------------%

"*openhdr"
; used by: Layout menu, *chgwin
( windowtype 2 eq?
  windowtype 3 eq?
  or
  ( endHF ) if
  windowtype 0 eq?
  ( _markoff header )
  ( pop beep ) ifelse
) def

%---------------------------------------------------------------------------%

"*openhf"
; used by: Layout menu
(  Hflist menu2
   dup NIL ne? 2 rol (pop) ifelse
) def

%---------------------------------------------------------------------------%

"*outdent"
(  ( plmrg pindent ) (NIL NIL)
   _fromind _fromlft copy -3 rol subunit
; Comment the following line if you want to use default unit instead of column
;  'c' tounit
   1 put xchg 0 put
   putinfo
) def

%---------------------------------------------------------------------------%

"*parfmt"
(  (pformat plmrg prmrg pindent pspace pabove pbelow)
   getinfo
   ParDlg
   dialog
   0 eq?
   1 graphpar?
   (  2 ndup 0 get 4 ne?
      ( beep Nogrchg message pop 0 ) if
   ) if
   and
   ( formatnextpar putinfo ) (pop pop) ifelse
) def

%---------------------------------------------------------------------------%

"*paste"
(  marked? (kill) if
   restoreitem true paste
) def

%---------------------------------------------------------------------------%

"*playkey"
; called by: Keyseq menu, Ctrl-K key
(  keyseqlist qsort dup
   (  (0)
      PlaykeyDlg
      dup 1 get 3 ndup 2 put pop
      dialog
      0 eq?
      (  0 get get getbind dup keyseq?
         (sendkeys)
         (pop Notksname message beep)
         ifelse
      )
      (pop pop)
      ifelse
   )
   (pop Noks message beep)
   ifelse
) def

%---------------------------------------------------------------------------%

"*print"
(  windowtype 0 ne? (endHF) if
   marked?
   (  mark duplicate
      tmpdoc 
      false paste updatebreak
      "_Oldfrpg" ( pfrpage ) getinfo xchg pop 0 get set
      ( pfrpage ) ( dpgstart ) getinfo xchg pop putinfo
      _printdoc
      ( pfrpage ) ( _Oldfrpg ) putinfo
      tmpdoc
   )
   ( _printdoc )
   ifelse
) def

%---------------------------------------------------------------------------%

"*prnnum"
(  windowtype 0 ne? (endHF) if
   ( dpgstart dfnstart padcount dpgfont dfnfont ) getinfo
   NumberDlg
   dup 5 get 0 fontlist dup -3 rol 2 put pop
   dup 6 get 2 rol 2 put pop
   dialog
   0 eq?
   ( putinfo )
   ( pop pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*prnopt"
(  ( ppitch pquality ) getinfo xchg pop
   (dpmrg ppitch pquality pcopy ptofile pfrpage ptopage psheets) getinfo
   PrnoptDlg
   dup 2 get style 2 put 2 put
   dialog 
   ( 0   (  windowtype 0 ne? (endHF) if
            marked?
            (  mark duplicate
               tmpdoc
               false paste updatebreak
               _putprnopt
               "_Oldfrpg" ( pfrpage ) getinfo xchg pop 0 get set
               ( pfrpage ) ( dpgstart ) getinfo xchg pop putinfo
               _printdoc
               ( pfrpage ) ( _Oldfrpg ) putinfo
               tmpdoc
            )
            (  _putprnopt
               _printdoc
            )
            ifelse
         )
     1   (  _putprnopt
            checkformat
            ( formatDBX pop )
            if
         )
     NIL  ( pop pop pop )
   ) case
) def

%---------------------------------------------------------------------------%

"*prnset"
(  (pdriver) getinfo 0 get xchg pop
   (pdriver pport pdnstate) getinfo
   PrnsetDlg
   (file "*.prn" NIL)
   _getsysdir 2 put 1 put
   dialog
   xchg dup 0 get NIL dialoglastdir filename 0 put xchg
   dup 1 eq?
   (  pop
      _keepset
      *writecon
   )
   (  0 eq?
      ( _keepset )
      ( pop pop pop )
      ifelse
   )
   ifelse
) def

%---------------------------------------------------------------------------%

"*prnspec"
(   "prnspecial" def?
    ( prnspecial)
    (    ()
         PrnspecDlg
         dialog pop pop
    )
    ifelse
) def

%---------------------------------------------------------------------------%

"*quit"
(  windowtype 0 eq?
   (  1 quit
      (  Confirmquit menu2
         dup 1 eq?
         (NIL quit)
         (2 eq? (writeall (NIL quit) if ) if)
         ifelse
      ) if
   )
   (beep)
   ifelse
) def

%---------------------------------------------------------------------------%

"*read"
(  windowtype 0 ne? (endHF) if
   "_Fileform" 0 set
   _readfile
) def

%---------------------------------------------------------------------------%

"*readasc"
(  windowtype 0 ne? (endHF) if
   "_Fileform" 1 set
   _readfile
) def

%---------------------------------------------------------------------------%

"*readcon"
(  windowtype 0 ne? (endHF) if
   ( <                                        > )
   ReadconDlg
   ( file "*.par" NIL )
   _getsysdir 2 put 1 put
   dialog
   0 eq?
   ( 0 get NIL dialoglastdir filename readparam
     (docdir) getinfo 0 get xchg pop
     "_Readdir" xchg set
   )
   ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*readdic"
(  ( spmaindic spramdic spauxdic spsecdic )
   DictDlg dbox
) def


%---------------------------------------------------------------------------%

"*readgr"
(  emptypar? not
   graphpar?
   or
   (  Noempty message beep )
   (  ( <                                        > 0 NIL )
      (gwidth) getinfo 0 get xchg pop 2 put
      copy xchg 0 get copy xchg pop 0 put
      GraphicsDlg dup 1 get (docdir) getinfo xchg pop 0 get 2 put 1 put
      dialog
      0 eq?
      ( "_Tmp" (pformat) getinfo xchg pop 0 get set
         (pformat) (4) putinfo
         setgraphpar not
         ( (pformat) ( 0 ) _Tmp 0 put putinfo ) if
         updatebreak
      ) if
      pop
   ) ifelse
) def

%--------------------------------------------------------------------------%

"*readkey"
(  ( <                                        > )
   ReadkeyDlg
   (file NIL NIL) (ksextn) getinfo xchg pop 0 get 1 put
   _getsysdir 2 put 1 put
   dialog
   0 eq?
   ( 0 get read not (Openerr message beep) if )
   ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*readsty" ; ADDED IN 4.20
(  windowtype 0 ne? (endHF) if
   ( stylefile ) getinfo xchg pop
   ReadstyDlg dup 1 get _getsysdir 2 put 1 put
   dialog
   0 eq?
   ( 0 get NIL dialoglastdir filename readstyles )
   ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*replace"
(  marked? not
   (  _ReplOpt
      ; kills the search & replace buffers
      ; later we can make a copy of of the replace buffer
      ; but we cannot use the old one because the redo would mess up
      ;0 0 put 0 1 put
      ;;I do not see any problem with the redo
      ;;hence I commented out the above statement 2-12-93 (CL)
      0 0 put 0 1 put
      ReplDlg dialog xchg pop 0 eq?
      (  _ReplOpt 0 get
         _ReplOpt 1 get
         _ReplOpt 2 get
         _ReplOpt 3 get
         ( mnline ) getinfo 0 get
         0 eq?
         (  (1) putinfo replace (mnline) (0) putinfo )
         (  pop replace )
         ifelse
      ) if
   ) if
) def

%---------------------------------------------------------------------------%

"*return" ; ADDED IN 4.20
;  if cursor is in normal text, apply style as specified in 'next' field
(  getstyle ( snext ) getstyleinfo 0 get
   split
   wherecursor not
   ( applystyle )
   ( pop )
   ifelse
   pop pop
) def

%---------------------------------------------------------------------------%

"*rm"
(  (prmrg)(NIL)
   _fromrgt 0 put
   putinfo
) def

%---------------------------------------------------------------------------%

"*scale"
(  graphpar?
   (  ( NIL ) 1 prepgraph
      ScaleDlg
      dialog 0 eq? ( 1 editgraph ) if pop
   )
   (  Curgr message beep  )
   ifelse
) def

%---------------------------------------------------------------------------%

"*search"
; called by: Edit dialog, Ctrl-S key
(  _SearchOpt SearchDlg dialog xchg pop 0 eq?
   (_search) if
) def

%---------------------------------------------------------------------------%

"*shifttab"
(  "_Tabx" -1 set
   "__movefn" (dup 0 eq? (pop _Tabcol) if neg cmove) def
   _movetab
) def

%---------------------------------------------------------------------------%

; REMOVED IN 4.20
;"*showhelp"
;( ( mnline ) getinfo dup 0 get
;  1 eq?
;  ( pop pop showhelp )
;  ( xchg dup ( 1 ) putinfo showhelp xchg putinfo )
;  ifelse
;) def

%---------------------------------------------------------------------------%

"*spell"
(  _markoff
   "_Spfoot" 0 set
   "_Spfootend" 0 set
   ( spellCheck dup )
   ( dup
     1 eq?
     ( pop _correct )
     ( 2 eq?
       ( footend? ( "_Spfootend" 1 set dup -3 rol ) if
         moveto footnote "_Spfoot" 1 set _correct
       )
       ( closewindow _Spfootend  1 eq? ( "_Spfootend" 0 set moveto ) if )
       ifelse
     )
     ifelse
   )
   while
   _markoff
   pop
)  def

%---------------------------------------------------------------------------%

"*split"
; called by: Ctrl-T
(  wherecursor _Intext eq?
   ((prmrg) getinfo _createtab putinfo) if
   splitcol
) def

%---------------------------------------------------------------------------%

"*splitwin"
( _markoff splitwindow )
def

%---------------------------------------------------------------------------%

"*stdgraph"
(  ( ghide gborder galign gwidth ) getinfo xchg pop
   GrsetDlg dialog
   0 eq? ( setgraphval ) if
   pop
) def

%---------------------------------------------------------------------------%

"*style" ; ADDED IN 4.20
(  stylelist dup
   getstyle                      ;get current style
   getoffset ( NIL ) xchg 0 put  ;( n )
   StyleDlg dup 1 get 3 ndup 2 put 1 put
   dialog
   (  0  (  0 get get applystyle )
      1  (  _stydef   )
      2  (  "op" 1 set           ;op == 1 => define
            0 get get            ;style name
            dup _styfmt
         )
      3  (  0 get get removestyle )
      4  (  pop pop *writesty )
     NIL (  pop pop )
   ) case
) def

%---------------------------------------------------------------------------%

"*switchdoc" (_markoff switchdoc) def

%---------------------------------------------------------------------------%

"*tab"
(  "_Tabx" 1 set
   "__movefn" (_Tabcol xchg sub cmove) def
   _movetab
) def

%---------------------------------------------------------------------------%

"*version"
; called by: Options dialog
(() VerDlg dialog pop pop) def

%---------------------------------------------------------------------------%

"*vmove"
; move vertically by x lines or levels (if in grid mode)
; x vmove ==>
; called by: Up/Down keys
(  1 grid?
   (rmove)
   (getcur xchg blmove getcur _afterlmove)
   ifelse
) def

%---------------------------------------------------------------------------%

"*write"
(  windowtype 0 ne? (endHF) if
   "_Fileform" 0 set
   _writefile
) def

%---------------------------------------------------------------------------%

"*writeasc"
(  windowtype 0 ne? (endHF) if
   "_Fileform" 1 set
   _writefile
) def

%---------------------------------------------------------------------------%

"*writecon"
(  windowtype 0 ne? (endHF) if
   ( <CONFIG.PAR                              > )
   WriteconDlg
   dialog
   0 eq?
   ( 0 get writeparam )
   ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*writekey"
(  ( <                                        > )
   WritekeyDlg
   dialog
   0 eq?
   ( 0 get writekeyseq )
   ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*writesty" ; ADDED IN 4.20
(  windowtype 0 ne? (endHF) if
   ( curstylefile ) getinfo xchg pop
   WritestyDlg
   dialog
   0 eq?
   ( 0 get writestyles )
   ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"*zapband"
(  getrb
   dup 0 ge?
   (  dup 2 eq?
      (  pop
         Zapband menu2
         dup NIL eq? (pop) (deleterb) ifelse
      )
      (deleterb)
      ifelse
   )
   (  pop
      Toband message
      beep
   )
   ifelse
) def

%--Helper functions---------------------------------------------------------%

"_addboxcol"
; adds an extra separator column
; used by: *addcol
(  0 setrefresh
   0 1 ndup addcol
   0 xchg addcol
   1 setrefresh refresh
) def

%---------------------------------------------------------------------------%

"_afterlmove"

; c1 c2 _afterlmove
; c1 and c2 are the cursors before and after a lmove
; this function moves the cursor from the baseline to the top or bottom
; of the line if it is a grid line
; called by: *vmove
(  _curcmp dup marked? not and
   (  0 grid?
      (  dup 0 lt?
         ((height) getinfo 0 get xchg pop neg rmove)
         ((depth) getinfo 0 get xchg pop rmove)
         ifelse
      )
      if
   )
   if
   pop
) def

%---------------------------------------------------------------------------%

"_correct"
( moveto
  mark
  moveto
  spChoose
  dup 0 eq?
  ( pop mark inbox? not ( 1 cmove ) if )
  ( 1 eq?
    ( kill true paste inbox? ( -1 cmove ) if )
    ( mark closewindow _Spfootend  1 eq? (pop) if )
    ifelse
  ) ifelse
) def

%---------------------------------------------------------------------------%

"_createtab"
; called by: PI_tab, *split
(  (pformat nlines) getinfo xchg pop
   dup 0 get dup 4 eq? xchg 5 eq? or
   xchg 1 get 1 gt? or
   (Notbl message)
   (  column
      emptypar?
      (maketable)
      (  home cmoveto *lm mark end cmoveto mark cut
         maketable true paste
      )
      ifelse
      cmoveto
   )
   ifelse
) def

%---------------------------------------------------------------------------%

"_curcmp"
; compares the _Para and _Line components of two cursors
; c1 c2 _curcmp ==> x
; x <  0 if c1 < c2
; x == 0 if c1 == c2
; x >  0 if c1 > c2
; called by: _afterlmove
(  1 ndup _Para get
   1 ndup _Para get
   sub dup 0 eq?
   (  pop
      1 ndup _Line get
      1 ndup _Line get
      sub
   )
   if
   -2 rol
   pop pop
) def

%---------------------------------------------------------------------------%

"_evalstyle"
(  resetprn
   style length
   (ppitch) getinfo xchg pop 0 get dup -2 rol
   le? ( pop (ppitch) (0) putinfo 0 ) if
   get eval
) def

%---------------------------------------------------------------------------%

; Distance in default unit that cursor is away from document left margin
"_fromlft"
; used by: *lm, *outdent
;( column col2unit ( dlmrg ) getinfo xchg pop 0 get subunit
(  column ( dlmrg ) getinfo xchg pop 0 get unit2col sub col2unit
) def

%---------------------------------------------------------------------------%

; Distance in default unit that cursor is away from document right margin
"_fromrgt"
; used by: *rm
(  ( dorient ) getinfo xchg pop 0 get
   0 eq?
   ( ( dpwid drmrg ) getinfo xchg pop )
   ( ( dplen drmrg ) getinfo xchg pop )
   ifelse
   dup 0 get xchg 1 get
   subunit unit2col 1 sub column sub
   col2unit
) def

%---------------------------------------------------------------------------%

"_fromind"
; used by: *outdent
(  ( plmrg pindent ) getinfo xchg pop
   dup 0 get xchg 1 get addunit defunits pop tounit
) def

%---------------------------------------------------------------------------%

"_getextn"
; used by: _readfile
(  _Fileform
   0 eq?
   ( (docextn) getinfo 0 get xchg pop )
   ( <.*> )
   ifelse
) def

%---------------------------------------------------------------------------%

"_getsysdir"
(  ( sysdir ) getinfo xchg pop 0 get )
def

%---------------------------------------------------------------------------%

"_gettab"
; used by: _movetab
(  (dlmrg dtabstop) getinfo xchg pop
   dup 1 get unit2col "_Tabcol" xchg set
   0 get unit2col _Tabcol mod column xchg sub
   dup 0 lt? (_Tabcol add) if
   _Tabcol mod
) def

%---------------------------------------------------------------------------%

"_keepset"
; called by: *prnset
(  putinfo
   ( pdriver ) getinfo 0 get xchg pop dup -2 rol
   ne?
   (  ; READS IN PRINTER DRIVER AND EVALUATE THE PITCH PROCEDURE
      resetstr
      "prnspecial" undef
      read
      ( _evalstyle )
      ( Nopdrv message _wait )
      ifelse
   )
   ( pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"_kskey"
; used by: Attachto menu
(  Keydef message
   readkey
   dup 'Esc' eq?
   (pop NIL) if
) def

%---------------------------------------------------------------------------%

"_ksname"
; used by: Attachto menu
(  (NIL)
   <                > copy xchg pop 0 put
   DefkeyDlg
   dialog 0 eq?
   (0 get)
   (pop NIL)
   ifelse
) def

%---------------------------------------------------------------------------%

"_markoff" (marked? (mark) if) def

%---------------------------------------------------------------------------%

"_movetab"
(  atindent?
   (_gettab __movefn *indent)
   (  wherecursor _Intext eq?
      (_gettab __movefn)
      (0 _Tabx cellmove)
      ifelse
   ) ifelse
) def

%---------------------------------------------------------------------------%

"_newdoc"
; called by: *newdoc
(  (dname)
   (NIL)
   <                                        >
   copy xchg pop 0 put
   NewdocDlg dialog 0 eq?
   (  dup 0 get length xchg pop 0 eq? (pop getdefault) if
      putinfo
      newdoc
   )
   (pop pop)
   ifelse
) def

%---------------------------------------------------------------------------%

"_newlevel"
; used in: *insctr, _onbaseln,_scrollv
(baseline add newoffset)
def

%---------------------------------------------------------------------------%

"_newmatrix"
(  0 setrefresh
   createbox
   (dup 1 gt?)
   (  0 -1 addcol
      1 "VBlank" 0 -1 -1 addrb
      0 -1 addcol
      1 sub
   )
   while
   pop
   (dup 1 gt?) (0 -1 addrow 1 sub) while
   pop
   1 setrefresh refresh
) def

%---------------------------------------------------------------------------%

"_newtable"
; tablename rubberbandtype _newtable ==>
(  0 setrefresh
   "_Tmp" xchg set
   createbox
   (dup 2 gt?)
   (  0 -1 addcol
      _Tmp 0 -1 -1 1 -4 rol addrb
      0 -1 addcol
      1 sub
   )
   while
   pop
   1 0 cellmove
   (dup 2 gt?) (0 -1 addrow 1 sub) while
   pop
   -1 0 cellmove
   1 setrefresh refresh
) def

%---------------------------------------------------------------------------%

"_parmove"
; used by: _qhome, _qend
(  getcur 0 _Line put
   dup _Para get 2 rol add
   dup 0 lt? (pop 0) if
   (npars) getinfo xchg pop 0 get
   dup 2 ndup le? (1 sub xchg) if
   pop
   _Para put
   moveto
) def

%---------------------------------------------------------------------------%

"_pgmove"
; used by: _qup, _qdn
(  curpage add pagetop moveto
) def

%---------------------------------------------------------------------------%

"_printdoc"
; called by: *print, *prnopt
(  ( prtype ) getinfo 0 get xchg pop
   (  checkformat
      (  formatDBX
         ( printdoc )
         if
      )
      ( printdoc )
      ifelse
   )
   ( ( pdname ) getinfo 0 get xchg pop Noprn message )
   ifelse
) def

%---------------------------------------------------------------------------%

"_putprnopt"
; called by: *prnopt
(  putinfo
   ( ppitch pquality ) getinfo xchg pop
   equal? not
   ( resetprn style (ppitch) getinfo 0 get xchg pop get eval )
   if
) def

%---------------------------------------------------------------------------%

"_qchar"
; used by: *qfind
(  "_qfind" "_qchar" getbind set
   _Qch 256 lt?
   (_Qft _Qch qsearch dup (moveto) (pop) ifelse)
   (beep)
   ifelse
) def

%---------------------------------------------------------------------------%

"_qdn"
; used by: *qfind
(  "_qfind" "_qdn" getbind set
   0 gt? (1 1 lmove) (0) ifelse
   _pgmove
   -1 lmove
) def

%---------------------------------------------------------------------------%


"_qend"
; used by: *qfind
(  "_qfind" "_qend" getbind set
   0 lt?
   (-1 _parmove) (1 lmove) ifelse
   getcur
   (nlines) getinfo xchg pop 0 get 1 sub
   _Line put
   moveto
   end cmoveto
) def

%---------------------------------------------------------------------------%

"_qhome"
; used by: *qfind
(  "_qfind" "_qend" getbind set
   0 gt?
   (1 _parmove)
   (-1 lmove getcur 0 _Line put moveto)
   ifelse
   home cmoveto
) def

%---------------------------------------------------------------------------%

"_qup"
; used by: *qfind
(  "_qfind" "_qup" getbind set
   0 gt? (1) (0 -1 lmove) ifelse
   _pgmove
) def

%---------------------------------------------------------------------------%

"_readdoc"
; called by: _readfile
(  dup 1 get -2 rol dup 0 get NIL dialoglastdir filename 0 put putinfo
   clearundo _Fileform readdoc
   "_Readdir" dialoglastdir set
) def

%---------------------------------------------------------------------------%

"_readfile"
; called by: *read, *readasc
(  _markoff
   _Fileform
   ( (dname NIL dtabstop) )
   ( (dname NIL NIL ) )
   ifelse
   (NIL 0 0)
   <                                        >
   copy xchg pop 0 put
   _Fileform
   (  ( dtabstop ) getinfo 0 get xchg pop 2 put
      0 1 put
      ReadascDlg
   )
   (  ReaddocDlg
   )
   ifelse
   ( file NIL NIL )
   _Readdir
   2 put 1 put
   dup 1 get _getextn 1 put pop
   dialog
   dup 0 eq?
   (  pop dup 0 get finddoc
      ( Nodup message pop pop)
      (  docmodified?
         ( Docmod menu2
           (   0 (pop pop)
               1  _readdoc
               2  (0 0 writedoc pop _readdoc)
            ) case
         )
         (_readdoc)
         ifelse
      )
      ifelse
   )
   (  1 eq?
      (  wherecursor _Intext eq?
         (  tmpdoc
            dup 1 get -2 rol
            dup 0 get NIL dialoglastdir filename 0 put putinfo
            _Fileform readdoc
            blockHome mark blockEnd mark cut
            tmpdoc
            split split -1 blmove
            false paste updatebreak
         )
         (pop pop Notbox message beep)
         ifelse
      )
      (pop pop)
      ifelse
   )
   ifelse
) def

%---------------------------------------------------------------------------%

"_readfont"
(  ( <                                        > 1 )
   FontDlg
   ( file NIL NIL)
   fontext 1 put
   _getsysdir 2 put 1 put
   dialog
   0 eq?
   ( dup 0 get NIL dialoglastdir filename dup 2 rol 1 get assignfont display )
   if
) def

%---------------------------------------------------------------------------%

"_search"
; used by: *search, *again
(  _SearchOpt 0 get
   _SearchOpt 1 get
   _SearchOpt 2 get
   0
   match
   dup
   (moveto Found message)
   (Notfnd message pop)
   ifelse
) def

%---------------------------------------------------------------------------%

"_styadv" ; ADDED IN 4.20
;
;  called by _stydlg
; <stylename> <newstylename> <newstylename> advlst parmlst Dlg
;     advlst parmlst <= tos
;
(  xchg
   AdvstyDlg
   dup 2 get ; (table "Parent style" NIL 2 5)
   stylelist 2 put pop
   dup 3 get ; (table "Next style" NIL 2 5)
   stylelist op not ( 8 ndup append ) if qsort 2 put pop
   dialog
   0 eq?
   (  xchg 4 rol pop 3 rol pop 2 rol _stydlg )
   (  pop pop pop pop pop pop _styfmt )
   ifelse
) def


%---------------------------------------------------------------------------%

"_stydef" ; ADDED IN 4.20
(  "op" 0 set                    ;op == 0 => define
   0 get get                     ;style name
   (  <          > )
   NewstyDlg
   dialog
   0 eq?
   (  0 get
      _styfmt
   )
   (  pop pop )
   ifelse
) def

%---------------------------------------------------------------------------%

"_stydlg" ; ADDED IN 4.20
;  called by _styfmt or _styadv on OK
; <stylename> <newstylename> <newstylename>  <advlst> <parmlst> Dlg <= tos
(  2 ndup 2 ndup 2 ndup
   dialog
   (  0     (  stylelist
               2 rol 1 ndup
               1 ndup 1 get get
               1 put 1 rol
               op not ( 6 ndup append ) if qsort
               1 ndup 2 get get 2 put
               xchg
               5 ndup            ;... advlist parmlist <stylename> <= tos
               op
               (  editstyle )
               (  definestyle )  ;C module
               ifelse
               pop pop pop pop pop pop
            )
      1     (  _styadv )
      NIL   (  pop pop pop pop pop pop pop pop pop )
   )  case
) def

%---------------------------------------------------------------------------%

"_styfmt" ; ADDED IN 4.20
;; called by _stydef or _styadv on Cancel
;; <stylename> <newstylename> <= tos
(  dup                           ;new style name
   2 ndup
   ( spformat splmrg sprmrg spindent spspacing spabove spbelow sfont NIL NIL NIL )
   getstyleinfo
   xchg pop
   xchg 
   ( stext sparent snext )
   getstyleinfo
   xchg pop xchg pop
   op 0 eq?
   (  <\< None \>>                  ;note the backslashes
      ( stext NIL NIL ) getstyleinfo
      xchg pop xchg 2 put
      5 ndup 1 put
      xchg pop                   ;throw away original advlist
   )
   if
   stylelist 1 ndup 1 get getoffset 1 put
   stylelist 1 ndup 2 get getoffset 2 put
   xchg                          ;stylename advlist parmlist   <- tos
   StyfmtDlg dup 0 get           ;stylename advlist parmlist Dlg (name...)
   5 ndup 1 put pop
   dup 8 get                     ;stylename advlist parmlist Dlg (table...)
   0 fontlist 2 put pop
   _stydlg
) def

%---------------------------------------------------------------------------%

"_thresh" ; ADDED IN 4.20
(  ( dhthres ) getinfo
   ThreshDlg
   dialog
   (  0     ( putinfo )
      NIL   ( pop pop )
   )
   case
) def

%---------------------------------------------------------------------------%

"_wait" (   beep (readkbd not) () while ) def

%---------------------------------------------------------------------------%

"_warnf1"
(  0 eq?
   (  Changef1 menu2
   )
   ( 1 )
   ifelse
) def

%---------------------------------------------------------------------------%

"_warnmark" ( Nomark message beep) def

%---------------------------------------------------------------------------%

"_writefile"
(  ( dname NIL ) getinfo 0 1 put
   _Fileform
   ( ExpascDlg )
   ( WriteDlg )
   ifelse
   dialog
   0 eq?
   (  dup 0 get checkname dup
      1 eq?
      ( pop pop pop Nameused message )
      (  dup
         2 eq?
         ( pop Overwrite menu2 )
         if
         0 eq?
         (  marked?
            (  mark duplicate
               tmpdoc
               false paste updatebreak
               dup 1 get -2 rol putinfo _Fileform writedoc pop
               tmpdoc
            )
            ( dup 1 get -2 rol putinfo _Fileform writedoc ( clearundo ) if )
            ifelse
         )
         ( pop pop )
         ifelse
      )
      ifelse
   )
   (pop pop)
   ifelse
) def

%==Variables and Functions used in ChiWriter================================%

"PI-tab"
% createtab for putinfo -- called from gp_pformat
  redefines *lm so that it doesn't interfere with the
  left margin in putinfo
%
(  "*lm" getbind
   "*lm" () def
   _createtab
   "*lm" xchg set
) def

"PI-create" (column maketable cmoveto) def

%---------------------------------------------------------------------------%

"SpellVal"
;changed from 50 to 64 characters (9-30-92 CL)
( <                                                                > )
set

%---------------------------------------------------------------------------%

"SpellRval" ( ) set

%---------------------------------------------------------------------------%

"cmoveto" (column sub cmove) def

%---------------------------------------------------------------------------%

"delRow"
; called by: Edit|Box|Row|Zap, ChiWriter
(  wherecursor
   dup _Intext ne?
   (  _Inbox eq?
      (deleterow)
      (*delline)
      ifelse
   )
   (pop)
   ifelse
) def

%---------------------------------------------------------------------------%

"endHF"
(  _markoff
   windowtype 0 ge?
   windowtype 3 le?
   and
   ( closewindow )
   ( Nowin message )
   ifelse
) def

%---------------------------------------------------------------------------%

"kill" (mark cut pop) def

%---------------------------------------------------------------------------%

"newoffset"
(  getcur _Offset get
   xchg sub
   dup (rmove) (pop) ifelse
) def

%==Variables and Functions used in Printer Drivers and Key Sequence Files===%

"blockHome"
; called by: Ctrl-Home key, _readfile, envelope key sequences
(  (0 0 0 0) moveto
   home cmoveto
) def

%---------------------------------------------------------------------------%

"blockEnd"
; called by: Ctrl-End key, _readfile, envelope key sequences
(  (npars) getinfo xchg pop 0 get 1 sub
   (0 0 0 0)   % tmp cursor %
   xchg _Para put
   moveto
   getcur
   (nlines) getinfo xchg pop 0 get 1 sub
   _Line put
   moveto
   end cmoveto
) def

%---------------------------------------------------------------------------%

"do-font"
; called by: *fontchg, fontkey, electric font key sequences
(  marked?
   (  Tofont message
      readkey getkeyfont
      dup 0 gt?
      (  dup 2 ndup eq? (xchg pop 0 xchg) if
         0 -2 rol *change
      )
      (pop pop beep)
      ifelse
   )
   (changefont checkfonthelp)
   ifelse
) def

%---------------------------------------------------------------------------%

"formatDBX"
; called from: *prnopt, _printdoc, PostScript printer driver
(  ()
   ReformatDlg
   dialog
   xchg pop
   0 eq?
   (  globalformat clearundo
      1
;     printdoc
   )
   ( 0 )
   ifelse
;  pop
) def


%==Date key sequence========================================================%

"_dateemit"
(  _CountM dup
   (  (  1 ( 0 )
         2 ( 2 )
         3 ( 's' )
         4 ( 'l' )
      )
      case
      'm'  _dmyemit
      "_CountM" 0 set
   )
   ( pop )
   ifelse

   _CountD dup
   (  (  1     ( 0 )
         2     ( 2 )
      )
      case
      'd'  _dmyemit
      "_CountD" 0 set
   )
   ( pop )
   ifelse

   _CountY dup
   (  (  2     ( 2 )
         4     ( 0 )
      )
      case
      'y'  _dmyemit
      "_CountY" 0 set
   )
   ( pop )
   ifelse

) def

%---------------------------------------------------------------------------%

"_datefmt"
(  "_CountM" 0 set "_CountD" 0 set "_CountY" 0 set
   length
   0
   ( 1 ndup 1 ndup dup -2 rol gt? )
   (  3 rol dup 2 rol get xchg -3 rol dup _dmy
      (  1  ( pop "_CountM" _CountM 1 add set )
         2  ( pop "_CountY" _CountY 1 add set )
         0  ( pop "_CountD" _CountD 1 add set )
         NIL   (  _dateemit
                  dup 0 eq? not
                  (getfont xchg _Ins insert)
                  ( pop )
                  ifelse
               )
      )
      case
      1 add
   )
   while
   pop pop pop pop
   _dateemit
) def

%---------------------------------------------------------------------------%

"_dmyemit"
(  (  'd'   ( getdate pop pop )
      'm'   ( getdate pop xchg pop )
      'y'   ( getdate -2 rol pop pop )
   )
   case
   xchg
   (  0     ( 0 num2str insertstr )
      2     ( 2 num2str insertstr )
     's'    ( _Month 0 get xchg get insertstr )
     'l'    ( _Month 1 get xchg get insertstr )
   )
   case
) def

%---------------------------------------------------------------------------%

"Date"
(  (  ( 0 )
      DateDlg
      dup 1 get DateOpt 2 put 1 put
      dialog
      0 eq?
      (  0 get DateOpt xchg get _datefmt )
      ( pop )
      ifelse
   )
) keyset

%==Mouse Interface==========================================================%

"*mouse"
(  wheremouse
   (  0     (_waitrel _instatus)
      1     (_inruler)
      2     (_indoc)
      3     (  windowtype
               (  0     ( otherdoc *switchdoc )
                  1     ( endHF )
                  2     ( endHF )
                  3     ( endHF )
               )
               case
            )
      4     (_scrollv)
      5     (_scrollh)
      6     (windowtype 7 ne? ( Main menu) if )
   ) case
) def

%---------------------------------------------------------------------------%

"_inruler"
(  1 mousecursor
   whereinruler
   _waitrel
   mousepos xchg pop cursorpos xchg pop sub cmove
   (  0     (*lm)
      1     (*rm)
      2     (*indent)
      3     (*indent)
   )
   case
   0 mousecursor
) def

%---------------------------------------------------------------------------%

"_indoc"
(  marked? ( mark ) if
   _mousego
   ( NIL NIL ) mousepos -2 rol 0 put xchg 1 put
   (  mousebutton )
   (  ( NIL NIL ) mousepos -2 rol 0 put xchg 1 put
      copy -2 rol
      equal? not
      (  marked? not ( mark ) if
         _mousego
      )
      if
   )
   while
   pop
   _onbaseln
) def

%---------------------------------------------------------------------------%

"_instatus"
(  whereinstatus
   (  0     (*doclist)
      1     (*fontlst)
      2     (*ins)
      3     (1 *chgfmt)
      4     (5 *chgfmt)
      5     (*gopg)
      6     ( (defunit) UnitDlg dbox )
      7     ( *style )
   )
   case
) def

%---------------------------------------------------------------------------%

"_mousego"
(  mousepos cursorpos xchg pop sub cmove
   cursorpos pop sub dup
   marked? 0 grid? not and
   (  outofline
      ( rmove )
      ( pop )
      ifelse
   )
   ( ( rmove ) ( pop ) ifelse )
   ifelse
   cursorpos xchg pop 0 eq? ( -1 cmove ) if
) def

%---------------------------------------------------------------------------%

"_onbaseln"
(  marked? not 0 grid? not and
   (  getcur _Offset get
      adjustoffset dup
      -2 rol ne?
      ( _newlevel )
      ( pop )
      ifelse
   )
   if
) def

%---------------------------------------------------------------------------%

"_scrollv"
(  whereinscroller
   (  0     (cursorpos pop windowpos pop pop xchg pop sub
             neg rmove 0 _newlevel
            )
      1     (_waitrel -1 1 grid? (blmove) (pmove)  ifelse)
      2     (dragmouse rmove _onbaseln)
      3     (_waitrel 1 1 grid?  (blmove) (pmove)  ifelse)
      4     (windowpos 2 rol sub -2 rol pop pop
               cursorpos pop windowpos pop pop xchg pop sub
               sub 3 add rmove 0 _newlevel
            )
   )
   case
) def

%---------------------------------------------------------------------------%

"_scrollh"
(  whereinscroller
   (  0     (-1 cmove)
      1     (_waitrel column neg cmove)
      2     (dragmouse cmove)
      3     (_waitrel ( dorient dpwid dplen ) getinfo xchg pop
               dup 0 get 0 eq?
               ( 1 get )
               ( 2 get )
               ifelse 
               unit2col column sub cmove)
      4     (1 cmove )
   )
   case
) def

%---------------------------------------------------------------------------%

"_waitrel"
; wait until mouse button released
( ( mousebutton ) () while )
def

%==Top Level Commands========================================================%

"MENU.CS" read not (Nomenu error) if
"KEYS.CS" read not (Nokeys error) if

Main setmenuline

%---------------------------------------------------------------------------%

(pdriver) getinfo 0 get xchg pop
resetstr
read not
( Nopdrv message _wait )
if

%---------------------------------------------------------------------------%

"style" def? ( _evalstyle ) if

%---------------------------------------------------------------------------%

(ksfile) getinfo xchg pop 0 get read pop
"autoexec" getbind keyseq? (autoexec sendkeys) if
