ECHO OFF
ECHO 
ECHO                              ChiWriter  4.2
ECHO                               Installation
ECHO 
IF .==%2. GOTO SYNTAX
FOR %%F IN (A:,B:,C:,D:,E:,F:,G:,H:,I:,J:,K:,L:,M:) DO IF %1.==%%F. GOTO OK
FOR %%F IN (a:,b:,c:,d:,e:,f:,g:,h:,i:,j:,k:,l:,m:) DO IF %1.==%%F. GOTO OK
FOR %%F IN (N:,O:,P:,Q:,R:,S:,T:,U:,V:,W:,X:,Y:,Z:) DO IF %1.==%%F. GOTO OK
FOR %%F IN (n:,o:,p:,q:,r:,s:,t:,u:,v:,w:,x:,y:,z:) DO IF %1.==%%F. GOTO OK

:SYNTAX		      
ECHO 
ECHO                       Installation Instructions
ECHO 
ECHO To install, type
ECHO      A: [Return]
ECHO      INSTALL2  C:  \CW4 [Return]
ECHO 
ECHO FORMAT:  INSTALL#  (drive)  (backslash)(sub-directory)
ECHO 
ECHO (Note the blank space between drive and backslash.) 
ECHO 

GOTO END

:OK
CD %1%2
COPY CONFIG?.PAR %1
COPY CW?.KEY %1
COPY CW?.BOX %1
COPY CW?.HLP %1
COPY FDCONFIG.* %1
COPY MATH?.AUX %1
COPY CONFIG?.ASC %1
COPY FDHELP?.TXT %1

ECHO ---------------------------------------------------------------
ECHO Please select one of the following keyboards:
ECHO        A - USA
ECHO        B - FRENCH CANADIAN
ECHO        C - DANISH
ECHO        D - FRENCH
ECHO        E - GERMAN
ECHO        F - ITALIAN
ECHO        G - NORWEGIAN
ECHO        H - SPANISH
ECHO        I - SWEDISH
ECHO        J - SWISS
ECHO        K - UK
ECHO  
ECHO Enter "A" if you are not sure.
ECHO --------------------------------------------------------------
GETKEY ABCDEFGHIJK
IF ERRORLEVEL 11 GOTO UK
IF ERRORLEVEL 10 GOTO SWISS
IF ERRORLEVEL 9 GOTO SWEDISH
IF ERRORLEVEL 8 GOTO SPANISH
IF ERRORLEVEL 7 GOTO NORWAY
IF ERRORLEVEL 6 GOTO ITALIAN
IF ERRORLEVEL 5 GOTO GERMAN
IF ERRORLEVEL 4 GOTO FRENCH
IF ERRORLEVEL 3 GOTO DANISH
IF ERRORLEVEL 2 GOTO CANADIAN
IF ERRORLEVEL 1 GOTO USA

:USA
COPY USA.KB? %1CONFIG.KBD
GOTO CONT1

:UK
COPY UK.KB? %1CONFIG.KBD
GOTO CONT1

:SWISS
COPY SWISS.KB? %1CONFIG.KBD
GOTO CONT1

:SWEDISH
COPY SWEDISH.KB? %1CONFIG.KBD
GOTO CONT1

:SPANISH
COPY SPANISH.KB? %1CONFIG.KBD
GOTO CONT1

:NORWAY
COPY NORWEGIA.KB? %1CONFIG.KBD
GOTO CONT1

:ITALIAN
COPY ITALIAN.KB? %1CONFIG.KBD
GOTO CONT1

:GERMAN
COPY GERMAN.KB? %1CONFIG.KBD
GOTO CONT1

:FRENCH
COPY FRENCH.KB? %1CONFIG.KBD
GOTO CONT1

:DANISH
COPY DANISH.KB? %1CONFIG.KBD
GOTO CONT1

:CANADIAN
COPY CANADIAN.KB? %1CONFIG.KBD

:CONT1
ECHO 
ECHO Do you want to install the ChiWriter 3 to 4 file converter? (Y/N) 
GETKEY YN
IF ERRORLEVEL 2 GOTO NO324
ECHO 
ECHO Extracting 324 converter
EXTR324 -O %1 > NUL
:NO324

:TEST_MANUAL

ECHO 
ECHO Which type of graphics boards do you have?
ECHO 
ECHO     C  -  CGA (640 x 200 resolution)
ECHO     E  -  EGA
ECHO     V  -  VGA
ECHO     H  -  Hercules Monochrome
ECHO     W  -  Wyse 700 / Amdek 1280
ECHO     M  -  MCGA (IBM PS/2 Model 30)
ECHO     A  -  AT&T/Olivetti (640 x 400 resolution)
ECHO     T  -  Toshiba 1000SE/1000LE/1200/3100/3200/5100 (640 x 400 resolution)
ECHO     N  -  Not sure 
ECHO ---------------------------------------------------------------
ECHO 
ECHO Please enter the letter corresponding to your graphics board.
ECHO If you are not sure, enter "N" to run a screen test routine. 

GETKEY ACEHMTVWN
IF ERRORLEVEL 9 GOTO TEST_SCREEN
IF ERRORLEVEL 8 GOTO WYSE
IF ERRORLEVEL 7 GOTO VGA
IF ERRORLEVEL 6 GOTO TOSH
IF ERRORLEVEL 5 GOTO MCGA
IF ERRORLEVEL 4 GOTO HERC
IF ERRORLEVEL 3 GOTO EGA
IF ERRORLEVEL 2 GOTO CGA
IF ERRORLEVEL 1 GOTO ATT

:TEST_SCREEN
ECHO Testing screen...
TESTSCR
IF ERRORLEVEL 8 GOTO TEST_ERR
IF ERRORLEVEL 7 GOTO TEST_TOSH
IF ERRORLEVEL 6 GOTO TEST_ATT
IF ERRORLEVEL 5 GOTO TEST_SVGA
IF ERRORLEVEL 4 GOTO TEST_VGA
IF ERRORLEVEL 3 GOTO TEST_EGA
IF ERRORLEVEL 2 GOTO TEST_CGA
IF ERRORLEVEL 1 GOTO TEST_HERC

:TEST_ERR

ECHO The installation program was not able to determine the type of your 
ECHO graphic adapter.

GOTO TEST_MANUAL

:TEST_HERC
ECHO The installation program has detected a HERCULES graphics adapter.
ECHO Is this correct? (Y/N) 
GETKEY NY
IF ERRORLEVEL 2 GOTO HERC
GOTO TEST_MANUAL

:TEST_CGA
ECHO The installation program has detected a CGA graphics adapter.
ECHO However, you may have a higher resolution graphics adapter
ECHO (e.g. Wyse/Amdek, AT&T or Toshiba graphics). If you do, you should
ECHO not install the low-resolution CGA but manually select your
ECHO graphics adapter.
ECHO 
ECHO Do you want to install CGA graphics? (Y/N)
GETKEY NY
IF ERRORLEVEL 2 GOTO CGA
GOTO TEST_MANUAL

:TEST_EGA
ECHO The installation program has detected an EGA graphics adapter.
ECHO Is this correct (Y/N)?
GETKEY NY
IF ERRORLEVEL 2 GOTO EGA
GOTO TEST_MANUAL

:TEST_VGA
ECHO The installation program has detected a VGA graphics adapter.
ECHO Is this correct (Y/N)?
GETKEY NY
IF ERRORLEVEL 2 GOTO VGA
GOTO TEST_MANUAL

:TEST_SVGA
ECHO The installation program has detected a SUPER VGA graphics adapter.
ECHO Please note:
ECHO 1. The installation program cannot detect whether you have a super
ECHO    VGA monitor. If you have a standard VGA monitor, you cannot display
ECHO    ChiWriter in super VGA mode.
ECHO 2. ChiWriter does support Super VGA cards that conform to the VESA
ECHO    standard, but it does not work with all cards. If your card is not
ECHO    supported, just run ChiWriter in VGA mode.
ECHO 3. You cannot use the mouse in super VGA mode.
ECHO 
ECHO We will install ChiWriter in VGA mode and also load the super VGA driver.
ECHO To start ChiWriter in super VGA mode, use the command line option
ECHO    CW -SSVGA
ECHO 
ECHO Do you want to install VGA and Super VGA graphics (Y/N)?
GETKEY NY
IF ERRORLEVEL 2 GOTO SVGA
GOTO TEST_MANUAL

:TEST_ATT
ECHO The installation program has detected an AT&T 640 x 400 graphics adapter.
ECHO Is this correct (Y/N)?
GETKEY NY
IF ERRORLEVEL 2 GOTO ATT
GOTO TEST_MANUAL

:TEST_TOSH
ECHO The installation program has detected a TOSHIBA 640 x 400 graphics adapter.
ECHO Is this correct (Y/N)?
GETKEY NY
IF ERRORLEVEL 2 GOTO TOSH
GOTO TEST_MANUAL

:CGA
ECHO Copying screen fonts...
COPY *.CFT %1
COPY CGA?.DRV %1
COPY CGA?.SCR %1CONFIG.SCR
GOTO FINISH

:ATT
ECHO Copying screen fonts...
COPY *.CFT %1
ECHO Copying high resolution screen fonts...
COPY *.EFT %1
COPY ATT??.DRV %1
COPY ATTHI?.SCR %1CONFIG.SCR
COPY ATTLO?.SCR %1
GOTO FINISH

:EGA
ECHO Copying screen fonts...
COPY *.CFT %1
ECHO Copying high resolution screen fonts...
COPY *.EFT %1
COPY PALETTE?.EXE %1
COPY EGA??.DRV %1
COPY EGAHI?.SCR %1CONFIG.SCR
COPY EGALO?.SCR %1
GOTO FINISH

:HERC
ECHO Copying screen fonts...
COPY *.CFT %1
ECHO Copying high resolution screen fonts...
COPY *.EFT %1
COPY HERC??.DRV %1
COPY HERCHI?.SCR %1CONFIG.SCR
COPY HERCLO?.SCR %1
GOTO FINISH

:MCGA
ECHO Copying high resolution screen fonts...
COPY *.EFT %1
COPY VGAHI?.DR? %1
COPY VGAHI?.SCR %1CONFIG.SC? 
COPY PALETTE?.EXE %1
GOTO FINISH

:TOSH
ECHO Copying screen fonts...
COPY *.CFT %1
ECHO Copying high resolution screen fonts...
COPY *.EFT %1
COPY TOSH??.DRV %1
COPY TOSHHI?.SCR %1CONFIG.SCR
COPY TOSHLO?.SCR %1
GOTO FINISH

:VGA
ECHO 
ECHO Do you have a color screen? (Y/N) 
GETKEY NY
IF ERRORLEVEL 2 GOTO CVGA
COPY MONVGAH?.SCR %1VGAHI.SCR
COPY MONVGAL?.SCR %1VGALO.SCR
COPY MONVGAH?.SCR %1CONFIG.SCR
GOTO MVGA
:CVGA
COPY VGA??.SCR %1
COPY VGAHI?.SCR %1CONFIG.SCR
:MVGA
ECHO Copying screen fonts...
COPY *.CFT %1
ECHO Copying high resolution screen fonts...
COPY *.EFT %1
COPY PALETTE?.EXE %1
COPY VGA??.DRV %1
GOTO FINISH

:SVGA
ECHO Creating Super VGA drivers
TESTSCR SVGA HI %1SVGAHI.SCR
TESTSCR SVGA LO %1SVGALO.SCR
COPY SVGA??.DRV %1
GOTO CVGA

:WYSE
ECHO Copying screen fonts...
COPY *.CFT %1
ECHO Copying high resolution screen fonts...
COPY *.EFT %1
COPY WYSE??.DRV %1
COPY WYSEHI?.SCR %1CONFIG.SCR
COPY WYSELO?.SCR %1

:FINISH
COPY CONTINUE.BAT %1
%1CONTINUE 3 %1 %2

:END
