Version 1.00
BEGIN Form BROLIST
	AutoRedraw   = -1
	BackColor    = QBColor(7)
	BorderStyle  = 6
	Caption      = "Browse"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(19)
	Left         = Char(4)
	MaxButton    = -1
	MinButton    = 0
	MousePointer = 0
	Tag          = ""
	Top          = Char(3)
	Visible      = -1
	Width        = Char(72)
	WindowState  = 0
	BEGIN Label Label1
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(15)
		BorderStyle  = 0
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(1)
		Height       = Char(1)
		Left         = Char(0)
		MousePointer = 0
		TabIndex     = 1
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(78)
	END
	BEGIN Label errmsgwin
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(1)
		BorderStyle  = 0
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(15)
		Height       = Char(1)
		Left         = Char(4)
		MousePointer = 0
		TabIndex     = 0
		Tag          = ""
		Top          = Char(15)
		Visible      = -1
		Width        = Char(74)
	END
	BEGIN Label Label2
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(15)
		BorderStyle  = 0
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(1)
		Height       = Char(1)
		Left         = Char(0)
		MousePointer = 0
		TabIndex     = 2
		Tag          = ""
		Top          = Char(0)
		Visible      = -1
		Width        = Char(78)
	END
	BEGIN Label Label3
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(5)
		BorderStyle  = 0
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(15)
		Height       = Char(1)
		Left         = Char(0)
		MousePointer = 0
		TabIndex     = 3
		Tag          = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(78)
	END
	BEGIN PictureBox EditWindow
		AutoRedraw   = -1
		BackColor    = QBColor(0)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(7)
		Height       = Char(11)
		Left         = Char(0)
		MousePointer = 0
		TabIndex     = 4
		TabStop      = -1
		Tag          = "EDITWINDOW"
		Top          = Char(3)
		Visible      = -1
		Width        = Char(78)
		BEGIN TextBox EditBox
			BackColor    = QBColor(15)
			BorderStyle  = 0
			DragMode     = 0
			Enabled      = -1
			ForeColor    = QBColor(0)
			Height       = Char(1)
			Left         = Char(20)
			MousePointer = 0
			MultiLine    = 0
			ScrollBars   = 0
			TabIndex     = 5
			TabStop      = -1
			Tag          = "EDITBOX"
			Text         = ""
			Top          = Char(1)
			Visible      = 0
			Width        = Char(13)
		END
	END
	BEGIN HScrollBar HScroll1
		Attached     = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(1)
		LargeChange  = 1
		Left         = Char(0)
		Max          = 32767
		Min          = 0
		MousePointer = 0
		SmallChange  = 1
		TabIndex     = 6
		TabStop      = -1
		Tag          = "SCROLLBAR"
		Top          = Char(14)
		Value        = 0
		Visible      = -1
		Width        = Char(70)
	END
	BEGIN Timer Timer1
		Enabled      = -1
		Interval     = 0
		Left         = Char(30)
		Tag          = ""
		Top          = Char(6)
	END
	BEGIN Label delflag
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(1)
		BorderStyle  = 0
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(14)
		Height       = Char(1)
		Left         = Char(0)
		MousePointer = 0
		TabIndex     = 7
		Tag          = ""
		Top          = Char(15)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN Menu Topic
		Caption      = "&File"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
		BEGIN Menu GoBottom
			Caption      = "Scroll to &Top"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu GoTop
			Caption      = "Scroll to &Bottom"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu sep33
			Caption      = "-"
			Checked      = 0
			Enabled      = -1
			Separator    = -1
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu exitprogram
			Caption      = "E&xit"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Shortcut     = {F10}
			Tag          = ""
			Visible      = -1
		END
	END
	BEGIN Menu edit
		Caption      = "&Edit"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
		BEGIN Menu SelExpr
			Caption      = "&Select Expression"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Shortcut     = {F2}
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu showall
			Caption      = "Show &all records"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Shortcut     = {F4}
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu sep3
			Caption      = "-"
			Checked      = 0
			Enabled      = -1
			Separator    = -1
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu redisplay
			Caption      = "&Refresh display"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Shortcut     = {F3}
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu sep2
			Caption      = "-"
			Checked      = 0
			Enabled      = -1
			Separator    = -1
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu delrecord
			Caption      = "Toggle &delete flag"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Shortcut     = {F6}
			Tag          = ""
			Visible      = -1
		END
	END
	BEGIN Menu help
		Caption      = "&Help"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
		BEGIN Menu helptopic
			Caption      = "&Topic"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Shortcut     = {F1}
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu sep1
			Caption      = ""
			Checked      = 0
			Enabled      = -1
			Separator    = -1
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu about
			Caption      = "&About"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
	END
	BEGIN Menu CtgIndexFiles
		Caption      = "&Catalog"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = 0
		BEGIN Menu IndexFiles
			Caption      = ""
			Checked      = 0
			Enabled      = -1
			Index        = 1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
	END
END
DECLARE SUB ParseComline (fileflag%, dbfmsg$, ndxmsg$, mode%)
DECLARE FUNCTION SAMPLE.GetInput$ ()
DECLARE FUNCTION Ctg..FileName$ (PathAndFile$)
DECLARE FUNCTION Ctg..FixName$ (file$, typ$)
DECLARE FUNCTION Ctg..GetHandle% (IndexName$)
DECLARE FUNCTION Ctg..LoadStructure% (DBFfile%)
DECLARE SUB Ctg..PutIndexName (DBFfile%, IndexName$, SelectExpression$, IndexStatus%)
DECLARE SUB Ctg..GetCatalog (CatName$, CatIndexNames$(), CatIndexSelects$(), CatIndexStatus%())
DECLARE SUB Ctg..ReadCatalog (CatName$, CatIndexNames$(), CatIndexSelects$(), CatIndexStatus%())
DECLARE SUB Ctg..ErrorMessage (errcode%)
DECLARE SUB Ctg..WhoAmI ()
DECLARE FUNCTION DB..Maintenance$ (DBFfile%, rebuild%)
DECLARE FUNCTION DB..BuildIndex% (DBFfile%, NDXname$, SelectExpression$, Unique%, KeyExpression$, RecordsIndexed#, DuplicateKeys#)
DECLARE FUNCTION DB..ReadFields% (DBFfile%, FieldData$(), MEMOdata$(), RecordData$)
DECLARE FUNCTION DB..GetFieldName$ (DBFfile%, FieldNum%)
DECLARE FUNCTION DB..GetTfields% (DBFfile%)
DECLARE FUNCTION DB..GetTlength% (DBFfile%)
DECLARE FUNCTION DB..GetTrecords# (DBFfile%)
DECLARE FUNCTION DB..OpenDatabase% (DBFfile%, DataFileName$, FileAccessMode%)
DECLARE FUNCTION DB..CloseDatabase% (DBFfile%)
DECLARE FUNCTION DB..SaveRecord% (DBFfile%, record#, NewRecordData$)
DECLARE FUNCTION DB..ConformFields% (DBFfile%, FieldData$(), MEMOdata$(), RecordData$)
DECLARE FUNCTION DB..Selected% (SelectionMacro$, record#, DataRecord$)
DECLARE FUNCTION DB..NextAvailable# (DBFfile%)

'$FORM memo
'--------------------------------------------------------
'(C) Copyright 1987 - 1993 AJS Publishing Inc.
'
' Module      : BROWSE-F.FRM
' Title       : User interface for db/LIB BROWSE
' Version     : 1.0
' Sys Req.    : MS Visual Basic for MS-DOS 1.0
' Supports    : DBF, NDX and DBT files
' Function    : Browse and Edit Database Records
' Written by  : Hank Marquis
' Last updated: 2/15/93
'--------------------------------------------------------

DECLARE SUB DeleteRecord ()
DECLARE SUB LoadRecords ()
DECLARE FUNCTION DisplayErrorMsg% (errcode%, errmsg$, mode%)
DECLARE SUB DisplayPrompt (prompt%)
DECLARE SUB LockRecord ()
DECLARE SUB ProcessLockedRecord ()
DECLARE SUB SaveField ()
DECLARE SUB DisplayHeader ()
DECLARE SUB EditMemo (hMemo%, status%, BlockAddress$)
DECLARE SUB UpdateEditBox ()
DECLARE SUB FormatDisplay ()
DECLARE SUB DisplayMessage (msg$)
DECLARE SUB ScrollDn (quiet%)
DECLARE SUB ScrollUp (quiet%)
DECLARE SUB EditBox_KeyDown (KeyCode%, Shift%)
DECLARE FUNCTION MINVAL& (BYVAL VAL1&, BYVAL VAL2&)
DECLARE FUNCTION MAXVAL& (BYVAL VAL1&, BYVAL VAL2&)
DECLARE SUB MoveEditBox (X!, Y!)
DECLARE SUB InitFiles (fileflag%, dbfmsg$, ndxmsg$, mode%)
DECLARE SUB InitNetworkParams ()
DECLARE SUB LoadDBFInfo ()
DECLARE SUB QUIT ()
DECLARE FUNCTION GetSelectExpr% (SELexp$)
DEFINT A-Z                  'define variables to default to integer
'$INCLUDE: 'C:\vbdos\catalog\db-CAT.bi'
'$INCLUDE: 'AJSDML.BI'
'$INCLUDE: 'BROWSE.BI'

SUB about_Click ()

    CALL StatusLIB("PRODUCT", status%, Version$)
    msg$ = Version$ + CHR$(13) + CHR$(13)
    msg$ = msg$ + "BROWSE - Browse and edit dBASE-type database and index files." + CHR$(13) + CHR$(13)
    msg$ = msg$ + CHR$(10) + "(C) Copyright 1993 AJS Publishing, Inc." + CHR$(10) + CHR$(10)
    msg$ = msg$ + "Usage BROWSE  <database>  <index>"
    
    MSGBOX msg$

END SUB

'
'delrecord_Click
'
'   1) Toggles a screen records delete flag. If the record is not locked,
'      this routine locks it. Record state on exit is what it was on
'      entry (e.g., locked or unlocked).
'
SUB delrecord_Click ()

    IF NOT REC_locked% THEN             'Is the record already locked?
        CALL LockRecord                 'No, go lock the record.
        IF REC_locked% THEN             'Did we get the lock?
            CALL DeleteRecord           'Yes, toggle it's deleted flag.
            CALL ProcessLockedRecord    'Restore edit state to what it was
        END IF
    ELSE                                'Record is already locked.
        CALL DeleteRecord               'Toggle the delete flag.
    END IF
                                  
    CALL DisplayPrompt(msg_normal)

END SUB

SUB EditBox_DragDrop (Source AS CONTROL, X AS SINGLE, Y AS SINGLE)

END SUB

'
'EditBox_GotFocus
'
'   1) Handles potential problem if edit box not visible -- always
'      make edit box visible if it has focus.
'
SUB EditBox_GotFocus ()

    EditBox.visible = TRUE%

END SUB

'
'EditBox_KeyDown
'
'   1) Main event handler for BROWSE application.
'
SUB EditBox_KeyDown (KeyCode%, Shift%)

    STATIC working%
    
    IF working% THEN EXIT SUB
    
    SELECT CASE KeyCode%

        CASE KEY_Home%                      'Home key
            '
            'Bounce back to start of "spreadsheet"
            'editor window.
            '
            IF Shift% = KEY_Control THEN    '^Home
                sm_FldStart% = 1               '1st field
                sm_CurrentColumn% = 1                 '1st col
                CALL FormatDisplay          'Re-generate & re-display screen using
            ELSE
                EXIT SUB
            END IF
        '??? DO WE NEED A CTRL-END CASE??
        '??? ARE THERE OTHER USEFUL KEY CONBINATIONS?

        CASE KEY_Escape%    'escape key
            'As the pageup and pagedn routines use DOEVENTS(), events may
            'be called recursively -- that is while a ^Page Up is running
            'an escape key press may still be trapped by EditBox_KeyDown.
            '
            'Pressing escape terminates any BROWSE displaying loops. status%
            'is set to TRUE%, which other routines trap for. If status% is
            'TRUE%, then the scrolling functions are stopped.
            '
            status% = TRUE%

        CASE KEY_PageUp% AND Shift = 0    'page down key

            'signal user with options
            CALL DisplayPrompt(msg_Scrolling)
            
            'If field data has changed, save it.
            IF DATA_changed% THEN CALL SaveField

            'If the record was locked, process it.
            IF REC_locked% THEN CALL ProcessLockedRecord

            'clear out the memo array because we're leaving
            REDIM MEMO_data$(Tfields%)

            'if control key was pressed
            IF Shift% = KEY_Control% THEN   '^PageUp

                'hide edit box
                EditBox.visible = FALSE%

                'hide scroll bar
                hscroll1.visible = FALSE%
                
                'scroll to top of database and/or index
                status% = FALSE%                        'reset status%
                working% = TRUE%
                WHILE status% = FALSE%                  'While status%=FALSE%
                    CALL ScrollDn(TRUE%)                'Call scroll down. TRUE% means run in quiet mode with no error reported.
                    j% = DOEVENTS()                     'Check for escape or help
                WEND
                status% = FALSE%                        'reset status%
                working% = FALSE%

                'show scroll bar
                hscroll1.visible = TRUE%

                EditBox.visible = TRUE%
                
            'Control key was not pressed, so handle normal
            'Page Dn key press.
            ELSE
                '
                'Page Dn - walk backwards a "page". A "page" is one edit
                'windows worth of viewable data.
                '
                'Use ScrollDn routine to do the hard work!
                '

                'hide edit box
                EditBox.visible = FALSE%

                'hide scroll bar
                hscroll1.visible = FALSE%

                working% = TRUE%
                FOR i% = 1 TO Maxlines% - 1     'For edit windows height...
                    CALL ScrollDn(TRUE%)        'Call scroll down. TRUE% means run in quiet mode with no error reported.
                    dummy = DOEVENTS()          'Process other keys.
                    IF status% THEN EXIT FOR    'If an error occurs or escape is pressed then exit display routine.
                NEXT
                working% = FALSE%
                EditBox.visible = TRUE%
                hscroll1.visible = TRUE%

            END IF

            'display user prompt
            CALL DisplayPrompt(msg_normal)

        CASE KEY_PageDown% AND Shift = 0               'PageUp
            '
            'Page Up means scroll only one viewable page up.
            'Uses ScrollUp to do the actual scrolling. Pressing
            'escape will terminate this routine.
            '
            '

            'indicate to user scrolling commands
            CALL DisplayPrompt(msg_Scrolling)
            
            'if we are out of data
            IF gMaxlines% < Maxlines% THEN       'Are we out of array data?
                CALL DisplayPrompt(msg_normal)
                BEEP
                EXIT SUB
            END IF
            
            'If field data has changed, save it.
            IF DATA_changed% THEN CALL SaveField

            'If the record was locked, process it.
            IF REC_locked% THEN CALL ProcessLockedRecord

            'clear out the memo array because we're leaving
            REDIM MEMO_data$(Tfields%)

            'If control key pressed
            IF Shift% = KEY_Control% THEN   '^PageDn

                'hide edit box
                EditBox.visible = FALSE%

                'hide scroll bar
                hscroll1.visible = FALSE%
                
                'scroll up page
                status% = FALSE%
                i% = 0
                working% = TRUE%
                WHILE status% = FALSE%
                    ScrollUp TRUE%
                    j% = DOEVENTS()                  'Check for escape or help
                WEND
                working% = FALSE%

                'show scroll bar
                hscroll1.visible = TRUE%
                
                status% = FALSE%
                EditBox.visible = TRUE%
            ELSE
                '
                'Page Up - walk forwards a "page". A "page" is one edit
                'windows worth of viewable data.
                '
                'Use scrollup routine to do the hard work!
                '

                'hide edit box
                EditBox.visible = FALSE%

                'hide scroll bar
                hscroll1.visible = FALSE%

                working% = TRUE%
                FOR i% = 1 TO Maxlines - 1      'For edit windows height...
                    CALL ScrollUp(TRUE%)        'Call scroll up.
                    dummy = DOEVENTS()          'Process other keys.
                    IF status% THEN EXIT FOR    'If an error occurs or
                                                'escape is pressed then
                                                'exit display routine.
                NEXT i%
                working% = FALSE%

                EditBox.visible = TRUE%
                hscroll1.visible = TRUE%

            END IF

            'display prompt to user
            CALL DisplayPrompt(msg_normal)

        CASE KEY_LeftArrow% '   ^<-

            'If control key pressed
            IF Shift% = KEY_Control% OR Shift% = 1 THEN

                IF Shift% = 1 THEN
                    FLDnum% = sm_CurrentColumn% + sm_FldStart% - 1
                    IF FLDnum% = 1 THEN EXIT SUB
                    SWAP FIELD_LIST%(FLDnum% - 1), FIELD_LIST%(FLDnum%)
                    CALL FormatDisplay      'Re-generate & re-display screen using current field and column pointers.
                END IF
                
                'if field data has changed then save it
                IF DATA_changed% THEN CALL SaveField

                'decrement current screen column pointer (sm_CurrentColumn%)
                sm_CurrentColumn% = sm_CurrentColumn% - 1

                'Handle display of columns and update screen
                IF sm_CurrentColumn% = 0 THEN             'Are we off the left side of the screen?
                    sm_FldStart% = sm_FldStart% - 1   'Reset display-from flag (sm_FldStart%)
                    sm_CurrentColumn% = 1                 'Reset current column pointer to 1st column
                    IF sm_FldStart% = 0 THEN       'Are we out of fields?
                        sm_FldStart% = 1           'Yes, reset to 1st field
                        BEEP                    'notify the user...
                        EXIT SUB                'bye!
                    ELSE                        'We are not out of fields.
                        CALL FormatDisplay      'Re-generate & re-display screen using
                                                ' current field and column pointers.
                    END IF
                END IF

            ELSE
                'any other key combination is invalid
                EXIT SUB

            END IF

        CASE KEY_RightArrow%, KEY_Enter%     '   ^->
            'If control key pressed
            IF Shift = KEY_Control% OR KeyCode% = KEY_Enter% OR Shift% = 1 THEN

                IF Shift% = 1 THEN
                    FLDnum% = sm_CurrentColumn% + sm_FldStart% - 1
                    IF FLDnum% = UBOUND(FIELD_LIST%) THEN EXIT SUB
                    SWAP FIELD_LIST%(FLDnum% + 1), FIELD_LIST%(FLDnum%)
                    CALL FormatDisplay      'Re-generate & re-display screen using current field and column pointers.
                END IF

                'If field data has changed save it
                IF DATA_changed% THEN CALL SaveField

                'increment current screen column pointer
                sm_CurrentColumn% = sm_CurrentColumn% + 1

                'update screen
                IF sm_CurrentColumn% >= sm_FldCount% THEN  'Are we off the screen?

                    sm_FldStart% = sm_FldStart% + 1       'Yes, increment starting
                                                          ' field number pointer.

                    IF sm_FldStart% > Tfields% THEN    'Are we out of fields?
                                                    ' Yes, reset pointers to
                                                    ' previous by decrementing
                                                    ' them to where they were.
                        sm_CurrentColumn% = sm_CurrentColumn% - 1  'Decrement column pointer.
                        sm_FldStart% = sm_FldStart% - 1   'Decrement field pointer.
                        BEEP                        'Alert user.
                        EXIT SUB                    'bye
                    END IF

                    sm_CurrentColumn% = sm_CurrentColumn% - 1           'Set current screen column to
                                                    ' total columns - 1
                                                    
                    IF sm_CurrentColumn% <= 0 THEN
                      sm_CurrentColumn% = 1         'handle column 0 (invalid)
                    END IF

                    IF sm_CurrentColumn% + sm_FldStart% - 1 > Tfields% THEN
                      sm_FldStart% = sm_FldStart% - 1
                      BEEP
                      EXIT SUB
                    END IF
                              
                    CALL FormatDisplay              'Re-generate & re-display screen using
                                                    ' current field and column pointers.
                END IF

            ELSE
                'any other key combination is invalid
                EXIT SUB
            END IF
        
        CASE KEY_UpArrow% AND Shift = 0'   line up
            direction% = -1

            'if we are out of data
            IF gMaxlines% = 0 THEN     'Are we out of array data?
                BEEP
                EXIT SUB
            END IF

            'If field data has changed save it
            IF DATA_changed% THEN CALL SaveField

            'If record was locked handle it
            IF REC_locked% THEN CALL ProcessLockedRecord

            'clear out the memo array because we're leaving
            REDIM MEMO_data$(Tfields%)

            'determine screen row position
            IF sm_CurrentRow% > 1 THEN                'Are we at top of edit window?
                sm_CurrentRow% = sm_CurrentRow% - 1             'Yes, decrement row (move up 1 row)
                gMaxlines% = Maxlines%
            ELSEIF sm_CurrentRow% < 1 THEN                          'We are at top of screen.
                BEEP
            ELSEIF sm_CurrentRow% > 0 THEN                          'We are at top of screen.
                CALL ScrollDn(FALSE%)       'Let ScrollDn scroll for us
            END IF

        CASE KEY_DownArrow% AND Shift = 0'   line down
            direction% = 1

            'If field data has changed save it
            IF DATA_changed% THEN CALL SaveField
            
            'If record was locked handle it
            IF REC_locked% THEN CALL ProcessLockedRecord

            'clear out the memo array because we're leaving
            REDIM MEMO_data$(Tfields%)

            'determine screen row position
            IF sm_CurrentRow% < Maxlines% THEN         'Are we at bottom of edit window?
                sm_CurrentRow% = sm_CurrentRow% + 1   'Yes, increment row (move down 1 row)
            ELSE                                      'We are at bottom of screen.
                CALL ScrollUp(FALSE%)                 'Let ScrollUp scroll for us
            END IF

            'if we are out of data
            IF sm_CurrentRow% > gMaxlines% THEN       'Are we out of array data?
                sm_CurrentRow% = sm_CurrentRow% - 1   'Yes, decrement row (move up 1 row)
                BEEP
                EXIT SUB
            END IF
            
        CASE ELSE
            'other keys are not valid
            EXIT SUB
            BEEP
    END SELECT
    
    '
    'If we got here, then one of the valid edit box movement key combinations
    'got us here. That means the position of the edit box need to change
    'as well as that the edit box needs to load the current fields data.
    '
    'So we call UpdateEditBox.
    '

    CALL UpdateEditBox

    KeyCode = 0

END SUB

'
'EditBox_KeyPress
'
'   1) Traps escape keys.
'   2) Only allows edits on available records.
'   3) Sets changed flag for later.
'
SUB EditBox_KeyPress (keyascii AS INTEGER)
    
    IF Trecords# = 0 THEN
        keyascii = 0
        EXIT SUB
    END IF

    IF keyascii = KEY_Escape% THEN EXIT SUB

    IF keyascii = KEY_Enter% THEN
        keyascii = 0
        EXIT SUB
    END IF

    'PREVENT EXCEEDING FIELD LENGTH
    FLDnum% = sm_CurrentColumn% + sm_FldStart% - 1

    IF LEN(EditBox.text) > FIELD_length%(FIELD_LIST%(FLDnum%)) THEN
        keyascii = 0
        EditBox.text = LEFT$(EditBox.text, FIELD_length%(FIELD_LIST%(FLDnum%)))
        BEEP
        EXIT SUB
    END IF

    '??? ATTEMPT TO PREVENT CHARACTERS IN NUMERIC FIELD OR DATES
    FLDtype$ = FIELD_type$(FIELD_LIST%(FLDnum%))    'from load structure array
    IF INSTR("FND", FLDtype$) > 0 THEN
        SELECT CASE keyascii
            CASE 43 TO 46, 48 TO 57, 127, 8
                '0 to 9, +, -, ., delete, backspace are OK
            CASE ELSE
                keyascii = 0
                BEEP
                EXIT SUB
        END SELECT
    END IF
    
    IF DATA_lock%(sm_CurrentRow%) OR gMaxlines% = 0 THEN
        keyascii = FALSE%
        BEEP
        EXIT SUB
    END IF

    IF NOT REC_locked% AND sm_CurrentRow% > 0 THEN
        CALL LockRecord
        IF NOT REC_locked% THEN
            keyascii = FALSE%
            EXIT SUB
        END IF
    ELSEIF sm_CurrentRow% < 1 THEN
        keyascii = FALSE%
        EXIT SUB
        BEEP
    END IF
    'edit memo file
    IF FIELD_type$(FIELD_LIST%(FLDnum%)) = "M" THEN
        j% = INSTR(dBFname$, ".DBF")
        IF j% THEN dbtname$ = LEFT$(dBFname$, j% - 1) + ".DBT"

        RECdata$ = DATA_record$(sm_CurrentRow%)
        record# = DATA_RecordNo#(sm_CurrentRow%)
        mode% = fom_Share%
        CALL OpenDBT(hMemo, status, dbtname$, FILETYPE%, blocksize%, mode)      'open the file
        IF status THEN
            IF LEN(DIR$(dbtname$)) = 0 THEN 'not there
                msg$ = "Memo file '" + dbtname$ + "' not found -- create a new one?"
                IF MSGBOX(msg$, mb_YESNO, "BROWSE") = mb_YESpressed THEN
                    mode% = fom_ExclusiveBufferCreate
                    blocksize% = 1
                    CALL StatusDBF(DBFfile%, status%, FILETYPE%, flags%, Trecords#, Tfields%, tlength%, UpDate$)
                    CALL OpenDBT(hMemo, status, dbtname$, FILETYPE%, blocksize%, mode%)      'open the file
                    IF status THEN
                        j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
                        keyascii = FALSE%
                        EXIT SUB
                    END IF
                ELSE
                    keyascii = FALSE%
                    EXIT SUB
                END IF
            ELSE
                j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
                keyascii = FALSE%
                EXIT SUB
            END IF
        END IF

        
        BlockAddress$ = FIELD_data$(FIELD_LIST%(FLDnum%))
        CALL EditMemo(hMemo%, status%, BlockAddress$)
        FIELD_data$(FIELD_LIST%(FLDnum%)) = BlockAddress$
        IF DATA_changed% THEN
          FldName$ = NUL
          CALL PutFLD(DBFfile%, status%, FIELD_LIST%(FLDnum%), FldName$, BlockAddress$, DATA_record$(sm_CurrentRow%))
          RECchanged% = TRUE%
        END IF
        
        mode% = 0
        CALL CloseDBT(hMemo, status%, mode%)
        IF status > 0 THEN
            j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
            keyascii = FALSE%
            BEEP
            EXIT SUB
        ELSE
            keyascii = FALSE%
            EXIT SUB
        END IF
        keyascii = FALSE%
        BEEP
    END IF

    DATA_changed% = TRUE%

END SUB

SUB EditWindow_GotFocus ()

    IF EditBox.visible THEN EditBox.SETFOCUS

END SUB

'
'EditWindow_KeyPress
'
'   1) Traps escape keypress
'   2) Sets status% flag for other routines to check.
'
SUB EditWindow_KeyPress (keyascii AS INTEGER)

    IF keyascii = KEY_Escape% THEN status% = TRUE%

END SUB

'
'EditWindow_MouseDown
'
'   1) Traps mouse press, and if button is the user-defined mouse button
'      then calls MoveEditBox() to setup new field editing.
'
'
SUB EditWindow_MouseDown (button%, Shift%, X!, Y!)

    IF button% = dml_ButtonPref THEN
        'If field data has changed, save it.
        IF DATA_changed% THEN CALL SaveField

        'If the record was locked, process it.
        IF REC_locked% THEN CALL ProcessLockedRecord

        CALL MoveEditBox(X!, Y!)
    END IF
    
END SUB

'
'exitprogram_Click
'
'   1) Calls program termination routine on F10 or Exit from menu.
'
SUB exitprogram_Click ()

    NDXfile% = 0
    CALL QUIT
    
END SUB

'
'Form_Load
'
'   1) Loads BROWSE form.
'   2) Sets up color preferences.
'   3) Initializes network paramaters.
'   4) Opens files.
'   5) Initializes field management arrays.
'   6) Setsup and calls browse engine.
'
SUB Form_Load ()
  MaxFiles% = 30  'an arbitrary number, maximum number of total files we're likely to open
  
  REDIM FileHandles%(MaxFiles%)
  REDIM AllFileNames(MaxFiles%)    AS STRING * 12

  REDIM SelectMacros$(MaxFiles%)
  REDIM SelectExpressions$(MaxFiles%)

  REDIM KeyExpressions$(MaxFiles%)
  REDIM KeyMacros$(MaxFiles%)

  REDIM KeyTypes(MaxFiles%)         AS STRING * 1
  REDIM KeyLengths%(MaxFiles%)
  REDIM KeyUnique%(MaxFiles%)
  REDIM DeletedRecordIndex%(MaxFiles%)
  REDIM MemoFile%(MaxFiles%)

' REM These arrays are used by Ctg..LoadStructure
  MaxFields% = 128          'set a large number of fields possible
                            'can be changed later as needed
  REDIM FieldType(MaxFiles%, MaxFields%)      AS STRING * 1
  REDIM FieldLength(MaxFiles%, MaxFields%)    AS INTEGER
  REDIM FieldDecimal(MaxFiles%, MaxFields%)   AS INTEGER
  
    msg_normal = msg_BrowseNormal

    REDIM DATA_lock%(0), DATA_record$(0), DATA_indexkey$(0), DATA_RecordNo#(0), DATA_Formated$(0)
    REDIM FIELD_data$(0), MEMO_data$(0)

    COMline$ = COMMAND$

    'Setup and display browse form
    caption = "BROWSE AND EDIT DATABASE FILE"
    CALL DisplayMessage("INITIALIZING! Please wait....")
    
    'set colors
    EditBox.forecolor = cp_EditlineFore
    EditBox.backcolor = cp_EditlineBack
    EditWindow.forecolor = cp_DispWinFore
    EditWindow.backcolor = cp_DispWinBack
    
    WindowState = ws_InitalState
    SHOW                         'display main form

    'Initialise db/LIB network paramaters
    InitNetworkParams

    fileflag% = pf_DatabaseANDORIndex
    dbfmsg$ = "Enter database file name to browse and edit then press OK." + CHR$(10) + CHR$(10) + "Press CANCEL to end program."
    ndxmsg$ = "Enter index file name to use then press OK. " + CHR$(10) + CHR$(10) + "Press CANCEL if you do not want to use an index."
    CALL ParseComline(fileflag%, dbfmsg$, ndxmsg$, mode%)

    'Open database catalog                          
      mode% = fom_Share%   'Existing files, shared access
      DBstatus% = DB..OpenDatabase(DBFfile%, dBFname$, mode%)'###
      IF DBstatus% THEN
        j% = DisplayErrorMsg(DBstatus%, ERROR$, mb_OK)
        CALL QUIT
      END IF
      'Read from Catalog
      
        BROLIST.CTGindexfiles.visible = TRUE%
        BROLIST.indexfiles(1).caption = "<No Index>"
        BROLIST.indexfiles(1).tag = STR$(0)
        BROLIST.indexfiles(1).checked = TRUE%
        IndexFileCount% = 1
        '### here just get the handle for the existing index
        FOR FileHandle% = 1 TO UBOUND(AllFileNames)
          IF FileHandles%(FileHandle%) = DBFfile% THEN ' it belongs to this database
            IndexFileCount% = IndexFileCount% + 1
            LOAD BROLIST.indexfiles(IndexFileCount%)
            BROLIST.indexfiles(IndexFileCount%).caption = Ctg..FileName$(AllFileNames(FileHandle%))
            BROLIST.indexfiles(IndexFileCount%).tag = STR$(FileHandle%)
            IF NDXname$ = Ctg..FileName$(AllFileNames(FileHandle%)) THEN
              BROLIST.indexfiles(IndexFileCount%).checked = TRUE%
              BROLIST.indexfiles(1).checked = FALSE%
              NDXfile% = VAL(BROLIST.indexfiles(IndexFileCount%).tag)
            ELSE
              BROLIST.indexfiles(IndexFileCount%).checked = FALSE%
            END IF
          END IF
        NEXT
        IF NDXfile% = 0 AND NDXname$ <> NUL THEN
          mode% = fom_Share%   'Existing file, shared access
          CALL OpenNDX(NDXfile%, status%, NDXname$, NDXtype%, NDXmode%, KEYexp$, KEYlen%, KEYtype%, mode%)
          IF status% = 0 THEN
          ' REM Put the index file's name in the name array.
            AllFileNames(NDXfile%) = Ctg..FileName$(NDXname$)
            CALL Ctg..PutIndexName(DBFfile%, NDXname$, IndexSelection$, 0)
          ELSE
            NDXname$ = NUL
          END IF
        END IF

      Trecords# = DB..GetTrecords#(DBFfile%)
      Tfields% = DB..GetTfields%(DBFfile%)
      tlength% = DB..GetTlength%(DBFfile%)
      
    COMline$ = NUL

    IF DBFfile THEN Maxlines% = MINVAL(EditWindow.height, Trecords#)
    IF Maxlines% = 0 THEN Maxlines% = 1

    REDIM DATA_lock%(Maxlines%), DATA_record$(Maxlines%), DATA_indexkey$(Maxlines%), DATA_RecordNo#(Maxlines%), DATA_Formated$(Maxlines%)

    CALL DisplayHeader

    screen.activeform.hscroll1.max = Tfields%
    screen.activeform.hscroll1.min = 1
    screen.MousePointer = mp_Normal
    
    'dim arrays properly
    REDIM FIELD_type$(Tfields%), FIELD_length%(Tfields%), FIELD_decimals%(Tfields%)
    REDIM FIELD_name$(Tfields%), FIELD_LIST%(Tfields%), FIELD_size%(Tfields%)
    REDIM FIELD_data$(Tfields%), MEMO_data$(Tfields%)
    
    'Process BROWSE
    EditBox.left = 1
    EditBox.top = 0
    CALL LoadDBFInfo

    FIRSTkey$ = NUL
    FIRSTrec# = 0
    sm_FldStart% = 1
    sm_CurrentColumn% = 1

    WindowSizeHasChanged = TRUE%  'initializes
    PROGNAME$ = "BROWSE"
    CALL FormatDisplay
    CALL UpdateEditBox
    EditBox.visible = TRUE%
    EditBox.SETFOCUS

    CALL DisplayPrompt(msg_normal)

END SUB

'
'FORM_RESIZE
'
'   1) Adjusts user interface elements to proper size of resize of form.
'   2) If database is open, re-display screen.
'
SUB FORM_RESIZE ()
    
    '??? need to comment
    IF height < ws_MinHeihgt THEN height = ws_MinHeihgt
    IF width < ws_MinWidth THEN width = ws_MinWidth

    errmsgwin.top = height - 4
    EditWindow.height = height - EditWindow.top - 5
    
    DelFlag.top = height - 4
    hscroll1.top = height - 5
    hscroll1.width = width - 2

    Maxlines% = EditWindow.height
    IF DBFfile THEN
        CALL StatusDBF(DBFfile%, status%, DBFtype%, flags%, Trecords#, Tfields%, tlength%, UpDate$)
        Maxlines% = MINVAL(EditWindow.height, Trecords#)
    END IF
    
    WindowSizeHasChanged = TRUE%

    IF DBFfile% THEN CALL FormatDisplay

    WindowSizeHasChanged = FALSE%
    
END SUB

'
'GoBottom_Click
'
'   1) Scrolls to bottom of database by simulateing a key press
'      of ^PageUp.
'
SUB GoBottom_Click ()

    CALL StatusDBF(DBFfile%, status%, DBFtype%, flags%, Trecords#, Tfields%, tlength%, UpDate$)
    IF Trecords# = 0 THEN EXIT SUB
    CALL EditBox_KeyDown(KEY_PageUp%, KEY_Control%)

END SUB

'
'GoTop_Click
'
'   1) Scrolls to top of database by simulateing a key press
'      of ^PageDn.
'
SUB GoTop_Click ()

    CALL StatusDBF(DBFfile%, status%, DBFtype%, flags%, Trecords#, Tfields%, tlength%, UpDate$)
    IF Trecords# = 0 THEN EXIT SUB
    CALL EditBox_KeyDown(KEY_PageDown%, KEY_Control%)

END SUB

'
'helptopic_Click
'
'   1) Looks up help for item that has focus.
'   2) Displays the help.
'
SUB helptopic_Click ()

    CALL DisplayPrompt(msg_help)

    SELECT CASE screen.activecontrol.tag
        CASE "EDITBOX": RESTORE EditBox
        CASE "EDITWINDOW": RESTORE EditWindow
        CASE "SCROLLBAR": RESTORE SCROLLBAR
    END SELECT

    DO
        READ tmp$
        IF tmp$ = "END" THEN EXIT DO
        msg$ = msg$ + tmp$ + CHR$(13)
    LOOP

    MSGBOX msg$, 0, "BROWSE HELP"

    CALL DisplayPrompt(msg_normal)

END SUB

SUB help_Click ()

END SUB

'
'HScroll1_Change
'
'   1) Shifts screen management columns.
'   2) Updates display to reflect changes.
'
SUB HScroll1_Change ()


    '??? need to comment

    STATIC firsttime%

    IF NOT firsttime% THEN
        firsttime% = NOT firsttime%
        EXIT SUB
    END IF

    sm_CurrentColumn% = 1
    sm_FldStart% = hscroll1.value
    CALL FormatDisplay
    CALL UpdateEditBox

END SUB

SUB HScroll1_GotFocus ()

    IF EditBox.visible THEN EditBox.SETFOCUS

END SUB

'
'HScroll1_KeyPress
'
'   1) Traps escape key for other routines.
'
SUB HScroll1_KeyPress (keyascii AS INTEGER)

    IF keyascii = KEY_Escape% THEN status% = TRUE%

END SUB

SUB IndexFiles_Click (index AS INTEGER)
                                  '###
    STATIC OldIndex
    
    FOR i = 1 TO IndexFileCount%
      indexfiles(i).checked = FALSE%
    NEXT
    indexfiles(index).checked = TRUE%
    IF OldIndex = index THEN EXIT SUB

    NDXfile% = VAL(indexfiles(index).tag)
    NDXname$ = indexfiles(index).caption
    OldIndex = index
    
    EditBox.left = 1
    EditBox.top = 0

    DATA_RecordNo#(1) = 0
    DATA_indexkey$(1) = NUL'###
    FIRSTkey$ = NUL
    FIRSTrec# = 0

    sm_FldStart% = 1
    sm_CurrentColumn% = 1

    WindowSizeHasChanged = TRUE%  'initializes
    CALL FormatDisplay
    CALL UpdateEditBox
    EditBox.visible = TRUE%
    EditBox.SETFOCUS

    CALL DisplayHeader
    CALL DisplayPrompt(msg_normal)

END SUB

'
'MoveEditBox
'
'   1) Repositions the edit box in the edit window according to current
'      mouse coordinates passed (x!, y!).
'
'   2) Reloads edit box with field data for highlighted field.
'
SUB MoveEditBox (X!, Y!)

        '??? need to comment this section

        IF Y! > gMaxlines% THEN BEEP: EXIT SUB

        FOR i% = LEN(sm_FldOffsets$) TO 1 STEP -1
            IF X! >= ASC(MID$(sm_FldOffsets$, i%, 1)) THEN
                IF (sm_CurrentRow% = Y! + 1) AND (sm_CurrentColumn% = i%) THEN EXIT SUB
                sm_CurrentColumn% = i%
                EXIT FOR
            END IF
        NEXT
        
        IF Y! + 1 > Maxlines THEN
            CALL EditBox_KeyDown(40, 0)
            EXIT SUB
        ELSEIF Y! + 1 < 1 THEN
            CALL EditBox_KeyDown(38, 0)
            EXIT SUB
        END IF

        sm_CurrentRow% = Y! + 1

        CALL UpdateEditBox

END SUB

'
'redisplay_Click
'
'   1) Reloads records from disk, getting most recent changes.
'   2) Redisplays the fields.
'   3) Updates the field editing box.
'
SUB redisplay_Click ()

    FIRSTrec# = DATA_RecordNo#(1)       'start at 1st record on screen
    FIRSTkey$ = DATA_indexkey$(1)       'if index, start at first

    CALL LoadRecords                    'reload records
    CALL FormatDisplay                  'show fields on screen
    CALL UpdateEditBox                  'enable edit box

END SUB

SUB SelExpr_Click ()
    
    CALL DisplayPrompt(msg_EnterSelExp)

    IF GetSelectExpr(SELexp$) THEN
        redisplay.enabled = TRUE%
        FIRSTrec# = 0
        FIRSTkey$ = NUL
        CALL LoadRecords
        CALL FormatDisplay
        CALL UpdateEditBox
    END IF

    CALL DisplayPrompt(msg_normal)

END SUB

'
'showall_Click
'
'   1) Reset record select flags to all records.
'   2) Reloads records from disk.
'   3) Redisplays field data on screen.
'   4) Redisplays the edit box.
'
SUB showall_Click ()

    SELprgm$ = NUL                      'lose record select expression
    FIRSTrec# = 0                       'start at top of file
    FIRSTkey$ = NUL                     'if index, start at top
    CALL LoadRecords                    'reload records
    CALL FormatDisplay                  'show fields on screen
    CALL UpdateEditBox                  'enable edit box
    
END SUB

'
'Timer1_Timer
'
'   1) Traps record lock timeout.
'   2) Unlocks record in event of 1 above.
'   3) Disables record lock timer.
'   4) Updates edit box.
'
SUB Timer1_Timer ()

    'if modal form is showing, exit with no change
    IF memo.visible THEN EXIT SUB
    
    'unlock record
    record# = DATA_RecordNo#(sm_CurrentRow%)
    count# = 1
    CALL UnLockREC(DBFfile%, status%, record#, count#)
    IF status% THEN
        '??? deal with error(s) here
        j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
    END IF
    
    timer1.enabled = FALSE%
    REC_locked% = FALSE%

    CALL DisplayPrompt(msg_normal)
    CALL UpdateEditBox

END SUB

