DECLARE FUNCTION SAMPLE.GetInput$ ()
DECLARE FUNCTION Ctg..FileName$ (PathAndFile$)
DECLARE FUNCTION Ctg..FixName$ (file$, typ$)
DECLARE FUNCTION Ctg..GetHandle% (IndexName$)
DECLARE FUNCTION Ctg..LoadStructure% (DBFfile%)
DECLARE SUB Ctg..PutIndexName (DBFfile%, IndexName$, SelectExpression$, IndexStatus%)
DECLARE SUB Ctg..GetCatalog (CatName$, CatIndexNames$(), CatIndexSelects$(), CatIndexStatus%())
DECLARE SUB Ctg..ReadCatalog (CatName$, CatIndexNames$(), CatIndexSelects$(), CatIndexStatus%())
DECLARE SUB Ctg..ErrorMessage (errcode%)
DECLARE SUB Ctg..WhoAmI ()
DECLARE FUNCTION DB..Maintenance$ (DBFfile%, rebuild%)
DECLARE FUNCTION DB..BuildIndex% (DBFfile%, NDXname$, SelectExpression$, Unique%, KeyExpression$, RecordsIndexed#, DuplicateKeys#)
DECLARE FUNCTION DB..ReadFields% (DBFfile%, FieldData$(), MEMOdata$(), RecordData$)
DECLARE FUNCTION DB..GetFieldName$ (DBFfile%, FieldNum%)
DECLARE FUNCTION DB..GetTfields% (DBFfile%)
DECLARE FUNCTION DB..GetTlength% (DBFfile%)
DECLARE FUNCTION DB..GetTrecords# (DBFfile%)
DECLARE FUNCTION DB..OpenDatabase% (DBFfile%, DataFileName$, FileAccessMode%)
DECLARE FUNCTION DB..CloseDatabase% (DBFfile%)
'DECLARE FUNCTION DB..SaveRecord% (DBFfile%, record#, NewRecordData$)
'DECLARE FUNCTION DB..ConformFields% (DBFfile%, FieldData$(), memodata$(), RecordData$)
DECLARE FUNCTION DB..Selected% (SelectionMacro$, record#, DataRecord$)
'DECLARE FUNCTION DB..NextAvailable# (DBFfile%)

'--------------------------------------------------------
'(C) Copyright 1987 - 1993 AJS Publishing Inc.
' Module      : DMLSHARE.BAS
' Title       : Shared routines for DML
' Version     : 1.0
' Sys Req.    : MS Visual Basic for MS-DOS 1.0
' Function    : Shared DML specific routines
' Written by  : Hank Marquis
' Last updated: 2/15/93
'--------------------------------------------------------

DEFINT A-Z

'$INCLUDE: 'AJSDML.BI'  'DML shared declarations

DECLARE SUB DisplayPrompt (prompt%)
DECLARE SUB DisplayHeader ()
DECLARE SUB CLOSEFILES ()
DECLARE SUB QUIT ()
DECLARE SUB FindKeyRecord (FINDkey$, FINDrec#, mode%)
DECLARE SUB RecordCount ()
DECLARE SUB MeterUpdate (partscomplete&)
DECLARE SUB PARSE.LIST.EXPRESSION ()
DECLARE SUB GetDBFparams (DBFtype%, mflds%, mrecsize%, mcfldsize%, mnfldsize%, mdps%)
DECLARE FUNCTION dbUserHook (partsdone#) AS INTEGER
DECLARE FUNCTION SELECTED% ()
DECLARE FUNCTION DisplayErrorMsg% (errcode%, errmsg$, mode%)
DECLARE FUNCTION MAXVAL& (BYVAL VAL1&, BYVAL VAL2&)
DECLARE FUNCTION MINVAL& (BYVAL VAL1&, BYVAL VAL2&)
DECLARE FUNCTION DBFFixname$ (file$)
DECLARE FUNCTION NDXFixName$ (file$)
DECLARE FUNCTION GetSelectExpr% (SELexp$)
DECLARE FUNCTION GetViewExpr% (VEWexp$)
DECLARE FUNCTION IsNumeric% (FLDtype$)

'$INCLUDE: 'C:\vbdos\catalog\db-CAT.bi'

'
'CloseFiles
'
'   1) Closes all open files.
'   2) Sets shared file handles to FALSE%.
'
SUB CLOSEFILES ()

    IF DBFfile% > 0 THEN
      status% = DB..CloseDatabase%(DBFfile%)  'closes whether catalog or not
      IF status% <> 0 THEN
        j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
      END IF
    END IF

    IF NDXfile% > 0 THEN  'in case of new index
      CALL CloseNDX(NDXfile%, status%)
      IF status% <> 0 THEN j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
    END IF

    DBFfile% = 0
    NDXfile% = 0

END SUB

'
'DBFFixname$
'
'   1) Strips path off a file name.
'   2) Appends .DBF it file name does not already have it.
'
FUNCTION DBFFixname$ (file$)

    '??? need to comment

    file$ = UCASE$(RTRIM$(LTRIM$(file$)))
    drive$ = NUL

    IF file$ = NUL THEN
        DBFFixname$ = SPACE$(14)
        EXIT FUNCTION
    END IF

    i% = INSTR(file$, ":")
    IF i% > 1 THEN
        drive$ = LEFT$(file$, i%)
        file$ = RIGHT$(file$, LEN(file$) - i%)
    END IF

    FOR i% = LEN(file$) - 1 TO 1 STEP -1
        IF MID$(file$, i%, 1) = "\" THEN EXIT FOR
    NEXT i%
    IF i% >= 0 THEN file$ = MID$(file$, i% + 1)

    i% = INSTR(file$, ".")
    IF i% < 1 THEN
        file$ = file$ + ".DBF"
    ELSE
        IF i% = LEN(file$) THEN file$ = file$ + "DBF"
    END IF

    DBFFixname$ = drive$ + file$

END FUNCTION

'
'DisplayErrorMsg
'
'   1) Displays an english error message.
'
'   errcode% > 0  :   carries the db/LIB status% result to lookup
'   errcode% = 0  :   simply display the message in errmsg$
'
'   mode% = Visual Basic message box type
'
'
FUNCTION DisplayErrorMsg (errcode%, errmsg$, mode%)

    IF screen.activeform.tag = "METER" THEN
        metershowing% = TRUE%
        screen.activeform.HIDE
    END IF

    tmp$ = screen.activeform.errmsgwin.caption

    screen.activeform.errmsgwin.forecolor = cp_ErrMsgColor
    screen.activeform.errmsgwin.caption = "ERROR: See dialog box for details."

    'lookup error code (if errcode% > 0)
    IF errcode% > 0 THEN
        CALL GetERROR(errcode%, errmsg$)
        msg$ = "ERROR:" + STR$(errcode%) + " " + errmsg$
    ELSE
        msg$ = "ERROR:" + errmsg$
    END IF

    'alert user
    BEEP

    'display error message
    DisplayErrorMsg = MSGBOX(msg$, mode%, "ERROR")

    'zap error message so other calls won't inadvertantly return an error message
    errmsg$ = NUL

    screen.activeform.errmsgwin.forecolor = cp_MsgColor
    screen.activeform.errmsgwin.caption = tmp$

END FUNCTION

'
'DisplayHeader
'
'   1) Displays pertenant file header information
'
'
SUB DisplayHeader ()

    CALL StatusDBF(DBFfile%, status%, DBFtype%, flags%, Trecords#, Tfields%, tlength%, UpDate$)

    tmp$ = SPACE$(14)
    LSET tmp$ = NDXFixName$((NDXname$))
    tmp1$ = SPACE$(9)
    LSET tmp1$ = FORMAT$(Trecords#, "#,###,###")
    IF Trecords# = 0 THEN LSET tmp1$ = "    0"
    screen.activeform.label1.caption = " NDX: " + tmp$ + " Total Records:  " + tmp1$ + " Fields     :  " + FORMAT$(Tfields%, "####,###")

    tmp$ = SPACE$(14)
    LSET tmp$ = DBFFixname$((dBFname$))
    tmp1$ = SPACE$(9)
    LSET tmp1$ = FORMAT$(tlength%, "#,###,###")
    screen.activeform.label2.caption = " DBF: " + tmp$ + " Record length:  " + tmp1$ + " Last Update:  " + UpDate$

END SUB

'
'DisplayMessage
'
'   1) Displays a message.
'
SUB DisplayMessage (msg$)


    '??? is this redundant with DisplayErroMsg or DisplayPrompt???
    'PROBABLY

    screen.activeform.errmsgwin.forecolor = cp_MsgColor
    screen.activeform.errmsgwin.caption = msg$

END SUB

'
'DisplayPrompt
'
'   1) Displays a prompt to the user.
'
SUB DisplayPrompt (prompt%)

    ON LOCAL ERROR RESUME NEXT
    screen.activeform.errmsgwin.forecolor = cp_MsgColor

    STATIC lastmsg%

    SELECT CASE prompt%
        CASE TRUE%              'get display state
            prompt% = lastmsg%
            EXIT SUB

        CASE msg_help
            msg$ = "Viewing help.  Press ENTER when done with help."

        CASE msg_BrowseNormal
            msg$ = "F1=Help F2=View F3=Refresh F4=Show All F6=Del F10=End"

        CASE msg_EnterSelExp
            msg$ = "ENTER=Accept expression  ESCAPE=Cancel process"

        CASE msg_locktimeout
            msg$ = "F1=Help F2=View F3=Refresh F4=Show All F6=Del F10=End <TIMEOUT>"

        CASE msg_LockRecord 'indicate current record is locked
            msg$ = "F1=Help F2=View F3=Refresh F4=Show All F6=Del F10=End <LOCKED>"

        CASE msg_DBFselect  'select a database file name
            msg$ = "Enter database file name, then select OK. Select CANCEL to end program."

        CASE msg_NDXselect  'select an index file name
            msg$ = "Enter index file name, then select OK. "

        CASE msg_Scrolling  'scrolling, abort
            msg$ = "ESC=Stop scrolling."

        CASE msg_NoIndexExp
            msg$ = "Missing index expression."

        CASE msg_BadIndexExp
            msg$ = "Index expression must result in character or numeric data."

        CASE msg_NoIndex
            msg$ = "No index file has been entered! Enter an index file name."

        CASE msg_Indexing
            msg$ = "Indexing ... <ABORT> to abort."

        CASE msg_IndexNormal
            msg$ = "F1=Help  F2=Index Expr.  F3=Select Expr.  F4=INDEX  F10=End"

        CASE msg_PackNormal
            msg$ = "F1=Help  F2=Purge Expr.  F4=PACK  F5=Purge  F10=End"

        CASE msg_Packing
            msg$ = "Copying database ... <ABORT> to abort."

        CASE msg_CreateNormal
            msg$ = "F1=Help  F6=CREATE  F10=End"

        CASE msg_ChooseField
            msg$ = "F1=Help  ENTER=Edit  TAB=Move  F6=Save  SHIFT " + CHR$(18) + "=Move field  F10=End"
        CASE msg_FC_New
            msg$ = "F1=Help  ENTER=New field  TAB=Move  F6=Save  F10=End"
        CASE msg_FC_Next
            msg$ = "F1=Help  ENTER=Next field  TAB=Move  F6=Save  F10=End"
        CASE msg_FC_Last
            msg$ = "F1=Help  ENTER=Previous field  TAB=Move  F6=Save  F10=End"
        CASE msg_FC_Del
            msg$ = "F1=Help  ENTER=Delete field  TAB=Move  F6=Save  F10=End"
        CASE msg_FC_Reset
            msg$ = "F1=Help  ENTER=Reset field  TAB=Move  F6=Save  F10=End"
        CASE msg_Creating
            msg$ = "CREATING DATABASE! Wait ..."

        CASE msg_DispStrNormal
            msg$ = "F1=Help  F6=New Database  F10=End"

        CASE msg_ModifyNormal
            msg$ = "F1=Help  F6=Save  F10=End"

        CASE msg_CopyRecNormal
            msg$ = "F1=Help  F4=Tag/Untag  F5=Tag All  F6=Clear All  F8=Copy  F10=End"

        CASE msg_AppendRecNormal
            msg$ = "F1=Help  F3=Save  F4=Last  F5=Clear Field  F6=Clear All  F10=End"

        CASE msg_LSTRPTNORMAL
            msg$ = "F1=Help  F2=Select Expr.  F4=Show All  F6=View Expr.  F10=End"

        CASE msg_LSTRPTPRINT
            msg$ = "Printing. Press <ESC> to abandon."

        CASE msg_UPDATEnormal
            msg$ = "F1=Help  F3=Update Database  F5=Clear Field  F6=Clear All  F10=End"

        CASE msg_UPDATING
            msg$ = "Updating database ... <ABORT> to abort."

        CASE ELSE
            EXIT SUB

    END SELECT

    'update message window
    screen.activeform.errmsgwin.caption = msg$
    screen.activeform.errmsgwin.REFRESH

    lastmsg% = prompt%

END SUB

SUB GetDBFparams (typedbf%, mflds%, mrecsize%, mcfldsize%, mnfldsize%, mdps%)
    SELECT CASE typedbf%
        CASE 1
            mflds% = 128
            mrecsize% = 4000
            mcfldsize% = 254
            mnfldsize% = 19
            mdps% = 15
        CASE 2
            mflds% = 512
            mrecsize% = 4000
            mcfldsize% = 254
            mnfldsize% = 19
            mdps% = 15
        CASE 3
            mflds% = 128
            mrecsize% = 4095
            mcfldsize% = 254
            mnfldsize% = 19
            mdps% = 15
        CASE 4
            mflds% = 255
            mrecsize% = 4000
            mcfldsize% = 254
            mnfldsize% = 20
            mdps% = 18
        CASE 5
            mflds% = 255
            mrecsize% = 4000
            mcfldsize% = 254
            mnfldsize% = 20
            mdps% = 18
        CASE 6
            mflds% = 1023
            mrecsize% = 8192
            mcfldsize% = 2048
            mnfldsize% = 30
            mdps% = 13
    END SELECT
END SUB

'
'   GetSelectExpr()
'
'       Gets record selection expression from user, trapping for proper
'       datatype and expression validity. Then returns TRUE% if succesful.
'
'       On entry SELexp$ contains the current or default expression,
'       If GetSelectExpr() returns TRUE%, then SELexp$ contains the
'       record select expression.
'
FUNCTION GetSelectExpr (SELexp$)

    msg$ = "Enter Record Select Expression, then select OK. To cancel and keep "
    msg$ = msg$ + "the previous expression select CANCEL." + CHR$(10) + CHR$(10)

    IF NOT reporting% THEN
        msg$ = msg$ + "NOTE: The Record Select Expression is used to determine "
        msg$ = msg$ + "which records ARE selected for the operation!"
    END IF

    workSELexp$ = SELexp$

    DO

        tmp$ = INPUTBOX$(msg$, "RECORD SELECT EXPRESSION", workSELexp$)
        IF tmp$ = NUL THEN EXIT DO

        CALL CompEXP(DBFfile%, status%, tmp$, SELprgm$, PGMtype$)

        IF status% THEN
            workSELexp$ = tmp$
            SELprgm$ = NUL
            IF DisplayErrorMsg(status%, errmsg$, mb_RETRYCANCEL) <> mb_RETRYpressed THEN EXIT DO
        ELSEIF PGMtype$ <> "L" THEN
            workSELexp$ = tmp$
            SELprgm$ = NUL
            errmsg$ = "Expression must result in a logical TRUE% or FALSE% " + CHR$(13) + CHR$(10)
            errmsg$ = errmsg$ + "condition and the exression entered does not. "
            IF DisplayErrorMsg(status%, errmsg$, mb_RETRYCANCEL) <> mb_RETRYpressed THEN EXIT DO
        ELSE
            SELexp$ = tmp$
            GetSelectExpr = TRUE%
            EXIT DO
        END IF

    LOOP

END FUNCTION

FUNCTION GetViewExpr (VEWexp$)

    msg$ = "Enter record view expression, then press enter or click OK. To cancel and keep "
    msg$ = msg$ + "the previous expression, press escape or click CANCEL."

    workVEWexp$ = VEWexp$

    DO

        tmp$ = INPUTBOX$(msg$, "VIEW EXPRESSION", workVEWexp$)
        IF tmp$ = NUL THEN EXIT DO

        CURRexp$ = tmp$

        PARSE.LIST.EXPRESSION

        IF status% THEN
            workVEWexp$ = tmp$
            VEWprgm$ = NUL
            IF DisplayErrorMsg(status%, errmsg$, mb_RETRYCANCEL) <> mb_RETRYpressed THEN EXIT DO
        ELSE
            VEWexp$ = CURRexp$
            GetViewExpr = TRUE%
            EXIT DO
        END IF

    LOOP

END FUNCTION

'
'InitFiles
'
'   1) Opens database [and index file].
'   2) Parses command line (if present) to autoload database & index.
'
'   NOTES:  fileflag% = 0 asks for database and opens it.
'           fileflag% = 1 asks for index file and opens it.
'           fileflag% = 2 asks for and REQUIRES index file, then opens it.
'           fileflag% = 3 asks for database file name, opens it, if not found
'                       then produce no error.
'           fileflag% = 4 same as 3, but without error
'
'   Mode% controls file open mode e.g., SHARE, EXCLUSIVE etc..
'
'  forget new or modify file stuff -
SUB InitFiles (fileflag%, dbfmsg$, ndxmsg$, mode%)

    'Open database file
    DO

       CALL DisplayPrompt(msg_DBFselect)

      'Open the database
       CALL OpenDBF(DBFfile%, status%, dBFname$, OLDtype%, mode%)

       IF status% = FALSE% THEN
           'get DBF info
           CALL StatusDBF(DBFfile%, status%, DBFtype%, flags%, Trecords#, Tfields%, tlength%, UpDate$)

           IF fileflag% = pf_DATABASE AND DBFfile% THEN
               closemode% = 0
               CALL CloseDBF(DBFfile%, status%, closemode%)

               DBFfile% = TRUE%
               errmsg$ = dBFname$ + " already exists!" + CHR$(13) + CHR$(13)
               errmsg$ = errmsg$ + "Cannot create an already existing database. " + CHR$(13) + CHR$(13)
               errmsg$ = errmsg$ + "Select NO to try again with a different name or " + CHR$(13) + "YES to erase existing file."
               IF DisplayErrorMsg(errcode%, errmsg$, mb_YESNO + mb_DefaultButton2) = mb_YESpressed THEN
                   ON LOCAL ERROR RESUME NEXT
                   KILL dBFname$
                   DBFtype% = 0
                   Trecords# = 0
                   Tfields% = 0
                   IF ERR THEN
                       errcode% = 0
                       j% = DisplayErrorMsg(errcode%, ERROR$, mb_OK)
                   ELSE
                       DBFfile% = FALSE%
                   END IF
               END IF

           ELSEIF fileflag% = pf_DatabaseQ THEN
               EXIT SUB

           ELSEIF fileflag% = pf_DATABASE THEN
               EXIT SUB
           ELSE
               EXIT DO
           END IF

          END IF

          IF fileflag% = pf_DATABASE AND DBFfile% THEN
          ELSEIF fileflag% = pf_DatabaseQ THEN
              EXIT SUB
          ELSEIF fileflag% = pf_DATABASE THEN
              EXIT SUB
          ELSE
              j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
          END IF

          COMline$ = NUL
        
        EXIT SUB

    LOOP
    
    'Open index file if flags% = 1
    'demand index file name if flags% = 2

    IF fileflag% THEN

        CALL DisplayPrompt(msg_NDXselect)

        DO
            IF COMline$ = NUL THEN
                NDXname$ = INPUTBOX$(ndxmsg$, "INDEX FILE NAME", NDXname$)
            ELSE
                COMline$ = NUL
            END IF

            IF NDXname$ <> NUL THEN

                IF INSTR(NDXname$, ".") = 0 THEN NDXname$ = NDXname$ + ".NDX"
                NDXname$ = UCASE$(LTRIM$(RTRIM$(NDXname$)))
                status% = 123
                retry% = 0

                mode% = fom_Share% + fom_Buffer%
                DO WHILE status% = 123 AND retry% < 9 'Because of error in some networks
                    CALL OpenNDX(NDXfile%, status%, NDXname$, NDXtype%, NDXmode%, KEYexp$, KEYlen%, KEYtype%, mode%)
                    retry% = retry% + 1
                LOOP

                IF status% = FALSE% THEN

                    CALL CompEXP(DBFfile%, status%, KEYexp$, KEYprgm$, PGMtype$)

                    IF status% = FALSE% THEN
                      EXIT DO
                    ELSEIF status% <> 0 OR PGMtype$ = "E" THEN
                      errmsg$ = "Index expression does not match file structure."
                      status% = 0
                      j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
                      IF fileflag% <> 2 THEN status% = 131
                    END IF

                ELSEIF fileflag% = status% THEN
                    status% = 0
                ELSEIF fileflag% = pf_DatabaseANDIndexQ THEN
                    EXIT DO
                    fileflag% = pf_DatabaseANDIndex
                ELSE
                    IF status% = 123 THEN status% = 5
                    j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
                END IF

            ELSEIF fileflag% = 2 THEN
                errmsg$ = " You must enter an index file name!" + CHR$(10) + CHR$(10) + CHR$(13)
                errmsg$ = errmsg$ + "Select CANCEL to end program."
                IF DisplayErrorMsg(status%, errmsg$, mb_RETRYCANCEL) <> mb_RETRYpressed THEN CALL QUIT
                status% = -1
            ELSEIF fileflag% = pf_DatabaseANDIndexQ THEN
                status% = -1
                fileflag% = pf_DatabaseANDIndex
            ELSE
                NDXfile% = 0
                status% = 0
                KEYprgm$ = NUL
            END IF

        LOOP WHILE status% <> 0

    END IF
  
END SUB

'
'InitNetworkParams
'
'   1) Sets up network concurrency paramaters.
'
SUB InitNetworkParams ()

    'setup db/LIB pool space
    parameter$ = "DBPOOL"
    definition$ = LTRIM$(STR$(32))
    CALL ConfigLIB(parameter$, status%, definition$)
    IF status% THEN j% = DisplayErrorMsg(status%, errmsg$, mb_OK)

    'setup number of retries
    parameter$ = "RETRY"
    definition$ = LTRIM$(STR$(net_retries))
    CALL ConfigLIB(parameter$, status%, definition$)
    IF status% THEN j% = DisplayErrorMsg(status%, errmsg$, mb_OK)

    'setup time delay period
    parameter$ = "DELAY"
    definition$ = LTRIM$(STR$(net_delay))
    CALL ConfigLIB(parameter$, status%, definition$)
    IF status% THEN j% = DisplayErrorMsg(status%, errmsg$, mb_OK)

END SUB

'
'Returns TRUE is this field type is a numeric-type field
'
'   Handle dBASE N or F fields
'
FUNCTION IsNumeric (FLDtype$)
    IF INSTR("FN", LEFT$(FLDtype$, 1)) > 0 THEN IsNumeric% = -1
END FUNCTION

'
'LoadDBFInfo
'
'   1) Loads database header field information.
'
SUB LoadDBFInfo ()

    SELexp$ = NUL

    sm_CurrentRow% = 1
    sm_CurrentColumn% = 1

    FOR fldnum% = 1 TO Tfields%
        FIELD_LIST%(fldnum%) = fldnum%
        FIELD_name$(fldnum%) = NUL
        FIELD_type$(fldnum%) = NUL
        FIELD_size%(fldnum%) = 0
        FIELD_length%(fldnum%) = 0
        FIELD_decimals%(fldnum%) = 0
    NEXT

    FOR fldnum% = 1 TO Tfields%

        CALL ReturnSTR(DBFfile%, status%, fldnum%, FLDname$, FLDtype$, FLDlen%, FLDdec%)
        IF status% <> 0 THEN
            j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
            EXIT SUB
        END IF

        FLDname$ = RTRIM$(LTRIM$(FLDname$))
        FIELD_name$(fldnum%) = LEFT$(FLDname$ + SPACE$(10), 10)
        FIELD_type$(fldnum%) = FLDtype$
        FIELD_size%(fldnum%) = MAXVAL&(LEN(FLDname$), FLDlen%)
        FIELD_length%(fldnum%) = FLDlen%
        FIELD_decimals%(fldnum%) = FLDdec%

    NEXT

END SUB

'
'MAXVAL%
'
'   1) Returns greater of two integers.
'
FUNCTION MAXVAL& (BYVAL VAL1&, BYVAL VAL2&)
    IF VAL1& > VAL2& THEN MAXVAL& = VAL1& ELSE MAXVAL& = VAL2&
END FUNCTION

'
'MINVAL%
'
'   1) Returns lesser of two integers.
'
FUNCTION MINVAL& (BYVAL VAL1&, BYVAL VAL2&)
    IF VAL1& < VAL2& THEN MINVAL& = VAL1& ELSE MINVAL& = VAL2&
END FUNCTION

'
'NDXFixName$
'
'   1) Strips path off a file name.
'   2) Appends .NDX it file name does not already have it.
'
FUNCTION NDXFixName$ (file$)

    file$ = UCASE$(RTRIM$(LTRIM$(file$)))
    drive$ = NUL

    IF file$ = NUL THEN
        NDXFixName$ = "<N/A>" + SPACE$(9)
        EXIT FUNCTION
    END IF

    i% = INSTR(file$, ":")
    IF i% > 1 THEN
        drive$ = LEFT$(file$, i%)
        file$ = RIGHT$(file$, LEN(file$) - i%)
    END IF

    FOR i% = LEN(file$) - 1 TO 1 STEP -1
        IF MID$(file$, i%, 1) = "\" THEN EXIT FOR
    NEXT i%
    IF i% >= 0 THEN file$ = MID$(file$, i% + 1)

    i% = INSTR(file$, ".")
    IF i% < 1 THEN
        file$ = file$ + ".NDX"
    ELSE
        IF i% = LEN(file$) THEN file$ = file$ + "NDX"
    END IF

    NDXFixName$ = drive$ + file$


END FUNCTION

DEFSNG A-Z
SUB PARSE.LIST.EXPRESSION ()

  literal% = FALSE
  'PRGMlink$ = Nul
  'CURRprgm$ = MKI$(0)

  STARTptr% = 1
  DO
    IF STARTptr% > LEN(CURRexp$) THEN EXIT DO

    FOR i% = STARTptr% TO LEN(CURRexp$)
      SELECT CASE MID$(CURRexp$, i%, 1)
        CASE CHR$(59)
          IF NOT literal% THEN
            exp$ = MID$(CURRexp$, STARTptr%, i% - STARTptr%) + "+' '+" + MID$(CURRexp$, i% - STARTptr% + 2)
            EXIT FOR
          END IF

        CASE CHR$(34)
          literal% = NOT literal%

        CASE ELSE
      END SELECT
    NEXT i%

    IF exp$ = NUL THEN exp$ = CURRexp$
    CALL CompEXP(DBFfile%, status%, exp$, PRGM$, PRGMtype$)
    IF status% = 0 AND PRGMtype$ <> "E" THEN
        'ok
        VEWprgm$ = PRGM$
    ELSE
      'bad
      EXIT SUB
    END IF
    STARTptr% = i% + 1

  LOOP

  CURRexp$ = exp$

END SUB

DEFINT A-Z
SUB ParseComline (fileflag%, dbfmsg$, ndxmsg$, mode%)

    'call parsecompline
    'if no dbfname then ask for it and ndx name
    'if only dbfname don't ask for index
    'if DBF does not exist then loop error
    
  IF COMline$ <> NUL THEN              'database name in command, parse it out
      dBFname$ = COMline$
      i% = INSTR(dBFname$, " ")
      IF i% > 0 THEN
          NDXname$ = UCASE$(LTRIM$(RTRIM$(MID$(dBFname$, i%))))
          dBFname$ = UCASE$(LTRIM$(RTRIM$(LEFT$(dBFname$, i% - 1))))
      END IF
      IF INSTR(dBFname$, ".") = 0 THEN dBFname$ = RTRIM$(dBFname$) + ".DBF"
      IF INSTR(NDXname$, ".") = 0 AND NDXname$ <> NUL THEN
        NDXname$ = NDXname$ + ".NDX"
      END IF

    IF LEN(DIR$(dBFname$)) = 0 THEN
      COMline$ = NUL
      j% = DisplayErrorMsg(2, ERROR$, mb_OK)
    ELSE
      EXIT SUB
    END IF
  END IF

  DO WHILE COMline$ = NUL           'no database in command? Prompt for it
    dBFname$ = UCASE$(LTRIM$(RTRIM$(INPUTBOX$(dbfmsg$, "DATABASE FILE NAME", dBFname$))))
    IF dBFname$ = NUL THEN CALL QUIT
    IF INSTR(dBFname$, ".") = 0 THEN dBFname$ = RTRIM$(dBFname$) + ".DBF"
    IF LEN(DIR$(dBFname$)) = 0 THEN
      j% = DisplayErrorMsg(2, ERROR$, mb_OK)
    ELSE
      EXIT DO
    END IF
  LOOP

  IF ndxmsg$ <> NUL THEN
    NDXname$ = UCASE$(LTRIM$(RTRIM$(INPUTBOX$(ndxmsg$, "INDEX FILE NAME", NDXname$))))
  END IF
  IF INSTR(NDXname$, ".") = 0 AND NDXname$ <> NUL THEN
    NDXname$ = NDXname$ + ".NDX"
  END IF

END SUB

'
'Quit
'
'       1) Closes files.
'       2) Hides form.
'       3) Clears screen.
'       4) unloads forms
'
SUB QUIT ()

    CALL CLOSEFILES
    screen.HIDE
    CLS
    '$INCLUDE: 'C:\vbdos\newdml\COMMERCL.bi'
    END

END SUB

'
'RecordCount
'
'   1) Returns current record count.
'   2) Returns number of fields for a database.
'   3) Updates header display with current information
'
SUB RecordCount ()

    'Get current database record count
    CALL StatusDBF(DBFfile%, status%, DBFtype%, flags%, Trecords#, Tfields%, tlength%, UpDate$)
    IF status% = 0 THEN
        CALL DisplayHeader
    ELSE
        j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
    END IF

END SUB

'
'SELECTED
'
'   1) Returns TRUE% if record (RecDATA$) meets record selection
'      criteria in the form of SELprgm$.
'
FUNCTION SELECTED ()

    IF SELprgm$ = NUL THEN
        SELECTED = TRUE%
    ELSE
        CALL EvalEXP(status%, SELprgm$, record#, RECdata$, results$)
        IF status% = FALSE% THEN IF INSTR("TtYy", results$) > 0 THEN SELECTED = TRUE%
    END IF

END FUNCTION

'
'   Traps user input to a given desired type as indicated by mode%
'
'       mode% = TRAP_NUMBER -> only allows number (plus edit keys)
'
SUB TrapKey (mode%, keycode%)

    SELECT CASE mode%
        CASE TRAP_NUMBER
            SELECT CASE keycode%
                CASE 445, 8 TO 57, 127, 8   '0 to 9, delete key, backspace
                CASE ELSE               'not 0 to 9, delete key, backspace
                    SOUND 150, .5                'annoy user
                    keycode% = 0        'reset keycode
            END SELECT
        CASE TRAP_EDITKEY
            SELECT CASE keycode%
                CASE 45, 127, 8            'delete key, backspace
                CASE ELSE
                    SOUND 150, 1        'annoy user
                    keycode% = 0        'reset keycode
            END SELECT
    END SELECT

END SUB

