DECLARE SUB MakeExpr (count%)
'$FORM BROLIST
'--------------------------------------------------------
'(C) Copyright 1987 - 1993 AJS Publishing Inc.
'
' Module      : DMLSCREN.BAS
' Title       : Shared screen management for db/LIB DML
' Version     : 1.0
' Sys Req.    : MS Visual Basic for DOS 1.0
' Function    : Scrolls or blanks the screen, displays messages
' Written by  : Hank Marquis
' Last updated: 2/15/93
'--------------------------------------------------------

DECLARE SUB UpdateEditBox ()
DECLARE SUB GetKEY (NDXfile%, status%, NDXkey$, record#, KEYNEXT%)
DECLARE SUB DisplayMessage (msg$)
DECLARE SUB FindKeyRecord (FINDkey$, FINDrec#, mode%)
DECLARE SUB LoadRecords ()
DECLARE SUB QUIT ()
DECLARE SUB RecordCount ()
DECLARE SUB MakeBrowseExpr (count%)
DECLARE FUNCTION DisplayErrorMsg% (errcode%, errmsg$, mode%)
DECLARE FUNCTION DBFFixname$ (file$)
DECLARE FUNCTION NDXFixName$ (file$)
DECLARE FUNCTION SELECTED% ()
DECLARE FUNCTION MAXVAL& (BYVAL VAL1&, BYVAL VAL2&)
DECLARE FUNCTION MINVAL& (BYVAL VAL1&, BYVAL VAL2&)
'$INCLUDE: 'AJSDML.BI'      'shared DML routines

'$INCLUDE: 'C:\vbdos\catalog\db-CAT.bi'

'
'FindKeyRecord
'
'   1) Locates current position in indexed file by use of FINDkey$ and
'      FINDrec#.
'   2) Finds next key after FINDkey$ or previous key before FINDkey$.
'   3) Returns FINDrec#, which is FINDkeys$'s record number.
'
SUB FindKeyRecord (FINDkey$, FINDrec#, mode%)
    
    HOLDrec# = FINDrec#
    HOLDkey$ = FINDkey$

    'handle seek top of database & index
    IF FINDkey$ = "" OR FINDrec# = 0 THEN
        status% = 33
        retry% = 0
        DO WHILE (status% = 33) AND retry% < net_GetKeyRetry%
            CALL GetKEY(NDXfile%, status%, FINDkey$, FINDrec#, KEYFIRST%)
            retry% = retry% + 1
        LOOP
        EXIT SUB
    END IF
    
    'locate ourselves in the index
    status% = 33
    retry% = 0
    DO WHILE (status% = 33) AND retry% < net_GetKeyRetry%
        CALL GetKEY(NDXfile%, status%, FINDkey$, FINDrec#, KEYEXACT%)
        retry% = retry% + 1
    LOOP

    'handle duplicate block of keys
    IF (status% = 0) AND (FINDrec# <> HOLDrec#) AND (FINDkey$ = HOLDkey$) THEN
        DO
            status% = 33
            retry% = 0
            DO WHILE (status% = 33) AND retry% < net_GetKeyRetry%
                CALL GetKEY(NDXfile%, status%, FINDkey$, FINDrec#, KEYNEXT%)
                retry% = retry% + 1
            LOOP
        LOOP UNTIL status% OR (FINDrec# = HOLDrec#)
    END IF
   
END SUB

'
'FormatDisplay
'
'   1) Creates an array of formatted records for display.
'
SUB FormatDisplay ()
    
    sm_FldCount% = 0
    sm_FldOffsets$ = NUL
    fldnum% = sm_FldStart%
    LINElen% = 0
    
    IF VEWprgm$ = NUL THEN

        DO WHILE (fldnum% <= Tfields%) AND (LINElen% <= screen.activeform.width - 4)
            FLDname$ = FIELD_name$(FIELD_LIST%(fldnum%))  '???
            FLDsize% = FIELD_size%(FIELD_LIST%(fldnum%)) + 1
            sm_FldOffsets$ = sm_FldOffsets$ + CHR$(LINElen% + 1)
            LINElen% = LINElen% + FLDsize%
            line$ = line$ + LEFT$(FLDname$ + SPACE$(FLDsize%), FLDsize%)
            fldnum% = fldnum% + 1
            sm_FldCount% = sm_FldCount% + 1
        LOOP
        
        'build title bar
        LinePrgm$ = NUL
        CURRexp$ = NUL
        separator$ = NUL
        
        CALL MakeExpr(sm_FldStart% + sm_FldCount% - 1)

    ELSE
        sm_FldOffsets$ = CHR$(1)
        sm_FldStart% = 1
        line$ = VEWexp$
        CALL CompEXP(DBFfile%, status%, VEWexp$, LinePrgm$, DataType$)
    END IF
    
    IF status% THEN
        j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
        EXIT SUB
    END IF
    
    screen.activeform.EditWindow.CLS
    screen.activeform.EditWindow.REFRESH
    
    ML = Maxlines%
    IF ML > UBOUND(DATA_record$) OR WindowSizeHasChanged% THEN
        FIRSTrec# = DATA_RecordNo#(1)
        FIRSTkey$ = DATA_indexkey$(1)
        CALL LoadRecords
        WindowSizeHasChanged% = FALSE%
    END IF
    
    FOR record# = 1 TO ML
        
        IF NOT DATA_lock%(record#) THEN
            IF LEN(DATA_record$(record#)) = FALSE% THEN EXIT FOR
            RECdata$ = DATA_record$(record#)
            CALL EvalEXP(status%, LinePrgm$, record#, RECdata$, REC_fmtd$)
            IF status% THEN
                j% = DisplayErrorMsg(status, errmsg$, mb_OK)
                EXIT SUB
            END IF
            IF VEWprgm$ <> NUL THEN
              REC_fmtd$ = MID$(REC_fmtd$, sm_CurrentColumn%)
            END IF
            DATA_Formated$(record#) = REC_fmtd$
        ELSE
            sp% = (screen.activeform.width \ 2) - 13
            IF sp% < 1 THEN sp% = 1
            DATA_record$(record#) = SPACE$(sp%) + " <Record Not Available> " + SPACE$(sp%)
            DATA_Formated$(record#) = DATA_record$(record#)
        END IF
        
        screen.activeform.EditWindow.currentx = 1
        screen.activeform.EditWindow.PRINT DATA_Formated$(record#)

    NEXT record#

    screen.activeform.label3.Caption = " " + line$
    screen.activeform.EditWindow.REFRESH
        
END SUB

'
'LoadRecords
'
'   1) Loads record data from disk into an array.
'   2) Traps condition where no records match display.
'
SUB LoadRecords ()
    
    '??? need to comment

    tmpcap$ = screen.activeform.errmsgwin.Caption

    CALL RecordCount

    Maxlines% = MINVAL(CINT(BROLIST.EditWindow.height), Trecords#)
    gMaxlines% = Maxlines% + 1
    REDIM DATA_lock%(gMaxlines%), DATA_record$(gMaxlines%), DATA_indexkey$(gMaxlines%), DATA_RecordNo#(gMaxlines%), DATA_Formated$(gMaxlines%)
    WindowSizeHasChanged% = TRUE%

    'direction% = 0   'find NEXT key in sequence
    i% = 0

    IF NDXfile% > 0 THEN
        record# = FIRSTrec#
        NDXkey$ = FIRSTkey$
        CALL FindKeyRecord(NDXkey$, record#, 0)
        IF status% <> 0 THEN
            j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
            EXIT SUB
        END IF

        screen.activeform.errmsgwin.Caption = "Retrieving records..."

        DO
            IF NOT DATA_locked% THEN
                IF status% = FALSE% THEN
                  CALL GetREC(DBFfile%, status%, record#, RECdata$)
                END IF
                IF status% = FALSE% THEN
                    IF SELECTED THEN
                        i% = i% + 1
                        DATA_RecordNo#(i%) = record#
                        DATA_record$(i%) = RECdata$
                        DATA_indexkey$(i%) = NDXkey$
                        DATA_lock%(i%) = FALSE%
                    END IF
                ELSEIF status% = 5 THEN
                    i% = i% + 1
                    DATA_RecordNo#(i%) = record#
                    DATA_record$(i%) = SPACE$(tlength%)
                    DATA_indexkey$(i%) = NDXkey$
                    DATA_lock%(i%) = TRUE%
                ELSEIF status% = 113 THEN
                    errmsg$ = "Index file is out of sync with Database. Re-Index."
                    j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
                    CALL QUIT
                ELSE
                    'IF i% = 0 THEN EXIT SUB
                    status% = FALSE%
                    EXIT DO
                END IF
            END IF
            DATA_locked% = FALSE%

            mode% = 1
            status% = 33: retry% = 0
            DO WHILE (status% = 33) AND retry% < net_GetKeyRetry%
                CALL GetKEY(NDXfile%, status%, NDXkey$, record#, mode%)
                retry% = retry% + 1
            LOOP

            IF status% = 123 THEN
                EXIT DO
            ELSEIF status% <> 0 THEN
                DATA_locked% = TRUE%
                status% = FALSE%
            END IF
            
        LOOP WHILE i% < gMaxlines%

    ELSE    'no index only database

        screen.activeform.errmsgwin.Caption = "Retrieving records..."

        IF FIRSTrec# > 0 THEN
            record# = FIRSTrec# - 1
        ELSE
            record# = 0
        END IF

        DO
            record# = record# + 1
            CALL GetREC(DBFfile%, status%, record#, RECdata$)
            IF status% = FALSE% THEN
                IF SELECTED THEN
                    i% = i% + 1
                    DATA_RecordNo#(i%) = record#
                    DATA_record$(i%) = RECdata$
                    DATA_lock%(i%) = FALSE%
                END IF
            ELSEIF status% = 5 THEN
                i% = i% + 1
                DATA_RecordNo#(i%) = record#
                DATA_record$(i%) = SPACE$(tlength%)
                DATA_lock%(i%) = TRUE%
            ELSE
                status% = FALSE%
                EXIT DO
            END IF

        LOOP WHILE i% < gMaxlines%

    END IF

    IF i% < sm_CurrentRow% THEN sm_CurrentRow% = i%
    status% = FALSE%
    IF NOT NDXfile% THEN FIRSTrec# = record#

    'gMaxlines% = i%
    screen.activeform.errmsgwin.Caption = tmpcap$

    IF gMaxlines% = 0 THEN
        errmsg$ = " No records match current expression! Press F2" + CHR$(10) + CHR$(13)
        errmsg$ = errmsg$ + "and enter a new expression."
        j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
    END IF

END SUB

DEFSNG A-Z
'
'Creates a view expression consisting of all fields from
'sm_fldStart% to count%
'
SUB MakeExpr (count%)
        CURRexp$ = NUL

        FOR fldnum% = sm_FldStart% TO count%

            FLDname$ = FIELD_name$(FIELD_LIST%(fldnum%))
            FLDsize% = FIELD_size%(FIELD_LIST%(fldnum%))
            FLDlen% = FIELD_length%(FIELD_LIST%(fldnum%))
            FLDdec% = FIELD_decimals%(FIELD_LIST%(fldnum%))

            SELECT CASE FIELD_type$(FIELD_LIST%(fldnum%))
                CASE "C"
                      IF FLDsize% > FLDlen% THEN
                          CURRexp$ = CURRexp$ + separator$ + "Rpad(" + RTRIM$(FLDname$) + "," + MID$(STR$(FLDsize%), 2) + ",[ ])"
                      ELSE
                          CURRexp$ = CURRexp$ + separator$ + RTRIM$(FLDname$)
                      END IF

                CASE "D"
                    IF PROGNAME$ = "BROWSE" THEN
                      IF FLDsize% > FLDlen% THEN
                          CURRexp$ = CURRexp$ + separator$ + "Rpad(" + RTRIM$(FLDname$) + "," + MID$(STR$(FLDsize%), 2) + ",[ ])"
                      ELSE
                          'CURRexp$ = CURRexp$ + separator$ + "IIF( Left$(" + RTRIM$(FLDname$) + ",1)=[ ],Space$(8),DATE([*A7]," + RTRIM$(FLDname$) + "))"
                          CURRexp$ = CURRexp$ + separator$ + RTRIM$(FLDname$)
                      END IF
                    ELSE
                      IF FLDsize% > FLDlen% THEN
                          CURRexp$ = CURRexp$ + separator$ + "Rpad(DATE([*A7]," + RTRIM$(FLDname$) + ")," + MID$(STR$(FLDsize%), 2) + ",[ ])"
                      ELSE
                          CURRexp$ = CURRexp$ + separator$ + "IIF( Left$(" + RTRIM$(FLDname$) + ",1)=[ ],Space$(8),DATE([*A7]," + RTRIM$(FLDname$) + "))"
                      END IF
                    END IF

                CASE "N", "F"
                    CURRexp$ = CURRexp$ + separator$ + "Str(" + RTRIM$(FLDname$) + "," + STR$(FLDsize%) + "," + STR$(FLDdec%) + ")"

                CASE "L"
                    CURRexp$ = CURRexp$ + separator$ + "IIF(" + RTRIM$(FLDname$) + "," + CHR$(34) + LEFT$("T" + SPACE$(FLDsize%), FLDsize%) + CHR$(34) + "," + CHR$(34) + LEFT$("F" + SPACE$(FLDsize%), FLDsize%) + CHR$(34) + ")"

                CASE "M"
                    m$ = LEFT$("memo" + SPACE$(FLDsize% + 1), FLDsize% + 1)
                    e$ = "IIF(VAL(STR$(" + FLDname$ + "))>0, UPPER('" + m$ + "'),'" + m$ + "')"
                    CURRexp$ = CURRexp$ + separator$ + e$
            END SELECT

            separator$ = "+' '+"

        NEXT fldnum%

        CALL CompEXP(DBFfile%, status%, CURRexp$, LinePrgm$, DataType$)
        IF status% <> 0 THEN BEEP: STOP

END SUB

DEFINT A-Z
'
'ScrollDn
'
'   1) Manages the edit window for scrolling.
'
'      quiet% is a flag controlling error message display where:
'           quiet% = TRUE%   -> do not display any error messages
'           quiet% = FALSE%  -> do display any error messages
'
SUB ScrollDn (QUIET%)

    '??? need to comment this section
    
    IF NOT QUIET% THEN screen.activeform.EditBox.visible = FALSE%
    
    'get window size
    workrec% = Maxlines%
    status% = FALSE%

    'check database for additions
    CALL StatusDBF(DBFfile%, status%, DBFtype%, flags%, Trecords#, Tfields%, tlength%, UpDate$)
    
    'get next record
    IF NDXfile% > 0 THEN
        FINDkey$ = DATA_indexkey$(1)
        FINDrec# = DATA_RecordNo#(1)
        CALL FindKeyRecord(FINDkey$, FINDrec#, KEYPREV)
        CALL GetKEY(NDXfile%, status%, NDXkey$, record#, KEYPREV)
    ELSE
        record# = DATA_RecordNo#(1) - 1
        IF record# = 0 THEN
            record# = 1
            status% = TRUE%
        END IF
    END IF

    IF status% = FALSE% THEN

        DO
            CALL GetREC(DBFfile%, status%, record#, RECdata$)
            IF status% = FALSE% THEN
                IF SELECTED THEN
                    EXIT DO
                ELSEIF NOT SELECTED THEN
                    IF NDXfile% > 0 THEN
                        CALL GetKEY(NDXfile%, status%, NDXkey$, record#, KEYPREV)
                    ELSE
                        record# = record# - 1
                    END IF
                END IF
                IF status <> FALSE% OR record# < 1 THEN
                    BEEP
                    status% = -1    'hm 12/8
                    IF NOT QUIET THEN
                        screen.activeform.EditBox.visible = TRUE%
                        screen.activeform.EditBox.SETFOCUS
                    END IF
                    EXIT SUB
                END IF
            ELSE
                BEEP
                status% = -1    'hm 12/8
                IF NOT QUIET THEN
                    screen.activeform.EditBox.visible = TRUE%
                    screen.activeform.EditBox.SETFOCUS
                END IF
                EXIT SUB
            END IF
        LOOP UNTIL status
        
        IF status% AND NOT QUIET% THEN
            j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
        END IF
        
        IF status% THEN
            sp% = (screen.activeform.width \ 2) - 13
            IF sp% < 1 THEN sp% = 1
            REC_fmtd$ = SPACE$(sp%) + " <Record Not Available> " + SPACE$(sp%)
        ELSE
            CALL EvalEXP(status%, LinePrgm$, record#, RECdata$, REC_fmtd$)
            IF status% THEN
                j% = DisplayErrorMsg(status, errmsg$, mb_OK)
                IF NOT QUIET% THEN
                    screen.activeform.EditBox.visible = TRUE%
                    screen.activeform.EditBox.SETFOCUS
                END IF
                EXIT SUB
            END IF
        END IF

        ML = workrec%

        screen.activeform.EditWindow.currentx = 1
        screen.activeform.EditWindow.currenty = 0
        
        IF VEW_prgm$ <> NUL THEN
          REC_fmtd$ = MID$(REC_fmtd$, sm_CurrentColumn%)
        END IF
        screen.activeform.EditWindow.PRINT REC_fmtd$

        FOR workrec% = 1 TO ML
            screen.activeform.EditWindow.currentx = 1
            screen.activeform.EditWindow.PRINT DATA_Formated$(workrec%)
        NEXT

        screen.activeform.EditWindow.REFRESH
        
        FOR workrec% = ML TO 2 STEP -1
            DATA_Formated$(workrec%) = DATA_Formated$(workrec% - 1)
            DATA_RecordNo#(workrec%) = DATA_RecordNo#(workrec% - 1)
            DATA_indexkey$(workrec%) = DATA_indexkey$(workrec% - 1)
            DATA_record$(workrec%) = DATA_record$(workrec% - 1)
            DATA_lock%(workrec%) = DATA_lock%(workrec% - 1)
        NEXT

        DATA_Formated$(1) = REC_fmtd$
        DATA_RecordNo#(1) = record#
        DATA_record$(1) = RECdata$
        DATA_lock%(1) = FALSE%
        DATA_indexkey$(1) = NDXkey$
        
    ELSE
        BEEP
    END IF

    IF NOT QUIET% THEN
        screen.activeform.EditBox.visible = TRUE%
        screen.activeform.EditBox.SETFOCUS
    END IF
    
END SUB

'
'
'
SUB ScrollUp (QUIET%)
  
    IF NOT QUIET% THEN screen.activeform.EditBox.visible = FALSE%

    'get window size
    workrec% = Maxlines%
    status% = FALSE%
    
    'check database for additions
    CALL StatusDBF(DBFfile%, status%, DBFtype%, flags%, Trecords#, Tfields%, tlength%, UpDate$)


    'get next record
    IF NDXfile% > 0 THEN
        FINDkey$ = DATA_indexkey$(workrec%)
        FINDrec# = DATA_RecordNo#(workrec%)
        CALL FindKeyRecord(FINDkey$, FINDrec#, KEYNEXT)
        CALL GetKEY(NDXfile%, status%, NDXkey$, record#, KEYNEXT)
    ELSE
        'increment record pointer
        record# = DATA_RecordNo#(workrec%) + 1
        IF record# >= Trecords# THEN
            IF record# > Trecords# THEN
                CALL RecordCount                'update header display
            ELSEIF record# < Trecords# THEN
                CALL RecordCount                'update header display
            END IF
        END IF
    END IF

    'fetch next database record
    IF status% = FALSE% THEN
        DO
            CALL GetREC(DBFfile%, status%, record#, RECdata$)
            IF status% = FALSE% THEN
                IF SELECTED THEN
                    EXIT DO
                ELSEIF NOT SELECTED THEN
                    IF NDXfile% > 0 THEN
                        CALL GetKEY(NDXfile%, status%, NDXkey$, record#, KEYNEXT)
                    ELSE
                        record# = record# + 1
                    END IF
                END IF
                IF status <> FALSE% OR record# > Trecords# THEN
                    BEEP
                    status% = -1    'hm 12/8
                    IF NOT QUIET THEN
                        screen.activeform.EditBox.visible = TRUE%
                        screen.activeform.EditBox.SETFOCUS
                    END IF
                    EXIT SUB
                END IF
            ELSE
                BEEP
                status% = -1    'hm 12/8
                GOSUB DoEditBox
                EXIT SUB
            END IF
        LOOP UNTIL status
    END IF
    
    'end of database trap
    IF status% THEN
        IF status% = 113 AND NDXfile% = FALSE% THEN
            BEEP
            status% = TRUE%
            GOSUB DoEditBox
            EXIT SUB
        ELSEIF status% = 123 THEN
            BEEP
            status% = TRUE%
            GOSUB DoEditBox
            EXIT SUB
        END IF
        IF NOT QUIET% THEN j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
        sp% = (screen.activeform.width \ 2) - 13
        IF sp% < 1 THEN sp% = 1
        DATA_record$(workrec%) = SPACE$(tlength%)
        DATA_Formated$(workrec%) = SPACE$(sp%) + " <Record Not Available> " + SPACE$(sp%)
    ELSE
        CALL EvalEXP(status%, LinePrgm$, record#, RECdata$, REC_fmtd$)
        IF status% THEN
            j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
            GOSUB DoEditBox
            EXIT SUB
        END IF
    END IF

    screen.activeform.EditWindow.currenty = 0

    ML = workrec%
    FOR workrec% = 1 TO ML - 1
        DATA_Formated$(workrec%) = DATA_Formated$(workrec% + 1)
        DATA_RecordNo#(workrec%) = DATA_RecordNo#(workrec% + 1)
        DATA_indexkey$(workrec%) = DATA_indexkey$(workrec% + 1)
        DATA_record$(workrec%) = DATA_record$(workrec% + 1)
        DATA_lock%(workrec%) = DATA_lock%(workrec% + 1)
        screen.activeform.EditWindow.currentx = 1
        screen.activeform.EditWindow.currenty = workrec% - 1
        screen.activeform.EditWindow.PRINT DATA_Formated$(workrec%)
    NEXT

    screen.activeform.EditWindow.currentx = 1
   
    IF VEW_prgm$ <> NUL THEN
      REC_fmtd$ = MID$(REC_fmtd$, sm_CurrentColumn%)
    END IF
    screen.activeform.EditWindow.PRINT REC_fmtd$
    
    DATA_Formated$(ML) = REC_fmtd$
    DATA_RecordNo#(ML) = record#
    DATA_record$(ML) = RECdata$
    DATA_lock%(ML) = FALSE%
    DATA_indexkey$(ML) = NDXkey$

    GOSUB DoEditBox

    EXIT SUB

DoEditBox:
    IF NOT QUIET% THEN
        screen.activeform.EditBox.visible = TRUE%
        screen.activeform.EditBox.SETFOCUS
    END IF
    RETURN
END SUB

