DECLARE FUNCTION SAMPLE.GetInput$ ()
DECLARE FUNCTION Ctg..FileName$ (PathAndFile$)
DECLARE FUNCTION Ctg..FixName$ (file$, typ$)
DECLARE FUNCTION Ctg..GetHandle% (IndexName$)
DECLARE FUNCTION Ctg..LoadStructure% (DBFfile%)
DECLARE SUB Ctg..PutIndexName (DBFfile%, IndexName$, SelectExpression$, IndexStatus%)
DECLARE SUB Ctg..GetCatalog (CatName$, CatIndexNames$(), CatIndexSelects$(), CatIndexStatus%())
DECLARE SUB Ctg..ReadCatalog (CatName$, CatIndexNames$(), CatIndexSelects$(), CatIndexStatus%())
DECLARE SUB Ctg..ErrorMessage (errcode%)
DECLARE SUB Ctg..WhoAmI ()
DECLARE FUNCTION DB..Maintenance$ (DBFfile%, rebuild%)
DECLARE FUNCTION DB..BuildIndex% (DBFfile%, NDXname$, SelectExpression$, Unique%, KeyExpression$, RecordsIndexed#, DuplicateKeys#)
DECLARE FUNCTION DB..ReadFields% (DBFfile%, FieldData$(), MEMOdata$(), RecordData$)
DECLARE FUNCTION DB..GetFieldName$ (DBFfile%, FieldNum%)
DECLARE FUNCTION DB..GetTfields% (DBFfile%)
DECLARE FUNCTION DB..GetTlength% (DBFfile%)
DECLARE FUNCTION DB..GetTrecords# (DBFfile%)
DECLARE FUNCTION DB..OpenDatabase% (DBFfile%, DataFileName$, FileAccessMode%)
DECLARE FUNCTION DB..CloseDatabase% (DBFfile%)
DECLARE FUNCTION DB..SaveRecord% (DBFfile%, record#, NewRecordData$)
DECLARE FUNCTION DB..ConformFields% (DBFfile%, FieldData$(), MEMOdata$(), RecordData$)
DECLARE FUNCTION DB..Selected% (SelectionMacro$, record#, DataRecord$)
'DECLARE FUNCTION DB..NextAvailable (DBFfile%)
'--------------------------------------------------------
'(C) Copyright 1987 - 1993 AJS Publishing Inc.
'
' Module      : BROWSE-B.BAS
' Title       : Browse
' Version     : 1.0
' Sys Req.    : MS Visual Basic for MS-DOS 1.0
' Supports    : DBF, NDX and DBT files
' Function    : Browse and Edit Database Records
' Written by  : Hank Marquis
' Last updated: 2/15/93
'--------------------------------------------------------
DECLARE SUB DisplayPrompt (prompt%)
DECLARE SUB DisplayPrompt (prompt%)
DECLARE SUB DisplayHeader ()
DECLARE SUB CLOSEFILES ()
DECLARE SUB QUIT ()
DECLARE SUB FindKeyRecord (FINDkey$, FINDrec#, mode%)
DECLARE SUB RecordCount ()
DECLARE SUB UpdateEditBox ()
DECLARE SUB FormatDisplay ()
DECLARE SUB LoadRecords ()
DECLARE SUB GetKEY (NDXfile%, status%, NDXkey$, record#, KEYNEXT%)
DECLARE SUB ScrollUp (QUIET%)
DECLARE SUB ScrollDn (QUIET%)
DECLARE FUNCTION SELECTED% ()
DECLARE FUNCTION DisplayErrorMsg% (errcode%, errmsg$, mode%)
DECLARE FUNCTION MAXVAL& (BYVAL VAL1&, BYVAL VAL2&)
DECLARE FUNCTION DisplayErrorMsg% (errcode%, errmsg$, mode%)
'$FORM BROLIST               'BROWSE user interface
'$INCLUDE: 'C:\vbdos\catalog\db-CAT.bi'
'$INCLUDE: 'AJSDML.BI'      'shared DML routines
'$INCLUDE: 'BROWSE.BI'      'shared DML routines
DEFINT A-Z                  'define variables to default to integer
'load and run browse
LOAD BROLIST

'
'DeleteRecord
'
'   1) Toggles a records delete flag.
'   2) Updates record status display with delete status.
'
SUB DeleteRecord ()
  
    IF DATA_record$(sm_CurrentRow%) = NUL THEN EXIT SUB

    IF ASC(DATA_record$(sm_CurrentRow%)) = REC_deleted THEN
        MID$(DATA_record$(sm_CurrentRow%), 1, 1) = CHR$(REC_normal)
    ELSE
        MID$(DATA_record$(sm_CurrentRow%), 1, 1) = CHR$(REC_deleted)
    END IF
    RECchanged% = TRUE%
    
    IF ASC(DATA_record$(sm_CurrentRow%)) = REC_deleted THEN
        BROLIST.DelFlag.Caption = "DEL"
    ELSE
        BROLIST.DelFlag.Caption = ""
    END IF
    
END SUB

'
'LockRecord
'
'   1) Locks a database record.
'   2) Enables locked record timeout via Timer1 is able to secure lock.
'
SUB LockRecord ()

    record# = DATA_RecordNo#(sm_CurrentRow%)
    IF record# = 0 THEN EXIT SUB

    count# = 1
    
    CALL LockREC(DBFfile%, status%, record#, count#)
    IF status% <> 0 THEN

        j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
        DATA_locked% = TRUE%
        REC_locked% = FALSE%

    ELSE

        DATA_locked% = FALSE%
        REC_locked% = TRUE%

        CALL GetREC(DBFfile%, status%, record#, RECdata$)

        IF DATA_record$(sm_CurrentRow%) <> RECdata$ THEN
            errmsg$ = "RECORD HAS CHANGED! Processing anyway."
            j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
            
            DATA_changed% = TRUE%
            DATA_record$(sm_CurrentRow%) = RECdata$

            CALL EvalEXP(status%, KEYprgm$, record#, DATA_record$(sm_CurrentRow%), DATA_indexkey$(sm_CurrentRow%))

        END IF

        'loads the field array especially memo fields
        FOR FLDnum% = 1 TO Tfields%
          FldName$ = NUL
          CALL GetFLD(DBFfile%, status%, FLDnum%, FldName$, FLDdata$, RECdata$)
          FIELD_data$(FLDnum%) = FLDdata$
        NEXT

        CALL DisplayPrompt(msg_LockRecord)

        BROLIST.timer1.enabled = -1
        BROLIST.timer1.interval = net_LockTimeou#

    END IF

END SUB

'
'ProcessLockedRecord
'
'   1) Saves a record to the database.
'   2) Updates index (if any)
'   3) Unlocks record after database update.
'
SUB ProcessLockedRecord ()

    BROLIST.timer1.enabled = FALSE%

    IF RECchanged% THEN

      FOR FLDnum% = 1 TO Tfields%
        FldName$ = NUL
        CALL GetFLD(DBFfile%, status%, FLDnum%, FldName$, FLDdata$, DATA_record$(sm_CurrentRow%))
        FIELD_data$(FLDnum%) = FLDdata$
      NEXT

      status% = DB..SaveRecord(DBFfile%, DATA_RecordNo#(sm_CurrentRow%), DATA_record$(sm_CurrentRow%))
      
      IF status% THEN
          j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
      END IF

        IF NDXfile% THEN        'reposition ourselves in  index
                OLDkey$ = DATA_indexkey$(sm_CurrentRow%)
                KEYprgm$ = KeyMacros$(NDXfile%)
                CALL EvalEXP(status%, KEYprgm$, record#, DATA_record$(sm_CurrentRow%), NEWkey$)
              DATA_indexkey$(sm_CurrentRow%) = NEWkey$
            
        END IF
        
    END IF

    IF REC_locked% THEN
        count# = 1
        CALL UnLockREC(DBFfile%, status%, DATA_RecordNo#(sm_CurrentRow%), count#)
        IF status% THEN
            j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
        END IF
        CALL DisplayPrompt(msg_normal)
    END IF

    REC_locked% = FALSE%
    
    IF NDXfile% AND OLDkey$ <> NEWkey$ AND RECchanged% THEN
        IF sm_CurrentRow% = 1 AND Maxlines% > 1 THEN  'IF first record, use next
          DATA_RecordNo#(1) = DATA_RecordNo#(2)   'start at 1st record on screen
          DATA_indexkey$(1) = DATA_indexkey$(2)   'start at 1st record on screen
        END IF

        FIRSTrec# = DATA_RecordNo#(1)
        FIRSTkey$ = DATA_indexkey$(1)
        CALL FindKeyRecord(FIRSTkey$, FIRSTrec#, 0)

        OLD_CurrentRow% = sm_CurrentRow%
        'Use ScrollDn routine to do the hard work!
        'hide edit box
        EditBox.visible = FALSE%
        'hide scroll bar
        hscroll1.visible = FALSE%
        working% = TRUE%
        
        IF DATA_indexkey$(OLD_CurrentRow%) < DATA_indexkey$(1) OR DATA_indexkey$(OLD_CurrentRow%) > DATA_indexkey$(Maxlines%) THEN
          CALL ScrollDn(TRUE%)            'Call scroll down. TRUE% means run in quiet mode with no error reported.
          FIRSTrec# = DATA_RecordNo#(1)   'start at 1st record on screen
          FIRSTkey$ = DATA_indexkey$(1)   'start at 1st record on screen
        END IF

        FOR i% = 1 TO Maxlines%         'For edit windows height...
            CALL ScrollUp(TRUE%)        'Call scroll up. TRUE% means run in quiet mode with no error reported.
            dummy = DOEVENTS()          'Process other keys.
            IF status% THEN EXIT FOR    'If an error occurs or escape is pressed then exit display routine.
        NEXT
        working% = FALSE%
        EditBox.visible = TRUE%
        hscroll1.visible = TRUE%
        sm_CurrentRow% = OLD_CurrentRow%

        CALL LoadRecords
        CALL FormatDisplay
        CALL UpdateEditBox
    END IF

    RECchanged% = FALSE%

END SUB

'
'SaveField
'
'   1) Saves modified field data to record, DOES NOT UPDATE DATABASE!
'   2) Prints modified field data to screen.
'
SUB SaveField ()

    'store field
    FldName$ = NUL
    FLDnum% = FIELD_LIST%(sm_CurrentColumn% + sm_FldStart% - 1)
        
    IF FIELD_type$(FLDnum%) <> "M" THEN
        FLDdata$ = LEFT$(BROLIST.EditBox.text + SPACE$(FIELD_length%(FLDnum%)), FIELD_length%(FLDnum%))
    ELSE
        FLDdata$ = BlockAddress$
    END IF
    
    CALL PutFLD(DBFfile%, status%, FLDnum%, FldName$, FLDdata$, DATA_record$(sm_CurrentRow%))
    IF status% THEN
        j% = DisplayErrorMsg(status%, errmsg$, mb_OK)
        EXIT SUB
    END IF
    RECchanged% = TRUE%
    FIELD_data$(FLDnum%) = FLDdata$
    
    'update displayed record
    CALL EvalEXP(status%, LinePrgm$, record#, DATA_record$(sm_CurrentRow%), REC_fmtd$)
    DATA_Formated$(sm_CurrentRow%) = REC_fmtd$

    'update display
    BROLIST.EditWindow.currenty = sm_CurrentRow% - 1
    BROLIST.EditWindow.currentx = 1
    BROLIST.EditWindow.PRINT DATA_Formated$(sm_CurrentRow%);

END SUB

'
'UpdateEditBox
'
'   1) Loads the edit box with the current fields data for editing.
'   2) Resets the changed flag.
'
SUB UpdateEditBox ()

    IF Trecords# = 0 THEN EXIT SUB

    'check for locked records & update if needed
    IF DATA_lock%(sm_CurrentRow%) THEN
        CALL GetREC(DBFfile%, status%, DATA_RecordNo#(sm_CurrentRow%), RECdata$)
        IF status% = FALSE% THEN
            DATA_lock%(sm_CurrentRow%) = 0
            CALL EvalEXP(status%, LinePrgm$, DATA_RecordNo#(sm_CurrentRow%), RECdata$, REC_fmtd$)
            IF status% = 0 THEN
                IF VEWprgm$ <> NUL THEN REC_fmtd$ = MID$(REC_fmtd$, sm_CurrentColumn%)
                DATA_record$(sm_CurrentRow%) = RECdata$
                DATA_Formated$(sm_CurrentRow%) = REC_fmtd$
                screen.activeform.EditWindow.currentx = 1
                screen.activeform.EditWindow.currenty = sm_CurrentRow% - 1
                screen.activeform.EditWindow.PRINT DATA_Formated$(sm_CurrentRow%)
                screen.activeform.EditWindow.REFRESH
            END IF
        END IF
    END IF
    
    'determine physical field number
    FLDnum% = sm_CurrentColumn% + sm_FldStart% - 1
       
    ebstate% = BROLIST.EditBox.Visible

    'update edit box
    BROLIST.EditBox.Visible = FALSE%
    BROLIST.EditBox.top = sm_CurrentRow% - 1
    BROLIST.EditBox.left = ASC(MID$(sm_FldOffsets$, sm_CurrentColumn%, 1) + " ")
    BROLIST.EditBox.text = LTRIM$(RTRIM$(MID$(DATA_Formated$(sm_CurrentRow%), BROLIST.EditBox.left, FIELD_size%(FIELD_LIST%(FLDnum%)))))
    BROLIST.EditBox.width = FIELD_size%(FIELD_LIST%(FLDnum%)) + 1
    BROLIST.EditBox.Visible = ebstate%

    IF BROLIST.EditBox.Visible THEN BROLIST.EditBox.SETFOCUS
    
    'reset changed flag to false as this is a new field
    DATA_changed% = FALSE%

    'update display of delete flag
    IF DATA_record$(sm_CurrentRow%) <> NUL THEN
        IF ASC(DATA_record$(sm_CurrentRow%) + " ") = REC_deleted THEN
            BROLIST.DelFlag.Caption = "DEL"
        ELSE
            BROLIST.DelFlag.Caption = ""
        END IF
    END IF

    BROLIST.EditBox.Visible = ebstate%

END SUB

