VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Yes Man"
   Height          =   2436
   Left            =   1788
   LinkTopic       =   "Form1"
   ScaleHeight     =   2016
   ScaleWidth      =   2796
   Top             =   3876
   Width           =   2892
   Begin CommandButton Command2 
      Caption         =   "Reset"
      Height          =   493
      Left            =   128
      TabIndex        =   3
      Top             =   833
      Width           =   1936
   End
   Begin VScrollBar VScroll1 
      Height          =   1564
      LargeChange     =   10
      Left            =   2304
      TabIndex        =   2
      Top             =   119
      Width           =   272
   End
   Begin HScrollBar HScroll1 
      Height          =   272
      LargeChange     =   10
      Left            =   128
      TabIndex        =   1
      Top             =   1428
      Width           =   1936
   End
   Begin CommandButton Command1 
      Caption         =   "Say 'Yes', Bill"
      Height          =   612
      Left            =   128
      TabIndex        =   0
      Top             =   119
      Width           =   1936
   End
End

DefInt A-Z

Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Function GetDC Lib "USER" (ByVal hWnd)
Declare Function ReleaseDC Lib "USER" (ByVal hWnd, ByVal DC)

Const SRCCOPY = &HCC0020     ' (DWORD) dest = source
Const SRCAND = &H8800C6      ' (DWORD) dest = source AND dest
Const SRCPAINT = &HEE0086    ' (DWORD) dest = source OR dest

Dim Shared DisplayDC, ScrCapDC, WorkSpaceDC
Dim Shared DWidth, DHeight, DestX, DestY
Dim Shared ResetFlag, LastX, LastY

Sub Command1_Click ()
    
    '-- Get the Display DC
    DisplayDC = GetDC(0)

    '-- Have we moved?
    If LastX <> DestX Or LastY <> DestY Then
        '-- Clean up the last image
        If Not ResetFlag Then ResetScreen
        '-- Capture the screen to the ScrCap picture control
        Success = BitBlt(ScrCapDC, 0, 0, DWidth, DHeight, DisplayDC, DestX, DestY, SRCCOPY)
    End If

    '-- Make Bill Bob his Big head
    For i = 0 To 6
        MaskDC = Masks.Mask(i).hDC
        ImageDC = Images.Frame(i).hDC
        GoSub DisplayFrame:
    Next
    For i = 5 To 0 Step -1
        MaskDC = Masks.Mask(i).hDC
        ImageDC = Images.Frame(i).hDC
        GoSub DisplayFrame:
    Next
    
    '-- Release the screen
    Success = ReleaseDC(0, DisplayDC)
    
    '-- Save the current position for ResetScreen
    LastX = DestX
    LastY = DestY

    '-- un-set the ResetFlag
    ResetFlag = False

    Exit Sub
    
DisplayFrame:
            
    '-- STEP 1: Copy the Display area to the WorkSpace
    Success = BitBlt(WorkSpaceDC, 0, 0, DWidth, DHeight, ScrCapDC, 0, 0, SRCCOPY)

    '-- STEP 2: AND the Mask to the WorkSpace
    Success = BitBlt(WorkSpaceDC, 0, 0, DWidth, DHeight, MaskDC, 0, 0, SRCAND)

    '-- STEP 3: OR the Image to the WorkSpace
    Success = BitBlt(WorkSpaceDC, 0, 0, DWidth, DHeight, ImageDC, 0, 0, SRCPAINT)

    '-- STEP 4: Copy the WorkSpace to the Display
    Success = BitBlt(DisplayDC, DestX, DestY, DWidth, DHeight, WorkSpaceDC, 0, 0, SRCCOPY)

    Return

End Sub

Sub Command2_Click ()

    ResetScreen

End Sub

Sub Form_Load ()

    '-- Set the limits of the scroll bars to the size of the screen
    HScroll1.Max = 800
    VScroll1.Max = 600

    '-- Set the destination X and Y on the form for the image
    DestX = 100
    DestY = 100
    
    '-- Set the width and height (for BitBlt) to the size of the images.
    DWidth = 117
    DHeight = 164

    '-- Get the static DC handles
    WorkSpaceDC = Masks.WorkSpace.hDC
    ScrCapDC = Images.ScrCap.hDC
    
    '-- Access all images so they are in the cache
    For i = 0 To 6
        ImageDC = Images.Frame(i).hDC
        MaskDC = Masks.Mask(i).hDC
        Success = BitBlt(DisplayDC, 0, 0, 0, 0, ImageDC, 0, 0, SRCCOPY)
        Success = BitBlt(DisplayDC, 0, 0, 0, 0, MaskDC, 0, 0, SRCCOPY)
    Next

    '-- Initialize the ResetFlag
    ResetFlag = True

End Sub

Sub Form_Unload (Cancel As Integer)
    
    '-- Clean up the last image
    If Not ResetFlag Then ResetScreen
    
    End

End Sub

Sub HScroll1_Change ()

    DestX = HScroll1.Value

End Sub

Sub ResetScreen ()

    '-- Touch up the screen.
    Success = BitBlt(DisplayDC, LastX, LastY, DWidth, DHeight, ScrCapDC, 0, 0, SRCCOPY)
    If Success = 0 Then Beep
    ResetFlag = True

End Sub

Sub VScroll1_Change ()

    DestY = VScroll1.Value

End Sub
