' ------------------------------------------------------------------------
'
'     APITYPES.TXT -- Windows 3.1 API Type Declarations for Visual Basic
'
'                       Copyright (C) 1992 Desaware
'
'  You have a royalty-free right to use, modify, reproduce and distribute
'  this file (and/or any modified version) in any way you find useful,
'  provided that you agree that Desaware and Ziff-Davis Press has no
'  warranty, obligation or liability for its contents.
'  Refer to the Ziff-Davis Visual Basic Programmer's Guide to the
'  Windows API for further information.
'
'  This file is in part derived from winapi.txt from Microsoft
'
' ------------------------------------------------------------------------

' Type definitions

Type RECT   '8 Bytes
	left As Integer
	top As Integer
	right As Integer
	bottom As Integer
End Type

Type POINTAPI  '4 Bytes - Synonymous with LONG
	x As Integer
	y As Integer
End Type

Type SIZEAPI  '4 Bytes - Synonymous with LONG
	x As Integer
	y As Integer
End Type

' ParameterBlock description structure for use with LoadModule
Type PARAMETERBLOCK  '14 Bytes
	wEnvSeg As Integer
	lpCmdLine As Long
	lpCmdShow As Long
	dwReserved As Long
End Type


'  OpenFile() Structure
Type OFSTRUCT  '136 Bytes
	cBytes As String * 1
	fFixedDisk As String * 1
	nErrCode As Integer
	reserved As String * 4
	szPathName As String * 128
End Type

'  Bitmap Header Definition
Type BITMAP '14 bytes
	bmType As Integer
	bmWidth As Integer
	bmHeight As Integer
	bmWidthBytes As Integer
	bmPlanes As String * 1
	bmBitsPixel As String * 1
	bmBits As Long
End Type

Type RGBTRIPLE    '3 Bytes
	rgbtBlue As String * 1
	rgbtGreen As String * 1
	rgbtRed As String * 1
End Type

Type RGBQUAD      '4 Bytes
	rgbBlue As String * 1
	rgbGreen As String * 1
	rgbRed As String * 1
	rgbReserved As String * 1
End Type

'  structures for defining DIBs
Type BITMAPCOREHEADER '12 bytes
	bcSize As Long
	bcWidth As Integer
	bcHeight As Integer
	bcPlanes As Integer
	bcBitCount As Integer
End Type

Type BITMAPINFOHEADER '40 bytes
	biSize As Long
	biWidth As Long
	biHeight As Long
	biPlanes As Integer
	biBitCount As Integer
	biCompression As Long
	biSizeImage As Long
	biXPelsPerMeter As Long
	biYPelsPerMeter As Long
	biClrUsed As Long
	biClrImportant As Long
End Type

Type BITMAPINFO   'Varies
	bmiHeader As BITMAPINFOHEADER
	bmiColors As String * 128 ' Array length is arbitrary; may be changed
End Type

Type BITMAPCOREINFO  'Varies
	bmciHeader As BITMAPCOREHEADER
	bmciColors As String * 48 ' Array length is arbitrary; may be changed
End Type

Type BITMAPFILEHEADER   '14 Bytes
	bfType As Integer
	bfSize As Long
	bfReserved1 As Integer
	bfReserved2 As Integer
	bfOffBits As Long
End Type


'  Clipboard Metafile Picture Structure
Type HANDLETABLE
	objectHandle As String * 512 ' Array length is arbitrary; may be changed
End Type

Type METARECORD
	rdSize As Long
	rdFunction As Integer
	rdParm As String * 512 ' Array length is arbitrary; may be changed
End Type


Type METAFILEPICT    '8 Bytes
	mm As Integer
	xExt As Integer
	yExt As Integer
	hmf As Integer
End Type

Type METAHEADER      '18 Bytes
	mtType As Integer
	mtHeaderSize As Integer
	mtVersion As Integer
	mtSize As Long
	mtNoObjects As Integer
	mtMaxRecord As Long
	mtNoParameters As Integer
End Type

Type TEXTMETRIC   '31 Bytes
	tmHeight As Integer
	tmAscent As Integer
	tmDescent As Integer
	tmInternalLeading As Integer
	tmExternalLeading As Integer
	tmAveCharWidth As Integer
	tmMaxCharWidth As Integer
	tmWeight As Integer
	tmItalic As String * 1
	tmUnderlined As String * 1
	tmStruckOut As String * 1
	tmFirstChar As String * 1
	tmLastChar As String * 1
	tmDefaultChar As String * 1
	tmBreakChar As String * 1
	tmPitchAndFamily As String * 1
	tmCharSet As String * 1
	tmOverhang As Integer
	tmDigitizedAspectX As Integer
	tmDigitizedAspectY As Integer
End Type

Type NEWTEXTMETRIC   '41 Bytes
	tmHeight As Integer
	tmAscent As Integer
	tmDescent As Integer
	tmInternalLeading As Integer
	tmExternalLeading As Integer
	tmAveCharWidth As Integer
	tmMaxCharWidth As Integer
	tmWeight As Integer
	tmItalic As String * 1
	tmUnderlined As String * 1
	tmStruckOut As String * 1
	tmFirstChar As String * 1
	tmLastChar As String * 1
	tmDefaultChar As String * 1
	tmBreakChar As String * 1
	tmPitchAndFamily As String * 1
	tmCharSet As String * 1
	tmOverhang As Integer
	tmDigitizedAspectX As Integer
	tmDigitizedAspectY As Integer
   ntmFlags As Long
   ntmSizeEM As Integer
   ntmCellHeight As Integer
   ntmAvgWidth As Integer
End Type

'  GDI Logical Objects:

'  Pel Array
Type PELARRAY  ' 10 Bytes
	paXCount As Integer
	paYCount As Integer
	paXExt As Integer
	paYExt As Integer
	paRGBs As Integer
End Type

'  Logical Brush (or Pattern)
Type LOGBRUSH     '8 Bytes
	lbStyle As Integer
	lbColor As Long
	lbHatch As Integer
End Type

'  Logical Pen
Type LOGPEN    '10 Bytes
	lopnStyle As Integer
	lopnWidth As POINTAPI
	lopnColor As Long
End Type

Type PALETTEENTRY    '4 Bytes
	peRed As String * 1
	peGreen As String * 1
	peBlue As String * 1
	peFlags As String * 1
End Type

'  Logical Palette
Type LOGPALETTE
	palVersion As Integer
	palNumEntries As Integer
	palPalEntry As String * 252 ' Array length is arbitrary; may be changed
End Type

'  Logical Font

Type LOGFONT   ' 50 Bytes
	lfHeight As Integer
	lfWidth As Integer
	lfEscapement As Integer
	lfOrientation As Integer
	lfWeight As Integer
	lfItalic As String * 1
	lfUnderline As String * 1
	lfStrikeOut As String * 1
	lfCharSet As String * 1
	lfOutPrecision As String * 1
	lfClipPrecision As String * 1
	lfQuality As String * 1
	lfPitchAndFamily As String * 1
	lfFaceName As String * 32
End Type

Type NEWLOGFONT   ' 146 Bytes
	lfHeight As Integer
	lfWidth As Integer
	lfEscapement As Integer
	lfOrientation As Integer
	lfWeight As Integer
	lfItalic As String * 1
	lfUnderline As String * 1
	lfStrikeOut As String * 1
	lfCharSet As String * 1
	lfOutPrecision As String * 1
	lfClipPrecision As String * 1
	lfQuality As String * 1
	lfPitchAndFamily As String * 1
	lfFaceName As String * 32
   lfFullName As String * 64
   lfStyle As String * 32
End Type


Type EVENTMSG  '10 Bytes
	message As Integer
	paramL As Integer
	paramH As Integer
	time As Long
End Type

'  Message structure
Type MSG    '18 Bytes
	hWnd As Integer
	message As Integer
	wParam As Integer
	lParam As Long
	time As Long
	pt As POINTAPI
End Type

Type PAINTSTRUCT     '32 Bytes
	hDC As Integer
	fErase As Integer
	rcPaint As RECT
	fRestore As Integer
	fIncUpdate As Integer
	rgbReserved As String * 16
End Type

Type CREATESTRUCT
	lpCreateParams As Long     '34 Bytes
	hInstance As Integer
	hMenu As Integer
	hWndParent As Integer
	cy As Integer
	cx As Integer
	y As Integer
	x As Integer
	style As Long
	lpszName As Long
	lpszClass As Long
	ExStyle As Long
End Type

Type MEASUREITEMSTRUCT  '14 Bytes
	CtlType As Integer
	CtlID As Integer
	itemID As Integer
	itemWidth As Integer
	itemHeight As Integer
	itemData As Long
End Type

'  DRAWITEMSTRUCT for ownerdraw
Type DRAWITEMSTRUCT     '26 Bytes
	CtlType As Integer
	CtlID As Integer
	itemID As Integer
	itemAction As Integer
	itemState As Integer
	hWndItem As Integer
	hDC As Integer
	rcItem As RECT
	itemData As Long
End Type

'  DELETEITEMSTRUCT for ownerdraw
Type DELETEITEMSTRUCT   '12 Bytes
	CtlType As Integer
	CtlID As Integer
	itemID As Integer
	hWndItem As Integer
	itemData As Long
End Type

'  COMPAREITEMSTRUCT for ownerdraw sorting
Type COMPAREITEMSTRUCT  '18 Bytes
	CtlType As Integer
	CtlID As Integer
	hWndItem As Integer
	itemID1 As Integer
	itemData1 As Long
	itemID2 As Integer
	itemData2 As Long
End Type

Type MENUITEMTEMPLATEHEADER   '4 Bytes
	versionNumber As Integer
	offset As Integer
End Type

Type MENUITEMTEMPLATE   'Varies depending on the size of the mtString array
	mtOption As Integer
	mtID As Integer
	mtString As String * 1
End Type

Type DCB    '25 Bytes
	Id As String * 1
	BaudRate As Integer
	ByteSize As String * 1
	Parity As String * 1
	StopBits As String * 1
	RlsTimeout As Integer
	CtsTimeout As Integer
	DsrTimeout As Integer

	Bits1 As String * 1 ' The fifteen actual DCB bit-sized data fields
	Bits2 As String * 1 ' within these two bytes can be manipulated by
			  ' bitwise logical And/Or operations.  Refer to
			  ' Chapter 14 for further information

	XonChar As String * 1
	XoffChar As String * 1
	XonLim As Integer
	XoffLim As Integer
	PeChar As String * 1
	EofChar As String * 1
	EvtChar As String * 1
	TxDelay As Integer
End Type

Type COMSTAT   '5 Bytes
	Bits As String * 1 ' For specific bit flags and their
			 ' meanings, refer to chapter 14
	cbInQue As Integer
	cbOutQue As Integer
End Type

Type MDICREATESTRUCT    '26 Bytes
	szClass As Long
	szTitle As Long
	hOwner As Integer
	x As Integer
	y As Integer
	cx As Integer
	cy As Integer
	style As Long
	lParam As Long
End Type

Type CLIENTCREATESTRUCT    '4 Bytes
	hWindowMenu As Integer
	idFirstChild As Integer
End Type

Type MULTIKEYHELP
	mkSize As Integer
	mkKeylist As String * 1
	szKeyphrase As String * 253 ' Array length is arbitrary; may be changed
End Type

Type WINDOWPLACEMENT    '20 Bytes
   length As Integer
   showCmd As Integer
   ptMinPosition As POINTAPI
   ptMaxPosition As POINTAPI
   rcNormalPosition As RECT
End Type

Type WNDCLASS  '26 Bytes
   style As Integer
   lpfnWndProc As Long  ' Note: address of function here
   cbClsExtra As Integer
   cbWndExtra As Integer
   hInstance As Integer
   hIcon As Integer
   hCursor As Integer
   hbrBackground As Integer
   lpszMenuName As Long    ' Resource ID or far pointer to name
   lpszClassName As Long   ' Far pointer to name
End Type

Type ABC    '6 Bytes
   abcA As Integer
   abcB As Integer
   abcC As Integer
End Type

Type PANOSE ' 10 Bytes
   bFamilyType As String * 1
   bSerifStyle As String * 1
   bWeight As String * 1
   bProportion As String * 1
   bContrast As String * 1
   bStrokeVariation As String * 1
   bArmStyle As String * 1
   bLetterform As String * 1
   bMidline As String * 1
   bXHeight As String * 1
End Type
      
Type OUTLINETEXTMETRIC  '112 Bytes
   otmSize As Integer
   otmTextMetrics As TEXTMETRIC
   otmFIller As String * 1
   otmPanoseNumber As PANOSE
   otmfsSelection As Integer
   otmfsType As Integer
   otmsCharSlopeRise As Integer
   otmsCharSlopeRun As Integer
   otmEMSquare As Integer
   otmAscent As Integer
   otmDescent As Integer
   otmLineGap As Integer
   otmCapEmHeight As Integer
   otmXHeight As Integer
   otmrcFontBox As RECT
   otmMacAscent As Integer
   otmMacDescent As Integer
   otmMacLineGap As Integer
   otmusMinimumPPEM As Integer
   otmptSubscriptSize As POINTAPI
   otmptSubscriptOffset As POINTAPI
   otmptSuperscriptSize As POINTAPI
   otmptSuperscriptOffset As POINTAPI
   otmsStrikeoutSize As Integer
   otmsStrikeoutPosition As Integer
   otmsUnderscoreSize As Integer
   otmsUnderscorePosition As Integer
   otmpFamilyName As Integer
   otmpFaceName As Integer
   otmpStyleName As Integer
   otmpFullName As Integer
End Type


Type RASTERIZERSTATUS   '6 Bytes
   nSize As Integer
   wFlags As Integer
   nLanguageID As Integer
End Type


Type GLYPHMETRICS ' 12 Bytes
   gmBlackBoxX As Integer
   gmBlackBoxY As Integer
   gmptGlyphOrigin As POINTAPI
   gmCellIncX As Integer
   gmCellIncY As Integer
End Type

Type Fixed  '4 Bytes
   fract As Integer
   value As Integer
End Type

Type MAT2   '16 Bytes
   eM11 As Fixed
   eM12 As Fixed
   eM21 As Fixed
   eM22 As Fixed
End Type

Type POINTFX   ' 8 Bytes
   x As Fixed
   y As Fixed
End Type

Type TTPOLYGONHEADER    ' 16 Bytes
   cb As Long
   dw As Long
   pfxStart As POINTFX
End Type

Type TTPOLYCURVE     ' 12 Bytes
   wType As Integer
   cpfx As Integer
   apfx As POINTFX
End Type

Type DOCINFO    ' 10 Bytes
   cbSize As Integer
   lpszDocName As Long
   lpszOutput As Long
End Type

Type WINDEBUGINFO   ' 26 Bytes
   flags As Integer
   dwOptions As Long
   dwFilter As Long
   achAllocModule As String * 8
   dwAllocBreak As Long
   dwAllocCount As Long
End Type

Type DEVMODE    ' 68 Bytes
    dmDeviceName As String * 32
    dmSpecVersion As Integer
    dmDriverVersion As Integer
    dmSize As Integer
    dmDriverExtra As Integer
    dmFields As Long
    dmOrientation As Integer
    dmPaperSize As Integer
    dmPaperLength As Integer
    dmPaperWidth As Integer
    dmScale As Integer
    dmCopies As Integer
    dmDefaultSource As Integer
    dmPrintQuality As Integer
    dmColor As Integer
    dmDuplex As Integer
    dmYResolution As Integer
    dmTTOption As Integer
End Type

Type FIXEDFILEINFO ' 52 Bytes
    dwSignature As Long
    dwStrucVersion As Long
    dwFileVersionMS As Long
    dwFileVersionLS As Long
    dwProductVersionMS As Long
    dwProductVersionLS As Long
    dwFileFlagsMask As Long
    dwFileFlags As Long
    dwFileOS As Long
    dwFileType As Long
    dwFileSubtype As Long
    dwFileDateMS As Long
    dwFileDateLS As Long
End Type

Type HELPWININFO  ' 14 Bytes
    wStructSize As Integer
    x As Integer
    y As Integer
    dX As Integer
    dY As Integer
    wMax As Integer
    rgchMember As String * 2
End Type


' ------------------------------------------------------------------------
'
'     APIDECS.TXT -- Windows 3.1 API Declarations for Visual Basic
'
'                       Copyright (C) 1992 Desaware
'
'  You have a royalty-free right to use, modify, reproduce and distribute
'  this file (and/or any modified version) in any way you find useful,
'  provided that you agree that Desaware and Ziff-Davis Press has no 
'  warranty, obligation or liability for its contents.  
'  Refer to the Ziff-Davis Visual Basic Programmer's Guide to the 
'  Windows API for further information.
'
'  This file is in part derived from winapi.txt from Microsoft
'
' ------------------------------------------------------------------------

Declare Function AbortDoc% Lib "GDI" (ByVal hDC%)
Declare Function AccessResource% Lib "Kernel" (ByVal hInstance%, ByVal hResInfo%)
Declare Function AddAtom% Lib "Kernel" (ByVal lpString$)
Declare Function AddFontResource% Lib "GDI" (ByVal lpFilename As Any)
Declare Function AddFontResourceByname% Lib "GDI" Alias "AddFontResource" (ByVal lpFilename$)
Declare Function AddFontResourceByHandle% Lib "GDI" Alias "AddFontResource" (ByVal lpFilename&)
Declare Sub AdjustWindowRect Lib "User" (lpRect As RECT, ByVal dwStyle&, ByVal bMenu%)
Declare Sub AdjustWindowRectEx Lib "User" (lpRect As RECT, ByVal dsStyle&, ByVal bMenu%, ByVal dwEsStyle&)
Declare Function AllocDStoCSAlias% Lib "Kernel" (ByVal wSelector%)
Declare Function AllocResource% Lib "Kernel" (ByVal hInstance%, ByVal hResInfo%, ByVal dwSize&)
Declare Function AllocSelector% Lib "Kernel" (ByVal wSelector%)
Declare Sub AnimatePalette Lib "GDI" (ByVal hPalette%, ByVal wStartIndex%, ByVal wNumEntries%, lpPaletteColors As PALETTEENTRY)
Declare Function AnsiLower& Lib "User" (ByVal lpString$)
Declare Function AnsiLowerBuff% Lib "User" (ByVal lpString$, ByVal aWORD%)
Declare Function AnsiNext& Lib "User" (ByVal lpString$)
Declare Function AnsiNextBynum& Lib "User" Alias "AnsiNext" (ByVal lpString&)
Declare Function AnsiPrev& Lib "User" (ByVal lpString$, ByVal lpCurrent&)
Declare Function AnsiPrevBynum& Lib "User" Alias "AnsiPrev" (ByVal lpString&, ByVal lpCurrent&)
Declare Function AnsiToOem% Lib "Keyboard" (ByVal lpAnsiStr$, ByVal lpOemStr$)
Declare Sub AnsiToOemBuff Lib "Keyboard" (ByVal lpAnsiStr$, ByVal lpOemStr$, ByVal nLength%)
Declare Function AnsiUpper& Lib "User" (ByVal lpString$)
Declare Function AnsiUpperBuff% Lib "User" (ByVal lpString$, ByVal aWORD%)
Declare Function AnyPopup% Lib "User" ()
Declare Function AppendMenu% Lib "User" (ByVal hMenu%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpNewItem As Any)
Declare Function AppendMenuByNum% Lib "User" Alias "AppendMenu" (ByVal hMenu%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpNewItem&)
Declare Function AppendMenuByString% Lib "User" Alias "AppendMenu" (ByVal hMenu%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpNewItem$)
Declare Function Arc% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal X3%, ByVal Y3%, ByVal X4%, ByVal Y4%)
Declare Function ArrangeIconicWindows% Lib "User" (ByVal hWnd%)
Declare Function BeginDeferWindowPos% Lib "User" (ByVal nNumWindows%)
Declare Function BeginPaint% Lib "User" (ByVal hWnd%, lpPaint As PAINTSTRUCT)
Declare Function BitBlt% Lib "GDI" (ByVal hDestDC%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal dwRop&)
Declare Sub BringWindowToTop Lib "User" (ByVal hWnd%)
Declare Function BuildCommDCB% Lib "User" (ByVal lpDef$, lpDCB As DCB)
Declare Function CallMsgFilter% Lib "User" (lpMsg As MSG, ByVal nCode%)
Declare Function CallWindowProc& Lib "User" (ByVal lpPrevWnd&, ByVal hWnd%, ByVal wMsg%, ByVal wParam%, ByVal lParam&)
Declare Function Catch% Lib "Kernel" (lpCatchBuf As Any)
Declare Function ChangeClipboardChain% Lib "User" (ByVal hWnd%, ByVal hWndNext%)
Declare Function ChangeSelector% Lib "Kernel" (ByVal wDestSelector%, ByVal wSourceSelector%)
Declare Sub CheckDlgButton Lib "User" (ByVal hDlg%, ByVal nIDButton%, ByVal wCheck%)
Declare Function CheckMenuItem% Lib "User" (ByVal hMenu%, ByVal wIDCheckItem%, ByVal wCheck%)
Declare Sub CheckRadioButton Lib "User" (ByVal hDlg%, ByVal nIDFirstButton%, ByVal nIDLastButton%, ByVal nIDCheckButton%)
Declare Function ChildWindowFromPoint% Lib "User" (ByVal hWnd%, ByVal Pnt As ANY)
Declare Function ChildWindowFromPointByNum% Lib "User" Alias "ChildWindowFromPoint" (ByVal hWnd%, ByVal Pnt&)
Declare Function Chord% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal X3%, ByVal Y3%, ByVal X4%, ByVal Y4%)
Declare Function ClearCommBreak% Lib "User" (ByVal nCid%)
Declare Sub ClientToScreen Lib "User" (ByVal hWnd%, lpPoint As POINTAPI)
Declare Sub ClipCursor Lib "User" (lpRect As Any)
Declare Sub ClipCursorRect Lib "User" Alias "ClipCursor" (lpRect As RECT)
Declare Sub ClipCursorClear Lib "User" Alias "ClipCursor" (Byval lpRect&)
Declare Function CloseClipboard% Lib "User" ()
Declare Function CloseComm% Lib "User" (ByVal nCid%)
Declare Function CloseMetaFile% Lib "GDI" (ByVal hMF%)
Declare Sub CloseSound Lib "Sound" ()
Declare Sub CloseWindow Lib "User" (ByVal hWnd%)
Declare Function CombineRgn% Lib "GDI" (ByVal hDestRgn%, ByVal hSrcRgn1%, ByVal hSrcRgn2%, ByVal nCombineMode%)
Declare Function CopyMetaFile% Lib "GDI" (ByVal hMF%, ByVal lpFilename$)
Declare Function CopyMetaFileBynum% Lib "GDI" (ByVal hMF%, ByVal hDest&)
Declare Function CopyCursor% Lib "User" (ByVal hinst%, ByVal hcur%)
Declare Function CopyIcon% Lib "User" (ByVal hinst%, ByVal hicon%)
Declare Function CopyRect% Lib "User" (lpDestRect As RECT, lpSourceRect As RECT)
Declare Function CountClipboardFormats% Lib "User" ()
Declare Function CountVoiceNotes% Lib "Sound" (ByVal nVoice%)
Declare Function CreateBitmap% Lib "GDI" (ByVal nWidth%, ByVal nHeight%, ByVal nPlanes%, ByVal nBitCount%, ByVal lpBits As Any)
Declare Function CreateBitmapBynum% Lib "GDI" Alias "CreateBitmap" (ByVal nWidth%, ByVal nHeight%, ByVal nPlanes%, ByVal nBitCount%, ByVal lpBits&)
Declare Function CreateBitmapBystring% Lib "GDI" Alias "CreateBitmap" (ByVal nWidth%, ByVal nHeight%, ByVal nPlanes%, ByVal nBitCount%, ByVal lpBits$)
Declare Function CreateBitmapIndirect% Lib "GDI" (lpBitmap As BITMAP)
Declare Function CreateBrushIndirect% Lib "GDI" (lpLogBrush As LOGBRUSH)
Declare Sub CreateCaret Lib "User" (ByVal hWnd%, ByVal hBitmap%, ByVal nWidth%, ByVal nHeight%)
Declare Function CreateCompatibleBitmap% Lib "GDI" (ByVal hDC%, ByVal nWidth%, ByVal nHeight%)
Declare Function CreateCompatibleDC% Lib "GDI" (ByVal hDC%)
Declare Function CreateCursor% Lib "User" (ByVal hInstance%, ByVal nXhotspot%, ByVal nYhotspot%, ByVal nWidth%, ByVal nHeight%, ByVal lpANDbitPlane As Any, ByVal lpXORbitPlane As Any)
Declare Function CreateCursorBynum% Lib "User" Alias "CreateCursor" (ByVal hInstance%, ByVal nXhotspot%, ByVal nYhotspot%, ByVal nWidth%, ByVal nHeight%, ByVal lpANDbitPlane&, ByVal lpXORbitPlane&)
Declare Function CreateCursorBystring% Lib "User" Alias "CreateCursor" (ByVal hInstance%, ByVal nXhotspot%, ByVal nYhotspot%, ByVal nWidth%, ByVal nHeight%, ByVal lpANDbitPlane$, ByVal lpXORbitPlane$)
Declare Function CreateDC% Lib "GDI" (ByVal lpDriverName$, ByVal lpDeviceName$, ByVal lpOutput$, ByVal lpInitData&)
Declare Function CreateDIBitmap% Lib "GDI" (ByVal hDC%, lpInfoHeader As BITMAPINFOHEADER, ByVal dwUsage&, ByVal lpInitBits$, lpInitInfo As BITMAPINFO, ByVal wUsage%)
Declare Function CreateDIBitmapBynum% Lib "GDI" Alias "CreateDIBitmap" (ByVal hDC%, lpInfoHeader As BITMAPINFOHEADER, ByVal dwUsage&, ByVal lpInitBits&, lpInitInfo As BITMAPINFO, ByVal wUsage%)
Declare Function CreateDIBPatternBrush% Lib "GDI" (ByVal hPackedDIB%, ByVal wUsage%)
Declare Function CreateDiscardableBitmap% Lib "GDI" (ByVal hDC%, ByVal nWidth%, ByVal nHeight%)
Declare Function CreateEllipticRgn% Lib "GDI" (ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
Declare Function CreateEllipticRgnIndirect% Lib "GDI" (lpRect As RECT)
Declare Function CreateFont% Lib "GDI" (ByVal H%, ByVal W%, ByVal E%, ByVal O%, ByVal W%, ByVal I%, ByVal U%, ByVal S%, ByVal C%, ByVal OP%, ByVal CP%, ByVal Q%, ByVal PAF%, ByVal F$)
Declare Function CreateFontIndirect% Lib "GDI" (lpLogFont As LOGFONT)
Declare Function CreateHatchBrush% Lib "GDI" (ByVal nIndex%, ByVal crColor&)
Declare Function CreateIC% Lib "GDI" (ByVal lpDriverName$, ByVal lpDeviceName$, ByVal lpOutput$, ByVal lpInitData$)
Declare Function CreateIcon% Lib "User" (ByVal hInstance%, ByVal nWidth%, ByVal nHeight%, ByVal nPlanes%, ByVal nBitsPixel%, ByVal lpANDbits As Any, ByVal lpXORbits As Any)
Declare Function CreateIconBynum% Lib "User" Alias "CreateIcon" (ByVal hInstance%, ByVal nWidth%, ByVal nHeight%, ByVal nPlanes%, ByVal nBitsPixel%, ByVal lpANDbits&, ByVal lpXORbits&)
Declare Function CreateIconBystring% Lib "User" Alias "CreateIcon" (ByVal hInstance%, ByVal nWidth%, ByVal nHeight%, ByVal nPlanes%, ByVal nBitsPixel%, ByVal lpANDbits$, ByVal lpXORbits$)
Declare Function CreateMenu% Lib "User" ()
Declare Function CreateMetaFile% Lib "GDI" (Byval lpString As Any)
Declare Function CreateMetaFileBynum% Lib "GDI" Alias "CreateMetaFile" (ByVal lpString&)
Declare Function CreateMetaFileBystring% Lib "GDI" Alias "CreateMetaFile" (ByVal lpString$)
Declare Function CreatePalette% Lib "GDI" (lpLogPalette As LOGPALETTE)
Declare Function CreatePatternBrush% Lib "GDI" (ByVal hBitmap%)
Declare Function CreatePen% Lib "GDI" (ByVal nPenStyle%, ByVal nWidth%, ByVal crColor&)
Declare Function CreatePenIndirect% Lib "GDI" (lpLogPen As LOGPEN)
Declare Function CreatePolygonRgn% Lib "GDI" (lpPoints As POINTAPI, ByVal nCount%, ByVal nPolyFillMode%)
Declare Function CreatePolyPolygonRgn% Lib "GDI" (lpPoints As POINTAPI, lpPolyCounts%, ByVal nCount%, ByVal nPolyFillMode%)
Declare Function CreatePopupMenu% Lib "User" ()
Declare Function CreateRectRgn% Lib "GDI" (ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
Declare Function CreateRectRgnIndirect% Lib "GDI" (lpRect As RECT)
Declare Function CreateRoundRectRgn% Lib "GDI" (ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal X3%, ByVal Y3%)
Declare Function CreateScalableFontResource% Lib "GDI" (ByVal fHidden%, ByVal lpszResourceFile$, ByVal lpszFontFile$, ByVal lpszCurrentPath$)
Declare Function CreateSolidBrush% Lib "GDI" (ByVal crColor&)
Declare Function CreateWindow% Lib "User" (ByVal lpClassName$, ByVal lpWindowName$, ByVal dwStyle&, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hWndParent%, ByVal hMenu%, ByVal hInstance%, ByVal lpParam$)
Declare Function CreateWindowEx% Lib "User" (ByVal dwExStyle&, ByVal lpClassName$, ByVal lpWindowName$, ByVal dwStyle&, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hWndParent%, ByVal hMenu%, ByVal hInstance%, ByVal lpParam$)
Declare Sub DebugBreak Lib "Kernel" ()
Declare Function DefDlgProc& Lib "User" (ByVal hDlg%, ByVal wMsg%, ByVal wParam%, ByVal lParam As Any)
Declare Function DeferWindowPos Lib "User" (ByVal hWinPosInfo%, ByVal hWnd%, ByVal hWndInsertAfter%, ByVal x, ByVal y, ByVal cx, ByVal cy, ByVal wFlags%)
Declare Function DefFrameProc& Lib "User" (ByVal hWnd%, ByVal hWndMDIClient%, ByVal wMsg%, ByVal wParam%, ByVal lParam&)
Declare Function DefHookProc& Lib "User" (ByVal code%, ByVal wParam%, ByVal lParam%, ByVal lplpfnNextHook&)
Declare Function DefMDIChildProc& Lib "User" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, ByVal lParam&)
Declare Function DefWindowProc& Lib "User" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, Byval lParam As Any)
Declare Function DeleteAtom% Lib "Kernel" (ByVal nAtom%)
Declare Function DeleteDC% Lib "GDI" (ByVal hDC%)
Declare Function DeleteMenu% Lib "User" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%)
Declare Function DeleteMetaFile% Lib "GDI" (ByVal hMF%)
Declare Function DeleteObject% Lib "GDI" (ByVal hObject%)
Declare Sub DestroyCaret Lib "User" ()
Declare Function DestroyCursor% Lib "User" (ByVal hCursor%)
Declare Function DestroyIcon% Lib "User" (ByVal hIcon%)
Declare Function DestroyMenu% Lib "User" (ByVal hMenu%)
Declare Function DestroyWindow% Lib "User" (ByVal hWnd%)
Declare Sub DirectedYield Lib "Kernel" (ByVal htask%)
Declare Function DispatchMessage& Lib "User" (lpMsg As MSG)
Declare Function DlgDirList% Lib "User" (ByVal hDlg%, ByVal lpPathSpec$, ByVal nIDListBox%, ByVal nIDStaticPath%, ByVal wFiletype%)
Declare Function DlgDirListComboBox% Lib "User" (ByVal hDlg%, ByVal lpPathSpec$, ByVal nIDComboBox%, ByVal nIDStaticPath%, ByVal wFileType%)
Declare Function DlgDirSelect% Lib "User" (ByVal hDlg%, ByVal lpString$, ByVal nIDListBox%)
Declare Function DlgDirSelectComboBox% Lib "User" (ByVal hDlg%, ByVal lpString$, ByVal nIDComboBox%)
Declare Function DPtoLP% Lib "GDI" (ByVal hDC%, lpPoints As POINTAPI, ByVal nCount%)
Declare Sub DrawFocusRect Lib "User" (ByVal hDC%, lpRect As RECT)
Declare Function DrawIcon% Lib "User" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal hIcon%)
Declare Sub DrawMenuBar Lib "User" (ByVal hWnd%)
Declare Function DrawText% Lib "User" (ByVal hDC%, ByVal lpStr$, ByVal nCount%, lpRect As RECT, ByVal wFormat%)
Declare Function Ellipse% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
Declare Function EmptyClipboard% Lib "User" ()
Declare Function EnableCommNotification% Lib "User" (ByVal idComDev%, ByVal hWnd%, ByVal cbWriteNotify%, ByVal cbOutQueue%)
Declare Function EnableHardwareInput% Lib "User" (ByVal bEnableInput%)
Declare Function EnableMenuItem% Lib "User" (ByVal hMenu%, ByVal wIDEnableItem%, ByVal wEnable%)
Declare Function EnableScrollBar% Lib "User" (ByVal hWnd%, ByVal fnSBFlags%, ByVal fuArrowFlags%)
Declare Function EnableWindow% Lib "User" (ByVal hWnd%, ByVal aBOOL%)
Declare Sub EndDeferWindowPos Lib "User" (ByVal hWinPosInfo%)
Declare Sub EndDialog Lib "User" (ByVal hDlg%, ByVal nResult%)
Declare Function EndDocAPI% Lib "GDI" Alias "EndDoc" (ByVal hDC%)
Declare Function EndPage% Lib "GDI" (ByVal hDC%)
Declare Sub EndPaint Lib "User" (ByVal hWnd%, lpPaint As PAINTSTRUCT)
Declare Function EnumChildWindows% Lib "User" (ByVal hWndParent%, ByVal lpEnumFunc&, ByVal lParam&)
Declare Function EnumClipboardFormats% Lib "User" (ByVal wFormat%)
Declare Function EnumFontFamilies% Lib "GDI" (ByVal hDC%, ByVal lpszFamily$, ByVal lpFontFunc&, ByVal lpData&)
Declare Function EnumFontFamiliesBynum% Lib "GDI" Alias "EnumFontFamilies" (ByVal hDC%, ByVal lpszFamily&, ByVal lpFontFunc&, ByVal lpData&)
Declare Function EnumFonts% Lib "GDI" (ByVal hDC%, ByVal lpFacename$, ByVal lpFontFunc&, ByVal lpData&)
Declare Function EnumFontsBynum% Lib "GDI" Alias "EnumFonts" (ByVal hDC%, ByVal lpFacename&, ByVal lpFontFunc&, ByVal lpData&)
Declare Function EnumMetaFile% Lib "GDI" (ByVal hDC%, ByVal hMF%, ByVal lpCallbackFunc&, ByVal lpClientData&)
Declare Function EnumObjects% Lib "GDI" (ByVal hDC%, ByVal nObjectType%, ByVal lpObjectFunc&, ByVal lpData&)
Declare Function EnumProps% Lib "User" (ByVal hWnd%, ByVal lpEnumFunc&)
Declare Function EnumTaskWindows% Lib "User" (ByVal hTask%, ByVal lpEnumFunc&, ByVal lParam&)
Declare Function EnumWindows% Lib "User" (ByVal lpEnumFunc&, ByVal lParam&)
Declare Function EqualRect% Lib "User" (lpRect1 As RECT, lpRect2 As RECT)
Declare Function EqualRgn% Lib "GDI" (ByVal hSrcRgn1%, ByVal hSrcRgn2%)
Declare Function Escape% Lib "GDI" (ByVal hDC%, ByVal nEscape%, ByVal nCount%, lplnData As Any, lpOutData As Any)
Declare Function EscapeBynum% Lib "GDI" Alias "Escape" (ByVal hDC%, ByVal nEscape%, ByVal nCount%, Byval lplnData&, Byval lpOutData&)
Declare Function EscapeBystring% Lib "GDI" Alias "Escape" (ByVal hDC%, ByVal nEscape%, ByVal nCount%, Byval lplnData$, Byval lpOutData$)
Declare Function EscapeCommFunction% Lib "User" (ByVal nCid%, ByVal nFunc%)
Declare Function ExcludeClipRect% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
Declare Function ExcludeUpdateRgn% Lib "User" (ByVal hDC%, ByVal hWnd%)
Declare Function ExitWindows% Lib "User" (ByVal dwReturnCode&, ByVal reserved%)
Declare Function ExitWindowsExec% Lib "User" (ByVal lpszExe$, ByVal lpszParams$)
Declare Function ExtFloodFill% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal crColor&, ByVal wFillType%)
Declare Function ExtTextOut% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal wOptions%, lpRect As Any, ByVal lpString$, ByVal nCount%, lpDx As Any)
Declare Function ExtTextOutBynum% Lib "GDI" Alias "ExtTextOut" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal wOptions%, Byval lpRect&, ByVal lpString$, ByVal nCount%, Byval lpDx&)
Declare Function ExtTextOutByrect% Lib "GDI" Alias "ExtTextOut" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal wOptions%, lpRect as RECT, ByVal lpString$, ByVal nCount%, Byval lpDx&)
Declare Sub FatalAppExit Lib "Kernel" (ByVal wAction%, ByVal lpMessageText$)
Declare Sub FatalExit Lib "Kernel" (ByVal Code%)
Declare Function FillRect% Lib "User" (ByVal hDC%, lpRect As RECT, ByVal hBrush%)
Declare Function FillRgn% Lib "GDI" (ByVal hDC%, ByVal hRgn%, ByVal hBrush%)
Declare Function FindAtom% Lib "Kernel" (ByVal lpString$)
Declare Function FindResource% Lib "Kernel" (ByVal hInstance%, ByVal lpName$, ByVal lpType As Any)
Declare Function FindResourceByname% Lib "Kernel" Alias "FindResource" (ByVal hInstance%, ByVal lpName$, ByVal lpType$)
Declare Function FindResourceBynum% Lib "Kernel" Alias "FindResource" (ByVal hInstance%, ByVal lpName$, ByVal lpType&)
Declare Function FindWindow% Lib "User" (Byval lpClassName As Any, Byval lpWindowName As Any)
Declare Function FindWindowBynum% Lib "User" Alias "FindWindow" (Byval lpClassName&, Byval lpWindowName&)
Declare Function FindWindowBystring% Lib "User" Alias "FindWindow" (Byval lpClassName$, Byval lpWindowName$)
Declare Function FlashWindow% Lib "User" (ByVal hWnd%, ByVal bInvert%)
Declare Function FloodFill% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal crColor&)
Declare Function FlushComm% Lib "User" (ByVal nCid%, ByVal nQueue%)
Declare Function FrameRect% Lib "User" (ByVal hDC%, lpRect As RECT, ByVal hBrush%)
Declare Function FrameRgn% Lib "GDI" (ByVal hDC%, ByVal hRgn%, ByVal hBrush%, ByVal nWidth%, ByVal nHeight%)
Declare Sub FreeLibrary Lib "Kernel" (ByVal hLibModule%)
Declare Sub FreeModule Lib "Kernel" (ByVal hModule%)
Declare Function FreeResource% Lib "Kernel" (ByVal hResData%)
Declare Function FreeSelector% Lib "Kernel" (ByVal wSelector%)
Declare Function GetActiveWindow% Lib "User" ()
Declare Function GetAspectRatioFilter& Lib "GDI" (ByVal hDC%)
Declare Function GetAspectRatioFilterEx& Lib "GDI" (ByVal hDC%, lpAspectRation As SIZEAPI)
Declare Function GetAsyncKeyState% Lib "User" (ByVal vKey%)
Declare Function GetAtomName% Lib "Kernel" (ByVal nAtom%, ByVal lpBuffer$, ByVal nSize%)
Declare Function GetBitmapBits& Lib "GDI" (ByVal hBitmap%, ByVal dwCount&, ByVal lpBits As Any)
Declare Function GetBitmapBitsBynum& Lib "GDI" Alias "GetBitmapBits" (ByVal hBitmap%, ByVal dwCount&, ByVal lpBits&)
Declare Function GetBitmapBitsBystring& Lib "GDI" Alias "GetBitmapBits" (ByVal hBitmap%, ByVal dwCount&, ByVal lpBits$)
Declare Function GetBitmapDimension& Lib "GDI" (ByVal hBitmap%)
Declare Function GetBitmapDimensionEx% Lib "GDI" (ByVal hBitmap%, lpDimension As SIZEAPI)
Declare Function GetBkColor& Lib "GDI" (ByVal hDC%)
Declare Function GetBkMode% Lib "GDI" (ByVal hDC%)
Declare Function GetBoundsRect% Lib "GDI" (ByVal hDC%, lprcBounds As RECT, ByVal flags%)
Declare Function GetBrushOrg& Lib "GDI" (ByVal hDC%)
Declare Function GetBrushOrgEx% Lib "GDI" (ByVal hDC%, lpPoint As POINTAPI)
Declare Function GetCapture% Lib "User" ()
Declare Function GetCaretBlinkTime% Lib "User" ()
Declare Sub GetCaretPos Lib "User" (lpPoint As POINTAPI)
Declare Function GetCharABCWidths Lib "GDI" (ByVal hDC%, ByVal uFirstChar%, ByVal uLastChar%, lpabc As ABC)
Declare Function GetCharWidth% Lib "GDI" (ByVal hDC%, ByVal wFirstChar%, ByVal wLastChar%, lpBuffer%)
Declare Function GetClassInfo% Lib "User" (ByVal hInstance%, ByVal lpClassName$, lpWndClass as WNDCLASS)
Declare Function GetClassLong& Lib "User" (ByVal hWnd%, ByVal nIndex%)
Declare Function GetClassName% Lib "User" (ByVal hWnd%, ByVal lpClassName$, ByVal nMaxCount%)
Declare Function GetClassWord% Lib "User" (ByVal hWnd%, ByVal nIndex%)
Declare Sub GetClientRect Lib "User" (ByVal hWnd%, lpRect As RECT)
Declare Function GetClipboardData% Lib "User" (ByVal wFormat%)
Declare Function GetClipboardFormatName% Lib "User" (ByVal wFormat%, ByVal lpString$, ByVal nMaxCount%)
Declare Function GetClipboardOwner% Lib "User" ()
Declare Function GetClipboardViewer% Lib "User" ()
Declare Function GetClipBox% Lib "GDI" (ByVal hDC%, lpRect As RECT)
Declare Sub GetClipCursor Lib "User" (lprc As Rect)
Declare Function GetCommError% Lib "User" (ByVal nCid%, lpStat As COMSTAT)
Declare Function GetCommEventMask% Lib "User" (ByVal nCid%, ByVal nEvtMask%)
Declare Function GetCommState% Lib "User" (ByVal nCid%, lpDCB as DCB)
Declare Function GetCurrentPDB% Lib "Kernel" ()
Declare Function GetCurrentPosition& Lib "GDI" (ByVal hDC%)
Declare Function GetCurrentPositionEx% Lib "GDI" (ByVal hDC%, lpPoint As POINTAPI)
Declare Function GetCurrentTask% Lib "Kernel" ()
Declare Function GetCurrentTime& Lib "User" ()
Declare Function GetCursor% Lib "User" ()
Declare Sub GetCursorPos Lib "User" (lpPoint As POINTAPI)
Declare Function GetDC% Lib "User" (ByVal hWnd%)
Declare Function GetDCEx% Lib "User" (ByVal hWnd%, ByVal hrgnClip%, ByVal fdwOptions&)
Declare Function GetDCOrg& Lib "GDI" (ByVal hDC%)
Declare Function GetDesktopHwnd% Lib "User" ()
Declare Function GetDesktopWindow% Lib "User" ()
Declare Function GetDeviceCaps% Lib "GDI" (ByVal hDC%, ByVal nIndex%)
Declare Function GetDialogBaseUnits& Lib "User" ()
Declare Function GetDIBits% Lib "GDI" (ByVal aHDC%, ByVal hBitmap%, ByVal nStartScan%, ByVal nNumScans%, ByVal lpBits$, lpBI As BITMAPINFO, ByVal wUsage%)
Declare Function GetDIBitsBynum% Lib "GDI" Alias "GetDIBits" (ByVal aHDC%, ByVal hBitmap%, ByVal nStartScan%, ByVal nNumScans%, ByVal lpBits&, lpBI As BITMAPINFO, ByVal wUsage%)
Declare Function GetDlgCtrlID% Lib "User" (ByVal hWnd%)
Declare Function GetDlgItem% Lib "User" (ByVal hDlg%, ByVal nIDDlgItem%)
Declare Function GetDlgItemInt% Lib "User" (ByVal hDlg%, ByVal nIDDlgItem%, lpTranslated%, ByVal bSigned%)
Declare Function GetDlgItemText% Lib "User" (ByVal hDlg%, ByVal nIDDlgItem%, ByVal lpString$, ByVal nMaxCount%)
Declare Function GetDOSEnvironment& Lib "Kernel" ()
Declare Function GetDoubleClickTime% Lib "User" ()
Declare Function GetDriveType% Lib "Kernel" (ByVal nDrive%)
Declare Function GetEnvironment% Lib "GDI" (ByVal lpPortName$, lpEnviron As Any, ByVal nMaxCount%)
Declare Function GetEnvironmentBystring% Lib "GDI" Alias "GetEnvironment" (ByVal lpPortName$, Byval lpEnviron$, ByVal nMaxCount%)
Declare Function GetEnvironmentBynum% Lib "GDI" Alias "GetEnvironment" (ByVal lpPortName$, Byval lpEnviron&, ByVal nMaxCount%)
Declare Function GetFocus% Lib "User" ()
Declare Function GetFontData& Lib "GDI" (ByVal hDC%, ByVal dwTable&, ByVal dwOffset&, ByVal lpvBuffer$, ByVal cbData&)
Declare Function GetFreeSpace& Lib "Kernel" (ByVal wFlags%)
Declare Function GetFreeSystemResources% Lib "User" (ByVal fuSysResource%)
Declare Function GetGlyphOutline& Lib "GDI" (ByVal hDC%, ByVal uChar%, ByVal fuFormat%, lpgm As GLYPHMETRICS, ByVal cbBuffer&, lppt As POINTAPI, lpmat2 As MAT2)
Declare Function GetInputState% Lib "User" ()
Declare Function GetInstanceData% Lib "Kernel" (ByVal hInstance%, ByVal pData%, ByVal nCount%)
Declare Function GetKBCodePage% Lib "Keyboard" ()
Declare Sub GetKeyboardState Lib "User" (LpKeyState As Any)
Declare Sub GetKeyboardStateBystring Lib "User" Alias "GetKeyboardState" (Byval LpKeyState$)
Declare Function GetKeyboardType% Lib "Keyboard" (ByVal nTypeFlag%)
Declare Function GetKeyNameText% Lib "Keyboard" (ByVal lParam&, ByVal lpBuffer$, ByVal nSize%)
Declare Function GetKeyState% Lib "User" (ByVal nVirtKey%)
Declare Function GetLastActivePopup% Lib "User" (ByVal hwndOwnder%)
Declare Function GetMapMode% Lib "GDI" (ByVal hDC%)
Declare Function GetMenu% Lib "User" (ByVal hWnd%)
Declare Function GetMenuCheckMarkDimensions& Lib "User" ()
Declare Function GetMenuItemCount% Lib "User" (ByVal hMenu%)
Declare Function GetMenuItemID% Lib "User" (ByVal hMenu%, ByVal nPos%)
Declare Function GetMenuState% Lib "User" (ByVal hMenu%, ByVal wId%, ByVal wFlags%)
Declare Function GetMenuString% Lib "User" (ByVal hMenu%, ByVal wIDItem%, ByVal lpString$, ByVal nMaxCount%, ByVal wFlag%)
Declare Function GetMessage% Lib "User" (lpMsg As MSG, ByVal hWnd%, ByVal wMsgFilterMin%, ByVal wMsgFilterMax%)
Declare Function GetMessageExtraInfo& Lib "User" ()
Declare Function GetMessagePos& Lib "User" ()
Declare Function GetMessageTime& Lib "User" ()
Declare Function GetMetaFile% Lib "GDI" (ByVal lpFilename$)
Declare Function GetMetaFileBits% Lib "GDI" (ByVal hMF%)
Declare Function GetModuleFileName% Lib "Kernel" (ByVal hModule%, ByVal lpFilename$, ByVal nSize%)
Declare Function GetModuleHandle% Lib "Kernel" (ByVal lpModuleName$)
Declare Function GetModuleUsage% Lib "Kernel" (ByVal hModule%)
Declare Function GetNearestColor& Lib "GDI" (ByVal hDC%, ByVal crColor&)
Declare Function GetNearestPaletteIndex% Lib "GDI" (ByVal hPalette%, ByVal crColor&)
Declare Function GetNextDlgGroupItem% Lib "User" (ByVal hDlg%, ByVal hCtl%, ByVal bPrevious%)
Declare Function GetNextDlgTabItem% Lib "User" (ByVal hDlg%, ByVal hCtl%, ByVal bPrevious%)
Declare Function GetNextWindow% Lib "User" (ByVal hWnd%, ByVal wFlag%)
Declare Function GetNumTasks% Lib "Kernel" ()
Declare Function GetObject% Lib "GDI" (ByVal hObject%, ByVal nCount%, ByVal lpObject&)
Declare Function GetOpenClipboardWindow% Lib "User" ()
Declare Function GetOutlineTextMetrics& Lib "GDI" (ByVal hDC%, ByVal cbData%, lpOTM As OUTLINETEXTMETRIC)
Declare Function GetPaletteEntries% Lib "GDI" (ByVal hPalette%, ByVal wStartIndex%, ByVal wNumEntries%, lpPaletteEntries As PALETTEENTRY)
Declare Function GetParent% Lib "User" (ByVal hWnd%)
Declare Function GetPixel& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function GetPolyFillMode% Lib "GDI" (ByVal hDC%)
Declare Function GetPriorityClipboardFormat% Lib "User" (lpPriorityList%, ByVal nCount%)
Declare Function GetPrivateProfileInt% Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal nDefault%, ByVal lpFileName$)
Declare Function GetPrivateProfileString% Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName As Any, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%, ByVal lpFileName$)
Declare Function GetProcAddress& Lib "Kernel" (ByVal hModule%, ByVal lpProcName$)
Declare Function GetProfileInt% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal nDefault%)
Declare Function GetProfileString% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName As Any, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%)
Declare Function GetProp% Lib "User" (ByVal hWnd%, ByVal lpString As Any)
Declare Function GetPropBystring% Lib "User" Alias "GetProp" (ByVal hWnd%, ByVal lpString$)
Declare Function GetPropBynum% Lib "User" Alias "GetProp" (ByVal hWnd%, ByVal lpString&)
Declare Function GetQueueStatus& Lib "User" (ByVal fuFlags%)
Declare Function GetRasterizerCaps% Lib "GDI" (lpraststat As RASTERIZERSTATUS, ByVal cb%)
Declare Function GetRgnBox% Lib "GDI" (ByVal hRgn%, lpRect As RECT)
Declare Function GetROP2% Lib "GDI" (ByVal hDC%)
Declare Function GetScrollPos% Lib "User" (ByVal hWnd%, ByVal nBar%)
Declare Sub GetScrollRange Lib "User" (ByVal hWnd%, ByVal nBar%, lpMinPos%, lpMaxPos%)
Declare Function GetSelectorBase& Lib "Kernel" (ByVal uSelector%)
Declare Function GetSelectorLimit& Lib "Kernel" (ByVal uSelector%)
Declare Function GetStockObject% Lib "GDI" (ByVal nIndex%)
Declare Function GetStretchBltMode% Lib "GDI" (ByVal hDC%)
Declare Function GetSubMenu% Lib "User" (ByVal hMenu%, ByVal nPos%)
Declare Function GetSysColor& Lib "User" (ByVal nIndex%)
Declare Function GetSysModalWindow% Lib "User" ()
Declare Function GetSystemDebugState& Lib "User" ()
Declare Function GetSystemDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)
Declare Function GetSystemMenu% Lib "User" (ByVal hWnd%, ByVal bRevert%)
Declare Function GetSystemMetrics% Lib "User" (ByVal nIndex%)
Declare Function GetSystemPaletteEntries% Lib "GDI" (ByVal hDC%, ByVal wStartIndex%, ByVal wNumEntries%, lpPaletteEntries As PALETTEENTRY)
Declare Function GetSystemPaletteUse% Lib "GDI" (ByVal hDC%)
Declare Function GetTabbedTextExtent& Lib "GDI" (ByVal hDC%, ByVal lpString$, ByVal nCount%, ByVal nTabPositions%, lpnTabStopPositions%)
Declare Function GetTempDrive% Lib "Kernel" (ByVal cDriveLetter%)
Declare Function GetTempFileName% Lib "Kernel" (ByVal cDriveLetter%, ByVal lpPrefixString$, ByVal wUnique%, ByVal lpTempFileName$)
Declare Function GetTextAlign% Lib "GDI" (ByVal hDC%)
Declare Function GetTextCharacterExtra% Lib "GDI" (ByVal hDC%)
Declare Function GetTextColor& Lib "GDI" (ByVal hDC%)
Declare Function GetTextExtent& Lib "GDI" (ByVal hDC%, ByVal lpString$, ByVal nCount%)
Declare Function GetTextExtentPoint% Lib "GDI" (Byval hDC%, ByVal lpszString$, ByVal cbString%, lpSize As SIZEAPI)
Declare Function GetTextFace% Lib "GDI" (ByVal hDC%, ByVal nCount%, ByVal lpFacename$)
Declare Function GetTextMetrics% Lib "GDI" (ByVal hDC%, lpMetrics As TEXTMETRIC)
Declare Function GetThresholdEvent& Lib "Sound" ()
Declare Function GetThresholdStatus% Lib "Sound" ()
Declare Function GetTickCount& Lib "User" ()
Declare Function GetTimerResolution& Lib "User" ()
Declare Function GetTopWindow% Lib "User" (ByVal hWnd%)
Declare Function GetUpdateRect% Lib "User" (ByVal hWnd%, lpRect As RECT, ByVal bErase%)
Declare Function GetUpdateRgn% Lib "User" (ByVal hWnd%, ByVal hRgn%, ByVal fErase%)
Declare Function GetVersion& Lib "Kernel" ()
Declare Function GetViewportExt& Lib "GDI" (ByVal hDC%)
Declare Function GetViewportExtEx% Lib "GDI" (ByVal hDC%, lpSize As SIZEAPI)
Declare Function GetViewportOrg& Lib "GDI" (ByVal hDC%)
Declare Function GetViewportOrgEx% Lib "GDI" (ByVal hDC%, lpSize As SIZEAPI)
Declare Function GetWinDebugInfo% Lib "Kernel" (lpwdi As WINDEBUGINFO, ByVal flags%)
Declare Function GetWindow% Lib "User" (ByVal hWnd%, ByVal wCmd%)
Declare Function GetWindowDC% Lib "User" (ByVal hWnd%)
Declare Function GetWindowExt& Lib "GDI" (ByVal hDC%)
Declare Function GetWindowExtEx% Lib "GDI" (ByVal hDC%, lpSize As SIZEAPI)
Declare Function GetWindowLong& Lib "User" (ByVal hWnd%, ByVal nIndex%)
Declare Function GetWindowOrg& Lib "GDI" (ByVal hDC%)
Declare Function GetWindowOrgEx% Lib "GDI" (ByVal hDC%, lpSize As SIZEAPI)
Declare Function GetWindowPlacement% Lib "User" (ByVal hWnd%, lpwndpl As WINDOWPLACEMENT)
Declare Sub GetWindowRect Lib "User" (ByVal hWnd%, lpRect As RECT)
Declare Function GetWindowsDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)
Declare Function GetWindowTask% Lib "User" (ByVal hWnd%)
Declare Function GetWindowText% Lib "User" (ByVal hWnd%, ByVal lpString$, ByVal aint%)
Declare Function GetWindowTextLength% Lib "User" (ByVal hWnd%)
Declare Function GetWindowWord% Lib "User" (ByVal hWnd%, ByVal nIndex%)
Declare Function GetWinFlags& Lib "Kernel" ()
Declare Function GlobalAddAtom% Lib "User" (ByVal lpString$)
Declare Function GlobalAlloc% Lib "Kernel" (ByVal wFlags%, ByVal dwBytes&)
Declare Function GlobalCompact& Lib "Kernel" (ByVal dwMinFree&)
Declare Function GlobalDeleteAtom% Lib "User" (ByVal nAtom%)
Declare Function GlobalFindAtom% Lib "User" (ByVal lpString$)
Declare Sub GlobalFix Lib "Kernel" (ByVal hMem%)
Declare Function GlobalFlags% Lib "Kernel" (ByVal hMem%)
Declare Function GlobalFree% Lib "Kernel" (ByVal hMem%)
Declare Function GlobalGetAtomName% Lib "User" (ByVal nAtom%, ByVal lpbuffer$, ByVal nSize%)
Declare Function GlobalHandle& Lib "Kernel" (ByVal wMem%)
Declare Function GlobalLock& Lib "Kernel" (ByVal hMem%)
Declare Function GlobalLRUNewest% Lib "Kernel" (ByVal hMem%)
Declare Function GlobalLRUOldest% Lib "Kernel" (ByVal hMem%)
Declare Function GlobalReAlloc% Lib "Kernel" (ByVal hMem%, ByVal dwBytes&, ByVal wFlags%)
Declare Function GlobalSize& Lib "Kernel" (ByVal hMem%)
Declare Function GlobalUnfix% Lib "Kernel" (ByVal hMem%)
Declare Function GlobalUnlock% Lib "Kernel" (ByVal hMem%)
Declare Function GrayString% Lib "User" (ByVal hDC%, ByVal lpOuputFunc&, ByVal lpData&, ByVal nCount%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%)
Declare Function GrayStringBystring% Lib "User" Alias "GrayString" (ByVal hDC%, ByVal lpOuputFunc&, ByVal lpData$, ByVal nCount%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%)
Declare Sub HideCaret Lib "User" (ByVal hWnd%)
Declare Function HiliteMenuItem% Lib "User" (ByVal hWnd%, ByVal hMenu%, ByVal wIDHiliteItem%, ByVal wHilite%)
Declare Sub hmemcpy Lib "Kernel" (hpvDest As Any, hpvSource As Any, ByVal cbCopy&)
Declare Sub hmemcpyBynum Lib "Kernel" Alias "hmemcpy" (ByVal hpvDest&, ByVal hpvSource&, ByVal cbCopy&)
Declare Function hread& Lib "Kernel" Alias "_hread" (ByVal hf%, ByVal hpvBuffer&, ByVal cbBuffer&)
Declare Function hwrite& Lib "Kernel" Alias "_hwrite" (ByVal hf%, ByVal hpvBuffer&, ByVal cbBuffer&)
Declare Sub InflateRect Lib "User" (lpRect As RECT, ByVal X%, ByVal Y%)
Declare Function InitAtomTable% Lib "Kernel" (ByVal nSize%)
Declare Function InSendMessage% Lib "User" ()
Declare Function InsertMenu% Lib "User" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpNewItem As Any)
Declare Function InsertMenuBynum% Lib "User" Alias "InsertMenu" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpNewItem&)
Declare Function InsertMenuBystring% Lib "User" Alias "InsertMenu" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpNewItem$)
Declare Function IntersectClipRect% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
Declare Function IntersectRect% Lib "User" (lpDestRect As RECT, lpSrc1Rect As RECT, lpSrc2Rect As RECT)
Declare Sub InvalidateRect Lib "User" (ByVal hWnd%, lpRect As RECT, ByVal bErase%)
Declare Sub InvalidateRectBynum Lib "User" Alias "InvalidateRect" (ByVal hWnd%, ByVal lpRect&, ByVal bErase%)
Declare Sub InvalidateRgn Lib "User" (ByVal hWnd%, ByVal hRgn%, ByVal bErase%)
Declare Sub InvertRect Lib "User" (ByVal hDC%, lpRect As RECT)
Declare Function InvertRgn% Lib "GDI" (ByVal hDC%, ByVal hRgn%)
Declare Function IsBadCodePtr% Lib "Kernel" (ByVal lpfn&)
Declare Function IsBadHugeReadPtr% Lib "Kernel" (ByVal lp&, ByVal cb&)
Declare Function IsBadHugeWritePtr% Lib "Kernel" (ByVal lp&, ByVal cb&)
Declare Function IsBadReadPtr% Lib "Kernel" (ByVal lp&, ByVal cb%)
Declare Function IsBadStringPtr% Lib "Kernel" (ByVal lpsz&, ByVal cb%)
Declare Function IsBadWritePtr% Lib "Kernel" (ByVal lp&, ByVal cb%)
Declare Function IsCharAlpha% Lib "User" (ByVal cChar%)
Declare Function IsCharAlphaNumeric% Lib "User" (ByVal cChar%)
Declare Function IsCharLower% Lib "User" (ByVal cChar%)
Declare Function IsCharUpper% Lib "User" (ByVal cChar%)
Declare Function IsChild% Lib "User" (ByVal hWndParent%, ByVal hWnd%)
Declare Function IsClipboardFormatAvailable% Lib "User" (ByVal wFormat%)
Declare Function IsDBCSLeadByte% Lib "Kernel" (ByVal bTestChar%)
Declare Function IsDialogMessage% Lib "User" (ByVal hDlg%, lpMsg As MSG)
Declare Function IsDlgButtonChecked% Lib "User" (ByVal hDlg%, ByVal nIDButton%)
Declare Function IsGDIObject% Lib "GDI" (ByVal hobj%)
Declare Function IsIconic% Lib "User" (ByVal hWnd%)
Declare Function IsMenu% Lib "User" (ByVal hMenu%)
Declare Function IsRectEmpty% Lib "User" (lpRect As RECT)
Declare Function IsTask% Lib "Kernel" (ByVal htask%)
Declare Function IsWindow% Lib "User" (ByVal hWnd%)
Declare Function IsWindowEnabled% Lib "User" (ByVal hWnd%)
Declare Function IsWindowVisible% Lib "User" (ByVal hWnd%)
Declare Function IsZoomed% Lib "User" (ByVal hWnd%)
Declare Function KillTimer% Lib "User" (ByVal hWnd%, ByVal nIDEvent%)
Declare Function lclose% Lib "Kernel" Alias "_lclose" (ByVal hFile%)
Declare Function lcreat% Lib "Kernel" Alias "_lcreat" (ByVal lpPathName$, ByVal iAttribute%)
Declare Sub LimitEmsPages Lib "Kernel" (ByVal dwKbytes&)
Declare Sub LineDDA Lib "GDI" (ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal lpLineFunc&, ByVal lpData&)
Declare Function LineTo% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function llseek& Lib "Kernel" Alias "_llseek" (ByVal hFile%, ByVal lOffset&, ByVal iOrigin%)
Declare Function LoadAccelerators% Lib "User" (ByVal hInstance%, ByVal lpTableName$)
Declare Function LoadBitmap% Lib "User" (ByVal hInstance%, ByVal lpBitmapName As Any)
Declare Function LoadBitmapBynum% Lib "User" Alias "LoadBitmap" (ByVal hInstance%, ByVal lpBitmapName&)
Declare Function LoadBitmapBystring% Lib "User" Alias "LoadBitmap" (ByVal hInstance%, ByVal lpBitmapName$)
Declare Function LoadCursor% Lib "User" (ByVal hInstance%, ByVal lpCursorName As Any)
Declare Function LoadCursorBystring% Lib "User" Alias "LoadCursor" (ByVal hInstance%, ByVal lpCursorName$)
Declare Function LoadCursorBynum% Lib "User" Alias "LoadCursor" (ByVal hInstance%, ByVal lpCursorName&)
Declare Function LoadIcon% Lib "User" (ByVal hInstance%, ByVal lpIconName As Any)
Declare Function LoadIconBynum% Lib "User" Alias "LoadIcon" (ByVal hInstance%, ByVal lpIconName&)
Declare Function LoadIconBystring% Lib "User" Alias "LoadIcon" (ByVal hInstance%, ByVal lpIconName$)
Declare Function LoadLibrary% Lib "Kernel" (ByVal lpLibFileName$)
Declare Function LoadMenu% Lib "User" (ByVal hInstance%, ByVal lpString$)
Declare Function LoadMenuIndirect% Lib "User" (lpMenuTemplate As MENUITEMTEMPLATE)
Declare Function LoadModule% Lib "Kernel" (ByVal lpModuleName$, lpParameterBlock As PARAMETERBLOCK)
Declare Function LoadResource% Lib "Kernel" (ByVal hInstance%, ByVal hResInfo%)
Declare Function LoadString% Lib "User" (ByVal hInstance%, ByVal wID%, ByVal lpBuffer$, ByVal nBufferMax%)
Declare Function LocalAlloc% Lib "Kernel" (ByVal wFlags%, ByVal wBytes%)
Declare Function LocalCompact% Lib "Kernel" (ByVal wMinFree%)
Declare Function LocalDiscard% Lib "Kernel" (ByVal hMem%)
Declare Function LocalFlags% Lib "Kernel" (ByVal hMem%)
Declare Function LocalFree% Lib "Kernel" (ByVal hMem%)
Declare Function LocalHandle% Lib "Kernel" (ByVal wMem%)
Declare Function LocalInit% Lib "Kernel" (ByVal wSegment%, ByVal pStart%, ByVal pEnd%)
Declare Function LocalLock% Lib "Kernel" (ByVal hMem%)
Declare Function LocalReAlloc% Lib "Kernel" (ByVal hMem%, ByVal wBytes%, ByVal wFlags%)
Declare Function LocalShrink% Lib "Kernel" (ByVal hSeg%, ByVal wSize%)
Declare Function LocalSize% Lib "Kernel" (ByVal hMem%)
Declare Function LocalUnlock% Lib "Kernel" (ByVal hMem%)
Declare Function LockInput% Lib "User" (ByVal hReserved%, ByVal hwndInput%, ByVal fLock%)
Declare Function LockResource& Lib "Kernel" (ByVal hResData%)
Declare Function LockSegment% Lib "Kernel" (ByVal wSegment%)
Declare Function LockWindowUpdate% Lib "User" (ByVal hWnd%)
Declare Sub LogError Lib "Kernel" (ByVal uErr%, lpvInfo As Any)
Declare Sub LogParamError Lib "Kernel" (ByVal uErr%, ByVal lpfn&, lpvInfo As Any)
Declare Function lopen% Lib "Kernel" Alias "_lopen" (ByVal lpPathName$, ByVal iReadWrite%)
Declare Function LPtoDP% Lib "GDI" (ByVal hDC%, lpPoints As POINTAPI, ByVal nCount%)
Declare Function lread% Lib "Kernel" Alias "_lread" (ByVal hFile%, ByVal lpBuffer$, ByVal wBytes%)
Declare Function lstrcat& Lib "Kernel" (ByVal lpString1 As Any, ByVal lpString2 As Any)
Declare Function lstrcmp% Lib "User" (ByVal lpString1 As Any, ByVal lpString2 As Any)
Declare Function lstrcmpi% Lib "User" (ByVal lpString1 As Any, ByVal lpString2 As Any)
Declare Function lstrcpy& Lib "Kernel" (ByVal lpString1 As Any, ByVal lpString2 As Any)
Declare Function lstrlen% Lib "Kernel" (ByVal lpString As Any)
Declare Function lwrite% Lib "Kernel" Alias "_lwrite" (ByVal hFile%, ByVal lpBuffer$, ByVal wBytes%)
Declare Sub MapDialogRect Lib "User" (ByVal hDlg%, lpRect As RECT)
Declare Function MapVirtualKey% Lib "Keyboard" (ByVal wCode%, ByVal wMapType%)
Declare Sub MapWindowPoints Lib "User" (ByVal hwndFrom%, ByVal hwndTo%, lppt As POINTAPI, ByVal cPoints%)
Declare Sub MessageBeep Lib "User" (ByVal wType%)
Declare Function MessageBox% Lib "User" (ByVal hWnd%, ByVal lpText$, ByVal lpCaption$, ByVal wType%)
Declare Function ModifyMenu% Lib "User" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpString As Any)
Declare Function ModifyMenuBynum% Lib "User" Alias "ModifyMenu" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpString&)
Declare Function ModifyMenuBystring% Lib "User" Alias "ModifyMenu" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpString$)
Declare Function MoveTo& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function MoveToEx% Lib "GDI" (ByVal hDC%, ByVal nX%, ByVal nY%, lpPoint As POINTAPI)
Declare Sub MoveWindow Lib "User" (ByVal hWnd%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal bRepaint%)
Declare Function MulDiv% Lib "GDI" (ByVal nNumber%, ByVal nNumerator%, ByVal nDenominator%)
Declare Function OemKeyScan& Lib "Keyboard" (ByVal wOemChar%)
Declare Function OemToAnsi% Lib "Keyboard" (ByVal lpOemStr$, ByVal lpAnsiStr$)
Declare Sub OemToAnsiBuff Lib "Keyboard" (ByVal lpOemStr$, ByVal lpAnsiStr$, ByVal nLength%)
Declare Function OffsetClipRgn% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Sub OffsetRect Lib "User" (lpRect As RECT, ByVal X%, ByVal Y%)
Declare Function OffsetRgn% Lib "GDI" (ByVal hRgn%, ByVal X%, ByVal Y%)
Declare Function OffsetViewportOrg& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function OffsetViewportOrgEx% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, lpPoint As POINTAPI)
Declare Function OffsetWindowOrg& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function OffsetWindowOrgEx% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, lpPoint As POINTAPI)
Declare Function OpenClipboard% Lib "User" (ByVal hWnd%)
Declare Function OpenComm% Lib "User" (ByVal lpComName$, ByVal wInQueue%, ByVal wOutQueue%)
Declare Function OpenFile% Lib "Kernel" (ByVal lpFileName$, lpReOpenBuff As OFSTRUCT, ByVal wStyle%)
Declare Function OpenIcon% Lib "User" (ByVal hWnd%)
Declare Function OpenSound% Lib "Sound" ()
Declare Sub OutputDebugString Lib "Kernel" (ByVal lpOutputString$)
Declare Function PaintRgn% Lib "GDI" (ByVal hDC%, ByVal hRgn%)
Declare Function PatBlt% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal dwRop&)
Declare Function PeekMessage% Lib "User" (lpMsg As MSG, ByVal hWnd%, ByVal wMsgFilterMin%, ByVal wMsgFilterMax%, ByVal wRemoveMsg%)
Declare Function Pie% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal X3%, ByVal Y3%, ByVal X4%, ByVal Y4%)
Declare Function PlayMetaFile% Lib "GDI" (ByVal hDC%, ByVal hMF%)
Declare Sub PlayMetaFileRecord Lib "GDI" (ByVal hDC%, lpHandletable%, lpMetaRecord As METARECORD, ByVal nHandles%)
Declare Function Polygon% Lib "GDI" (ByVal hDC%, lpPoints As POINTAPI, ByVal nCount%)
Declare Function Polyline% Lib "GDI" (ByVal hDC%, lpPoints As POINTAPI, ByVal nCount%)
Declare Function PolyPolygon% Lib "GDI" (ByVal hDC%, lpPoints As POINTAPI, lpPolyCounts%, ByVal nCount%)
Declare Function PostAppMessage% Lib "User" (ByVal hTask%, ByVal wMsg%, ByVal wParam%, lParam As Any)
Declare Function PostAppMessageBynum% Lib "User" Alias "PostAppMessage" (ByVal hTask%, ByVal wMsg%, ByVal wParam%, Byval lParam&)
Declare Function PostAppMessageBystring% Lib "User" Alias "PostAppMessage" (ByVal hTask%, ByVal wMsg%, ByVal wParam%, Byval lParam$)
Declare Function PostMessage% Lib "User" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, lParam As Any)
Declare Function PostMessageBynum% Lib "User" Alias "PostMessage" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, Byval lParam&)
Declare Function PostMessageBystring% Lib "User" Alias "PostMessage" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, Byval lParam$)
Declare Sub PostQuitMessage Lib "User" (ByVal nExitCode%)
Declare Function PtInRect% Lib "User" (lpRect As RECT, ByVal Pnt As Any)
Declare Function PtInRectBynum% Lib "User" Alias "PtInRect" (lpRect As RECT, ByVal Pnt&)
Declare Function PtInRegion% Lib "GDI" (ByVal hRgn%, ByVal X%, ByVal Y%)
Declare Function PtVisible% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function QuerySendMessage% Lib "User" (ByVal hreserved1%, hreserved2%, hreserved3%, lpMessage As MSG)
Declare Function ReadComm% Lib "User" (ByVal nCid%, ByVal lpBuf$, ByVal nSize%)
Declare Function RealizePalette% Lib "User" (ByVal hDC%)
Declare Function Rectangle% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
Declare Function RectInRegion% Lib "GDI" (ByVal hRgn%, lpRect As RECT)
Declare Function RectVisible% Lib "GDI" (ByVal hDC%, lpRect As RECT)
Declare Function RedrawWindow% Lib "User" (ByVal hWnd%, lprcUpdate As RECT, ByVal hrgnUpdate%, ByVal fuRedraw%)
Declare Function RegisterClass% Lib "User" (lpWndClass As WNDCLASS)
Declare Function RegisterClipboardFormat% Lib "User" (ByVal lpString$)
Declare Function RegisterWindowMessage% Lib "User" (ByVal lpString$)
Declare Sub ReleaseCapture Lib "User" ()
Declare Function ReleaseDC% Lib "User" (ByVal hWnd%, ByVal hDC%)
Declare Function RemoveFontResource% Lib "GDI" (ByVal lpFilename As Any)
Declare Function RemoveFontResourceBynum% Lib "GDI" Alias "RemoveFontResource" (ByVal lpFilename&)
Declare Function RemoveFontResourceBystring% Lib "GDI" Alias "RemoveFontResource" (ByVal lpFilename$)
Declare Function RemoveMenu% Lib "User" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%)
Declare Function RemoveProp% Lib "User" (ByVal hWnd%, ByVal lpString$)
Declare Function RemovePropBynum% Lib "User" Alias "RemoveProp" (ByVal hWnd%, ByVal lpString&)
Declare Sub ReplyMessage Lib "User" (ByVal lReply&)
Declare Function ResetDC% Lib "GDI" (ByVal hDC%, lpdm As DEVMODE)
Declare Function ResizePalette% Lib "GDI" (ByVal hPalette%, ByVal nNumEntries%)
Declare Function RestoreDC% Lib "GDI" (ByVal hDC%, ByVal nSavedDC%)
Declare Function RoundRect% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal X3%, ByVal Y3%)
Declare Function SaveDC% Lib "GDI" (ByVal hDC%)
Declare Function ScaleViewportExt& Lib "GDI" (ByVal hDC%, ByVal Xnum%, ByVal Xdenom%, ByVal Ynum%, ByVal Ydenom%)
Declare Function ScaleViewportExtEx& Lib "GDI" (ByVal hDC%, ByVal nXnum%, ByVal nXdenom%, ByVal nYnum%, ByVal nYdenom%, lpSize As SIZEAPI)
Declare Function ScaleWindowExt& Lib "GDI" (ByVal hDC%, ByVal Xnum%, ByVal Xdenom%, ByVal Ynum%, ByVal Ydenom%)
Declare Function ScaleWindowExtEx& Lib "GDI" (ByVal hDC%, ByVal nXnum%, ByVal nXdenom%, ByVal nYnum%, ByVal nYdenom%, lpSize As SIZEAPI)
Declare Sub ScreenToClient Lib "User" (ByVal hWnd%, lpPoint As POINTAPI)
Declare Function ScrollDC% Lib "User" (ByVal hDC%, ByVal dx%, ByVal dy%, lprcScroll As RECT, lprcClip As RECT, ByVal hRgnUpdate%, lprcUpdate As RECT)
Declare Sub ScrollWindow Lib "User" (ByVal hWnd%, ByVal XAmount%, ByVal YAmount%, lpRect As RECT, lpClipRect As RECT)
Declare Sub ScrollWindowBynum Lib "User" Alias "ScrollWindow" (ByVal hWnd%, ByVal XAmount%, ByVal YAmount%, ByVal lpRect&, ByVal lpClipRect&)
Declare Sub ScrollWindowEx Lib "User" (ByVal hWnd%, ByVal dx%, ByVal dy%, lprcScroll As RECT, lprcClip As RECT, ByVal hrgnUpdate%, lprcUpdate As Rect, ByVal fuScroll%)
Declare Sub ScrollWindowExBynum Lib "User" Alias "ScrollWindow" (ByVal hWnd%, ByVal dx%, ByVal dy%, ByVal lprcScroll&, ByVal lprcClip&, ByVal hrgnUpdate%, ByVal lprcUpdate&, ByVal fuScroll%)
Declare Function SelectClipRgn% Lib "GDI" (ByVal hDC%, ByVal hRgn%)
Declare Function SelectObject% Lib "GDI" (ByVal hDC%, ByVal hObject%)
Declare Function SelectPalette% Lib "User" (ByVal hDC%, ByVal hPalette%, ByVal bForceBackground%)
Declare Function SendDlgItemMessage& Lib "User" (ByVal hDlg%, ByVal nIDDlgItem%, ByVal wMsg%, ByVal wParam%, lParam As Any)
Declare Function SendMessage& Lib "User" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, lParam As Any)
Declare Function SendMessageBynum& Lib "User" Alias "SendMessage" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, Byval lParam&)
Declare Function SendMessageBystring& Lib "User" Alias "SendMessage" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, Byval lParam$)
Declare Function SetAbortProc% Lib "GDI" (ByVal hDC%, ByVal abrtprc&)
Declare Function SetActiveWindow% Lib "User" (ByVal hWnd%)
Declare Function SetBitmapBits& Lib "GDI" (ByVal hBitmap%, ByVal dwCount&, ByVal lpBits As Any)
Declare Function SetBitmapBitsBynum& Lib "GDI" Alias "SetBitmapBits" (ByVal hBitmap%, ByVal dwCount&, ByVal lpBits&)
Declare Function SetBitmapBitsBystring& Lib "GDI" Alias "SetBitmapBits" (ByVal hBitmap%, ByVal dwCount&, ByVal lpBits$)
Declare Function SetBitmapDimension& Lib "GDI" (ByVal hBitmap%, ByVal X%, ByVal Y%)
Declare Function SetBitmapDimensionEx% Lib "GDI" (ByVal hBitmap%, ByVal nX%, ByVal nY%, lpSize As SIZEAPI)
Declare Function SetBkColor& Lib "GDI" (ByVal hDC%, ByVal crColor&)
Declare Function SetBkMode% Lib "GDI" (ByVal hDC%, ByVal nBkMode%)
Declare Function SetBoundsRect% Lib "GDI" (ByVal hDC%, lprcBounds As RECT, ByVal flags%)
Declare Function SetBrushOrg& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function SetCapture% Lib "User" (ByVal hWnd%)
Declare Sub SetCaretBlinkTime Lib "User" (ByVal wMSeconds%)
Declare Sub SetCaretPos Lib "User" (ByVal X%, ByVal Y%)
Declare Function SetClassLong& Lib "User" (ByVal hWnd%, ByVal nIndex%, ByVal dwNewLong&)
Declare Function SetClassWord% Lib "User" (ByVal hWnd%, ByVal nIndex%, ByVal wNewWord%)
Declare Function SetClipboardData% Lib "User" (ByVal wFormat%, ByVal hMem%)
Declare Function SetClipboardViewer% Lib "User" (ByVal hWnd%)
Declare Function SetCommBreak% Lib "User" (ByVal nCid%)
Declare Function SetCommEventMask& Lib "User" (ByVal nCid%, ByVal nEvtMask%)
Declare Function SetCommState% Lib "User" (lpDCB as DCB)
Declare Function SetCursor% Lib "User" (ByVal hCursor%)
Declare Sub SetCursorPos Lib "User" (ByVal X%, ByVal Y%)
Declare Function SetDIBits% Lib "GDI" (ByVal aHDC%, ByVal hBitmap%, ByVal nStartScan%, ByVal nNumScans%, ByVal lpBits$, lpBI As BITMAPINFO, ByVal wUsage%)
Declare Function SetDIBitsBynum% Lib "GDI" Alias "SetDIBits" (ByVal aHDC%, ByVal hBitmap%, ByVal nStartScan%, ByVal nNumScans%, ByVal lpBits&, lpBI As BITMAPINFO, ByVal wUsage%)
Declare Function SetDIBitsToDevice% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal dX%, ByVal dY%, ByVal SrcX%, ByVal SrcY%, ByVal Scan%, ByVal NumScans%, ByVal Bits$, BitsInfo As BITMAPINFO, ByVal wUsage%)
Declare Function SetDIBitsToDeviceBynum% Lib "GDI" Alias "SetDIBitsToDevice" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal dX%, ByVal dY%, ByVal SrcX%, ByVal SrcY%, ByVal Scan%, ByVal NumScans%, ByVal Bits&, BitsInfo As BITMAPINFO, ByVal wUsage%)
Declare Sub SetDlgItemInt Lib "User" (ByVal hDlg%, ByVal nIDDlgItem%, ByVal wValue%, ByVal bSigned%)
Declare Sub SetDlgItemText Lib "User" (ByVal hDlg%, ByVal nIDDlgItem%, ByVal lpString$)
Declare Sub SetDoubleClickTime Lib "User" (ByVal wCount%)
Declare Function SetEnvironment% Lib "GDI" (ByVal lpPortName$, ByVal lpEnviron$, ByVal nCount%)
Declare Function SetErrorMode% Lib "Kernel" (ByVal wMode%)
Declare Function SetFocusAPI% Lib "User" Alias "SetFocus" (ByVal hWnd%)
Declare Function SetHandleCount% Lib "Kernel" (ByVal wNumber%)
Declare Sub SetKeyboardState Lib "User" (lpKeyState As Any)
Declare Sub SetKeyboardStateBystring Lib "User" Alias "SetKeyboardState" (Byval lpKeyState$)
Declare Function SetMapMode% Lib "GDI" (ByVal hDC%, ByVal nMapMode%)
Declare Function SetMapperFlags& Lib "GDI" (ByVal hDC%, ByVal dwFlag&)
Declare Function SetMenu% Lib "User" (ByVal hWnd%, ByVal hMenu%)
Declare Function SetMenuItemBitmaps% Lib "User" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%, ByVal hBitmapUnchecked%, ByVal hBitmapChecked%)
Declare Function SetMessageQueue% Lib "User" (ByVal cMsg%)
Declare Function SetMetaFileBits% Lib "GDI" (ByVal hMem%)
Declare Function SetMetaFileBitsBetter% Lib "GDI" (ByVal hmf%)
Declare Function SetPaletteEntries% Lib "GDI" (ByVal hPalette%, ByVal wStartIndex%, ByVal wNumEntries%, lpPaletteEntries As PALETTEENTRY)
Declare Function SetParent% Lib "User" (ByVal hWndChild%, ByVal hWndNewParent%)
Declare Function SetPixel& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal crColor&)
Declare Function SetPolyFillMode% Lib "GDI" (ByVal hDC%, ByVal nPolyFillMode%)
Declare Function SetProp% Lib "User" (ByVal hWnd%, ByVal lpString$, ByVal hData%)
Declare Function SetPropBynum% Lib "User" Alias "SetProp" (ByVal hWnd%, ByVal lpString&, ByVal hData%)
Declare Sub SetRect Lib "User" (lpRect As RECT, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
Declare Sub SetRectEmpty Lib "User" (lpRect As RECT)
Declare Sub SetRectRgn Lib "GDI" (ByVal hRgn%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
Declare Function SetROP2% Lib "GDI" (ByVal hDC%, ByVal nDrawMode%)
Declare Function SetScrollPos% Lib "User" (ByVal hWnd%, ByVal nBar%, ByVal nPos%, ByVal bRedraw%)
Declare Sub SetScrollRange Lib "User" (ByVal hWnd%, ByVal nBar%, ByVal nMinPos%, ByVal nMaxPos%, ByVal bRedraw%)
Declare Function SetSelectorBase% Lib "Kernel" (ByVal selector%, ByVal dwBase&)
Declare Function SetSelectorLimit% Lib "Kernel" (ByVal selector%, ByVal dwBase&)
Declare Function SetSoundNoise% Lib "Sound" (ByVal nSource%, ByVal nDuration%)
Declare Function SetStretchBltMode% Lib "GDI" (ByVal hDC%, ByVal nStretchMode%)
Declare Function SetSwapAreaSize& Lib "Kernel" (ByVal rsSize%)
Declare Sub SetSysColors Lib "User" (ByVal nChanges%, lpSysColor%, lpColorValues&)
Declare Function SetSysModalWindow% Lib "User" (ByVal hWnd%)
Declare Function SetSystemPaletteUse% Lib "GDI" (ByVal hDC%, ByVal wUsage%)
Declare Function SetTextAlign% Lib "GDI" (ByVal hDC%, ByVal wFlags%)
Declare Function SetTextCharacterExtra% Lib "GDI" (ByVal hDC%, ByVal nCharExtra%)
Declare Function SetTextColor& Lib "GDI" (ByVal hDC%, ByVal crColor&)
Declare Function SetTextJustification% Lib "GDI" (ByVal hDC%, ByVal nBreakExtra%, ByVal nBreakCount%)
Declare Function SetViewportExt& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function SetViewportExtEx% Lib "GDI" (ByVal hDC%, ByVal nX%, ByVal nY%, lpSize As SIZEAPI)
Declare Function SetViewportOrg& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function SetViewportOrgEx% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, lpSize As SIZEAPI)
Declare Function SetVoiceAccent% Lib "Sound" (ByVal nVoice%, ByVal nTempo%, ByVal nVolume%, ByVal nMode%, ByVal nPitch%)
Declare Function SetVoiceEnvelope% Lib "Sound" (ByVal nVoice%, ByVal nShape%, ByVal nRepeat%)
Declare Function SetVoiceNote% Lib "Sound" (ByVal nVoice%, ByVal nValue%, ByVal nLength%, ByVal nCdots%)
Declare Function SetVoiceQueueSize% Lib "Sound" (ByVal nVoice%, ByVal nBytes%)
Declare Function SetVoiceSound% Lib "Sound" (ByVal nVoice%, ByVal lFrequency&, ByVal nDuration%)
Declare Function SetVoiceThreshold% Lib "Sound" (ByVal nVoice%, ByVal nNotes%)
Declare Function SetWinDebugInfo% Lib "Kernel" (lpwdi As WINDEBUGINFO)
Declare Function SetWindowExt& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function SetWindowExtEx% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, lpSize As SIZEAPI)
Declare Function SetWindowLong& Lib "User" (ByVal hWnd%, ByVal nIndex%, ByVal dwNewLong&)
Declare Function SetWindowOrg& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function SetWindowOrgEx% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, lpSize As SIZEAPI)
Declare Function SetWindowPlacement% Lib "User" (ByVal hWnd%, lpwndpl As WINDOWPLACEMENT)
Declare Sub SetWindowPos Lib "User" (ByVal hWnd%, ByVal hWndInsertAfter%, ByVal X%, ByVal Y%, ByVal cx%, ByVal cy%, ByVal wFlags%)
Declare Sub SetWindowText Lib "User" (ByVal hWnd%, ByVal lpString$)
Declare Function SetWindowWord% Lib "User" (ByVal hWnd%, ByVal nIndex%, ByVal wNewWord%)
Declare Sub ShowCaret Lib "User" (ByVal hWnd%)
Declare Function ShowCursor% Lib "User" (ByVal bShow%)
Declare Sub ShowOwnedPopups Lib "User" (ByVal hWnd%, ByVal fShow%)
Declare Sub ShowScrollBar Lib "User" (ByVal hWnd%, ByVal wBar%, ByVal bShow%)
Declare Function ShowWindow% Lib "User" (ByVal hWnd%, ByVal nCmdShow%)
Declare Function SizeofResource% Lib "Kernel" (ByVal hInstance%, ByVal hResInfo%)
Declare Function StartDoc% Lib "GDI" (ByVal hDC%, lpdi As DOCINFO)
Declare Function StartPage% Lib "GDI" (ByVal hDC%)
Declare Function StartSound% Lib "Sound" ()
Declare Function StopSound% Lib "Sound" ()
Declare Function StretchBlt% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal nSrcWidth%, ByVal nSrcHeight%, ByVal dwRop&)
Declare Function StretchDIBits% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal dX%, ByVal dY%, ByVal SrcX%, ByVal SrcY%, ByVal wSrcWidth%, ByVal wSrcHeight%, ByVal lpBits$, lpBitsInfo As BITMAPINFO, ByVal wUsage%, ByVal dwRop&)
Declare Function StretchDIBitsBynum% Lib "GDI" Alias "StretchDIBits" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal dX%, ByVal dY%, ByVal SrcX%, ByVal SrcY%, ByVal wSrcWidth%, ByVal wSrcHeight%, ByVal lpBits&, lpBI As BITMAPINFO, ByVal wUsg%, ByVal dwR&)
Declare Function SubtractRect% Lib "User" (lprcDest As RECT, lprcSource1 As RECT, lprcSource2 As RECT)
Declare Function SwapMouseButton% Lib "User" (ByVal bSwap%)
Declare Sub SwapRecording Lib "Kernel" (ByVal wFlag%)
Declare Sub SwitchStackBack Lib "Kernel" ()
Declare Sub SwitchStackTo Lib "Kernel" (ByVal wStackSegment%, ByVal wStackPointer%, ByVal wStackTop%)
Declare Function SyncAllVoices% Lib "Sound" ()
Declare Function SystemParametersInfo% Lib "User" (ByVal uAction%, ByVal uParam%, lpvParam As Any, ByVal fuWinIni%)
Declare Function SystemParametersInfoByval% Lib "User" Alias "SystemParametersInfo" (ByVal uAction%, ByVal uParam%, ByVal lpvParam As Any, ByVal fuWinIni%)
Declare Function TabbedTextOut& Lib "User" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal lpString$, ByVal nCount%, ByVal nTabPositions%, lpnTabStopPositions%, ByVal nTabOrigin%)
Declare Function TextOut% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal lpString$, ByVal nCount%)
Declare Sub Throw Lib "Kernel" (lpCatchBuf As Any, ByVal nThrowBack%)
Declare Function ToAscii% Lib "Keyboard" (ByVal wVirtKey%, ByVal wScanCode%, lpKeyState As Any, lpChar As Any, Byval wFlags%)
Declare Function ToAsciiBystring% Lib "Keyboard" Alias "ToAscii" (ByVal wVirtKey%, ByVal wScanCode%, Byval lpKeyState$, lpChar&, Byval wFlags%)
Declare Function TrackPopupMenu% Lib "User" (ByVal hMenu%, ByVal wFlags%, ByVal x%, ByVal y%, ByVal nReserved%, ByVal hWnd%, lpRect As Any)
Declare Function TrackPopupMenuBynum% Lib "User" Alias "TrackPopupMenu" (ByVal hMenu%, ByVal wFlags%, ByVal x%, ByVal y%, ByVal nReserved%, ByVal hWnd%, Byval lpRect&)
Declare Function TranslateAccelerator% Lib "User" (ByVal hWnd%, ByVal hAccTable%, lpMsg As MSG)
Declare Function TranslateMDISysAccel% Lib "User" (ByVal hWndClient%, lpMsg As MSG)
Declare Function TranslateMessage% Lib "User" (lpMsg As MSG)
Declare Function TransmitCommChar% Lib "User" (ByVal nCid%, ByVal cChar%)
Declare Function UngetCommChar% Lib "User" (ByVal nCid%, ByVal cChar%)
Declare Function UnionRect% Lib "User" (lpDestRect As RECT, lpSrc1Rect As RECT, lpSrc2Rect As RECT)
Declare Function UnlockSegment% Lib "Kernel" (ByVal wSegment%)
Declare Function UnrealizeObject% Lib "GDI" (ByVal hObject%)
Declare Function UnregisterClass% Lib "User" (ByVal lpClassName$, ByVal hInstance%)
Declare Function UpdateColors% Lib "GDI" (ByVal hDC%)
Declare Sub UpdateWindow Lib "User" (ByVal hWnd%)
Declare Sub ValidateCodeSegments Lib "Kernel" ()
Declare Function ValidateFreeSpaces& Lib "Kernel" ()
Declare Sub ValidateRect Lib "User" (ByVal hWnd%, lpRect As RECT)
Declare Sub ValidateRectBynum Lib "User" Alias "ValidateRect" (ByVal hWnd%, ByVal lpRect&)
Declare Sub ValidateRgn Lib "User" (ByVal hWnd%, ByVal hRgn%)
Declare Function VkKeyScan% Lib "Keyboard" (ByVal cChar%)
Declare Sub WaitMessage Lib "User" ()
Declare Function WaitSoundState% Lib "Sound" (ByVal nState%)
Declare Function WindowFromPoint% Lib "User" (ByVal Pnt As Any)
Declare Function WindowFromPointBynum% Lib "User" Alias "WindowFromPoint" (ByVal Pnt&)
Declare Function WinExec% Lib "Kernel" (ByVal lpCmdLine$, nCmdShow%)
Declare Function WinHelp% Lib "User" (ByVal hWnd%, ByVal lpHelpFile$, ByVal wCommand%, dwData As Any)
Declare Function WinHelpBynum% Lib "User" Alias "WinHelp" (ByVal hWnd%, ByVal lpHelpFile$, ByVal wCommand%, Byval dwData&)
Declare Function WNetAddConnection% Lib "User" (ByVal lpszNetPath$, ByVal lpszPassword$, ByVal lpszLocalName$)
Declare Function WNetCancelConnection% Lib "User" (ByVal lpszName$, ByVal fForce%)
Declare Function WNetGetConnection% Lib "User" (ByVal lpszLocalName$, ByVal lpszRemoteName$, cbRemoteName%)
Declare Function WriteComm% Lib "User" (ByVal nCid%, ByVal lpBuf$, ByVal nSize%)
Declare Function WritePrivateProfileString% Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal lpString$, ByVal lplFileName$)
Declare Function WritePrivateProfileStringBynum% Lib "Kernel" Alias "WritePrivateProfileString" (ByVal lpApplicationName$, ByVal lpKeyName&, ByVal lpString&, ByVal lplFileName$)
Declare Function WriteProfileString% Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal lpString$)
Declare Function WriteProfileStringBynum% Lib "Kernel" Alias "WriteProfileString" (ByVal lpApplicationName$, ByVal lpKeyName&, ByVal lpString&)
Declare Function wvsprintf% Lib "User" (ByVal lpszOutput$, ByVal lpszFormat$, lpvArglist%)
Declare Sub Yield Lib "Kernel" ()

' The following functions require the presence of one or more of the
' Windows 3.1 extension dynamic link libraries.

Declare Function CopyLZFile& Lib "lzexpand" (ByVal hfSource%, ByVal hfDest%)
Declare Sub DragAcceptFiles Lib "shell.dll" (ByVal hwnd%, ByVal fAccept%)
Declare Sub DragFinish Lib "shell.dll" (ByVal hDrop%)
Declare Function DragQueryFile% Lib "shell.dll" (ByVal hDrop%, ByVal iFile%, ByVal lpszFile$, ByVal cb%)
Declare Function DragQueryPoint% Lib "shell.dll" (ByVal hDrop%, lppt As POINTAPI)
Declare Function ExtractIcon% Lib "shell.dll" (ByVal hisnt%, ByVal lpszExeName$, ByVal iIcon%)
Declare Function FindExecutable% Lib "shell.dll" (ByVal lpszFile%, ByVal lpszDir$, ByVal lpszResult$)
Declare Function GetExpandedName% Lib "lzexpand" (ByVal lpszSource$, ByVal lpszBuffer$)
Declare Function GetFileResource% Lib "ver.dll" (ByVal lpszFileName$, ByVal lpszResType&, ByVal lpszResID&, ByVal dwFileOffset&, ByVal dwResLen&, ByVal lpvData&)
Declare Function GetFileResourceSize& Lib "ver.dll" (ByVal lpszFileName$, ByVal lpszResType&, ByVal lpszResID&, dwFileOffset&)
Declare Function GetFileVersionInfo% Lib "ver.dll" (ByVal lpszFileName$, ByVal handle&, ByVal cbBuf&, ByVal lpvData&)
Declare Function GetFileVersionInfoSize% Lib "ver.dll" (ByVal lpszFileName$, lpdwHandle&)
Declare Sub LZClose Lib "lzexpand" (ByVal hf%)
Declare Function LZCopy& Lib "lzexpand" (ByVal hfSource%, ByVal hfDest%)
Declare Sub LZDone Lib "lzexpand" ()
Declare Function LZInit% Lib "lzexpand" (ByVal hfSrc%)
Declare Function LZOpenFile% Lib "lzexpand" (ByVal lpszFile$, lpof As OFSTRUCT, ByVal style%)
Declare Function LZRead% Lib "lzexpand" (ByVal hf%, ByVal lpvBuf&, ByVal cb%)
Declare Function LZSeek& Lib "lzexpand" (ByVal hf%, ByVal lOffset&, ByVal nOrigin%)
Declare Function LZStart% Lib "lzexpand" ()
Declare Function ShellExecute% Lib "shell.dll" (ByVal hwnd%, ByVal lpszOp$, ByVal lpszFile$, ByVal spszParams$, ByVal lpszDir$, ByVal fsShowCmd%)
Declare Function ShellExecuteBynum% Lib "shell.dll" Alias "ShellExecute" (ByVal hwnd%, ByVal lpszOp&, ByVal lpszFile$, ByVal spszParams&, ByVal lpszDir$, ByVal fsShowCmd%)
Declare Function VerFindFile% Lib "ver.dll" (ByVal fl%, ByVal FileName$, ByVal WinDir&, ByVal AppDir$, ByVal CurrDir$, CurDirLen%, ByVal DestDir$, DestDirLen%)
Declare Function VerInstallFile& Lib "ver.dll" (ByVal fl%, ByVal SrcFile$, ByVal DstFile$, ByVal SrcDir$, ByVal DstDir$, ByVal CurrDir$, ByVal TmpFile$, TmpFileLen%)
Declare Function VerLanguageName% Lib "ver.dll" (ByVal Lang%, ByVal lpszLang$, ByVal cbLang%)
Declare Function VerQueryValue% Lib "ver.dll" (ByVal lpvBlock&, ByVal SubBlock$, lpBuffer&, lpcb%)







