''''''''''''''''''''''''''''
' Thunder global constant file. This file can be loaded
' into the global module.
'
' Some constants are commented out because they have
' duplicates (e.g., NONE appears several places).
'
''''''''''''''''''''''''''''

' General

' Booleans


' Clipboard formats
Global Const CF_LINK = &HBF00
Global Const CF_TEXT = 1
Global Const CF_BITMAP = 2
Global Const CF_METAFILE = 3
Global Const CF_DIB = 8

' DragOver
Global Const ENTER = 0
Global Const LEAVE = 1
Global Const OVER = 2

' Show parameters
Global Const MODAL = True
Global Const MODELESS = False


' Colors

Global Const RED = &HFF
Global Const GREEN = &HFF00&
Global Const BLUE = &HFF0000
Global Const WHITE = &HFFFFFF
Global Const BLACK = 0

' System Colors
Global Const DESKTOP = &H80000001                ' Desktop
Global Const APPLICATION_WORKSPACE = &H8000000C  ' Application Workspace
Global Const WINDOW_BACKGROUND = &H80000005      ' Window Background
Global Const WINDOW_TEXT = &H80000008            ' Window Text
Global Const MENU_BAR = &H80000004               ' Menu Bar
Global Const MENU_TEXT = &H80000007              ' Menu Text
Global Const ACTIVE_TITLE_BAR = &H80000002       ' Active Title Bar
Global Const INACTIVE_TITLE_BAR = &H80000003     ' Inactive Title Bar
Global Const TITLE_BAR_TEXT = &H80000009         ' Title Bar Text
Global Const ACTIVE_BORDER = &H8000000A          ' Active Border
Global Const INACTIVE_BORDER = &H8000000B        ' Inactive Border
Global Const WINDOW_FRAME = &H80000006           ' Window Frame
Global Const SCROLL_BARS = &H80000000            ' Scroll Bars

' Properties

' Alignment Values
Global Const LEFT_JUSTIFY = 0           ' 0 - Left
Global Const CENTER = 1                 ' 1 - Center
Global Const RIGHT_JUSTIFY = 2          ' 2 - Right

' BorderStyle Values (forms and controls)
Global Const NONE = 0                  ' 0 - None
Global Const THIN = 1                  ' 1 - Thin
Global Const THICK = 2                 ' 2 - Thick (Forms only)
Global Const DIALOG = 3                ' 3 - Dialog (Forms only)

' Cursor Values
Global Const ARROW = 1          ' Standard arrow cursor.
Global Const CROSSHAIR = 2      ' Crosshair cursor.
Global Const IBEAM = 3          ' Text I-beam cursor.
Global Const ICON = 4           ' Empty icon.
Global Const SIZE = 5           ' Four-pointed cursor
Global Const SIZE_NE_SW = 6     ' Double-pointed cursor with arrows
                                    ' pointing northeast and southwest.
Global Const SIZE_N_S = 7       ' Double-pointed cursor with arrows
                                    ' pointing northsouth.
Global Const SIZE_NW_SE = 8     ' Double-pointed cursor with arrows
                                    ' pointing northwest and southeast.
Global Const SIZE_W_E = 9       ' Double-pointed cursor with arrows
                                    ' pointing west and east.
Global Const UP_ARROW = 10      ' Vertical arrow cursor.
Global Const HOURGLASS = 11     ' Hourglass cursor.
' 12-15 unassigned.

' DragMode Values
Global Const MANUAL = 0         ' 0 - Manual
Global Const AUTOMATIC = 1      ' 1 - Automatic

' DrawMode Values
Global Const DRAW_BLACK = 1          ' 1 - Black
Global Const NOT_MERGE_PEN = 2       ' 2 - Not Merge Pen
Global Const MASK_NOT_PEN = 3        ' 3 - Mask Not Pen
Global Const NOT_COPY_PEN = 4        ' 4 - Not Copy Pen
Global Const MASK_PEN_NOT = 5        ' 5 - Mask Pen Not
Global Const INVERSE = 6             ' 6 - Not
Global Const XOR_PEN = 7             ' 7 - Xor Pen
Global Const NOT_MASK_PEN = 8        ' 8 - Not Mask Pen
Global Const MASK_PEN = 9            ' 9 - Mask Pen
Global Const NOT_XOR_PEN = 10        ' 10 - Not Xor Pen
Global Const NOP = 11                ' 11 - Nop
Global Const MERGE_NOT_PEN = 12      ' 12 - Merge Not Pen
Global Const COPY_PEN = 13           ' 13 - Copy Pen
Global Const MERGE_PEN_NOT = 14      ' 14 - Merge Pen Not
Global Const MERGE_PEN = 15          ' 15 - Merge Pen
Global Const DRAW_WHITE = 16         ' 16 - White

' DrawStyle property Values
Global Const SOLID = 0               ' 0 - Solid
Global Const DASH = 1                ' 1 - Dash
Global Const DOT = 2                 ' 2 - Dot
Global Const DASH_DOT = 3            ' 3 - Dash-Dot
Global Const DASH_DOT_DOT = 4        ' 4 - Dash-Dot-Dot
Global Const INVISIBLE = 5           ' 5 - Transparent
Global Const INSIDE_SOLID = 6        ' 6 - Inside Solid

' FillStyle Values
' Global Const SOLID = 0             ' 0 - Solid
Global Const TRANSPARENT = 1         ' 1 - Transparent
Global Const HORIZONTAL = 2          ' 2 - Horizontal
Global Const VERTICAL = 3            ' 3 - Vertical
Global Const UPWARD_DIAGONAL = 4     ' 4 - Upward Diagonal
Global Const DOWNWARD_DIAGONAL = 5   ' 5 - Downward Diagonal
Global Const CROSS = 6               ' 6 - Cross
Global Const DIAGONAL_CROSS = 7      ' 7 - Diagonal Cross

' LinkMode
' Global Const NONE = 0              ' 0 - None
Global Const HOT = 1                 ' 1 - Hot
Global Const SERVER = 1              ' 1 - Server

' SaveImage Values
' Global Const NONE = 0              ' 0 - None
Global Const BITMAP = 1              ' 1 - Bitmap

' ScaleMode Values
Global Const USER = 0                ' 0 - User
Global Const TWIPS = 1               ' 1 - Twip
Global Const POINTS = 2              ' 2 - Point
Global Const PIXELS = 3              ' 3 - Pixel
Global Const CHARACTERS = 4          ' 4 - Character
Global Const INCHES = 5              ' 5 - Inch
Global Const MILLIMETERS = 6         ' 6 - Millimeter
Global Const CENTIMETERS = 7         ' 7 - Centimeter


